/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Tree;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.CubeResetOptionsPanel;
import com.sas.olapadmin.designer.visuals.GeneralAdvancedDialog;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.WsRunCode;
import com.sas.olapadmin.utilities.studio.ChangeOLAPSchemaPanel;
import com.sas.olapadmin.utilities.studio.OLAPSchemaNewButton;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class CubeGeneralPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(CubeGeneralPanel.class);
    private WATextField inputCubeName;
    private WATextArea inputDescription;
    private WAComboBox inputCubePath;
    private JButton browse;
    private JButton browseFolder;
    private WAComboBox inputWorkPath;
    private JButton browseForWork;
    private OLAPCube olapCube;
    private Tree folder;
    private JComboBox inputLoadType;
    private WATextField repositoryFolder;
    private boolean initialized;
    private JCheckBox summaryTablesCheckbox;
    private JCheckBox securitySubset;
    private String cubeType;
    private JButton advanced;
    private boolean loadTypeChanged;
    private boolean cubeTypeChanged;
    private String oldLoadType;
    private boolean firstTime;
    private String originalCubeName;
    private OLAPSchema originalSchema;
    private Tree originalFolder;
    private TableSet tableSet;
    private Vector cubePaths;
    private Vector workPaths;
    private ChangeOLAPSchemaPanel olapSchemas;

    public CubeGeneralPanel(OLAPCube inputOlapCube) {
        this.olapCube = inputOlapCube;
        this.tableSet = this.olapCube.getTableSet();
        this.setLayout(new GridBagLayout());
        this.layoutWidgets();
        this.initialized = false;
        this.loadTypeChanged = false;
        this.cubeTypeChanged = false;
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            if (!this.initialized) {
                this.initialize();
            }
            this.initialized = true;
        }
        return true;
    }

    protected void initialize() {
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        parent.addWizardData("WORKPATHS", (Object)this.workPaths);
        this.olapCube.getOptionsSet();
        this.olapCube.getTableSet().addToMetadataListener();
        this.firstTime = this.olapCube.isNewObject();
        this.cubeType = "MOLAP";
        this.inputWorkPath.setSelectedIndex(-1);
        try {
            MeasureSet measureSet = this.olapCube.getMeasureSet();
            measureSet.setAutoRestore(false);
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        AdvancedListener advanceButton = new AdvancedListener();
        this.advanced.addActionListener(advanceButton);
        this.inputLoadType.addItem(bundle.getString("CubeDesigner.General.LoadType1.txt"));
        this.inputLoadType.addItem(bundle.getString("CubeDesigner.General.LoadType2.txt"));
        this.inputLoadType.addItem(bundle.getString("CubeDesigner.General.LoadType3.txt"));
        this.inputCubeName.setToolTipText(bundle.getString("CubeDesigner.General.cubenameToolTip.txt"));
        this.inputDescription.setToolTipText(bundle.getString("CubeDesigner.General.descriptionToolTip.txt"));
        this.summaryTablesCheckbox.setToolTipText(bundle.getString("CubeDesigner.General.CubetypeToolTip.txt"));
        this.inputLoadType.setToolTipText(bundle.getString("CubeDesigner.General.LoadtypeToolTip.txt"));
        this.inputCubePath.setToolTipText(bundle.getString("CubeDesigner.General.cubePathToolTip.txt"));
        this.browse.setToolTipText(bundle.getString("CubeDesigner.General.browseToolTip.txt"));
        this.inputWorkPath.setToolTipText(bundle.getString("CubeDesigner.General.workpath.tooltip.txt"));
        this.browseForWork.setToolTipText(bundle.getString("CubeDesigner.General.browseForWork.tooltip.txt"));
        this.repositoryFolder.setToolTipText(bundle.getString("CubeDesigner.General.CubeRepositoryFolder.action.tip"));
        this.originalCubeName = this.olapCube.getName();
        parent.addWizardData("ORIGINALCUBENAME", (Object)this.originalCubeName);
        if (!this.olapCube.isNewObject()) {
            this.inputCubeName.setText(this.olapCube.getName());
            this.inputDescription.setText(this.olapCube.getDesc());
            if (this.olapCube.getType().equals("HOLAP")) {
                this.summaryTablesCheckbox.setSelected(true);
            } else {
                this.summaryTablesCheckbox.setSelected(false);
            }
            try {
                String workPath;
                this.folder = this.olapCube.getFolder();
                if (this.originalFolder == null) {
                    this.originalFolder = this.folder;
                }
                try {
                    if (this.folder != null) {
                        MdOMIUtil mdUtil = Workspace.getMdFactory().getOMIUtil();
                        String pathURL = mdUtil.getObjectPath((MdObjectStore)this.folder.getObjectStore(), (PrimaryType)this.folder, false);
                        this.repositoryFolder.setText(pathURL);
                    }
                }
                catch (MdException mdError) {
                    ExceptionHandler.handleException((Exception)((Object)mdError));
                }
                catch (RemoteException re) {
                    ExceptionHandler.handleException((Exception)re);
                }
                if (this.originalSchema == null) {
                    this.originalSchema = this.olapCube.getAssociatedOLAPSchema();
                }
                if (this.originalSchema != null && !ModelUtilities.canWrite((String)"OLAPSchema", (CMetadata)this.originalSchema)) {
                    this.olapSchemas.setEnabled(false);
                }
                this.summaryTablesCheckbox.setEnabled(true);
                if (this.tableSet.isLoadDetailTable()) {
                    this.inputLoadType.setSelectedIndex(0);
                } else if (this.tableSet.isLoadStarSchema()) {
                    this.inputLoadType.setSelectedIndex(1);
                } else {
                    this.inputLoadType.setSelectedIndex(2);
                    this.summaryTablesCheckbox.setEnabled(false);
                }
                String cubePath = this.olapCube.getPath();
                if (cubePath != null && !this.cubePaths.contains(cubePath)) {
                    this.cubePaths.add(0, cubePath);
                    if (this.cubePaths.size() > 5) {
                        this.cubePaths.remove(5);
                    }
                }
                if ((workPath = this.olapCube.getWorkPath()) != null && !this.workPaths.contains(workPath)) {
                    this.workPaths.add(0, workPath);
                    if (this.workPaths.size() > 5) {
                        this.workPaths.remove(5);
                    }
                }
                this.inputCubePath.setSelectedItem((Object)cubePath);
                this.inputWorkPath.setSelectedItem((Object)workPath);
                String securitySubsetInitialize = this.olapCube.getSecuritySubset();
                if (securitySubsetInitialize.equals("YES")) {
                    this.securitySubset.setSelected(false);
                } else {
                    this.securitySubset.setSelected(true);
                }
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            String physicalCubeName = this.olapCube.getPhysicalName();
            try {
                if (!ModelUtilities.isBlank((String)physicalCubeName) | ModelUtilities.isPreviousGeneration((OLAPCube)this.olapCube)) {
                    this.inputCubePath.setEnabled(false);
                    this.browse.setEnabled(false);
                }
            }
            catch (MdException mdError) {
                ExceptionHandler.handleException((Exception)((Object)mdError));
            }
            catch (RemoteException re) {
                ExceptionHandler.handleException((Exception)re);
            }
            this.inputLoadType.setEnabled(false);
        } else {
            this.securitySubset.setSelected(true);
            this.folder = (Tree)parent.getWizardData("GROUP");
            if (this.folder == null) {
                try {
                    this.folder = ModelUtilities.getDefaultFolder((OLAPSchema)this.olapCube.getAssociatedOLAPSchema(), (MdObjectStore)this.olapCube.getObjectStore());
                }
                catch (OLAPException e) {
                    this.folder = null;
                }
            }
            if (this.folder != null) {
                try {
                    MdOMIUtil mdUtil = Workspace.getMdFactory().getOMIUtil();
                    String pathURL = mdUtil.getObjectPath((MdObjectStore)this.folder.getObjectStore(), (PrimaryType)this.folder, false);
                    this.repositoryFolder.setText(pathURL);
                }
                catch (MdException mdError) {
                    ExceptionHandler.handleException((Exception)((Object)mdError));
                }
                catch (RemoteException re) {
                    ExceptionHandler.handleException((Exception)re);
                }
            }
            this.inputLoadType.setSelectedIndex(0);
            if (!this.cubePaths.isEmpty()) {
                this.inputCubePath.setSelectedItem(this.cubePaths.get(0));
            }
            OLAPSchema schema = this.olapSchemas.getSelectedOLAPSchema();
            this.inputCubeName.setText(ModelUtilities.getUniqueSASNameForType((String)"Cube", (OLAPSchema)schema, (Tree)this.folder));
        }
        this.summaryTablesCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (!CubeGeneralPanel.this.summaryTablesCheckbox.isSelected() & CubeGeneralPanel.this.inputLoadType.getSelectedIndex() == 2) {
                    CubeGeneralPanel.this.summaryTablesCheckbox.setSelected(true);
                }
            }
        });
        this.securitySubset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    if (CubeGeneralPanel.this.securitySubset.isSelected()) {
                        CubeGeneralPanel.this.olapCube.setSecuritySubset("NO");
                    } else {
                        CubeGeneralPanel.this.olapCube.setSecuritySubset("YES");
                    }
                }
                catch (OLAPException oError) {
                    ExceptionHandler.handleException((Exception)((Object)oError));
                }
            }
        });
        this.inputLoadType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String newLoadType = (String)CubeGeneralPanel.this.inputLoadType.getSelectedItem();
                try {
                    CubeGeneralPanel.this.oldLoadType = CubeGeneralPanel.this.tableSet.getLoadType();
                }
                catch (OLAPException oLAPException) {
                    // empty catch block
                }
                CubeGeneralPanel.this.loadTypeChanged = !CubeGeneralPanel.this.oldLoadType.equals(newLoadType);
                if (CubeGeneralPanel.this.inputLoadType.getSelectedIndex() == 2) {
                    CubeGeneralPanel.this.summaryTablesCheckbox.setSelected(true);
                    CubeGeneralPanel.this.summaryTablesCheckbox.setEnabled(false);
                } else {
                    CubeGeneralPanel.this.summaryTablesCheckbox.setEnabled(true);
                    CubeGeneralPanel.this.summaryTablesCheckbox.setSelected(false);
                }
            }
        });
        this.browse.addActionListener(new BrowseButtonsListener());
        this.browseForWork.addActionListener(new BrowseButtonsListener());
        this.browseFolder.addActionListener(new SelectFolderButtonsListener());
    }

    protected void layoutWidgets() {
        JLabel labelCubeName = new JLabel();
        this.inputCubeName = new WATextField();
        this.inputCubeName.setName("cubeNameField");
        labelCubeName.setName("cubeNameLabel");
        labelCubeName.setLabelFor((Component)this.inputCubeName);
        VisualUtilities.setLabelTextAndMnemonic(labelCubeName, bundle.getString("Common.Name.control.label"));
        JLabel labelDescription = new JLabel();
        this.inputDescription = new WATextArea(2, 1);
        this.inputDescription.setLineWrap(true);
        this.inputDescription.setWrapStyleWord(true);
        this.inputDescription.setMaxCharacters(256);
        JScrollPane scrollDescription = new JScrollPane((Component)this.inputDescription);
        this.inputDescription.setName("cubeDescField");
        labelDescription.setName("cubeDescLabel");
        labelDescription.setLabelFor((Component)this.inputDescription);
        VisualUtilities.setLabelTextAndMnemonic(labelDescription, bundle.getString("CubeDesigner.General.description.txt"));
        JLabel labelCubeFolder = new JLabel();
        this.repositoryFolder = new WATextField();
        this.repositoryFolder.setPreferredSize(new Dimension(0, this.repositoryFolder.getPreferredSize().height));
        this.repositoryFolder.setBehavior(2);
        this.repositoryFolder.setName("cubeRepositoryFolder");
        labelCubeFolder.setName("cubeRepositoryFolder");
        labelCubeFolder.setLabelFor((Component)this.repositoryFolder);
        VisualUtilities.setLabelTextAndMnemonic(labelCubeFolder, bundle.getString("CubeDesigner.General.CubeRepositoryFolder.control.label"));
        this.browseFolder = new JButton();
        this.browseFolder.setName("newcuberepositoryfolder");
        VisualUtilities.setButtonTextAndMnemonic(this.browseFolder, bundle.getString("CubeDesigner.General.browseForFolder.action.label"));
        ArrayList<OLAPCube> cubes = new ArrayList<OLAPCube>();
        cubes.add(this.olapCube);
        this.olapSchemas = new ChangeOLAPSchemaPanel(cubes.toArray());
        JLabel olapschemaLabel = new JLabel();
        olapschemaLabel.setName("cubeOlapschemaLabel");
        olapschemaLabel.setLabelFor((Component)((Object)this.olapSchemas));
        VisualUtilities.setLabelTextAndMnemonic(olapschemaLabel, bundle.getString("CubeDesigner.General.OLAPSchema.control.label"));
        OLAPSchemaNewButton button = new OLAPSchemaNewButton(this.olapSchemas, (AbstractOLAPModel)this.olapCube);
        JLabel labelCubePath = new JLabel();
        this.cubePaths = VisualUtilities.getCubePaths();
        this.inputCubePath = new WAComboBox(this.cubePaths.toArray());
        this.inputCubePath.setName("cubePathField");
        labelCubePath.setName("cubePathLabel");
        labelCubePath.setLabelFor((Component)this.inputCubePath);
        VisualUtilities.setLabelTextAndMnemonic(labelCubePath, bundle.getString("CubeDesigner.General.PhysicalCubeFolder.control.label"));
        this.browse = new JButton();
        this.browse.setName("browseButton");
        VisualUtilities.setButtonTextAndMnemonic(this.browse, bundle.getString("Common.Browse.txt"));
        this.inputCubePath.setEditable(true);
        JLabel labelWorkPath = new JLabel();
        this.workPaths = VisualUtilities.getWorkPaths();
        this.inputWorkPath = new WAComboBox(this.workPaths.toArray());
        this.inputWorkPath.setName("cubeWorkPathField");
        labelWorkPath.setName("cubeWorkPathLabel");
        labelWorkPath.setLabelFor((Component)this.inputWorkPath);
        VisualUtilities.setLabelTextAndMnemonic(labelWorkPath, bundle.getString("CubeDesigner.General.workpath.txt"));
        this.browseForWork = new JButton();
        this.browseForWork.setName("browseForWorkButton");
        VisualUtilities.setButtonTextAndMnemonic(this.browseForWork, bundle.getString("CubeDesigner.General.browseForWork.txt"));
        this.inputWorkPath.setEditable(true);
        this.inputLoadType = new JComboBox();
        this.inputLoadType.setName("inputType");
        this.summaryTablesCheckbox = new JCheckBox(bundle.getString("CubeDesigner.General.CubeType.checkbox.txt"));
        this.summaryTablesCheckbox.setName("summaryTablesCheckbox");
        VisualUtilities.setButtonTextAndMnemonic(this.summaryTablesCheckbox, bundle.getString("CubeDesigner.General.CubeType.checkbox.txt"));
        this.securitySubset = new JCheckBox();
        this.securitySubset.setName("securitySubset");
        VisualUtilities.setButtonTextAndMnemonic(this.securitySubset, bundle.getString("CubeDesigner.General.SecuredMember.checkbox.label"));
        this.securitySubset.setToolTipText(bundle.getString("CubeDesigner.General.SecuredMember.checkbox.tip"));
        this.add(labelCubeName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.inputCubeName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add(labelDescription, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add(scrollDescription, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add(olapschemaLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)((Object)this.olapSchemas), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(button, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add(labelCubeFolder, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.repositoryFolder, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.browseFolder, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add(labelCubePath, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.inputCubePath, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.browse, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add(labelWorkPath, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.inputWorkPath, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.browseForWork, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 0), 0, 0));
        WAPanel loadtype = new WAPanel();
        loadtype.setLayout((LayoutManager)new GridBagLayout());
        TitledBorder titledBorder3 = new TitledBorder(bundle.getString("CubeDesigner.General.Loadtype.txt"));
        loadtype.setBorder((Border)titledBorder3);
        loadtype.add((Component)this.inputLoadType, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        loadtype.add((Component)this.summaryTablesCheckbox, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 7, 0, 0), 0, 0));
        this.add((Component)loadtype, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.advanced = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.advanced, bundle.getString("Common.AdvancedButton.txt"));
        this.advanced.setName("GeneralAdvanced");
        this.advanced.setToolTipText(bundle.getString("CubeDesigner.General.Advanced.tooltip.txt"));
        this.add(this.advanced, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 14, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.add(this.securitySubset, new GridBagConstraints(0, 7, 2, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 5, 0), 0, 0));
    }

    public void saveSettingsAndCleanUp() {
        this.olapCube.getTableSet().removeFromMetadataListener();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean validateData() {
        OLAPSchema newSchema;
        Workspace workspace = Workspace.getWorkspace();
        if (!Utilities.isConnectedToMetadataServer((boolean)true)) {
            return false;
        }
        this.cubeTypeChanged = false;
        try {
            if (this.folder != null && this.folder != this.originalFolder) {
                this.olapCube.setFolder(this.folder);
                this.olapCube.verifyFolder();
            }
            if (this.folder == null) {
                this.folder = this.olapCube.getFolder();
                if (this.folder != null) {
                    try {
                        MdOMIUtil mdUtil = Workspace.getMdFactory().getOMIUtil();
                        String pathURL = mdUtil.getObjectPath((MdObjectStore)this.folder.getObjectStore(), (PrimaryType)this.folder, false);
                        this.repositoryFolder.setText(pathURL);
                    }
                    catch (MdException mdError) {
                        ExceptionHandler.handleException((Exception)((Object)mdError));
                    }
                    catch (RemoteException re) {
                        ExceptionHandler.handleException((Exception)re);
                    }
                }
            }
        }
        catch (OLAPException error) {
            return ExceptionHandler.handleException((Exception)((Object)error));
        }
        boolean changedSchema = (newSchema = this.olapSchemas.getSelectedOLAPSchema()) != this.originalSchema;
        try {
            if (changedSchema) {
                this.olapCube.setAssociatedOLAPSchema(newSchema);
            }
            this.olapCube.verifyOLAPSchema();
        }
        catch (OLAPException error) {
            if (this.originalSchema == null) return ExceptionHandler.handleException((Exception)((Object)error));
            this.olapCube.setAssociatedOLAPSchema(this.originalSchema);
            return ExceptionHandler.handleException((Exception)((Object)error));
        }
        boolean changedFolder = this.folder != this.originalFolder;
        String newName = this.inputCubeName.getText();
        if (this.olapCube.isNewObject() || !this.olapCube.isNewObject() && !newName.equals(this.originalCubeName) || changedSchema || changedFolder) {
            try {
                this.olapCube.setName(newName);
                this.olapCube.verifyName();
                boolean verifySpecialChars = workspace.getAppDefaultsFile().getPropertyBoolean(VisualUtilities.VERIFY_SPEC_CHARACTERS, true);
                if (verifySpecialChars && this.olapCube.isSpecialCharactersName()) {
                    JCheckBox checkbox = new JCheckBox();
                    VisualUtilities.setButtonTextAndMnemonic(checkbox, bundle.getString("Common.ShowMessage.checkbox.label"));
                    WATextArea message = new WATextArea(bundle.getString("CubeDesigner.General.SpecialCharacters.txt"));
                    message.setBehavior(2);
                    message.setColumns(35);
                    message.setAutosize(true);
                    Object[] allObjects = new Object[]{message, " ", checkbox};
                    String titleMessage = bundle.getString("CubeDesigner.General.SpecialCharacters.title");
                    int optionSelected = JOptionPane.showConfirmDialog((Component)workspace, allObjects, titleMessage, 0, 2);
                    workspace.getAppDefaultsFile().setPropertyBoolean(VisualUtilities.VERIFY_SPEC_CHARACTERS, !checkbox.isSelected());
                    if (optionSelected == 1) {
                        this.olapCube.setName(this.originalCubeName);
                        return false;
                    }
                }
            }
            catch (OLAPException error) {
                try {
                    this.olapCube.setName(this.originalCubeName);
                    if (this.originalFolder != null) {
                        this.olapCube.setFolder(this.originalFolder);
                    }
                    this.olapCube.setAssociatedOLAPSchema(this.originalSchema);
                    return ExceptionHandler.handleException((Exception)((Object)error));
                }
                catch (OLAPException checkbox) {
                    // empty catch block
                }
                return ExceptionHandler.handleException((Exception)((Object)error));
            }
        }
        String originalPath = null;
        try {
            originalPath = this.olapCube.getPath();
            this.olapCube.setPath((String)this.inputCubePath.getSelectedItem());
            this.olapCube.verifyCubePath();
        }
        catch (OLAPException error) {
            this.olapCube.setPath(originalPath);
            return ExceptionHandler.handleException((Exception)((Object)error));
        }
        String cubeDesc = this.inputDescription.getText();
        if (ModelUtilities.isBlank((String)cubeDesc)) {
            this.olapCube.setDesc(this.inputCubeName.getText());
        } else {
            this.olapCube.setDesc(cubeDesc);
        }
        String newLoadType = this.inputLoadType.getSelectedItem().toString();
        try {
            this.oldLoadType = this.tableSet.getLoadType();
            if (this.oldLoadType.equals(newLoadType)) {
                this.loadTypeChanged = false;
            }
            AggregationSet aggregationSet = this.olapCube.getAggregationSet();
            if (this.summaryTablesCheckbox.isSelected()) {
                this.cubeType = "HOLAP";
                aggregationSet.setHasStoredAggregations(true);
            } else {
                this.cubeType = "MOLAP";
                aggregationSet.setHasStoredAggregations(false);
            }
        }
        catch (OLAPException error) {
            return ExceptionHandler.handleException((Exception)((Object)error));
        }
        String oldCubeType = this.olapCube.getType();
        if (ModelUtilities.isBlank((String)oldCubeType)) {
            this.cubeTypeChanged = false;
        } else if (oldCubeType.equals(this.cubeType)) {
            this.cubeTypeChanged = false;
        } else if (this.cubeType.equals("MOLAP") && oldCubeType.equals("HOLAP")) {
            this.cubeTypeChanged = true;
        }
        if (!this.firstTime) {
            boolean hasAdvancedOptions = false;
            ArrayList<String> cubeOptions = new ArrayList<String>();
            List listOfDimensions = null;
            List listOfDimensionTables = null;
            try {
                String cubeOption = this.olapCube.getSASCode();
                cubeOptions.add(cubeOption);
                hasAdvancedOptions = hasAdvancedOptions || !ModelUtilities.isBlank((String)cubeOption);
                cubeOption = this.olapCube.getFormatSearchOptions();
                cubeOptions.add(cubeOption);
                hasAdvancedOptions = hasAdvancedOptions || !ModelUtilities.isBlank((String)cubeOption);
                cubeOption = this.olapCube.getEmptyChar();
                cubeOptions.add(cubeOption);
                hasAdvancedOptions = hasAdvancedOptions || cubeOption != null;
                cubeOption = this.olapCube.getEmptyNum();
                cubeOptions.add(cubeOption);
                if (this.olapCube.getLanguageSet().getSelectedLocales().size() > 0) {
                    cubeOptions.add("languages!");
                    hasAdvancedOptions = true;
                } else {
                    cubeOptions.add(null);
                }
                cubeOption = this.olapCube.getCompact();
                cubeOptions.add(cubeOption);
                hasAdvancedOptions = hasAdvancedOptions || !ModelUtilities.isBlank((String)cubeOption);
                hasAdvancedOptions = hasAdvancedOptions || cubeOption != null;
                DimensionSet dimensionSet = this.olapCube.getDimensionSet();
                listOfDimensions = dimensionSet.getCubeDimensions();
                listOfDimensionTables = dimensionSet.getTables();
            }
            catch (OLAPException cubeOption) {
                // empty catch block
            }
            if (listOfDimensions != null && !listOfDimensions.isEmpty() || listOfDimensionTables != null && !listOfDimensionTables.isEmpty() || hasAdvancedOptions) {
                int option = 0;
                if (this.loadTypeChanged && !this.firstTime) {
                    CubeResetOptionsPanel resetPanel = null;
                    if (hasAdvancedOptions) {
                        resetPanel = new CubeResetOptionsPanel(this.olapCube, cubeOptions);
                        option = MessageUtil.displayDetailsMessage((String)bundle.getString("CubeDesigner.General.InputChanged.Warning.txt"), (String)bundle.getString("Reset.Title.txt"), (int)2, (int)2, (JComponent)resetPanel);
                    } else {
                        option = MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.General.InputChanged.Warning3.txt"), (String)bundle.getString("Reset.Title.txt"), (int)2, (int)2);
                    }
                    if (option != 0) return false;
                    try {
                        if (resetPanel != null) {
                            resetPanel.saveToModel();
                        }
                        this.tableSet.setLoadType(this.inputLoadType.getSelectedItem().toString());
                        this.olapCube.reset();
                        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                        parent.addWizardData("OLAPCUBE_RESET", (Object)"TRUE");
                    }
                    catch (OLAPException error) {
                        ExceptionHandler.handleException((Exception)((Object)error));
                    }
                }
            }
            if (this.cubeTypeChanged && !this.loadTypeChanged) {
                try {
                    if (!this.olapCube.getAggregationSet().getStoredAggregations().isEmpty()) {
                        int option = MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.General.TypeChanged.RemoveAggregations.txt"), (int)2, (int)2);
                        if (option != 0) return false;
                        this.olapCube.getAggregationSet().resetStoredAggregations();
                    } else {
                        this.olapCube.getAggregationSet().resetStoredAggregations();
                    }
                }
                catch (OLAPException error) {
                    ExceptionHandler.handleException((Exception)((Object)error));
                }
            }
        }
        this.olapCube.setType(this.cubeType);
        try {
            this.olapCube.setWorkPath(ModelUtilities.trim((String)((String)this.inputWorkPath.getSelectedItem())));
            this.tableSet.setLoadType(newLoadType);
        }
        catch (OLAPException error) {
            ExceptionHandler.handleException((Exception)((Object)error));
        }
        try {
            if (!this.tableSet.isLoadStarSchema()) {
                if (this.olapCube.getCompact() != null) {
                    this.olapCube.setCompact(null);
                }
                if (this.olapCube.getMissingDimensionKeys() != null) {
                    this.olapCube.setMissingDimensionKeys(null);
                }
            }
        }
        catch (OLAPException error) {
            ExceptionHandler.handleException((Exception)((Object)error));
        }
        this.firstTime = false;
        this.loadTypeChanged = false;
        this.cubeTypeChanged = false;
        return true;
    }

    public void onParentCancel() {
        this.saveSettingsAndCleanUp();
        super.onParentCancel();
    }

    public String createFinishString() {
        String infoString = null;
        try {
            infoString = this.olapCube.generateCodeLongForm().toString();
        }
        catch (OLAPException error) {
            ExceptionHandler.handleException((Exception)((Object)error));
        }
        return infoString;
    }

    private class AdvancedListener
    implements ActionListener {
        private AdvancedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                int option = 0;
                boolean hasAdvancedOptions = false;
                ArrayList<String> cubeOptions = new ArrayList<String>();
                List listOfDimensions = null;
                List listOfDimensionTables = null;
                try {
                    String cubeOption = CubeGeneralPanel.this.olapCube.getSASCode();
                    cubeOptions.add(cubeOption);
                    hasAdvancedOptions = hasAdvancedOptions || !ModelUtilities.isBlank((String)cubeOption);
                    cubeOption = CubeGeneralPanel.this.olapCube.getFormatSearchOptions();
                    cubeOptions.add(cubeOption);
                    hasAdvancedOptions = hasAdvancedOptions || !ModelUtilities.isBlank((String)cubeOption);
                    cubeOption = CubeGeneralPanel.this.olapCube.getEmptyChar();
                    cubeOptions.add(cubeOption);
                    hasAdvancedOptions = hasAdvancedOptions || cubeOption != null;
                    cubeOption = CubeGeneralPanel.this.olapCube.getEmptyNum();
                    cubeOptions.add(cubeOption);
                    if (CubeGeneralPanel.this.olapCube.getLanguageSet().getSelectedLocales().size() > 0) {
                        cubeOptions.add("languages!");
                        hasAdvancedOptions = true;
                    } else {
                        cubeOptions.add(null);
                    }
                    cubeOption = CubeGeneralPanel.this.olapCube.getCompact();
                    cubeOptions.add(cubeOption);
                    hasAdvancedOptions = hasAdvancedOptions || !ModelUtilities.isBlank((String)cubeOption);
                    hasAdvancedOptions = hasAdvancedOptions || cubeOption != null;
                    DimensionSet dimensionSet = CubeGeneralPanel.this.olapCube.getDimensionSet();
                    listOfDimensions = dimensionSet.getCubeDimensions();
                    listOfDimensionTables = dimensionSet.getTables();
                }
                catch (OLAPException cubeOption) {
                    // empty catch block
                }
                if ((listOfDimensions != null && !listOfDimensions.isEmpty() || listOfDimensionTables != null && !listOfDimensionTables.isEmpty() || hasAdvancedOptions) && CubeGeneralPanel.this.loadTypeChanged && !CubeGeneralPanel.this.firstTime) {
                    CubeResetOptionsPanel resetPanel = null;
                    if (hasAdvancedOptions) {
                        resetPanel = new CubeResetOptionsPanel(CubeGeneralPanel.this.olapCube, cubeOptions);
                        option = MessageUtil.displayDetailsMessage((String)bundle.getString("CubeDesigner.General.InputChanged.Warning.txt"), (String)bundle.getString("Reset.Title.txt"), (int)2, (int)2, (JComponent)resetPanel);
                    } else {
                        option = MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.General.InputChanged.Warning3.txt"), (String)bundle.getString("Reset.Title.txt"), (int)2, (int)2);
                    }
                    if (option == 0) {
                        if (resetPanel != null) {
                            resetPanel.saveToModel();
                        }
                        CubeGeneralPanel.this.olapCube.reset();
                        WAWizardDialog parent = (WAWizardDialog)CubeGeneralPanel.this.getTopLevelAncestor();
                        parent.addWizardData("OLAPCUBE_RESET", (Object)"TRUE");
                        CubeGeneralPanel.this.firstTime = true;
                        CubeGeneralPanel.this.loadTypeChanged = false;
                    }
                }
                if (option == 0) {
                    CubeGeneralPanel.this.tableSet.setLoadType(CubeGeneralPanel.this.inputLoadType.getSelectedItem().toString());
                    GeneralAdvancedDialog advancedDialog = new GeneralAdvancedDialog(CubeGeneralPanel.this.olapCube);
                    advancedDialog.show();
                }
            }
            catch (OLAPException error) {
                ExceptionHandler.handleException((Exception)((Object)error));
            }
        }
    }

    private class BrowseButtonsListener
    implements ActionListener {
        private BrowseButtonsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (Utilities.isConnectedToMetadataServer((boolean)true)) {
                boolean cubePath = event.getSource().equals(CubeGeneralPanel.this.browse);
                WAWizardDialog parent = (WAWizardDialog)CubeGeneralPanel.this.getTopLevelAncestor();
                parent.setCursor(Cursor.getPredefinedCursor(3));
                WsAppServer appserver = WsRunCode.getServer();
                if (appserver != null) {
                    try {
                        appserver.openSASCodeSession();
                    }
                    catch (WsAppServerFailException e) {
                        ExceptionHandler.handleException((Exception)((Object)e));
                    }
                    String windowTitle = "";
                    windowTitle = cubePath ? bundle.getString("CubeDesigner.BrowsePath.title.txt") : bundle.getString("CubeDesigner.BrowseWorkPath.title.txt");
                    String path = "";
                    parent.setCursor(Cursor.getPredefinedCursor(0));
                    try {
                        String inpath = "";
                        inpath = cubePath ? CubeGeneralPanel.this.inputCubePath.getText() : CubeGeneralPanel.this.inputWorkPath.getText();
                        if (!Utilities.isBlank((String)inpath) && !inpath.endsWith("/")) {
                            inpath = inpath + "/";
                        }
                        path = appserver.promptForDirectory(windowTitle, inpath, null, false);
                    }
                    catch (GenericError e) {
                        ExceptionHandler.handleException((Exception)((Object)e));
                    }
                    catch (WsAppServerFailException e) {
                        ExceptionHandler.handleException((Exception)((Object)e));
                    }
                    if (!Utilities.isBlank((String)path)) {
                        if (cubePath) {
                            CubeGeneralPanel.this.inputCubePath.setSelectedItem((Object)path);
                        } else {
                            CubeGeneralPanel.this.inputWorkPath.setSelectedItem((Object)path);
                        }
                    }
                    appserver.closeSASCodeSession();
                } else {
                    MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.General.NoBrowse.txt"));
                }
            }
        }
    }

    private class SelectFolderButtonsListener
    implements ActionListener {
        private SelectFolderButtonsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (Utilities.isConnectedToMetadataServer((boolean)true)) {
                try {
                    PathUrl pathUrl;
                    ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
                    String sPathWithType = Workspace.getMdFactory().getOMIUtil().getObjectPath((MdObjectStore)CubeGeneralPanel.this.folder.getObjectStore(), (PrimaryType)CubeGeneralPanel.this.folder, true);
                    PathUrl m_pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)sPathWithType);
                    SimpleObjectImpl oSimple = null;
                    if (CubeGeneralPanel.this.olapCube != null && !CubeGeneralPanel.this.olapCube.isNewObject()) {
                        oSimple = new SimpleObjectImpl(CubeGeneralPanel.this.originalCubeName, CubeGeneralPanel.this.olapCube.getFQID(), "Cube", "Cube");
                    }
                    SimpleObject[] aObjects = null;
                    if (oSimple != null) {
                        aObjects = new SimpleObject[]{oSimple};
                    }
                    String sInitialPath = null;
                    if (m_pathUrl != null) {
                        sInitialPath = m_pathUrl.toString();
                    }
                    if ((pathUrl = WsMetadataUtil.promptForPathUrl((String)sInitialPath, (boolean)false, (SimpleObject[])aObjects)) != null) {
                        MetadataInterface metadataObject = Workspace.getWorkspace().getInformationService().getObjectByPath(Workspace.getWorkspace().getUserContext(), pathUrl);
                        CubeGeneralPanel.this.folder = (Tree)metadataObject.getRepositoryEntity();
                        MdOMIUtil mdUtil = Workspace.getMdFactory().getOMIUtil();
                        if (CubeGeneralPanel.this.folder != null) {
                            String pathFolder = mdUtil.getObjectPath((MdObjectStore)CubeGeneralPanel.this.folder.getObjectStore(), (PrimaryType)CubeGeneralPanel.this.folder, false);
                            CubeGeneralPanel.this.repositoryFolder.setText(pathFolder);
                        }
                    }
                }
                catch (RemoteException e) {
                    ExceptionHandler.handleException((Exception)e);
                }
                catch (MdException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
                catch (ServiceException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
            }
        }
    }
}

