/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.nls.collator.SASCollatorFactory;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.LanguageSet;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.CubeUserAggregationAddPanel;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.OLAPDualListSelector;
import com.sas.swing.models.CollectionToListModelAdapter;
import com.sas.swing.visuals.dualselector.BaseDualSelector;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;

public class CubeGeneralLanguagePanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(CubeUserAggregationAddPanel.class);
    protected OLAPCube cubeModel;
    protected OLAPDualListSelector listbox;
    protected CollectionToListModelAdapter availModel;
    protected DefaultListModel selectModel;
    protected LanguageSet languageModel;
    protected Properties listOfCountries;
    protected List userSelectedCountries;
    protected boolean saveToCubeModel;
    protected String originalLocale;
    protected TableSet tableSet;
    private List currentLanguages;
    private boolean isInitialLanguages;
    public OLAPList listOfShared;
    private List initialLanguages;
    private boolean firstEntry;

    public CubeGeneralLanguagePanel(OLAPCube CM) throws OLAPException {
        this.cubeModel = CM;
        this.setLayout(new GridBagLayout());
        DimensionSet dimensionSet = CM.getDimensionSet();
        this.listOfShared = dimensionSet.getSharedDimensions();
        this._layoutWidgets();
    }

    public boolean validateData() {
        TreeSet available = (TreeSet)this.availModel.getModel();
        if (this.selectModel.size() == 1) {
            MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.TranslationPanel.OneLanguageSelected.txt"), (int)2);
            return false;
        }
        if (this.originalLocale != null && !this.selectModel.isEmpty() && (available.contains(this.originalLocale) || this.selectModel.indexOf(this.originalLocale) != 0)) {
            if (!this.cubeModel.isNewObject()) {
                String errorMessage = bundle.formatString("CubeDesigner.General.Advanced.DefaultLocale.Edit.fmt.txt", (Object)this.originalLocale);
                MessageUtil.displayMessage((String)errorMessage);
                return false;
            }
            String errorMessage = bundle.formatString("CubeDesigner.General.Advanced.DefaultLocale.Create.fmt.txt", (Object)this.originalLocale);
            int option = MessageUtil.displayMessage((String)errorMessage, (int)2, (int)2);
            if (option == 0) {
                try {
                    this.cubeModel.reset();
                }
                catch (OLAPException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
            } else {
                return false;
            }
        }
        this.currentLanguages.clear();
        for (int t = 0; t < this.selectModel.size(); ++t) {
            String countryName = (String)this.selectModel.elementAt(t);
            this.currentLanguages.add(countryName);
        }
        if (!this.initialLanguages.equals(this.currentLanguages)) {
            this.cubeModel.setLanguageChanged(true);
        } else {
            this.cubeModel.setLanguageChanged(false);
        }
        return true;
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            this.tableSet = this.cubeModel.getTableSet();
            try {
                if (this.tableSet.isLoadStarSchema()) {
                    String countryName;
                    this.languageModel = this.cubeModel.getLanguageSet();
                    this.userSelectedCountries = this.languageModel.getSelectedLocales();
                    if (!this.firstEntry) {
                        this.initialLanguages.addAll(this.userSelectedCountries);
                        this.firstEntry = true;
                    }
                    this.listOfCountries = this.languageModel.getCountries();
                    TreeSet<String> available = new TreeSet<String>((Comparator<String>)SASCollatorFactory.createCollator());
                    for (String string : this.listOfCountries.keySet()) {
                        countryName = this.listOfCountries.getProperty(string.toUpperCase());
                        available.add(countryName);
                    }
                    if (this.userSelectedCountries != null) {
                        for (int i = 0; i < this.userSelectedCountries.size(); ++i) {
                            String string = (String)this.userSelectedCountries.get(i);
                            countryName = this.listOfCountries.getProperty(string.toUpperCase());
                            this.currentLanguages.add(countryName);
                            this.selectModel.addElement(countryName);
                            available.remove(countryName);
                        }
                    }
                    this.isInitialLanguages = this.languageModel.isCubeMultipleLanguageSupported();
                    this.availModel.setModel(available);
                    this.listbox.setModel((ListModel)this.availModel);
                    this.listbox.setTargetModel(this.selectModel);
                    if (this.selectModel.size() > 0) {
                        this.originalLocale = (String)this.selectModel.elementAt(0);
                    }
                    this.saveToCubeModel = true;
                }
            }
            catch (OLAPException e) {
                return ExceptionHandler.handleException((Exception)((Object)e));
            }
        }
        return true;
    }

    public void saveDataToCubeModel() {
        if (this.saveToCubeModel) {
            if (this.userSelectedCountries != null) {
                this.userSelectedCountries.clear();
            }
            for (int t = 0; t < this.selectModel.size(); ++t) {
                String countryName = (String)this.selectModel.elementAt(t);
                String countryCode = this.languageModel.getLocale(countryName);
                this.userSelectedCountries.add(countryCode);
            }
            try {
                if (this.isInitialLanguages && !this.languageModel.isCubeMultipleLanguageSupported()) {
                    this.cubeModel.removeAllIds();
                    this.cubeModel.setDrillThruMemPref(null);
                }
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
            }
        }
    }

    private void _layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.initialLanguages = new ArrayList();
        this.currentLanguages = new ArrayList();
        this.listbox = new OLAPDualListSelector(bundle.getString("CubeDesigner.DeleteLanguage.window.title"), bundle.getString("CubeDesigner.DeleteLanguages.window.title"), bundle.getString("CubeDesigner.DeleteLanguages.txt"), bundle.getString("CubeDesigner.DeleteAllLanguages.txt"));
        this.availModel = new CollectionToListModelAdapter();
        this.selectModel = new DefaultListModel();
        VisualUtilities.setDualSelectorTextAndMnemonic((BaseDualSelector)this.listbox, bundle.getString("CubeDesigner.DualListbox.leftlistbox.txt"), bundle.getString("CubeDesigner.DualListbox.rightlistbox.txt"));
        this.listbox.setCopyModeDuplicatesAllowed(false);
        this.listbox.setTargetControlsVisible(true);
        this.listbox.setTransferAllControlsVisible(true);
        this.listbox.setAlternatingMultipleButtonStyle(true);
        this.listbox.setDragAndDropEnabled(false);
        this.listbox.setToolTipText(bundle.getString("CubeDesigner.TranslationPanel.ToolTip.txt"));
        this.listbox.setName("TranslationListbox");
        if (this.listOfShared.size() > 0) {
            this.listbox.setEnabled(false);
        }
        this.add((Component)((Object)this.listbox), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onCancel() {
        if (this.userSelectedCountries == null || this.userSelectedCountries.size() < 1) {
            this.languageModel = null;
        }
    }
}

