/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class CubeFinishButtonPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(CubeFinishButtonPanel.class);
    private OLAPCube olapCube;
    private JRadioButton buildCube;
    private JRadioButton saveMetadata;
    private JCheckBox disableBox;

    public CubeFinishButtonPanel(OLAPCube inCube) {
        this.olapCube = inCube;
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean saveToModel) {
        return true;
    }

    private void _layoutWidgets() {
        try {
            JLabel saveItem1;
            JLabel saveItemSharedNotExist;
            DimensionSet dimensionSet = this.olapCube.getDimensionSet();
            OLAPList sharedDims = dimensionSet.getSharedDimensions();
            boolean exist = true;
            int size = sharedDims.size();
            for (int i = 0; i < size && exist; ++i) {
                OLAPSharedDimension dim = (OLAPSharedDimension)sharedDims.get(i);
                exist = dim.physicallyExists();
            }
            JLabel howLabel = new JLabel();
            this.buildCube = new JRadioButton();
            this.saveMetadata = new JRadioButton();
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.saveMetadata);
            this.buildCube.setName("BuildCubeRadio");
            this.saveMetadata.setName("SaveMetadataRadio");
            JLabel buildItem1 = new JLabel();
            VisualUtilities.setLabelTextAndMnemonic(buildItem1, bundle.getString("CubeFinishDialog.BuildItem1.txt"));
            this.disableBox = new JCheckBox();
            if (this.olapCube.physicallyExists() && exist) {
                buttonGroup.add(this.buildCube);
                this.buildCube.setSelected(true);
                if (!ModelUtilities.canAdmin((OLAPCube)this.olapCube)) {
                    this.disableBox.setEnabled(false);
                }
                VisualUtilities.setButtonTextAndMnemonic(this.disableBox, bundle.getString("CubeFinishDialog.Disable.Edit.checkbox.label"));
                JLabel buildItem2 = new JLabel();
                VisualUtilities.setLabelTextAndMnemonic(buildItem2, bundle.getString("CubeFinishDialog.BuildItem2.Edit.txt"));
                JLabel buildItem3 = new JLabel();
                VisualUtilities.setLabelTextAndMnemonic(buildItem3, bundle.getString("CubeFinishDialog.BuildItem3.Edit.txt"));
                JLabel saveItem12 = new JLabel();
                VisualUtilities.setLabelTextAndMnemonic(saveItem12, bundle.getString("CubeFinishDialog.SaveItem1.Edit.txt"));
                JLabel saveItem2 = new JLabel();
                VisualUtilities.setLabelTextAndMnemonic(saveItem2, bundle.getString("CubeFinishDialog.SaveItem2.Edit.txt"));
                JLabel saveItem3 = new JLabel();
                VisualUtilities.setLabelTextAndMnemonic(saveItem3, bundle.getString("CubeFinishDialog.SaveItem3.Edit.txt"));
                VisualUtilities.setButtonTextAndMnemonic(this.buildCube, bundle.getString("CubeFinishDialog.BuildPhysical.radio.label"));
                VisualUtilities.setButtonTextAndMnemonic(this.saveMetadata, bundle.getString("CubeFinishDialog.SaveCube.Edit.radio.label"));
                VisualUtilities.setLabelTextAndMnemonic(howLabel, bundle.getString("CubeFinishDialog.How.Edit.txt"));
                Font font = this.getFont();
                float size2 = font.getSize2D() * 1.3f;
                Font boldFont = font.deriveFont(1, size2);
                howLabel.setFont(boldFont);
                this.buildCube.setFont(boldFont);
                this.saveMetadata.setFont(boldFont);
                this.add(howLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(7, 7, 10, 0), 0, 0));
                this.add(this.buildCube, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 28, 0, 0), 0, 0));
                this.add(buildItem1, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 48, 0, 0), 0, 0));
                this.add(buildItem2, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 48, 0, 0), 0, 0));
                this.add(buildItem3, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 48, 10, 0), 0, 0));
                this.add(this.saveMetadata, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 28, 0, 0), 0, 0));
                this.add(saveItem12, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 48, 0, 0), 0, 0));
                this.add(saveItem2, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 48, 0, 0), 0, 0));
                this.add(saveItem3, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 48, 0, 0), 0, 0));
                this.add(this.disableBox, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 18, 2, new Insets(7, 7, 0, 0), 0, 0));
            } else if (!this.olapCube.physicallyExists() && exist) {
                buttonGroup.add(this.buildCube);
                this.buildCube.setSelected(true);
                JLabel saveItem13 = new JLabel();
                VisualUtilities.setLabelTextAndMnemonic(saveItem13, bundle.getString("CubeFinishDialog.SaveItem1.txt"));
                VisualUtilities.setButtonTextAndMnemonic(this.buildCube, bundle.getString("CubeFinishDialog.BuildPhysical.radio.label"));
                VisualUtilities.setButtonTextAndMnemonic(this.saveMetadata, bundle.getString("CubeFinishDialog.SaveCube.radio.label"));
                VisualUtilities.setLabelTextAndMnemonic(howLabel, bundle.getString("CubeFinishDialog.How.txt"));
                Font font = this.getFont();
                float size3 = font.getSize2D() * 1.3f;
                Font boldFont = font.deriveFont(1, size3);
                howLabel.setFont(boldFont);
                this.buildCube.setFont(boldFont);
                this.saveMetadata.setFont(boldFont);
                this.add(howLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(7, 7, 10, 0), 0, 0));
                this.add(this.buildCube, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 28, 0, 0), 0, 0));
                this.add(buildItem1, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 48, 10, 0), 0, 0));
                this.add(this.saveMetadata, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 28, 0, 0), 0, 0));
                this.add(saveItem13, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 48, 0, 10), 0, 0));
            }
            if (this.olapCube.physicallyExists() && !exist) {
                if (!ModelUtilities.canAdmin((OLAPCube)this.olapCube)) {
                    this.disableBox.setEnabled(false);
                }
                this.saveMetadata.setSelected(true);
                VisualUtilities.setButtonTextAndMnemonic(this.disableBox, bundle.getString("CubeFinishDialog.Disable.Edit.checkbox.label"));
                saveItemSharedNotExist = new JLabel();
                VisualUtilities.setLabelTextAndMnemonic(saveItemSharedNotExist, bundle.getString("CubeFinishDialog.SaveItem1.SharedDimensionsNotBuilt.txt"));
                saveItem1 = new JLabel();
                VisualUtilities.setLabelTextAndMnemonic(saveItem1, bundle.getString("CubeFinishDialog.SaveItem1.Edit.txt"));
                JLabel saveItem2 = new JLabel();
                VisualUtilities.setLabelTextAndMnemonic(saveItem2, bundle.getString("CubeFinishDialog.SaveItem2.Edit.txt"));
                JLabel saveItem3 = new JLabel();
                VisualUtilities.setLabelTextAndMnemonic(saveItem3, bundle.getString("CubeFinishDialog.SaveItem3.Edit.txt"));
                VisualUtilities.setButtonTextAndMnemonic(this.saveMetadata, bundle.getString("CubeFinishDialog.SaveCube.Edit.radio.label"));
                VisualUtilities.setLabelTextAndMnemonic(howLabel, bundle.getString("CubeFinishDialog.How.Edit.txt"));
                Font font = this.getFont();
                float size4 = font.getSize2D() * 1.3f;
                Font boldFont = font.deriveFont(1, size4);
                howLabel.setFont(boldFont);
                this.saveMetadata.setFont(boldFont);
                this.add(howLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(7, 7, 10, 0), 0, 0));
                this.add(this.saveMetadata, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 28, 0, 0), 0, 0));
                this.add(saveItemSharedNotExist, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 48, 0, 0), 0, 0));
                this.add(saveItem1, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 48, 0, 0), 0, 0));
                this.add(saveItem2, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 48, 0, 0), 0, 0));
                this.add(saveItem3, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 48, 0, 0), 0, 0));
                this.add(this.disableBox, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 18, 2, new Insets(7, 7, 0, 0), 0, 0));
            } else if (!this.olapCube.physicallyExists() && !exist) {
                this.saveMetadata.setSelected(true);
                saveItemSharedNotExist = new JLabel();
                VisualUtilities.setLabelTextAndMnemonic(saveItemSharedNotExist, bundle.getString("CubeFinishDialog.SaveItem1.SharedDimensionsNotBuilt.txt"));
                saveItem1 = new JLabel();
                VisualUtilities.setLabelTextAndMnemonic(saveItem1, bundle.getString("CubeFinishDialog.SaveItem1.txt"));
                VisualUtilities.setButtonTextAndMnemonic(this.saveMetadata, bundle.getString("CubeFinishDialog.SaveCube.radio.label"));
                VisualUtilities.setLabelTextAndMnemonic(howLabel, bundle.getString("CubeFinishDialog.How.txt"));
                Font font = this.getFont();
                float size5 = font.getSize2D() * 1.3f;
                Font boldFont = font.deriveFont(1, size5);
                howLabel.setFont(boldFont);
                this.buildCube.setFont(boldFont);
                this.saveMetadata.setFont(boldFont);
                this.add(howLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(7, 7, 10, 0), 0, 0));
                this.add(this.saveMetadata, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 28, 0, 0), 0, 0));
                this.add(saveItemSharedNotExist, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 48, 0, 10), 0, 0));
                this.add(saveItem1, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 48, 0, 10), 0, 0));
            }
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
    }

    protected boolean isDisabled() {
        return this.disableBox.isSelected();
    }

    protected boolean isBuildSelected() {
        return this.buildCube.isSelected();
    }
}

