/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.CubeDimensionPanel;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

public class CubeDimensionTab
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(CubeDimensionTab.class);
    protected CubeDimensionPanel m_appPanel;
    protected OLAPCube cubeModel;
    private static final String HOLAP_CUBE = "HOLAP";
    private static final String NON_HOLAP_CUBE = "NEXT";

    public CubeDimensionTab(OLAPCube CM) {
        super(bundle.getString("CubeDesigner.Dimensions.instruct.txt"));
        this.cubeModel = CM;
        this.m_appPanel = new CubeDimensionPanel(this.cubeModel);
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("cd_dimensions");
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        this.m_appPanel.doDataExchange(bSaveToModel);
        return true;
    }

    public boolean validateData() {
        return this.m_appPanel.validateData();
    }

    public String getConditionState() {
        TableSet tableSet = this.cubeModel.getTableSet();
        String ConditionState = NON_HOLAP_CUBE;
        try {
            String cubeType = this.cubeModel.getType();
            if (tableSet.isLoadClassicSAS() & cubeType.equalsIgnoreCase(HOLAP_CUBE)) {
                ConditionState = HOLAP_CUBE;
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        return ConditionState;
    }

    public void _layoutWidgets() {
        this.add((Component)((Object)this.m_appPanel), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void onBack() {
        this.m_appPanel.onBack();
    }
}

