/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.DefinedMemberSet;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.DimensionTable;
import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.model.OLAPMemberProperty;
import com.sas.olapadmin.designer.model.OLAPMemberPropertySet;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.CubeDesigner;
import com.sas.olapadmin.designer.visuals.CubeDimensionMapDialog;
import com.sas.olapadmin.designer.visuals.CubeMemberPropertiesAddDialog;
import com.sas.olapadmin.designer.visuals.CubeSharedDimensionDialog;
import com.sas.olapadmin.designer.visuals.DimDesigner;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.CubeButtons;
import com.sas.olapadmin.utilities.studio.StructureTreeCellRenderer;
import com.sas.util.UsageVersion;
import com.sas.visuals.Resources;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAWizardModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsDecoratableIcon;
import com.sas.workspace.WsPopupMenuRequestListener;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CubeDimensionPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(CubeDimensionPanel.class);
    private static String VERSION_WARNING_SHARED_DIM = "CubeDesigner.SharedDim.Version.Number.Warning";
    static int UPDATE_ALWAYS = 1;
    static int UPDATE_NEVER = 0;
    static int UPDATE_SOMETIMES = 2;
    private CubeButtons buttons;
    private JButton addButton;
    private JButton deleteButton;
    private JButton modifyButton;
    private JButton mapButton;
    private JButton memberPropertyButton;
    private JButton sharedDimButton;
    private JCheckBox showCaption;
    private JTree tree;
    private boolean initialized;
    private OLAPDimension geoDimension;
    protected OLAPCube olapCube;
    private List newList;
    private DimensionSet dimensionSet;
    private TableSet tableSet;
    private WAComboBox updateableDimensions;
    private int lastUpdateableValue;
    private RenameTreeModel treeModel;
    private boolean isStarSchema;
    protected WsAbstractAction addAction;
    protected WsAbstractAction deleteAction;
    protected WsAbstractAction addMemberPropertyAction;
    protected WsAbstractAction modifyAction;
    protected WsAbstractAction renameAction;
    protected WsAbstractAction sharedDimAction;
    private boolean renameAllowed;
    private boolean isShowCaption;
    private PopupListener popupListener;
    private StructureTreeCellRenderer renderer;
    private CubeDesigner designer;
    private PopUpAction popupAction;
    private DefinedMemberSet definedMemberSet;

    public CubeDimensionPanel(OLAPCube CM) {
        this.olapCube = CM;
        this.dimensionSet = this.olapCube.getDimensionSet();
        this.tableSet = this.olapCube.getTableSet();
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public boolean validateData() {
        try {
            List allCubeDimensions;
            TreeCellEditor ce = this.tree.getCellEditor();
            if (ce != null && ce instanceof TreeCellRenameEditor) {
                ce.stopCellEditing();
            }
            if ((allCubeDimensions = this.dimensionSet.getAllCubeDimensions()).isEmpty()) {
                MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.DimensionPanel.NoDimError.txt"), (String)bundle.getString("CubeDesigner.DimensionPanel.NoDimError.window.title"), (int)0);
                return false;
            }
            OLAPList allDimensions = this.dimensionSet.getCubeDimensions();
            int size = allDimensions.size();
            for (int i = 0; i < size; ++i) {
                String dimensionName;
                OLAPHierarchy hierarchy;
                String name;
                OLAPList listOfHierarchies;
                OLAPDimension nextDim = (OLAPDimension)allDimensions.get(i);
                nextDim.verifyAllLevelsUsed();
                if (nextDim.isStarDimension()) {
                    nextDim.verifyStarSchemaKey();
                    nextDim.verifyFactKey();
                }
                if ((listOfHierarchies = nextDim.getHierarchies()).size() != 1 || (name = (hierarchy = (OLAPHierarchy)listOfHierarchies.get(0)).getName()).equalsIgnoreCase(dimensionName = nextDim.getName())) continue;
                MessageUtil.displayMessage((String)bundle.getString("DimDesigner.Hierarchy.Rename.Hierarchy.txt"));
                hierarchy.setName(dimensionName);
            }
            AggregationSet aggregationSet = this.olapCube.getAggregationSet();
            if (aggregationSet.isResetLevels()) {
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                parent.addWizardData("TABLECHANGEDMEASURES", (Object)"YES");
                OLAPList listOfAggregations = aggregationSet.getAggregations();
                int size2 = listOfAggregations.size();
                if (size2 == 1) {
                    OLAPAggregation aggregation = (OLAPAggregation)listOfAggregations.get(0);
                    if (!aggregation.isNway()) {
                        MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.Reset.Aggregations.txt"), (int)2);
                    }
                    aggregationSet.resetLevels();
                } else if (size2 > 1) {
                    MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.Reset.Aggregations.txt"), (int)2);
                    aggregationSet.resetLevels();
                }
            }
        }
        catch (OLAPException OLAPError) {
            ExceptionHandler.handleException((Exception)((Object)OLAPError));
            return false;
        }
        try {
            this.definedMemberSet.synchDefinedMembers();
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
            return false;
        }
        return true;
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            try {
                WAWizardDialog parent;
                String tableChanges;
                if (!this.initialized) {
                    this.initialize();
                }
                if ((tableChanges = (String)(parent = (WAWizardDialog)this.getTopLevelAncestor()).getWizardData("TABLECHANGED")) != null || this.dimensionSet.getAllCubeDimensions().isEmpty() && this.initialized) {
                    OLAPObjectNode root = (OLAPObjectNode)this.treeModel.getRoot();
                    root.removeAllChildren();
                    this.setUpDimensionTree();
                    parent.removeWizardData("TABLECHANGED");
                    parent.addWizardData("TABLECHANGEDMEASURES", (Object)"YES");
                }
                if (this.tableSet.isLoadStarSchema()) {
                    this.isStarSchema = true;
                    if (this.olapCube.getLanguageSet().isCubeMultipleLanguageSupported()) {
                        this.sharedDimButton.setEnabled(false);
                    } else {
                        this.sharedDimButton.setEnabled(true);
                    }
                } else {
                    this.sharedDimButton.setEnabled(false);
                }
                if (this.olapCube.getType().equals("HOLAP")) {
                    this.updateableDimensions.setEnabled(false);
                    this.olapCube.setUpdateableDimensions("1");
                    this.dimensionSet.allUpdateableDimensions = UPDATE_NEVER;
                    this.updateableDimensions.setSelectedIndex(UPDATE_NEVER);
                } else {
                    this.updateableDimensions.setEnabled(true);
                }
            }
            catch (OLAPException OLAPError) {
                ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
        }
        return true;
    }

    protected void initialize() {
        try {
            this.tree.getInputMap().put(KeyStroke.getKeyStroke(121, 64, false), "popup");
            this.popupAction = new PopUpAction();
            this.tree.getActionMap().put("popup", (Action)((Object)this.popupAction));
            this.designer = (CubeDesigner)((Object)this.getTopLevelAncestor());
            this.newList = new ArrayList();
            this.setUpDimensionTree();
            this.popupListener = new PopupListener();
            this.tree.addMouseListener(this.popupListener);
            this.addAction = new NewDimensionAction();
            this.modifyAction = new ModifyAction();
            this.renameAction = new RenameAction();
            this.deleteAction = new DeleteAction();
            this.sharedDimAction = new NewSharedDimensionAction();
            this.addMemberPropertyAction = new NewMemberPropertyAction();
            this.lastUpdateableValue = -1;
            this.updateableDimensions.addItem((Object)bundle.getString("CubeDesigner.UpdateableDimensionNever.control.label"));
            this.updateableDimensions.addItem((Object)bundle.getString("CubeDesigner.UpdateableDimensionAlways.control.label"));
            this.updateableDimensions.addItem((Object)bundle.getString("CubeDesigner.UpdateableDimensionSometimes.control.label"));
            this.updateableDimensions.addActionListener((ActionListener)new UpdateDimensionsListener());
            int setUpdateableDimensions = UPDATE_ALWAYS;
            String cubeUpdateValue = this.olapCube.getUpdateableDimensions();
            String typeOfCube = this.olapCube.getType();
            List dimensions = this.dimensionSet.getAllCubeDimensions();
            if (cubeUpdateValue != null && cubeUpdateValue.equals("1") || typeOfCube.equals("HOLAP")) {
                setUpdateableDimensions = UPDATE_NEVER;
            } else {
                int count = 0;
                int size = dimensions.size();
                for (int i = 0; i < size; ++i) {
                    OLAPDimension currentDimension = (OLAPDimension)dimensions.get(i);
                    if (currentDimension.isUpdateable()) continue;
                    ++count;
                }
                if (!dimensions.isEmpty() && count == dimensions.size()) {
                    setUpdateableDimensions = UPDATE_NEVER;
                } else if (count > 0) {
                    setUpdateableDimensions = UPDATE_SOMETIMES;
                }
            }
            this.updateableDimensions.setSelectedIndex(setUpdateableDimensions);
            this.dimensionSet.allUpdateableDimensions = setUpdateableDimensions;
            this.addButton.setToolTipText(bundle.getString("CubeDesigner.DimensionPanel.AddTip.txt"));
            this.addButton.setName("DimensionAddButton");
            this.addButton.addActionListener(new AddButtonListener());
            this.deleteButton.setEnabled(false);
            this.deleteButton.setName("DimensionDeleteButton");
            this.deleteButton.setToolTipText(bundle.getString("CubeDesigner.DimensionPanel.DeleteTip.txt"));
            this.deleteButton.addActionListener(new DeleteButtonListener());
            this.modifyButton.setEnabled(false);
            this.modifyButton.setName("DimensionModifyButton");
            this.modifyButton.setToolTipText(bundle.getString("CubeDesigner.DimensionPanel.ModifyTip.txt"));
            this.modifyButton.addActionListener(new ModifyButtonlistener());
            this.mapButton.setEnabled(false);
            this.mapButton.setName("DimensionMapButton");
            this.mapButton.setToolTipText(bundle.getString("CubeDesigner.DimensionPanel.MapButton.tooltip.txt"));
            this.mapButton.addActionListener(new MapButtonListener());
            this.memberPropertyButton.setEnabled(false);
            this.memberPropertyButton.setName("DimensionMemberPropertyButton");
            this.memberPropertyButton.setToolTipText(bundle.getString("CubeDesigner.DimensionPanel.MemberPropertyButton.tip"));
            this.memberPropertyButton.addActionListener(new MemberPropertyButtonlistener());
            this.showCaption.setName("showCaption");
            this.showCaption.addActionListener(new ShowCaptionListener());
            this.lastUpdateableValue = setUpdateableDimensions;
            this.definedMemberSet = this.olapCube.getDefinedMemberSet();
            this.definedMemberSet.getDefinedMembers();
            this.initialized = true;
        }
        catch (OLAPException OLAPError) {
            ExceptionHandler.handleException((Exception)((Object)OLAPError));
        }
    }

    private void _layoutWidgets() {
        this.buttons = new CubeButtons();
        this.treeModel = new RenameTreeModel(new OLAPObjectNode((AbstractOLAPModel)this.olapCube));
        this.tree = new JTree(this.treeModel);
        this.updateableDimensions = new WAComboBox();
        JLabel labelForUpdate = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(labelForUpdate, bundle.getString("CubeDesigner.UpdateableDimension.control.label"));
        this.updateableDimensions.setToolTipText(bundle.getString("DimDesigner.NoDimensionUpdate.checkbox.ToolTip.txt"));
        this.addButton = this.buttons.getAddButton();
        VisualUtilities.setButtonTextAndMnemonic(this.addButton, bundle.getString("Common.addSharedDimension.txt"));
        this.modifyButton = this.buttons.getModifyButton();
        this.deleteButton = this.buttons.getDeleteButton();
        this.mapButton = this.buttons.getApplyButton();
        VisualUtilities.setButtonTextAndMnemonic(this.mapButton, bundle.getString("CubeDesigner.DimensionPanel.MapButton.txt"));
        this.memberPropertyButton = this.buttons.getResetButton();
        VisualUtilities.setButtonTextAndMnemonic(this.memberPropertyButton, bundle.getString("CubeDesigner.DimensionPanel.AddMemberProperty.control.label.txt"));
        this.sharedDimButton = this.buttons.getDefaultButton();
        VisualUtilities.setButtonTextAndMnemonic(this.sharedDimButton, bundle.getString("CubeDesigner.DimensionPanel.AddSharedDim.control.label.txt"));
        this.sharedDimButton.setToolTipText(bundle.getString("CubeDesigner.DimensionPanel.SharedDim.tip"));
        this.sharedDimButton.setName("SharedDimensionAddButton");
        this.sharedDimButton.addActionListener(new AddSharedDimButtonListener());
        JScrollPane scrollPane = new JScrollPane(this.tree);
        scrollPane.setName("DimensionAdded");
        JLabel labelListBox = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(labelListBox, bundle.getString("CubeDesigner.Dimensions.tree.control.label"));
        labelListBox.setLabelFor(this.tree);
        this.tree.setToolTipText(bundle.getString("CubeDesigner.DimensionPanel.TreeTip1.txt"));
        this.tree.addTreeSelectionListener(new DimensionTreeListener());
        this.tree.setEditable(true);
        this.tree.setInvokesStopCellEditing(true);
        this.renderer = new DecoratableStructureTreeCellRenderer();
        this.tree.setCellRenderer(this.renderer);
        this.tree.setCellEditor(new TreeCellRenameEditor(this.tree, this.renderer));
        this.showCaption = new JCheckBox();
        VisualUtilities.setButtonTextAndMnemonic(this.showCaption, bundle.getString("CubeDesigner.DimensionPanel.ShowCaption.control.label"));
        this.add(labelListBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(scrollPane, new GridBagConstraints(0, 1, 2, 2, 1.0, 1.0, 18, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.add(labelForUpdate, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.updateableDimensions, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)((Object)this.buttons), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.showCaption, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
    }

    public void onBack() {
        TreeCellEditor ce = this.tree.getCellEditor();
        if (ce != null && ce instanceof TreeCellRenameEditor) {
            ce.stopCellEditing();
        }
    }

    private void setButtonsState() {
        TreePath[] selectedObjectPaths = this.tree.getSelectionPaths();
        if (selectedObjectPaths != null) {
            int size = selectedObjectPaths.length;
            if (size == 1) {
                OLAPObjectNode node = (OLAPObjectNode)selectedObjectPaths[0].getLastPathComponent();
                TreeNode[] nodes = node.getPath();
                OLAPObjectNode topLevelNode = null;
                if (nodes.length > 1) {
                    topLevelNode = (OLAPObjectNode)nodes[1];
                }
                Object nextObject = node.getUserObject();
                this.renameAllowed = true;
                if (nextObject instanceof OLAPCube) {
                    this.modifyButton.setEnabled(false);
                    this.deleteButton.setEnabled(false);
                    this.mapButton.setEnabled(false);
                    this.memberPropertyButton.setEnabled(false);
                    this.renameAllowed = false;
                } else if (nextObject instanceof OLAPSharedDimension) {
                    this.renameAllowed = false;
                    this.modifyButton.setEnabled(false);
                    this.deleteButton.setEnabled(true);
                    this.mapButton.setEnabled(false);
                    this.memberPropertyButton.setEnabled(false);
                } else if (nextObject instanceof OLAPDimension) {
                    OLAPDimension dimension = (OLAPDimension)nextObject;
                    this.modifyButton.setEnabled(true);
                    this.deleteButton.setEnabled(true);
                    if (dimension.equals(this.geoDimension)) {
                        this.mapButton.setEnabled(true);
                    } else {
                        this.mapButton.setEnabled(false);
                    }
                    this.memberPropertyButton.setEnabled(false);
                } else if (nextObject instanceof OLAPHierarchy) {
                    if (topLevelNode.getUserObject() instanceof OLAPSharedDimension) {
                        this.renameAllowed = false;
                        this.modifyButton.setEnabled(false);
                        this.deleteButton.setEnabled(false);
                    } else {
                        this.modifyButton.setEnabled(true);
                        this.deleteButton.setEnabled(true);
                    }
                    this.mapButton.setEnabled(false);
                    this.memberPropertyButton.setEnabled(false);
                } else if (nextObject instanceof OLAPLevel) {
                    if (topLevelNode.getUserObject() instanceof OLAPSharedDimension) {
                        this.renameAllowed = false;
                        this.modifyButton.setEnabled(false);
                        this.deleteButton.setEnabled(false);
                        this.memberPropertyButton.setEnabled(false);
                    } else {
                        this.modifyButton.setEnabled(true);
                        this.deleteButton.setEnabled(true);
                        this.memberPropertyButton.setEnabled(true);
                    }
                    this.mapButton.setEnabled(false);
                } else if (nextObject instanceof OLAPMemberProperty) {
                    if (topLevelNode.getUserObject() instanceof OLAPSharedDimension) {
                        this.renameAllowed = false;
                        this.modifyButton.setEnabled(false);
                        this.deleteButton.setEnabled(false);
                    } else {
                        this.modifyButton.setEnabled(true);
                        this.deleteButton.setEnabled(true);
                    }
                    this.mapButton.setEnabled(false);
                    this.memberPropertyButton.setEnabled(false);
                }
            } else {
                this.renameAllowed = false;
                this.modifyButton.setEnabled(false);
                this.deleteButton.setEnabled(true);
                this.mapButton.setEnabled(false);
                this.memberPropertyButton.setEnabled(false);
            }
        } else {
            this.renameAllowed = false;
            this.modifyButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.mapButton.setEnabled(false);
            this.memberPropertyButton.setEnabled(false);
        }
    }

    private void setUpDimensionTree() {
        try {
            List allDimensions = this.dimensionSet.getAllCubeDimensions();
            this.newList.clear();
            this.newList.addAll(allDimensions);
            Collections.sort(this.newList);
            OLAPObjectNode root = (OLAPObjectNode)this.treeModel.getRoot();
            int size = this.newList.size();
            for (int i = 0; i < size; ++i) {
                OLAPSharedDimension dimension;
                OLAPList hierarchies = null;
                OLAPObjectNode dimensionNode = null;
                AbstractOLAPModel nextObject = (AbstractOLAPModel)this.newList.get(i);
                if (nextObject instanceof OLAPSharedDimension) {
                    dimension = (OLAPSharedDimension)nextObject;
                    if (dimension.isGeography()) {
                        this.geoDimension = dimension;
                    }
                    dimensionNode = new OLAPObjectNode((AbstractOLAPModel)dimension);
                    root.add(dimensionNode);
                    hierarchies = dimension.getHierarchies();
                } else {
                    dimension = (OLAPDimension)nextObject;
                    if (dimension.isGeography()) {
                        this.geoDimension = dimension;
                    }
                    dimensionNode = new OLAPObjectNode((AbstractOLAPModel)dimension);
                    root.add(dimensionNode);
                    hierarchies = dimension.getHierarchies();
                }
                for (int j = 0; j < hierarchies.size(); ++j) {
                    OLAPHierarchy hierarchy = (OLAPHierarchy)hierarchies.get(j);
                    OLAPObjectNode hierarchyNode = new OLAPObjectNode((AbstractOLAPModel)hierarchy);
                    dimensionNode.add(hierarchyNode);
                    OLAPList levels = hierarchy.getLevels();
                    for (int k = 0; k < levels.size(); ++k) {
                        OLAPLevel level = (OLAPLevel)levels.get(k);
                        OLAPObjectNode levelNode = new OLAPObjectNode((AbstractOLAPModel)level);
                        hierarchyNode.add(levelNode);
                        levelNode.setParent(hierarchyNode);
                        OLAPList memberProperties = level.getOLAPProperties();
                        int sizeMP = memberProperties.size();
                        for (int t = 0; t < sizeMP; ++t) {
                            OLAPMemberProperty member = (OLAPMemberProperty)memberProperties.get(t);
                            OLAPList listOfMPHierarchies = member.getHierarchies();
                            if (!listOfMPHierarchies.contains(hierarchy)) continue;
                            OLAPObjectNode memberPropertyNode = new OLAPObjectNode((AbstractOLAPModel)member);
                            memberPropertyNode.setAllowsChildren(false);
                            this.treeModel.insertNodeInto(memberPropertyNode, levelNode, levelNode.getChildCount());
                            memberPropertyNode.setParent(levelNode);
                        }
                    }
                }
            }
            this.treeModel.reload();
            this.tree.expandPath(new TreePath(root));
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
    }

    private void deleteSharedDimension(MeasureSet measureSet, OLAPObjectNode objectNode, Object object) throws OLAPException {
        OLAPSharedDimension selectedDimension = (OLAPSharedDimension)object;
        selectedDimension.deleteFromCube();
        if (selectedDimension.isGeography()) {
            this.geoDimension = null;
        }
        this.olapCube.getAggregationSet().setResetLevels(true);
        measureSet.synchNuniqueLevel();
        measureSet.synchNuniqueHierarchy();
        WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
        parent.addWizardData("TABLECHANGEDMEASURES", (Object)"YES");
        this.treeModel.removeNodeFromParent(objectNode);
    }

    private List expandList() {
        ArrayList<TreePath> expandedNodes = new ArrayList<TreePath>();
        OLAPObjectNode root = (OLAPObjectNode)this.treeModel.getRoot();
        boolean nodeHierExpandedFound = false;
        boolean nodeLevelExpandedFound = false;
        boolean isExpanded = false;
        boolean isExpandedLevel = false;
        for (int i = 0; i < root.getChildCount(); ++i) {
            TreePath path;
            DefaultMutableTreeNode dimNode = (DefaultMutableTreeNode)root.getChildAt(i);
            nodeHierExpandedFound = false;
            int size = dimNode.getChildCount();
            for (int t = 0; t < size; ++t) {
                DefaultMutableTreeNode hierNode = (DefaultMutableTreeNode)dimNode.getChildAt(t);
                TreePath path2 = new TreePath(hierNode.getPath());
                isExpanded = this.tree.isExpanded(path2);
                if (!isExpanded) continue;
                nodeLevelExpandedFound = false;
                int sizeLevels = hierNode.getChildCount();
                for (int a = 0; a < sizeLevels; ++a) {
                    DefaultMutableTreeNode levelNode = (DefaultMutableTreeNode)hierNode.getChildAt(a);
                    TreePath pathLevel = new TreePath(levelNode.getPath());
                    isExpandedLevel = this.tree.isExpanded(pathLevel);
                    if (!isExpandedLevel) continue;
                    expandedNodes.add(pathLevel);
                    nodeLevelExpandedFound = true;
                    nodeHierExpandedFound = true;
                }
                if (nodeLevelExpandedFound) continue;
                expandedNodes.add(path2);
                nodeHierExpandedFound = true;
            }
            if (nodeHierExpandedFound || !(isExpanded = this.tree.isExpanded(path = new TreePath(dimNode.getPath())))) continue;
            expandedNodes.add(path);
        }
        return expandedNodes;
    }

    private OLAPObjectNode findNode(DefaultMutableTreeNode node, AbstractOLAPModel object) {
        if (node == null) {
            return null;
        }
        int numChildNodes = node.getChildCount();
        OLAPObjectNode foundNode = null;
        for (int i = 0; i < numChildNodes && foundNode == null; ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            OLAPObjectNode simpleChildNode = (OLAPObjectNode)childNode;
            AbstractOLAPModel checkObject = (AbstractOLAPModel)simpleChildNode.getUserObject();
            if (!checkObject.equals(object)) continue;
            foundNode = simpleChildNode;
        }
        return foundNode;
    }

    public JPopupMenu createTreePopupMenu() {
        JMenu mnuPopup = new JMenu();
        mnuPopup.add((Action)this.modifyAction);
        mnuPopup.addSeparator();
        mnuPopup.add((Action)this.addAction);
        mnuPopup.add((Action)this.addMemberPropertyAction);
        mnuPopup.add((Action)this.sharedDimAction);
        mnuPopup.addSeparator();
        mnuPopup.add((Action)this.deleteAction);
        mnuPopup.add((Action)this.renameAction);
        return mnuPopup.getPopupMenu();
    }

    private void setActions() {
        if (this.addButton.isEnabled()) {
            this.addAction.setEnabled(true);
        } else {
            this.addAction.setEnabled(false);
        }
        if (this.sharedDimButton.isEnabled()) {
            this.sharedDimAction.setEnabled(true);
        } else {
            this.sharedDimAction.setEnabled(false);
        }
        if (this.modifyButton.isEnabled()) {
            this.modifyAction.setEnabled(true);
        } else {
            this.modifyAction.setEnabled(false);
        }
        if (this.memberPropertyButton.isEnabled()) {
            this.addMemberPropertyAction.setEnabled(true);
        } else {
            this.addMemberPropertyAction.setEnabled(false);
        }
        if (this.renameAllowed) {
            this.renameAction.setEnabled(true);
        } else {
            this.renameAction.setEnabled(false);
        }
        if (this.deleteButton.isEnabled()) {
            this.deleteAction.setEnabled(true);
        } else {
            this.deleteAction.setEnabled(false);
        }
    }

    private class OLAPObjectNode
    extends DefaultMutableTreeNode
    implements Comparable {
        private static final long serialVersionUID = 1L;

        OLAPObjectNode(AbstractOLAPModel inputObject) {
            this.userObject = inputObject;
        }

        @Override
        public String toString() {
            String objectName = null;
            AbstractOLAPModel olapObject = (AbstractOLAPModel)this.userObject;
            objectName = CubeDimensionPanel.this.isShowCaption ? olapObject.getDesc() : olapObject.getName();
            return objectName;
        }

        public int compareTo(Object obj) {
            int compnum = this.toString().compareToIgnoreCase(obj.toString());
            return compnum;
        }

        public void rename(OLAPObjectNode node, String newName) {
            AbstractOLAPModel olapObject = (AbstractOLAPModel)this.userObject;
            if (!CubeDimensionPanel.this.isShowCaption) {
                olapObject.setName(newName);
            } else {
                olapObject.setDesc(newName);
            }
        }

        public Icon getIcon() {
            return CubeDimensionPanel.this.renderer.getIcon();
        }
    }

    public class RenameTreeModel
    extends DefaultTreeModel {
        private static final long serialVersionUID = 1L;

        public RenameTreeModel(OLAPObjectNode root) {
            super(root, true);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object value) {
            OLAPObjectNode node = (OLAPObjectNode)path.getLastPathComponent();
            this.nodeChanged(node);
        }
    }

    private class TreeCellRenameEditor
    extends DefaultTreeCellEditor {
        protected WATextField m_txtEditor;

        public TreeCellRenameEditor(JTree atree, TreeCellRenderer arenderer) {
            super(atree, (DefaultTreeCellRenderer)arenderer);
        }

        @Override
        protected void determineOffset(JTree atree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            if (value instanceof OLAPObjectNode) {
                this.editingIcon = ((OLAPObjectNode)value).getIcon();
                this.offset = this.renderer.getIconTextGap();
                if (this.editingIcon != null) {
                    this.offset += this.editingIcon.getIconWidth();
                }
            } else {
                super.determineOffset(atree, value, isSelected, expanded, leaf, row);
            }
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (!this.tree.isEditable()) {
                return false;
            }
            OLAPObjectNode node = (OLAPObjectNode)this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return false;
            }
            Object nodeObject = node.getUserObject();
            if (nodeObject instanceof OLAPCube || nodeObject instanceof OLAPSharedDimension) {
                return false;
            }
            return super.isCellEditable(e);
        }

        @Override
        protected TreeCellEditor createTreeCellEditor() {
            this.m_txtEditor = new WATextField();
            this.m_txtEditor.setMaxCharacters(32);
            this.m_txtEditor.setBorder(UIManager.getBorder("Tree.editorBorder"));
            DefaultCellEditor editor = new DefaultCellEditor((JTextField)this.m_txtEditor){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean stopCellEditing() {
                    boolean bEditingStopped;
                    TreePath path = TreeCellRenameEditor.this.tree.getEditingPath();
                    if (path != null) {
                        OLAPObjectNode node = (OLAPObjectNode)path.getLastPathComponent();
                        AbstractOLAPModel objectSelected = (AbstractOLAPModel)node.getUserObject();
                        String objectNameDesc = TreeCellRenameEditor.this.m_txtEditor.getText();
                        String originalName = null;
                        try {
                            if (objectSelected instanceof OLAPDimension) {
                                OLAPDimension dimension = (OLAPDimension)objectSelected;
                                originalName = dimension.getName();
                                if (!CubeDimensionPanel.this.isShowCaption) {
                                    dimension.setUndo(false);
                                    dimension.setName(objectNameDesc);
                                    dimension.verifyName();
                                    dimension.setUndo(true);
                                } else {
                                    dimension.setDesc(objectNameDesc);
                                }
                            } else if (objectSelected instanceof OLAPHierarchy) {
                                OLAPHierarchy hierarchy = (OLAPHierarchy)objectSelected;
                                originalName = hierarchy.getName();
                                if (!CubeDimensionPanel.this.isShowCaption) {
                                    OLAPDimension nextDim = hierarchy.getDimension();
                                    OLAPList listOfHierarchies = nextDim.getHierarchies();
                                    boolean updateName = true;
                                    if (listOfHierarchies.size() == 1) {
                                        String dimensionName = nextDim.getName();
                                        updateName = objectNameDesc.equalsIgnoreCase(dimensionName);
                                    }
                                    if (updateName) {
                                        hierarchy.setUndo(false);
                                        hierarchy.setName(objectNameDesc);
                                        hierarchy.verifyName();
                                        hierarchy.setUndo(true);
                                    } else {
                                        MessageUtil.displayMessage((String)bundle.getString("DimDesigner.Hierarchy.Rename.Hierarchy.txt"));
                                    }
                                } else {
                                    hierarchy.setDesc(objectNameDesc);
                                }
                            } else if (objectSelected instanceof OLAPLevel) {
                                OLAPLevel level = (OLAPLevel)objectSelected;
                                originalName = level.getName();
                                if (!CubeDimensionPanel.this.isShowCaption) {
                                    level.setUndo(false);
                                    level.setName(objectNameDesc);
                                    level.verifyName();
                                    level.setUndo(true);
                                } else {
                                    level.setDesc(objectNameDesc);
                                }
                            } else if (objectSelected instanceof OLAPMeasure) {
                                OLAPMeasure measure = (OLAPMeasure)objectSelected;
                                originalName = measure.getName();
                                if (!CubeDimensionPanel.this.isShowCaption) {
                                    measure.setName(objectNameDesc);
                                    measure.verifyName();
                                } else {
                                    measure.setDesc(objectNameDesc);
                                }
                            } else if (objectSelected instanceof OLAPMemberProperty) {
                                OLAPMemberProperty property = (OLAPMemberProperty)objectSelected;
                                originalName = property.getName();
                                if (!CubeDimensionPanel.this.isShowCaption) {
                                    property.setName(objectNameDesc);
                                    property.verifyName();
                                    property.verifyUniqueOLAPMemberProperty();
                                } else {
                                    property.setDesc(objectNameDesc);
                                }
                            }
                        }
                        catch (OLAPException oError) {
                            ExceptionHandler.handleException((Exception)((Object)oError));
                            objectSelected.setName(originalName);
                            return false;
                        }
                    }
                    if ((bEditingStopped = super.stopCellEditing()) && path != null) {
                        TreeCellRenameEditor.this.tree.setSelectionPath(path);
                        TreeCellRenameEditor.this.tree.scrollPathToVisible(path);
                    }
                    return bEditingStopped;
                }
            };
            editor.setClickCountToStart(1);
            return editor;
        }
    }

    protected class PopUpAction
    extends WsAbstractAction {
        public void actionPerformed(ActionEvent e) {
            CubeDimensionPanel.this.setActions();
            JPopupMenu mnuPopup = CubeDimensionPanel.this.createTreePopupMenu();
            Point pt = CubeDimensionPanel.this.tree.isSelectionEmpty() ? CubeDimensionPanel.this.getLocation() : CubeDimensionPanel.this.tree.getPathBounds(CubeDimensionPanel.this.tree.getLeadSelectionPath()).getLocation();
            mnuPopup.show((Component)e.getSource(), pt.x, pt.y);
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                TreePath selPath = CubeDimensionPanel.this.tree.getPathForLocation(e.getX(), e.getY());
                if (selPath != null) {
                    CubeDimensionPanel.this.tree.setSelectionPath(selPath);
                }
                CubeDimensionPanel.this.setActions();
                CubeDimensionPanel.this.createTreePopupMenu().show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    protected class NewDimensionAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public NewDimensionAction() {
            super(bundle, "CubeDesigner.DimensionPanel.Add.control.label", 256);
        }

        public void actionPerformed(ActionEvent e) {
            CubeDimensionPanel.this.addButton.doClick();
        }
    }

    protected class ModifyAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public ModifyAction() {
            super(bundle, "CubeDesigner.DimensionPanel.Modify.control.label", 256);
        }

        public void actionPerformed(ActionEvent e) {
            CubeDimensionPanel.this.modifyButton.doClick();
        }
    }

    protected class RenameAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public RenameAction() {
            super(bundle, "CubeDesigner.DimensionPanel.Rename.control.label", 256);
        }

        public void actionPerformed(ActionEvent e) {
            TreePath pathSelected = CubeDimensionPanel.this.tree.getSelectionPath();
            CubeDimensionPanel.this.tree.startEditingAtPath(pathSelected);
        }
    }

    protected class DeleteAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public DeleteAction() {
            super(bundle, "CubeDesigner.DimensionPanel.Delete.control.label", 256);
        }

        public void actionPerformed(ActionEvent e) {
            CubeDimensionPanel.this.deleteButton.doClick();
        }
    }

    protected class NewSharedDimensionAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public NewSharedDimensionAction() {
            super(bundle, "CubeDesigner.DimensionPanel.AddSharedDim.control.label", 256);
        }

        public void actionPerformed(ActionEvent e) {
            CubeDimensionPanel.this.sharedDimButton.doClick();
        }
    }

    protected class NewMemberPropertyAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public NewMemberPropertyAction() {
            super(bundle, "CubeDesigner.DimensionPanel.AddMemberProperty.control.label", 256);
        }

        public void actionPerformed(ActionEvent e) {
            CubeDimensionPanel.this.memberPropertyButton.doClick();
        }
    }

    public class UpdateDimensionsListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            int updateOption = CubeDimensionPanel.this.updateableDimensions.getSelectedIndex();
            try {
                List dimensions = CubeDimensionPanel.this.dimensionSet.getAllCubeDimensions();
                if (CubeDimensionPanel.this.lastUpdateableValue != updateOption) {
                    if (updateOption != UPDATE_SOMETIMES) {
                        int size = dimensions.size();
                        for (int i = 0; i < size; ++i) {
                            OLAPDimension olapDimension = (OLAPDimension)dimensions.get(i);
                            if (updateOption == 0) {
                                olapDimension.setUpdateable("1");
                                continue;
                            }
                            olapDimension.setUpdateable("0");
                        }
                        if (updateOption == UPDATE_NEVER) {
                            CubeDimensionPanel.this.olapCube.setUpdateableDimensions("1");
                            ((CubeDimensionPanel)CubeDimensionPanel.this).dimensionSet.allUpdateableDimensions = UPDATE_NEVER;
                        } else {
                            CubeDimensionPanel.this.olapCube.setUpdateableDimensions("0");
                            ((CubeDimensionPanel)CubeDimensionPanel.this).dimensionSet.allUpdateableDimensions = UPDATE_ALWAYS;
                        }
                    } else {
                        ((CubeDimensionPanel)CubeDimensionPanel.this).dimensionSet.allUpdateableDimensions = UPDATE_SOMETIMES;
                        CubeDimensionPanel.this.olapCube.setUpdateableDimensions("0");
                    }
                    CubeDimensionPanel.this.lastUpdateableValue = updateOption;
                }
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
            }
        }
    }

    private final class AddButtonListener
    implements ActionListener {
        private AddButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CubeDimensionPanel.this.setCursor(new Cursor(3));
            TreeCellEditor ce = CubeDimensionPanel.this.tree.getCellEditor();
            if (ce != null && ce instanceof TreeCellRenameEditor) {
                ce.stopCellEditing();
            }
            OLAPDimension dimension = null;
            try {
                dimension = CubeDimensionPanel.this.dimensionSet.createOLAPDimension();
                Workspace workspace = Workspace.getWorkspace();
                if (CubeDimensionPanel.this.updateableDimensions.getSelectedIndex() == UPDATE_NEVER) {
                    dimension.setUpdateable("1");
                } else {
                    dimension.setUpdateable("0");
                }
                DimDesigner dimdesigner = new DimDesigner((Frame)workspace, bundle.getString("DimDesigner.Title.txt"), dimension);
                dimdesigner.show();
                List dimensions = CubeDimensionPanel.this.dimensionSet.getAllCubeDimensions();
                if (dimdesigner.getReturnValue() == 1) {
                    MeasureSet measureSet;
                    CubeDimensionPanel.this.newList.clear();
                    CubeDimensionPanel.this.newList.addAll(dimensions);
                    Collections.sort(CubeDimensionPanel.this.newList);
                    int whereToPutNewDim = CubeDimensionPanel.this.newList.indexOf(dimension);
                    if (dimensions.isEmpty()) {
                        whereToPutNewDim = 0;
                    }
                    OLAPObjectNode root = (OLAPObjectNode)CubeDimensionPanel.this.treeModel.getRoot();
                    OLAPObjectNode dimensionNode = new OLAPObjectNode((AbstractOLAPModel)dimension);
                    dimensionNode.setAllowsChildren(true);
                    CubeDimensionPanel.this.treeModel.insertNodeInto(dimensionNode, root, whereToPutNewDim);
                    OLAPList hierarchies = dimension.getHierarchies();
                    for (int j = 0; j < hierarchies.size(); ++j) {
                        OLAPHierarchy hierarchy = (OLAPHierarchy)hierarchies.get(j);
                        OLAPObjectNode hierarchyNode = new OLAPObjectNode((AbstractOLAPModel)hierarchy);
                        hierarchyNode.setAllowsChildren(true);
                        dimensionNode.add(hierarchyNode);
                        hierarchyNode.setParent(dimensionNode);
                        OLAPList levels = hierarchy.getLevels();
                        for (int k = 0; k < levels.size(); ++k) {
                            OLAPLevel level = (OLAPLevel)levels.get(k);
                            OLAPObjectNode levelNode = new OLAPObjectNode((AbstractOLAPModel)level);
                            levelNode.setAllowsChildren(true);
                            hierarchyNode.add(levelNode);
                            levelNode.setParent(hierarchyNode);
                            OLAPList memberProperties = level.getOLAPProperties();
                            CubeDimensionPanel.this.newList.clear();
                            CubeDimensionPanel.this.newList.addAll(memberProperties);
                            Collections.sort(CubeDimensionPanel.this.newList);
                            int sizeMP = CubeDimensionPanel.this.newList.size();
                            for (int t = 0; t < sizeMP; ++t) {
                                OLAPMemberProperty member = (OLAPMemberProperty)CubeDimensionPanel.this.newList.get(t);
                                OLAPList listOfMPHierarchies = member.getHierarchies();
                                if (!listOfMPHierarchies.contains(hierarchy)) continue;
                                OLAPObjectNode memberPropertyNode = new OLAPObjectNode((AbstractOLAPModel)member);
                                memberPropertyNode.setAllowsChildren(false);
                                CubeDimensionPanel.this.treeModel.insertNodeInto(memberPropertyNode, levelNode, levelNode.getChildCount());
                                memberPropertyNode.setParent(levelNode);
                            }
                        }
                    }
                    if (dimension.isGeography()) {
                        CubeDimensionPanel.this.geoDimension = dimension;
                    }
                    if (!CubeDimensionPanel.this.designer.isFinishEnabled() && (measureSet = CubeDimensionPanel.this.olapCube.getMeasureSet()).getMeasures().size() > 0) {
                        CubeDimensionPanel.this.designer.setFinishExportEnabled(true);
                    }
                }
                CubeDimensionPanel.this.setCursor(new Cursor(0));
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
                CubeDimensionPanel.this.setCursor(new Cursor(0));
                return;
            }
        }
    }

    private final class DeleteButtonListener
    implements ActionListener {
        private DeleteButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                TreeCellEditor ce = CubeDimensionPanel.this.tree.getCellEditor();
                if (ce != null && ce instanceof TreeCellRenameEditor) {
                    ce.stopCellEditing();
                }
                MeasureSet measureSet = CubeDimensionPanel.this.olapCube.getMeasureSet();
                CubeDimensionPanel.this.setCursor(new Cursor(3));
                TreePath[] selectedPath = CubeDimensionPanel.this.tree.getSelectionPaths();
                int choice = 0;
                int size = selectedPath.length;
                if (size == 1) {
                    OLAPObjectNode objectNode = (OLAPObjectNode)selectedPath[0].getLastPathComponent();
                    AbstractOLAPModel object = (AbstractOLAPModel)objectNode.getUserObject();
                    String deleteTitle = null;
                    if (object instanceof OLAPDimension) {
                        deleteTitle = bundle.getString("CubeDesigner.DeleteDimension.window.title");
                    } else if (object instanceof OLAPHierarchy) {
                        deleteTitle = bundle.getString("CubeDesigner.DeleteHierarchy.window.title");
                    } else if (object instanceof OLAPLevel) {
                        deleteTitle = bundle.getString("CubeDesigner.DeleteLevel.window.title");
                    } else if (object instanceof OLAPMemberProperty) {
                        deleteTitle = bundle.getString("CubeDesigner.DeleteMemberProperty.window.title");
                    } else if (object instanceof OLAPSharedDimension) {
                        deleteTitle = bundle.getString("CubeDesigner.DeleteSharedDimension.window.title");
                    }
                    choice = MessageUtil.displayMessage((String)bundle.formatString("CubeDesigner.Delete.Message.fmt.txt", (Object)object.getName()), (String)deleteTitle, (int)1, (int)0);
                } else if (size > 1) {
                    choice = MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.DeleteDimensions.txt"), (String)bundle.getString("CubeDesigner.DeleteDimensions.window.title"), (int)1, (int)0);
                }
                if (choice == 0) {
                    for (int i = size - 1; i >= 0; --i) {
                        int t;
                        OLAPObjectNode dimensionNode;
                        OLAPObjectNode objectNode = (OLAPObjectNode)selectedPath[i].getLastPathComponent();
                        Object object = objectNode.getUserObject();
                        if (object instanceof OLAPSharedDimension) {
                            CubeDimensionPanel.this.deleteSharedDimension(measureSet, objectNode, object);
                            ((OLAPSharedDimension)object).setWasDeleted(Boolean.valueOf(true));
                            continue;
                        }
                        if (object instanceof OLAPDimension) {
                            OLAPDimension selectedDimension = (OLAPDimension)object;
                            boolean wasGeo = selectedDimension.isGeography();
                            selectedDimension.setUndo(false);
                            selectedDimension.delete();
                            selectedDimension.setUndo(true);
                            CubeDimensionPanel.this.olapCube.getAggregationSet().setResetLevels(true);
                            measureSet.synchNuniqueLevel();
                            measureSet.synchNuniqueHierarchy();
                            WAWizardDialog parent = (WAWizardDialog)CubeDimensionPanel.this.getTopLevelAncestor();
                            parent.addWizardData("TABLECHANGEDMEASURES", (Object)"YES");
                            if (wasGeo) {
                                CubeDimensionPanel.this.geoDimension = null;
                            }
                            CubeDimensionPanel.this.treeModel.removeNodeFromParent(objectNode);
                            continue;
                        }
                        if (object instanceof OLAPLevel) {
                            OLAPObjectNode node;
                            int a;
                            OLAPLevel level = (OLAPLevel)object;
                            OLAPList listOfLevels = level.getDimension().getLevels();
                            if (listOfLevels.size() == 1) {
                                MessageUtil.displayMessage((String)bundle.formatString("CubeDesigner.DimensionPanel.CannotRemoveOnlyLevel.NoDelete.txt", (Object)level.getName()), (int)0);
                                continue;
                            }
                            OLAPList levelsHierarchies = level.getHierarchies();
                            ArrayList<OLAPObjectNode> levelNodes = new ArrayList<OLAPObjectNode>();
                            ArrayList<OLAPObjectNode> removeHierarchyNodes = new ArrayList<OLAPObjectNode>();
                            int sizehiers = levelsHierarchies.size();
                            for (int t2 = 0; t2 < sizehiers; ++t2) {
                                OLAPHierarchy hierarchy = (OLAPHierarchy)levelsHierarchies.get(t2);
                                OLAPDimension dim = hierarchy.getDimension();
                                hierarchy.setUndo(false);
                                dimensionNode = CubeDimensionPanel.this.findNode((DefaultMutableTreeNode)CubeDimensionPanel.this.treeModel.getRoot(), (AbstractOLAPModel)dim);
                                if (dimensionNode == null) continue;
                                OLAPDimension dimensionObject = (OLAPDimension)dimensionNode.getUserObject();
                                dimensionObject.setUndo(false);
                                OLAPObjectNode hierarchyNode = CubeDimensionPanel.this.findNode(dimensionNode, (AbstractOLAPModel)hierarchy);
                                if (hierarchyNode == null) continue;
                                OLAPHierarchy hierarchyObject = (OLAPHierarchy)hierarchyNode.getUserObject();
                                if (hierarchyObject.getLevels().size() == 1) {
                                    removeHierarchyNodes.add(hierarchyNode);
                                }
                                hierarchyObject.setUndo(false);
                                OLAPObjectNode findLevelNode = CubeDimensionPanel.this.findNode(hierarchyNode, (AbstractOLAPModel)level);
                                if (findLevelNode == null) continue;
                                levelNodes.add(findLevelNode);
                            }
                            int sizeLevels = levelNodes.size();
                            for (a = 0; a < sizeLevels; ++a) {
                                node = (OLAPObjectNode)levelNodes.get(a);
                                CubeDimensionPanel.this.treeModel.removeNodeFromParent(node);
                            }
                            int sizeHier = removeHierarchyNodes.size();
                            for (a = 0; a < sizeHier; ++a) {
                                node = (OLAPObjectNode)removeHierarchyNodes.get(a);
                                CubeDimensionPanel.this.treeModel.removeNodeFromParent(node);
                            }
                            level.setUndo(false);
                            level.delete();
                            level.setUndo(true);
                            OLAPDimension dimension = level.getDimension();
                            if (dimension != null) {
                                dimension.setUndo(true);
                                OLAPList listOfHierarchies = dimension.getHierarchies();
                                int sizeHiers = listOfHierarchies.size();
                                for (int z = 0; z < sizeHiers; ++z) {
                                    OLAPHierarchy hier = (OLAPHierarchy)listOfHierarchies.get(z);
                                    hier.setUndo(true);
                                }
                            }
                            CubeDimensionPanel.this.olapCube.getAggregationSet().setResetLevels(true);
                            measureSet.synchNuniqueLevel();
                            measureSet.synchNuniqueHierarchy();
                            WAWizardDialog parent = (WAWizardDialog)CubeDimensionPanel.this.getTopLevelAncestor();
                            parent.addWizardData("TABLECHANGEDMEASURES", (Object)"YES");
                            continue;
                        }
                        if (object instanceof OLAPHierarchy) {
                            WAWizardDialog parent;
                            OLAPHierarchy hierarchy = (OLAPHierarchy)object;
                            OLAPDimension dimension = hierarchy.getDimension();
                            OLAPList listOfHierarchies = dimension.getHierarchies();
                            if (listOfHierarchies.size() == 1) {
                                MessageUtil.displayMessage((String)bundle.formatString("CubeDesigner.DimensionPanel.CannotRemoveOnlyHieararhy.NoDelete.txt", (Object)hierarchy.getName()), (int)0);
                                continue;
                            }
                            OLAPHierarchy defaultHierarchy = dimension.getDefault();
                            if (hierarchy != null && hierarchy.equals(defaultHierarchy)) {
                                choice = MessageUtil.displayMessage((String)bundle.formatString("CubeDesigner.Delete.DefaultHierarchy.txt", (Object)hierarchy.getName()), (String)bundle.getString("CubeDesigner.DeleteDefaultHierarchy.window.title"), (int)1, (int)0);
                                if (choice == 0) {
                                    hierarchy.setUndo(false);
                                    dimension.setUndo(false);
                                    hierarchy.delete();
                                    CubeDimensionPanel.this.treeModel.removeNodeFromParent(objectNode);
                                    measureSet.synchNuniqueLevel();
                                    measureSet.synchNuniqueHierarchy();
                                    parent = (WAWizardDialog)CubeDimensionPanel.this.getTopLevelAncestor();
                                    parent.addWizardData("TABLECHANGEDMEASURES", (Object)"YES");
                                }
                            } else {
                                hierarchy.setUndo(false);
                                dimension.setUndo(false);
                                hierarchy.delete();
                                CubeDimensionPanel.this.treeModel.removeNodeFromParent(objectNode);
                                measureSet.synchNuniqueLevel();
                                measureSet.synchNuniqueHierarchy();
                                parent = (WAWizardDialog)CubeDimensionPanel.this.getTopLevelAncestor();
                                parent.addWizardData("TABLECHANGEDMEASURES", (Object)"YES");
                            }
                            hierarchy.setUndo(true);
                            dimension.setUndo(true);
                            continue;
                        }
                        if (!(object instanceof OLAPMemberProperty)) continue;
                        OLAPMemberProperty memberProperty = (OLAPMemberProperty)object;
                        OLAPColumn levelLayer = memberProperty.getAssociatedLevel().getMapLayer();
                        if (memberProperty.getName().equalsIgnoreCase("SAS_SPATIAL_ID") && levelLayer != null) {
                            MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.MemberProperty.NoDelete.txt"), (int)0);
                            continue;
                        }
                        OLAPList memberPropertyHierarchies = memberProperty.getHierarchies();
                        ArrayList<OLAPObjectNode> memberPropertyNodes = new ArrayList<OLAPObjectNode>();
                        OLAPLevel level = memberProperty.getAssociatedLevel();
                        int sizehiers = memberPropertyHierarchies.size();
                        for (t = 0; t < sizehiers; ++t) {
                            OLAPObjectNode hierarchyNode;
                            OLAPHierarchy hierarchy = (OLAPHierarchy)memberPropertyHierarchies.get(t);
                            OLAPDimension dim = hierarchy.getDimension();
                            dimensionNode = CubeDimensionPanel.this.findNode((DefaultMutableTreeNode)CubeDimensionPanel.this.treeModel.getRoot(), (AbstractOLAPModel)dim);
                            if (dimensionNode == null || (hierarchyNode = CubeDimensionPanel.this.findNode(dimensionNode, (AbstractOLAPModel)hierarchy)) == null) continue;
                            OLAPHierarchy hierarchyObject = (OLAPHierarchy)hierarchyNode.getUserObject();
                            hierarchyObject.setUndo(false);
                            OLAPObjectNode findLevelNode = CubeDimensionPanel.this.findNode(hierarchyNode, (AbstractOLAPModel)level);
                            if (findLevelNode == null) continue;
                            OLAPObjectNode findMemberNode = CubeDimensionPanel.this.findNode(findLevelNode, (AbstractOLAPModel)memberProperty);
                            OLAPLevel levelObject = (OLAPLevel)findLevelNode.getUserObject();
                            levelObject.setUndo(false);
                            if (findMemberNode == null) continue;
                            memberPropertyNodes.add(findMemberNode);
                        }
                        int sizeLevels = memberPropertyNodes.size();
                        for (int a = 0; a < sizeLevels; ++a) {
                            OLAPObjectNode node = (OLAPObjectNode)memberPropertyNodes.get(a);
                            CubeDimensionPanel.this.treeModel.removeNodeFromParent(node);
                        }
                        memberProperty.setUndo(false);
                        memberProperty.delete();
                        memberProperty.setUndo(true);
                        sizehiers = memberPropertyHierarchies.size();
                        for (t = 0; t < sizehiers; ++t) {
                            OLAPHierarchy hierarchy = (OLAPHierarchy)memberPropertyHierarchies.get(t);
                            hierarchy.setUndo(true);
                        }
                        level.setUndo(true);
                    }
                    if (CubeDimensionPanel.this.designer.isFinishEnabled() && CubeDimensionPanel.this.dimensionSet.getAllCubeDimensions().size() < 1) {
                        CubeDimensionPanel.this.designer.setFinishExportEnabled(false);
                    }
                }
            }
            catch (OLAPException OLAPError) {
                ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
            CubeDimensionPanel.this.setCursor(new Cursor(0));
        }
    }

    private final class ModifyButtonlistener
    implements ActionListener {
        private ModifyButtonlistener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            DimDesigner dimdesigner;
            OLAPLevel level;
            TreeCellEditor ce = CubeDimensionPanel.this.tree.getCellEditor();
            if (ce != null && ce instanceof TreeCellRenameEditor) {
                ce.stopCellEditing();
            }
            OLAPObjectNode hierarchyNode = null;
            OLAPObjectNode levelNode = null;
            OLAPObjectNode root = null;
            OLAPObjectNode dimensionNode = null;
            OLAPObjectNode newDimNode = null;
            OLAPObjectNode memberPropertyNode = null;
            OLAPObjectNode lastSelectedObject = null;
            CubeDimensionPanel.this.setCursor(new Cursor(3));
            Workspace workspace = Workspace.getWorkspace();
            TreePath selectedPath = CubeDimensionPanel.this.tree.getSelectionPath();
            DefaultMutableTreeNode objectNode = (DefaultMutableTreeNode)selectedPath.getLastPathComponent();
            Object object = objectNode.getUserObject();
            OLAPDimension selected = null;
            if (object instanceof OLAPDimension) {
                selected = (OLAPDimension)object;
                DimDesigner dimdesigner2 = new DimDesigner((Frame)workspace, bundle.getString("DimDesigner.Title.txt"), selected);
                dimdesigner2.show();
                if (selected.equals(CubeDimensionPanel.this.geoDimension) && !selected.isGeography()) {
                    try {
                        selected.deleteMapInformation();
                        OLAPList listOfLevels = selected.getLevels();
                        int size = listOfLevels.size();
                        for (int i = 0; i < size; ++i) {
                            OLAPLevel level2 = (OLAPLevel)listOfLevels.get(i);
                            level2.deleteMapInformation();
                        }
                    }
                    catch (OLAPException e) {
                        ExceptionHandler.handleException((Exception)((Object)e));
                    }
                    finally {
                        CubeDimensionPanel.this.geoDimension = null;
                        MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.DimensionPanel.MapInfoRemoved.txt"));
                    }
                } else if (selected.isGeography()) {
                    CubeDimensionPanel.this.geoDimension = selected;
                }
            } else if (object instanceof OLAPLevel) {
                try {
                    level = (OLAPLevel)object;
                    selected = level.getDimension();
                    dimdesigner = new DimDesigner((Frame)workspace, bundle.getString("DimDesigner.Title.txt"), selected);
                    WAWizardModel wModel = dimdesigner.getWizardModel();
                    WAPropertyTab firstPanel = wModel.getCurrent().getTab();
                    firstPanel.doDataExchange(false);
                    wModel.next();
                    dimdesigner.show();
                }
                catch (MdException mdError) {
                    ExceptionHandler.handleException((Exception)((Object)mdError));
                }
                catch (RemoteException re) {
                    ExceptionHandler.handleException((Exception)re);
                }
            } else if (object instanceof OLAPHierarchy) {
                try {
                    level = (OLAPHierarchy)object;
                    selected = level.getDimension();
                    dimdesigner = new DimDesigner((Frame)workspace, bundle.getString("DimDesigner.Title.txt"), selected);
                    WAWizardModel wModel = dimdesigner.getWizardModel();
                    WAPropertyTab firstPanel = wModel.getCurrent().getTab();
                    firstPanel.doDataExchange(false);
                    wModel.next();
                    WAPropertyTab secondPanel = wModel.getCurrent().getTab();
                    secondPanel.doDataExchange(false);
                    wModel.next();
                    dimdesigner.show();
                }
                catch (MdException mdError) {
                    ExceptionHandler.handleException((Exception)((Object)mdError));
                }
                catch (RemoteException re) {
                    ExceptionHandler.handleException((Exception)re);
                }
            } else if (object instanceof OLAPMemberProperty) {
                try {
                    OLAPMemberProperty memproperty = (OLAPMemberProperty)object;
                    WAStandardDialog m_parent = (WAStandardDialog)CubeDimensionPanel.this.getTopLevelAncestor();
                    OLAPLevel level3 = memproperty.getAssociatedLevel();
                    selected = level3.getDimension();
                    CubeMemberPropertiesAddDialog memberPDialog = null;
                    if (!CubeDimensionPanel.this.isStarSchema) {
                        memberPDialog = new CubeMemberPropertiesAddDialog((Dialog)m_parent, bundle.getString("CubeDesigner.MemberProperty.txt"), CubeDimensionPanel.this.olapCube, memproperty, (List)level3.getHierarchies(), level3);
                    } else {
                        OLAPDimension dimension = level3.getDimension();
                        OLAPList columnList = null;
                        DimensionTable table = dimension.getTable();
                        if (table != null) {
                            columnList = table.getColumns();
                        }
                        memberPDialog = new CubeMemberPropertiesAddDialog((Dialog)m_parent, bundle.getString("CubeDesigner.MemberProperty.txt"), CubeDimensionPanel.this.olapCube, memproperty, (List)level3.getHierarchies(), (List)columnList, level3);
                    }
                    memberPDialog.show();
                }
                catch (OLAPException oError) {
                    ExceptionHandler.handleException((Exception)((Object)oError));
                }
            }
            try {
                TreeNode[] nodes = objectNode.getPath();
                dimensionNode = (OLAPObjectNode)nodes[1];
                CubeDimensionPanel.this.treeModel.removeNodeFromParent(dimensionNode);
                root = (OLAPObjectNode)CubeDimensionPanel.this.treeModel.getRoot();
                CubeDimensionPanel.this.newList.clear();
                CubeDimensionPanel.this.newList.addAll(CubeDimensionPanel.this.dimensionSet.getAllCubeDimensions());
                Collections.sort(CubeDimensionPanel.this.newList);
                int whereToPutModifiedDim = CubeDimensionPanel.this.newList.indexOf(selected);
                dimensionNode.setAllowsChildren(true);
                newDimNode = new OLAPObjectNode((AbstractOLAPModel)selected);
                if (selected.equals(object)) {
                    lastSelectedObject = newDimNode;
                }
                CubeDimensionPanel.this.treeModel.insertNodeInto(newDimNode, root, whereToPutModifiedDim);
                OLAPList hierarchies = selected.getHierarchies();
                for (int j = 0; j < hierarchies.size(); ++j) {
                    OLAPHierarchy hierarchy = (OLAPHierarchy)hierarchies.get(j);
                    hierarchyNode = new OLAPObjectNode((AbstractOLAPModel)hierarchy);
                    if (hierarchy.equals(object)) {
                        lastSelectedObject = hierarchyNode;
                    }
                    hierarchyNode.setAllowsChildren(true);
                    CubeDimensionPanel.this.treeModel.insertNodeInto(hierarchyNode, newDimNode, j);
                    hierarchyNode.setParent(newDimNode);
                    OLAPList levels = hierarchy.getLevels();
                    for (int k = 0; k < levels.size(); ++k) {
                        OLAPLevel level4 = (OLAPLevel)levels.get(k);
                        levelNode = new OLAPObjectNode((AbstractOLAPModel)level4);
                        if (level4.equals(object)) {
                            lastSelectedObject = levelNode;
                        }
                        levelNode.setAllowsChildren(true);
                        CubeDimensionPanel.this.treeModel.insertNodeInto(levelNode, hierarchyNode, k);
                        levelNode.setParent(hierarchyNode);
                        OLAPList memberProperties = level4.getOLAPProperties();
                        int sizeMP = memberProperties.size();
                        for (int t = 0; t < sizeMP; ++t) {
                            OLAPMemberProperty member = (OLAPMemberProperty)memberProperties.get(t);
                            OLAPList listOfHierarchies = member.getHierarchies();
                            if (!listOfHierarchies.contains(hierarchy)) continue;
                            memberPropertyNode = new OLAPObjectNode((AbstractOLAPModel)member);
                            if (member.equals(object)) {
                                lastSelectedObject = memberPropertyNode;
                            }
                            memberPropertyNode.setAllowsChildren(false);
                            CubeDimensionPanel.this.treeModel.insertNodeInto(memberPropertyNode, levelNode, levelNode.getChildCount());
                            memberPropertyNode.setParent(levelNode);
                        }
                    }
                }
                TreePath path = null;
                path = lastSelectedObject != null ? new TreePath(lastSelectedObject.getPath()) : new TreePath(newDimNode.getPath());
                CubeDimensionPanel.this.tree.expandPath(path);
                if (selected.isGeography()) {
                    CubeDimensionPanel.this.geoDimension = selected;
                }
                CubeDimensionPanel.this.setCursor(new Cursor(0));
                WAWizardDialog parent = (WAWizardDialog)CubeDimensionPanel.this.getTopLevelAncestor();
                parent.addWizardData("TABLECHANGEDMEASURES", (Object)"YES");
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
            }
        }
    }

    public class MapButtonListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            TreeCellEditor ce = CubeDimensionPanel.this.tree.getCellEditor();
            if (ce != null && ce instanceof TreeCellRenameEditor) {
                ce.stopCellEditing();
            }
            TreePath selectedPath = CubeDimensionPanel.this.tree.getSelectionPath();
            DefaultMutableTreeNode dimensionNode = (DefaultMutableTreeNode)selectedPath.getLastPathComponent();
            OLAPDimension selected = (OLAPDimension)dimensionNode.getUserObject();
            CubeDimensionMapDialog dialog = new CubeDimensionMapDialog(selected);
            dialog.show();
        }
    }

    private final class MemberPropertyButtonlistener
    implements ActionListener {
        private MemberPropertyButtonlistener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TreeCellEditor ce = CubeDimensionPanel.this.tree.getCellEditor();
            if (ce != null && ce instanceof TreeCellRenameEditor) {
                ce.stopCellEditing();
            }
            OLAPMemberPropertySet propertySet = CubeDimensionPanel.this.olapCube.getOLAPMemberPropertySet();
            TreePath selectedPath = CubeDimensionPanel.this.tree.getSelectionPath();
            OLAPObjectNode levelNode = (OLAPObjectNode)selectedPath.getLastPathComponent();
            OLAPLevel level = (OLAPLevel)levelNode.getUserObject();
            OLAPMemberProperty memproperty = null;
            try {
                memproperty = propertySet.createOLAPMemberProperty();
                WAStandardDialog m_parent = (WAStandardDialog)CubeDimensionPanel.this.getTopLevelAncestor();
                CubeMemberPropertiesAddDialog memberPDialog = null;
                if (!CubeDimensionPanel.this.isStarSchema) {
                    memberPDialog = new CubeMemberPropertiesAddDialog((Dialog)m_parent, bundle.getString("CubeDesigner.MemberProperty.txt"), CubeDimensionPanel.this.olapCube, memproperty, (List)level.getHierarchies(), level);
                } else {
                    OLAPDimension dimension = level.getDimension();
                    OLAPList columnList = null;
                    DimensionTable table = dimension.getTable();
                    if (table != null) {
                        columnList = table.getColumns();
                    }
                    memberPDialog = new CubeMemberPropertiesAddDialog((Dialog)m_parent, bundle.getString("CubeDesigner.MemberProperty.txt"), CubeDimensionPanel.this.olapCube, memproperty, (List)level.getHierarchies(), (List)columnList, level);
                }
                memberPDialog.show();
                if (memberPDialog.getReturnValue() == 1) {
                    int i;
                    OLAPList memberPropertyHierarchies = memproperty.getHierarchies();
                    ArrayList<OLAPObjectNode> levelNodes = new ArrayList<OLAPObjectNode>();
                    int size = memberPropertyHierarchies.size();
                    for (i = 0; i < size; ++i) {
                        OLAPObjectNode findLevelNode;
                        OLAPObjectNode hierarchyNode;
                        OLAPHierarchy hierarchy = (OLAPHierarchy)memberPropertyHierarchies.get(i);
                        OLAPDimension dim = hierarchy.getDimension();
                        OLAPObjectNode dimensionNode = CubeDimensionPanel.this.findNode((DefaultMutableTreeNode)CubeDimensionPanel.this.treeModel.getRoot(), (AbstractOLAPModel)dim);
                        if (dimensionNode == null || (hierarchyNode = CubeDimensionPanel.this.findNode(dimensionNode, (AbstractOLAPModel)hierarchy)) == null || (findLevelNode = CubeDimensionPanel.this.findNode(hierarchyNode, (AbstractOLAPModel)level)) == null) continue;
                        levelNodes.add(findLevelNode);
                    }
                    size = levelNodes.size();
                    for (i = 0; i < size; ++i) {
                        OLAPObjectNode node = (OLAPObjectNode)levelNodes.get(i);
                        int count = CubeDimensionPanel.this.treeModel.getChildCount(node);
                        for (int t = count - 1; t > -1; --t) {
                            OLAPObjectNode nextNode = (OLAPObjectNode)CubeDimensionPanel.this.treeModel.getChild(node, t);
                            CubeDimensionPanel.this.treeModel.removeNodeFromParent(nextNode);
                        }
                        OLAPList listOfMemberProperties = level.getOLAPProperties();
                        CubeDimensionPanel.this.newList.clear();
                        CubeDimensionPanel.this.newList.addAll(listOfMemberProperties);
                        Collections.sort(CubeDimensionPanel.this.newList);
                        int sizeLevel = CubeDimensionPanel.this.newList.size();
                        for (int t = 0; t < sizeLevel; ++t) {
                            OLAPObjectNode memberPropertyNode = new OLAPObjectNode((AbstractOLAPModel)((OLAPMemberProperty)CubeDimensionPanel.this.newList.get(t)));
                            CubeDimensionPanel.this.treeModel.insertNodeInto(memberPropertyNode, node, t);
                            memberPropertyNode.setAllowsChildren(false);
                            memberPropertyNode.setParent(node);
                        }
                    }
                    CubeDimensionPanel.this.tree.expandPath(selectedPath);
                } else {
                    memproperty.delete();
                }
            }
            catch (OLAPException OLAPError) {
                ExceptionHandler.handleException((Exception)((Object)OLAPError));
                return;
            }
        }
    }

    private class ShowCaptionListener
    implements ActionListener {
        private ShowCaptionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List expandedNodes = CubeDimensionPanel.this.expandList();
            if (CubeDimensionPanel.this.tree.isEditing()) {
                CubeDimensionPanel.this.tree.stopEditing();
            }
            if (CubeDimensionPanel.this.showCaption.isSelected()) {
                CubeDimensionPanel.this.isShowCaption = true;
            } else {
                CubeDimensionPanel.this.isShowCaption = false;
            }
            CubeDimensionPanel.this.treeModel.reload();
            int sizeNodes = expandedNodes.size();
            for (int i = 0; i < sizeNodes; ++i) {
                CubeDimensionPanel.this.tree.expandPath((TreePath)expandedNodes.get(i));
            }
        }
    }

    private final class AddSharedDimButtonListener
    implements ActionListener {
        private AddSharedDimButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                boolean showVersionWarning;
                TreeCellEditor ce = CubeDimensionPanel.this.tree.getCellEditor();
                if (ce != null && ce instanceof TreeCellRenameEditor) {
                    ce.stopCellEditing();
                }
                WAWizardDialog parent = (WAWizardDialog)CubeDimensionPanel.this.getTopLevelAncestor();
                ArrayList beforeAddingShared = new ArrayList();
                OLAPList listOfShared = CubeDimensionPanel.this.dimensionSet.getSharedDimensions();
                beforeAddingShared.addAll(listOfShared);
                UsageVersion version = CubeDimensionPanel.this.olapCube.getVersionNumber();
                if (version.getMajorVersion() < 5 && !CubeDimensionPanel.this.olapCube.isNewObject() && (showVersionWarning = Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(VERSION_WARNING_SHARED_DIM, true))) {
                    Workspace workspace = Workspace.getWorkspace();
                    JCheckBox checkbox = new JCheckBox();
                    VisualUtilities.setButtonTextAndMnemonic(checkbox, bundle.getString("Common.ShowMessage.checkbox.label"));
                    WATextArea description = new WATextArea();
                    description.setLineWrap(true);
                    description.setBehavior(1);
                    description.setWrapStyleWord(true);
                    description.setRows(4);
                    description.setColumns(35);
                    String message = new String(bundle.getString("CubeDesigner.SharedDimension.VersionChange.txt"));
                    description.setText(message);
                    Object[] allObjects = new Object[]{description, " ", checkbox};
                    String titleMessage = bundle.getString("Common.warning.window.title");
                    int optionSelected = JOptionPane.showConfirmDialog((Component)workspace, allObjects, titleMessage, 0, 2);
                    if (checkbox.isSelected()) {
                        Workspace.getWorkspace().getAppDefaultsFile().setPropertyBoolean(VERSION_WARNING_SHARED_DIM, false);
                    }
                    if (optionSelected == 1) {
                        return;
                    }
                }
                CubeSharedDimensionDialog sharedDimDialog = new CubeSharedDimensionDialog((Dialog)parent, bundle.getString("CubeDesigner.SharedDimension.window.title"), CubeDimensionPanel.this.olapCube);
                sharedDimDialog.setResizable(true);
                sharedDimDialog.show();
                List recentlyAddedDims = sharedDimDialog.getRecentlyAddSharedDimensions();
                CubeDimensionPanel.this.setCursor(new Cursor(3));
                OLAPObjectNode root = (OLAPObjectNode)CubeDimensionPanel.this.treeModel.getRoot();
                if (sharedDimDialog.getReturnValue() == 1) {
                    if (!recentlyAddedDims.isEmpty()) {
                        MeasureSet measureSet;
                        CubeDimensionPanel.this.olapCube.getAggregationSet().setResetLevels(true);
                        String[] sortingOptions = sharedDimDialog.getSortingOptionsForProc();
                        if (sortingOptions[0] != null) {
                            CubeDimensionPanel.this.olapCube.setCollation(sortingOptions[0]);
                        }
                        if (sortingOptions[1] != null) {
                            CubeDimensionPanel.this.olapCube.setLocale(sortingOptions[1]);
                        }
                        ArrayList allDims = new ArrayList();
                        allDims.addAll(recentlyAddedDims);
                        allDims.addAll(CubeDimensionPanel.this.dimensionSet.getAllCubeDimensions());
                        Collections.sort(allDims);
                        int size = recentlyAddedDims.size();
                        for (int i = 0; i < size; ++i) {
                            OLAPSharedDimension dimension = (OLAPSharedDimension)recentlyAddedDims.get(i);
                            if (beforeAddingShared.contains(dimension)) continue;
                            int whereToPutNewDim = allDims.indexOf(dimension);
                            listOfShared.add((Object)dimension);
                            OLAPObjectNode dimensionNode = new OLAPObjectNode((AbstractOLAPModel)dimension);
                            dimensionNode.setAllowsChildren(true);
                            if (allDims.size() == recentlyAddedDims.size() && i == 0) {
                                whereToPutNewDim = 0;
                            }
                            CubeDimensionPanel.this.treeModel.insertNodeInto(dimensionNode, root, whereToPutNewDim);
                            CubeDimensionPanel.this.dimensionSet.UseSharedDimension(dimension);
                            dimension.setWasDeleted(Boolean.valueOf(false));
                            OLAPList hierarchies = dimension.getHierarchies();
                            for (int j = 0; j < hierarchies.size(); ++j) {
                                OLAPHierarchy hierarchy = (OLAPHierarchy)hierarchies.get(j);
                                OLAPObjectNode hierarchyNode = new OLAPObjectNode((AbstractOLAPModel)hierarchy);
                                hierarchyNode.setAllowsChildren(true);
                                dimensionNode.add(hierarchyNode);
                                hierarchyNode.setParent(dimensionNode);
                                OLAPList levels = hierarchy.getLevels();
                                for (int k = 0; k < levels.size(); ++k) {
                                    OLAPLevel level = (OLAPLevel)levels.get(k);
                                    OLAPObjectNode levelNode = new OLAPObjectNode((AbstractOLAPModel)level);
                                    levelNode.setAllowsChildren(true);
                                    hierarchyNode.add(levelNode);
                                    levelNode.setParent(hierarchyNode);
                                    OLAPList memberProperties = level.getOLAPProperties();
                                    int sizeMP = memberProperties.size();
                                    for (int t = 0; t < sizeMP; ++t) {
                                        OLAPMemberProperty member = (OLAPMemberProperty)memberProperties.get(t);
                                        OLAPList listOfMPHierarchies = member.getHierarchies();
                                        if (!listOfMPHierarchies.contains(hierarchy)) continue;
                                        OLAPObjectNode memberPropertyNode = new OLAPObjectNode((AbstractOLAPModel)member);
                                        memberPropertyNode.setAllowsChildren(false);
                                        CubeDimensionPanel.this.treeModel.insertNodeInto(memberPropertyNode, levelNode, levelNode.getChildCount());
                                        memberPropertyNode.setParent(levelNode);
                                    }
                                }
                            }
                            if (!dimension.isGeography()) continue;
                            CubeDimensionPanel.this.geoDimension = (OLAPDimension)dimension;
                        }
                        if (!CubeDimensionPanel.this.designer.isFinishEnabled() && (measureSet = CubeDimensionPanel.this.olapCube.getMeasureSet()).getMeasures().size() > 0) {
                            CubeDimensionPanel.this.designer.setFinishExportEnabled(true);
                        }
                    }
                    MeasureSet measureSet = CubeDimensionPanel.this.olapCube.getMeasureSet();
                    int numDim = root.getChildCount();
                    for (int i = numDim - 1; i >= 0; --i) {
                        OLAPSharedDimension dim;
                        OLAPObjectNode node = (OLAPObjectNode)root.getChildAt(i);
                        Object obj = node.getUserObject();
                        if (!(obj instanceof OLAPSharedDimension) || listOfShared.contains((Object)(dim = (OLAPSharedDimension)obj))) continue;
                        CubeDimensionPanel.this.deleteSharedDimension(measureSet, node, dim);
                    }
                }
                CubeDimensionPanel.this.setCursor(new Cursor(0));
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
                CubeDimensionPanel.this.setCursor(new Cursor(0));
                return;
            }
        }
    }

    private final class DimensionTreeListener
    implements TreeSelectionListener {
        private DimensionTreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            CubeDimensionPanel.this.setButtonsState();
        }
    }

    public class DecoratableStructureTreeCellRenderer
    extends StructureTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree inTree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasTheFocus) {
            super.getTreeCellRendererComponent(CubeDimensionPanel.this.tree, value, sel, expanded, leaf, row, this.hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object userObject = node.getUserObject();
            if (userObject instanceof OLAPSharedDimension) {
                ImageIcon sharedDimIcon = Resources.getImageIcon((String)"OLAPDimension_shared.gif", (int)16);
                WsDecoratableIcon decoratedIcon = new WsDecoratableIcon((Icon)sharedDimIcon);
                OLAPSharedDimension dim = (OLAPSharedDimension)userObject;
                if (!dim.physicallyExists()) {
                    ImageIcon decoration = bundle.getImageIcon("CubeDesigner.SharedDimension.Decorator.Definition.image");
                    decoratedIcon.setSEDecoration((Icon)decoration);
                }
                this.setIcon((Icon)decoratedIcon);
                this.setDisabledIcon((Icon)decoratedIcon);
            }
            return this;
        }
    }

    protected class DefaultTreePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected DefaultTreePopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = CubeDimensionPanel.this.createTreePopupMenu();
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }
}

