/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.MdObjectStore;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.visuals.CubeAggregationTablesTab;
import com.sas.olapadmin.designer.visuals.CubeDimensionTab;
import com.sas.olapadmin.designer.visuals.CubeDimensionTablesTab;
import com.sas.olapadmin.designer.visuals.CubeFinishTab;
import com.sas.olapadmin.designer.visuals.CubeGeneralTab;
import com.sas.olapadmin.designer.visuals.CubeInputTab;
import com.sas.olapadmin.designer.visuals.CubeMeasureMapTab;
import com.sas.olapadmin.designer.visuals.CubeMeasuresHolapAssignStatGroupTab;
import com.sas.olapadmin.designer.visuals.CubeMeasuresHolapDerivedTab;
import com.sas.olapadmin.designer.visuals.CubeMeasuresHolapDetailTab;
import com.sas.olapadmin.designer.visuals.CubeMeasuresHolapSelectTab;
import com.sas.olapadmin.designer.visuals.CubeMeasuresSelectTab;
import com.sas.olapadmin.designer.visuals.CubeUserAggregationsHolapTab;
import com.sas.olapadmin.designer.visuals.CubeUserAggregationsTab;
import com.sas.olapadmin.designer.visuals.MLSCaptionsTab;
import com.sas.visuals.Resources;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATransitionWizardModel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsDescriptionWizardTab;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class CubeDesignerPlugin {
    private static WAdminResource bundle = new WAdminResource(CubeDesignerPlugin.class);
    protected String m_name;
    protected String m_label;
    protected ImageIcon m_icon;
    protected String m_tooltip;
    protected String m_desc;
    protected String m_category;
    protected WAWizardDialog m_wizardDialog;
    protected WATransitionWizardModel m_wizardModel;
    protected OLAPCube m_cubeModel;
    public String[][] Transitions = new String[][]{{"GENERAL", "NEXT", "INPUT"}, {"INPUT", "NEXT", "DIMENSIONS"}, {"INPUT", "STAR", "DIMTABLES"}, {"DIMTABLES", "NEXT", "DIMENSIONS"}, {"DIMENSIONS", "NEXT", "MMEASURES"}, {"DIMENSIONS", "HOLAP", "HMEASURES"}, {"MMEASURES", "NEXT", "USERAGGS"}, {"MMEASURES", "HOLAP", "AGGRTABLES"}, {"HMEASURES", "NEXT", "ASGDETAIL"}, {"ASGDETAIL", "NEXT", "HDERIVED"}, {"HDERIVED", "NEXT", "HDETAIL"}, {"HDETAIL", "NEXT", "AGGRTABLES"}, {"AGGRTABLES", "NEXT", "RUSERAGGS"}, {"AGGRTABLES", "NOAGGRS", "USERAGGS"}, {"AGGRTABLES", "NOTNWAY", "MEASUREMAP"}, {"MEASUREMAP", "NEXT", "RUSERAGGS"}, {"RUSERAGGS", "NEXT", "USERAGGS"}, {"USERAGGS", "NEXT", "OLAPFINISH"}, {"USERAGGS", "MLSCAPTIONS", "MLSCAPTIONS"}, {"MLSCAPTIONS", "NEXT", "OLAPFINISH"}};

    public CubeDesignerPlugin() {
        this.m_name = bundle.getString("CubeDesigner.title.txt");
        this.m_label = bundle.getString("CubeDesigner.label.txt");
        this.m_icon = Resources.getImageIcon((String)"OLAPCube.gif", (int)16);
        this.m_tooltip = bundle.getString("CubeDesigner.tooltip.txt");
        this.m_desc = bundle.getString("CubeDesigner.desc.txt");
        this.m_category = bundle.getString("CubeDesigner.category.txt");
        this.m_cubeModel = null;
    }

    public CubeDesignerPlugin(OLAPCube incube) {
        this.m_cubeModel = incube;
    }

    public String getDescription() {
        return this.m_desc;
    }

    public void initPlugin() {
    }

    public void dispose() {
    }

    public String getName() {
        return this.m_name;
    }

    public Icon getIcon() {
        return this.m_icon;
    }

    public String getCategory() {
        return this.m_category;
    }

    public String getToolTip() {
        return this.m_tooltip;
    }

    public boolean initializeWizard(WAWizardDialog wizardDialog, WATransitionWizardModel wizardModel) {
        this.m_wizardDialog = wizardDialog;
        this.m_wizardDialog.setCanFinishEarly(true);
        this.m_wizardModel = wizardModel;
        OLAPCube olapCube = null;
        if (this.m_cubeModel == null) {
            MdObjectStore MdOS = (MdObjectStore)this.m_wizardDialog.getWizardData("OBJECTSTORE");
            try {
                olapCube = new OLAPCube(MdOS);
            }
            catch (OLAPException e) {
                olapCube = null;
            }
        } else {
            olapCube = this.m_cubeModel;
        }
        ImageIcon image1 = bundle.getImageIcon("CubeDesigner.General.image");
        String general = bundle.getString("CubeDesigner.General.image");
        ImageIcon image2 = bundle.getImageIcon("CubeDesigner.Input.image");
        ImageIcon image3 = bundle.getImageIcon("CubeDesigner.Dimensions.image");
        ImageIcon image4 = bundle.getImageIcon("CubeDesigner.Measures.image");
        ImageIcon image7 = bundle.getImageIcon("CubeDesigner.Aggregations.image");
        ImageIcon image9 = bundle.getImageIcon("CubeDesigner.Finish.image");
        ImageIcon image11 = bundle.getImageIcon("CubeDesigner.MeasuresDetail.image");
        String input = bundle.getString("CubeDesigner.Input.image");
        String dimension = bundle.getString("CubeDesigner.Dimensions.image");
        String measure = bundle.getString("CubeDesigner.Measures.image");
        String aggregation = bundle.getString("CubeDesigner.Aggregations.image");
        String measuredetail = bundle.getString("CubeDesigner.MeasuresDetail.image");
        String finish = bundle.getString("CubeDesigner.Finish.image");
        WsDescriptionWizardTab tab = null;
        tab = new CubeGeneralTab(olapCube);
        this.m_wizardDialog.addTab(bundle.getString("CubeDesigner.General.top.txt"), "GENERAL", (WAPropertyTab)tab, general, (Icon)image1, true);
        this.m_wizardDialog.addTabToCleanupOnCancel((WAPropertyTab)tab);
        tab = new CubeInputTab(olapCube);
        this.m_wizardDialog.addTab(bundle.getString("CubeDesigner.Input.top.txt"), "INPUT", (WAPropertyTab)tab, input, (Icon)image2, true);
        this.m_wizardDialog.addTabToCleanupOnCancel((WAPropertyTab)tab);
        tab = new CubeDimensionTablesTab(olapCube);
        this.m_wizardDialog.addTab(bundle.getString("CubeDesigner.DimensionTables.top.txt"), "DIMTABLES", (WAPropertyTab)tab, input, (Icon)image2, true);
        this.m_wizardDialog.addTabToCleanupOnCancel((WAPropertyTab)tab);
        tab = new CubeDimensionTab(olapCube);
        this.m_wizardDialog.addTab(bundle.getString("CubeDesigner.Dimensions.top.txt"), "DIMENSIONS", (WAPropertyTab)tab, dimension, (Icon)image3, true);
        this.m_wizardDialog.addTabToCleanupOnCancel((WAPropertyTab)tab);
        tab = new CubeMeasuresSelectTab(olapCube);
        this.m_wizardDialog.addTab(bundle.getString("CubeDesigner.MeasuresSelect.top.txt"), "MMEASURES", (WAPropertyTab)tab, measure, (Icon)image4, true);
        this.m_wizardDialog.addTabToCleanupOnCancel((WAPropertyTab)tab);
        tab = new CubeMeasuresHolapSelectTab(olapCube);
        this.m_wizardDialog.addTab(bundle.getString("CubeDesigner.MeasuresSelectStored.top.txt"), "HMEASURES", (WAPropertyTab)tab, measure, (Icon)image4, true);
        this.m_wizardDialog.addTabToCleanupOnCancel((WAPropertyTab)tab);
        tab = new CubeMeasuresHolapAssignStatGroupTab(olapCube);
        this.m_wizardDialog.addTab(bundle.getString("CubeDesigner.MeasuresAssignStored.top.txt"), "ASGDETAIL", (WAPropertyTab)tab, measure, (Icon)image4, true);
        this.m_wizardDialog.addTabToCleanupOnCancel((WAPropertyTab)tab);
        tab = new CubeMeasuresHolapDerivedTab(olapCube);
        this.m_wizardDialog.addTab(bundle.getString("CubeDesigner.MeasuresSelectDerived.top.txt"), "HDERIVED", (WAPropertyTab)tab, measure, (Icon)image4, true);
        this.m_wizardDialog.addTabToCleanupOnCancel((WAPropertyTab)tab);
        tab = new CubeMeasuresHolapDetailTab(olapCube);
        this.m_wizardDialog.addTab(bundle.getString("CubeDesigner.MeasuresEditDetails.top.txt"), "HDETAIL", (WAPropertyTab)tab, measuredetail, (Icon)image11, true);
        this.m_wizardDialog.addTabToCleanupOnCancel((WAPropertyTab)tab);
        tab = new CubeAggregationTablesTab(olapCube);
        this.m_wizardDialog.addTab(bundle.getString("CubeDesigner.AggregationTables.top.txt"), "AGGRTABLES", (WAPropertyTab)tab, input, (Icon)image2, true);
        this.m_wizardDialog.addTabToCleanupOnCancel((WAPropertyTab)tab);
        tab = new CubeUserAggregationsTab(olapCube);
        this.m_wizardDialog.addTab(bundle.getString("CubeDesigner.UserAggregations.top.txt"), "USERAGGS", (WAPropertyTab)tab, aggregation, (Icon)image7, true);
        this.m_wizardDialog.addTabToCleanupOnCancel((WAPropertyTab)tab);
        tab = new CubeMeasureMapTab(olapCube);
        this.m_wizardDialog.addTab(bundle.getString("CubeDesigner.MeasureMap.top.txt"), "MEASUREMAP", (WAPropertyTab)tab, aggregation, (Icon)image7, true);
        this.m_wizardDialog.addTabToCleanupOnCancel((WAPropertyTab)tab);
        tab = new CubeUserAggregationsHolapTab(olapCube);
        this.m_wizardDialog.addTab(bundle.getString("CubeDesigner.UserAggregationsHolap.top.txt"), "RUSERAGGS", (WAPropertyTab)tab, aggregation, (Icon)image7, true);
        this.m_wizardDialog.addTabToCleanupOnCancel((WAPropertyTab)tab);
        tab = new MLSCaptionsTab(olapCube);
        this.m_wizardDialog.addTab(bundle.getString("CubeDesigner.MLSCaptions.top.txt"), "MLSCAPTIONS", (WAPropertyTab)tab, "", null, true);
        this.m_wizardDialog.addTabToCleanupOnCancel((WAPropertyTab)tab);
        this.m_wizardDialog.addTab(bundle.getString("CubeDesigner.Finish.top.txt"), "OLAPFINISH", (WAPropertyTab)new CubeFinishTab(olapCube), finish, (Icon)image9, true);
        this.m_wizardModel.addTransitions(this.Transitions);
        return true;
    }

    public String getInitialTabName() {
        String value = "GENERAL";
        return value;
    }

    public String[] getLastTabNames() {
        String[] value = new String[]{"OLAPFINISH"};
        return value;
    }

    public String getCMetadataType() {
        return "Cube";
    }
}

