/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.CubeAggregationTablesPanel;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

public class CubeAggregationTablesTab
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(CubeAggregationTablesTab.class);
    private CubeAggregationTablesPanel panel;
    private static final String ROLAP_CUBE = "NEXT";
    private static final String NON_ROLAP_CUBE = "NOAGGRS";
    private static final String FULLY_ROLAP_CUBE = "NOTNWAY";
    private OLAPCube olapCube;

    public CubeAggregationTablesTab(OLAPCube inputOlapCube) {
        super(bundle.getString("CubeDesigner.AggregationTables.instruct.txt"));
        this.panel = new CubeAggregationTablesPanel(inputOlapCube);
        this.olapCube = inputOlapCube;
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("cd_aggr_tables");
        this.setLayout(new GridBagLayout());
        this.layoutWidgets();
    }

    public boolean validateData() {
        return this.panel.validateData();
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        return this.panel.doDataExchange(bSaveToModel);
    }

    public void saveSettingsAndCleanUp() {
        this.panel.saveSettingsAndCleanUp();
    }

    public void onBack() {
        this.panel.onBack();
    }

    public String getConditionState() {
        String conditionState = ROLAP_CUBE;
        TableSet tableSet = this.olapCube.getTableSet();
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            AggregationSet aggregationSet = this.olapCube.getAggregationSet();
            tableSet = this.olapCube.getTableSet();
            try {
                OLAPList aggregationTables = aggregationSet.getTables();
                if (aggregationTables == null || aggregationTables.isEmpty()) {
                    conditionState = NON_ROLAP_CUBE;
                } else if (!tableSet.isLoadClassicSAS()) {
                    conditionState = FULLY_ROLAP_CUBE;
                }
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
        }
        return conditionState;
    }

    protected void layoutWidgets() {
        this.add((Component)((Object)this.panel), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
    }
}

