/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.cubeviewer;

import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.OlapServer;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.MDXQueryGeneration;
import com.sas.olapadmin.utilities.MDXQueryGenerationException;
import com.sas.olapadmin.utilities.MemberTreeNode;
import com.sas.olapadmin.utilities.MemberTreePanel;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.sasmdx.Dimension;
import com.sas.storage.olap.sasmdx.Hierarchy;
import com.sas.storage.olap.sasmdx.Member;
import com.sas.storage.olap.sasmdx.Metadata;
import com.sas.swing.models.OLAPTableModelAdapter;
import com.sas.swing.visuals.olaptableview.OLAPTableView;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CubeViewerPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    static WAdminResource bundle = new WAdminResource(CubeViewerPanel.class);
    static final String COLUMN = bundle.getString("CubeViewer.Axis.Column.txt");
    static final String ROW = bundle.getString("CubeViewer.Axis.Row.txt");
    static final String DEFAULT_LEVEL_MEMBERS = ".DefaultMember.Level.Members";
    static final String DEFAULT_CHILDREN = ".DefaultMember.Children";
    private Cube cube;
    private JPanel tabresPanel;
    private OLAPTableView table;
    private OlapServer olapServer;
    private OLAPDataSetInterface olapDataSet = null;
    private OLAPTableModelAdapter olapAdapter = null;
    private MemberTreePanel memberTreePanel;
    private JButton apply;
    private JPanel mdxPanel;
    private String resetMDX;
    JCheckBox replaceSelector;
    WATextArea mdxInput;
    JTree tree;
    WAComboBox addToSelector;
    String cubeName;
    MDXQueryGeneration mdxGeneration;
    String mdxQuery;
    private String displayMdxText;
    private String resetDisplayMdxText;
    MemberInterface defaultMeasureMember;
    OLAPCube olapCube;
    private boolean isAllMemberVisible2;
    private boolean isAllMemberVisible;
    private ArrayList resetDimensionInformation;

    public CubeViewerPanel(Cube cube, OlapServer olapServer) throws RemoteException, com.sas.olapadmin.designer.model.OLAPException, OLAPException {
        this.cube = cube;
        this.olapServer = olapServer;
        this.setLayout(new GridBagLayout());
        this.setCursor(Cursor.getPredefinedCursor(3));
        this._layoutWidgets();
        this._initialize();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public boolean validateData() {
        return true;
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.memberTreePanel.moveDataToStore();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.memberTreePanel.moveDataToView();
        this.tree.setToggleClickCount(2);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void populateStore() throws MdException, RemoteException {
        this.memberTreePanel.populateStore();
    }

    private void _initialize() throws com.sas.olapadmin.designer.model.OLAPException, OLAPException, RemoteException {
        ArrayList copied;
        HashMap<String, Object> dimInfo;
        String selectedUniqueName;
        this.olapCube = new OLAPCube(this.cube);
        HashMap<String, String> allMembers = new HashMap<String, String>();
        Metadata cubeMetadata = this.olapServer.getCubeMetadataSet();
        Filter filter = new Filter();
        this.cubeName = this.cube.getName();
        filter.setCubeName(this.cubeName);
        OLAPSchema schema = this.olapServer.getOLAPSchema();
        String schemaName = "";
        if (schema != null) {
            schemaName = schema.getName();
        }
        filter.setSchemaName(schemaName);
        DimensionInterface[] dimensions = cubeMetadata.getDimensions(filter);
        String defaultHierarchyName = "";
        String defaultHierarchyName2 = "";
        Dimension measureDimension = null;
        Dimension defaultDimension = null;
        Dimension secondDimension = null;
        boolean isOnlyAllMemberVisibleNoChildren = false;
        MemberInterface topMember = null;
        for (int i = 0; i < dimensions.length; ++i) {
            int secondDimension_memberCount;
            boolean isReadFirstLevel;
            HierarchyInterface defaultHier;
            isOnlyAllMemberVisibleNoChildren = false;
            topMember = null;
            Dimension dim = (Dimension)dimensions[i];
            int dimtype = dim.getType();
            if (dimtype == 2) {
                measureDimension = dim;
                this.defaultMeasureMember = dim.getDefaultHierarchy().getDefaultMember();
                continue;
            }
            String name = dim.getName();
            OLAPDimension olapDimension = this.olapCube.getDimensionSet().getDimension(name);
            if (olapDimension == null) continue;
            OLAPList hierarchies = olapDimension.getHierarchies();
            for (int hierNum = 0; hierNum < hierarchies.size(); ++hierNum) {
                OLAPHierarchy hier = (OLAPHierarchy)hierarchies.get(hierNum);
                String allMember = hier.getAllMember();
                allMembers.put(allMember, hier.getName());
            }
            String type = "Dimension";
            if (olapDimension instanceof OLAPSharedDimension) {
                type = "SharedDimension";
            }
            boolean isRead = this.isReadAllowedOnDimension(olapDimension.getFQID(), name, type);
            if (defaultDimension == null) {
                defaultHier = this.getHierarchyForDefault(olapDimension, (DimensionInterface)dim);
                if (defaultHier == null) continue;
                int defaultDimension_memberCount = defaultHier.getMemberCount();
                if (defaultDimension_memberCount == 0 | !isRead) {
                    defaultDimension = null;
                    continue;
                }
                OLAPList hierarchyLevels = olapDimension.getDefault().getLevels();
                OLAPLevel olapLevel = (OLAPLevel)hierarchyLevels.get(0);
                isReadFirstLevel = this.isReadAllowedOnFirstHierarchyLevel(olapLevel.getFQID(), olapLevel.getName());
                if (isReadFirstLevel) {
                    defaultDimension = dim;
                    defaultHierarchyName = defaultHier.getUniqueName();
                    this.isAllMemberVisible = defaultHier.getTopMember() != null;
                    continue;
                }
                defaultDimension = null;
                continue;
            }
            if (secondDimension != null || dim.getType() != 1 || (defaultHier = this.getHierarchyForDefault(olapDimension, (DimensionInterface)dim)) == null) continue;
            HierarchyInterface[] dimHierarchies = dim.getHierarchies();
            int dimHierarchiesCount = dimHierarchies.length;
            if (defaultHier.getMemberCount() == 0 && dimHierarchiesCount > 1) {
                HierarchyInterface hierarchyToUse = null;
                for (int m = 0; m < dimHierarchies.length; ++m) {
                    hierarchyToUse = dimHierarchies[m];
                    if (hierarchyToUse.getMemberCount() <= 0) continue;
                    defaultHier = hierarchyToUse;
                    break;
                }
            }
            if ((secondDimension_memberCount = defaultHier.getMemberCount()) == 0 | !isRead) {
                secondDimension = null;
                continue;
            }
            if (secondDimension_memberCount == 1 && defaultHier.getTopMember() != null) {
                secondDimension = dim;
                defaultHierarchyName2 = defaultHier.getUniqueName();
                isOnlyAllMemberVisibleNoChildren = true;
                topMember = defaultHier.getTopMember();
                continue;
            }
            OLAPList hierarchyLevels = olapDimension.getDefault().getLevels();
            OLAPLevel olapLevel = (OLAPLevel)hierarchyLevels.get(0);
            isReadFirstLevel = this.isReadAllowedOnFirstHierarchyLevel(olapLevel.getFQID(), olapLevel.getName());
            if (isReadFirstLevel) {
                secondDimension = dim;
                defaultHierarchyName2 = defaultHier.getUniqueName();
                this.isAllMemberVisible2 = defaultHier.getTopMember() != null;
                continue;
            }
            secondDimension = null;
        }
        String measureName = this.defaultMeasureMember.getUniqueName();
        ArrayList<String> dimensionMember = new ArrayList<String>();
        dimensionMember.add(measureName);
        this.resetDimensionInformation = new ArrayList();
        try {
            this.mdxGeneration = new MDXQueryGeneration();
            this.mdxGeneration.setAllMemberMap(allMembers);
            if (!defaultHierarchyName2.equals("")) {
                ArrayList<String> secondDimensionMember = new ArrayList<String>();
                selectedUniqueName = "";
                selectedUniqueName = this.isAllMemberVisible2 ? defaultHierarchyName2.concat(DEFAULT_CHILDREN) : (isOnlyAllMemberVisibleNoChildren ? topMember.getUniqueName() : defaultHierarchyName2.concat(DEFAULT_LEVEL_MEMBERS));
                secondDimensionMember.add(selectedUniqueName);
                this.mdxGeneration.addDimensionMembersForAxis(secondDimension, secondDimensionMember, " ON COLUMNS");
                dimInfo = new HashMap<String, Object>();
                dimInfo.put("Dimension", secondDimension);
                copied = new ArrayList(secondDimensionMember);
                dimInfo.put("DimensionMember", copied);
                dimInfo.put("Axis", " ON COLUMNS");
                this.resetDimensionInformation.add(dimInfo);
            }
            this.mdxGeneration.addDimensionMembersForAxis((DimensionInterface)measureDimension, dimensionMember, " ON COLUMNS");
            HashMap<String, Object> dimInfo2 = new HashMap<String, Object>();
            dimInfo2.put("Dimension", measureDimension);
            ArrayList copied2 = new ArrayList(dimensionMember);
            dimInfo2.put("DimensionMember", copied2);
            dimInfo2.put("Axis", " ON COLUMNS");
            this.resetDimensionInformation.add(dimInfo2);
        }
        catch (MDXQueryGenerationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (String)measureDimension.getUniqueName());
            return;
        }
        try {
            if (defaultDimension == null) {
                this.saveSettingsAndCleanUp();
                throw new com.sas.olapadmin.designer.model.OLAPException(bundle.formatString("ViewCube.NoResultsDisplayed.informational.txt", (Object)this.cubeName), 1);
            }
            ArrayList<String> defaultHierarchyMember = new ArrayList<String>();
            selectedUniqueName = "";
            selectedUniqueName = this.isAllMemberVisible ? defaultHierarchyName.concat(DEFAULT_CHILDREN) : defaultHierarchyName.concat(DEFAULT_LEVEL_MEMBERS);
            defaultHierarchyMember.add(selectedUniqueName);
            this.mdxGeneration.addDimensionMembersForAxis((DimensionInterface)defaultDimension, defaultHierarchyMember, " ON ROWS");
            dimInfo = new HashMap();
            dimInfo.put("Dimension", defaultDimension);
            copied = new ArrayList(defaultHierarchyMember);
            dimInfo.put("DimensionMember", copied);
            dimInfo.put("Axis", " ON ROWS");
            this.resetDimensionInformation.add(dimInfo);
            this.mdxQuery = this.mdxGeneration.constructMdxQuery(this.cubeName);
            this.displayMdxText = this.mdxGeneration.getDisplayMdxQuery();
        }
        catch (MDXQueryGenerationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (String)defaultDimension.getUniqueName());
            return;
        }
        this.resetMDX = this.mdxQuery.toString();
        this.resetDisplayMdxText = this.displayMdxText.toString();
        this.mdxInput.setText(this.displayMdxText);
        this.olapDataSet = this.olapServer.getOLAPDataSet(this.mdxQuery);
        this.olapAdapter = new OLAPTableModelAdapter();
        this.olapAdapter.setModel(this.olapDataSet);
        this.table.setModel((TableModel)this.olapAdapter);
        this.table.setPopupMenuEnabled(false);
    }

    private HierarchyInterface getHierarchyForDefault(OLAPDimension olapDimension, DimensionInterface dim) throws com.sas.olapadmin.designer.model.OLAPException, OLAPException {
        OLAPHierarchy olapDefaultHierarchy = null;
        HierarchyInterface hierarchyToUse = null;
        HierarchyInterface defaultHierarchy = null;
        olapDefaultHierarchy = olapDimension.getDefault();
        defaultHierarchy = dim.getDefaultHierarchy();
        if (!this.isReadAllowedOnHierarchy(olapDefaultHierarchy.getFQID(), olapDefaultHierarchy.getName())) {
            HierarchyInterface[] hierarchies = dim.getHierarchies();
            for (int i = 0; i < hierarchies.length; ++i) {
                HierarchyInterface hier = hierarchies[i];
                OLAPHierarchy olapHierarchy = this.olapCube.getDimensionSet().getHierarchy(hier.getName());
                if (!this.isReadAllowedOnHierarchy(olapHierarchy.getFQID(), hier.getName())) continue;
                hierarchyToUse = hier;
                break;
            }
        } else {
            hierarchyToUse = defaultHierarchy;
        }
        return hierarchyToUse;
    }

    public void applyReset() {
        try {
            this.mdxGeneration.resetOnColumns();
            this.mdxGeneration.resetOnRows();
            this.mdxGeneration.resetWhere();
            for (int i = 0; i < this.resetDimensionInformation.size(); ++i) {
                HashMap map = (HashMap)this.resetDimensionInformation.get(i);
                DimensionInterface dimension = (DimensionInterface)map.get("Dimension");
                List members = (List)map.get("DimensionMember");
                ArrayList copied = new ArrayList(members);
                String axis = (String)map.get("Axis");
                this.mdxGeneration.addDimensionMembersForAxis(dimension, copied, axis);
            }
            this.applyMDXtoTable(this.resetMDX);
            this.mdxInput.setText(this.resetDisplayMdxText);
        }
        catch (MDXQueryGenerationException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)1);
        }
    }

    private boolean isReadAllowedOnDimension(String FQId, String name, String type) {
        boolean isReadPermission = ModelUtilities.getPermissionFromId((String)"Read", (String)type, (String)FQId);
        return isReadPermission;
    }

    private boolean isReadAllowedOnFirstHierarchyLevel(String FQId, String name) {
        boolean isReadPermission = ModelUtilities.getPermissionFromId((String)"Read", (String)"Level", (String)FQId);
        return isReadPermission;
    }

    private boolean isReadAllowedOnHierarchy(String FQId, String name) {
        boolean isReadPermission = ModelUtilities.getPermissionFromId((String)"Read", (String)"Hierarchy", (String)FQId);
        return isReadPermission;
    }

    private void _layoutWidgets() throws RemoteException {
        this.cubeName = this.cube.getCubeName();
        this.replaceSelector = new JCheckBox();
        Utilities.setButtonTextAndMnemonic((AbstractButton)this.replaceSelector, (String)bundle.getString("CubeViewer.Checkbox.txt"));
        this.mdxPanel = new JPanel(new BorderLayout());
        this.tabresPanel = new JPanel(new BorderLayout());
        TitledBorder titledBorder2 = new TitledBorder(bundle.getString("CubeViewer.NavigationPane.Title.txt"));
        Object[] axis = new String[]{ROW, COLUMN};
        WAPanel dimensionSelectorPanel = new WAPanel();
        dimensionSelectorPanel.setLayout((LayoutManager)new GridBagLayout());
        dimensionSelectorPanel.setBorder((Border)titledBorder2);
        JLabel addtoLabel = new JLabel();
        this.addToSelector = new WAComboBox(axis);
        Utilities.setLabelTextAndMnemonic((JLabel)addtoLabel, (String)bundle.getString("CubeViewer.AddTo.Label.txt"));
        addtoLabel.setLabelFor((Component)this.addToSelector);
        ImageIcon icon = null;
        icon = bundle.getImageIcon("CubeViewer.ApplyArrow.image");
        this.apply = new JButton(icon);
        this.apply.setToolTipText(bundle.getString("CubeViewer.ApplyArrow.action.tip"));
        WAPanel addApplyPanel = new WAPanel();
        addApplyPanel.add((Component)addtoLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        addApplyPanel.add((Component)this.addToSelector, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        addApplyPanel.add((Component)this.apply, (Object)new GridBagConstraints(2, 0, 1, 1, 0.5, 0.5, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        dimensionSelectorPanel.add((Component)addApplyPanel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.5, 0.1, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        dimensionSelectorPanel.add((Component)this.replaceSelector, (Object)new GridBagConstraints(0, 1, 1, 1, 0.5, 0.1, 11, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.replaceSelector.setSelected(true);
        this.replaceSelector.setEnabled(true);
        this.memberTreePanel = new MemberTreePanel(this.cube, this.olapServer);
        this.tree = this.memberTreePanel.getTreeComponent();
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(4);
        dimensionSelectorPanel.add((Component)this.memberTreePanel, (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 0.8, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        WAPanel mdxTablePanel = new WAPanel();
        mdxTablePanel.setLayout((LayoutManager)new GridBagLayout());
        this.table = new OLAPTableView();
        this.tabresPanel.add((Component)new JScrollPane((Component)this.table), "Center");
        mdxTablePanel.add((Component)this.tabresPanel, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.8, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.mdxInput = new WATextArea();
        this.mdxInput.setBehavior(2);
        this.mdxInput.setAutoSelect(false);
        this.mdxInput.setAutosize(true);
        Border titledBorder1 = null;
        this.mdxPanel.setBorder(titledBorder1);
        JScrollPane mdxScrollPane = new JScrollPane((Component)this.mdxInput);
        this.mdxPanel.add((Component)mdxScrollPane, "Center");
        mdxTablePanel.add((Component)this.mdxPanel, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.2, 17, 1, new Insets(5, 5, 5, 10), 0, 0));
        JSplitPane splitPane = new JSplitPane(1, (Component)dimensionSelectorPanel, (Component)mdxTablePanel);
        splitPane.setResizeWeight(0.25);
        this.add(splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        ApplyListener applyListener = new ApplyListener();
        this.apply.addActionListener(applyListener);
    }

    public void saveSettingsAndCleanUp() {
        if (this.olapServer != null) {
            try {
                this.olapServer.disconnect();
            }
            catch (com.sas.olapadmin.designer.model.OLAPException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage());
            }
            this.olapServer = null;
        }
    }

    void applyMDXtoTable(String mdx_query) {
        try {
            this.olapServer.verifyMdx(mdx_query);
            this.olapDataSet.executeQuery(mdx_query);
            this.olapAdapter.setModel(this.olapDataSet);
            this.olapAdapter.fireTableStructureChanged();
        }
        catch (OLAPException e1) {
            this.olapAdapter = new OLAPTableModelAdapter();
            this.table.setModel((TableModel)this.olapAdapter);
            MessageUtil.displayMessage((String)bundle.getString("ViewCube.NoConnectionSession.information.txt"), (int)1);
        }
        catch (com.sas.olapadmin.designer.model.OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    class ApplyListener
    implements ActionListener {
        String[] strArray = new String[50];
        List dimension_list;
        DimensionInterface dimension;
        boolean abort_mdxConstruction = false;

        ApplyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            block46: {
                try {
                    String axisToApply;
                    CubeViewerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    String selectedUniqueName = "";
                    TreePath[] selectionPaths = CubeViewerPanel.this.tree.getSelectionPaths();
                    int numPaths = CubeViewerPanel.this.tree.getSelectionCount();
                    if (numPaths == 0) {
                        return;
                    }
                    this.abort_mdxConstruction = false;
                    int numSelectionPaths = selectionPaths.length;
                    if (numSelectionPaths <= 0) break block46;
                    String selectedAxis = (String)CubeViewerPanel.this.addToSelector.getSelectedItem();
                    if (selectedAxis.equals(ROW)) {
                        axisToApply = " ON ROWS";
                        if (CubeViewerPanel.this.replaceSelector.isSelected()) {
                            CubeViewerPanel.this.mdxGeneration.resetOnRows();
                        }
                    } else if (selectedAxis.equals(COLUMN)) {
                        axisToApply = " ON COLUMNS";
                        if (CubeViewerPanel.this.replaceSelector.isSelected()) {
                            CubeViewerPanel.this.mdxGeneration.resetOnColumns();
                        }
                    } else {
                        axisToApply = " WHERE ";
                        if (CubeViewerPanel.this.replaceSelector.isSelected()) {
                            CubeViewerPanel.this.mdxGeneration.resetWhere();
                        }
                    }
                    for (int i = 0; i < numSelectionPaths; ++i) {
                        ArrayList existingDimensions;
                        block47: {
                            TreePath selectedPath = selectionPaths[i];
                            TreeNode selectedNode = (TreeNode)selectedPath.getLastPathComponent();
                            Object userObject = null;
                            if (!(selectedNode instanceof MemberTreeNode)) {
                                this.abort_mdxConstruction = true;
                                break;
                            }
                            userObject = ((MemberTreeNode)selectedNode).getUserObject();
                            if (userObject != null) {
                                if (userObject instanceof Dimension) {
                                    try {
                                        this.dimension = (Dimension)userObject;
                                        HierarchyInterface[] hierarchies = ((Dimension)userObject).getHierarchies();
                                        if (hierarchies.length == 0) {
                                            this.abort_mdxConstruction = true;
                                            MessageUtil.displayMessage((String)bundle.formatString("ViewCube.NoHierarchies.informational.txt", (Object)this.dimension.getName()), (int)1);
                                            break;
                                        }
                                        Hierarchy firstHierarchy = null;
                                        MemberInterface defaultMember = null;
                                        if (this.dimension.getType() == 2) {
                                            firstHierarchy = (Hierarchy)hierarchies[0];
                                            if (firstHierarchy != null && (defaultMember = firstHierarchy.getDefaultMember()) != null) {
                                                selectedUniqueName = defaultMember.getUniqueName();
                                            }
                                            if (firstHierarchy == null || defaultMember == null) {
                                                this.abort_mdxConstruction = true;
                                                MessageUtil.displayMessage((String)bundle.formatString("ViewCube.NoHierarchies.informational.txt", (Object)this.dimension.getName()), (int)1);
                                                break;
                                            }
                                            break block47;
                                        }
                                        String name = this.dimension.getName();
                                        OLAPDimension olapDimension = CubeViewerPanel.this.olapCube.getDimensionSet().getDimension(name);
                                        firstHierarchy = CubeViewerPanel.this.getHierarchyForDefault(olapDimension, this.dimension);
                                        if (firstHierarchy != null) {
                                            MemberInterface topMember = firstHierarchy.getTopMember();
                                            int dimHierarchiesCount = hierarchies.length;
                                            if (firstHierarchy.getMemberCount() == 0 && dimHierarchiesCount > 1) {
                                                HierarchyInterface hierarchyToUse = null;
                                                for (int m = 0; m < hierarchies.length; ++m) {
                                                    hierarchyToUse = hierarchies[m];
                                                    if (hierarchyToUse.getMemberCount() <= 0) continue;
                                                    firstHierarchy = hierarchyToUse;
                                                    topMember = firstHierarchy.getTopMember();
                                                    break;
                                                }
                                            }
                                            String hierarchyUniqueName = firstHierarchy.getUniqueName();
                                            selectedUniqueName = topMember == null ? hierarchyUniqueName.concat(CubeViewerPanel.DEFAULT_LEVEL_MEMBERS) : (firstHierarchy.getMemberCount() == 1 && topMember != null ? topMember.getUniqueName() : hierarchyUniqueName.concat(CubeViewerPanel.DEFAULT_CHILDREN));
                                            break block47;
                                        }
                                        this.abort_mdxConstruction = true;
                                        MessageUtil.displayMessage((String)bundle.formatString("ViewCube.NoHierarchies.informational.txt", (Object)this.dimension.getName()), (int)1);
                                    }
                                    catch (com.sas.olapadmin.designer.model.OLAPException e1) {
                                        MessageUtil.displayDetailsMessage((String)bundle.getString("CubeViewer.DataSourceTree.ReadError.txt"), (int)0, (String)e1.getLocalizedMessage());
                                        this.abort_mdxConstruction = true;
                                    }
                                    catch (OLAPException e2) {
                                        MessageUtil.displayDetailsMessage((String)bundle.getString("CubeViewer.DataSourceTree.ReadError.txt"), (int)0, (String)e2.getLocalizedMessage());
                                        this.abort_mdxConstruction = true;
                                    }
                                    catch (IllegalStateException e3) {
                                        this.abort_mdxConstruction = true;
                                        MessageUtil.displayMessage((String)bundle.formatString("ViewCube.NoResultsDisplayed.informational.txt", (Object)CubeViewerPanel.this.cubeName), (int)1);
                                    }
                                    break;
                                }
                                if (userObject instanceof Hierarchy) {
                                    try {
                                        this.dimension = ((Hierarchy)userObject).getDimension();
                                        Hierarchy hierarchySelected = (Hierarchy)userObject;
                                        if (this.dimension.getType() == 2) {
                                            MemberInterface defaultMember = hierarchySelected.getDefaultMember();
                                            selectedUniqueName = defaultMember.getUniqueName();
                                        } else {
                                            int numberHierarchyMembers;
                                            String hierarchyUniqueName = hierarchySelected.getUniqueName();
                                            if (hierarchySelected.getMemberCount() == 0) {
                                                this.abort_mdxConstruction = true;
                                                MessageUtil.displayMessage((String)bundle.formatString("ViewCube.NoMembersForHierarchy.informational.txt", (Object)hierarchySelected.getDescription()), (int)1);
                                                break;
                                            }
                                            selectedUniqueName = hierarchySelected.getTopMember() == null ? hierarchyUniqueName.concat(CubeViewerPanel.DEFAULT_LEVEL_MEMBERS) : ((numberHierarchyMembers = hierarchySelected.getMemberCount()) == 1 && hierarchySelected.getTopMember() != null ? hierarchySelected.getTopMember().getUniqueName() : hierarchyUniqueName.concat(CubeViewerPanel.DEFAULT_CHILDREN));
                                        }
                                        break block47;
                                    }
                                    catch (OLAPException e1) {
                                        MessageUtil.displayDetailsMessage((String)bundle.getString("CubeViewer.DataSourceTree.ReadError.txt"), (int)0, (String)e1.getLocalizedMessage());
                                        this.abort_mdxConstruction = true;
                                        break;
                                    }
                                    catch (IllegalStateException e3) {
                                        this.abort_mdxConstruction = true;
                                        MessageUtil.displayMessage((String)bundle.formatString("ViewCube.NoResultsDisplayed.informational.txt", (Object)CubeViewerPanel.this.cubeName), (int)1);
                                        break;
                                    }
                                }
                                if (userObject instanceof Member) {
                                    try {
                                        selectedUniqueName = ((Member)userObject).getUniqueName();
                                        this.dimension = ((Member)userObject).getDimension();
                                    }
                                    catch (OLAPException olapException) {
                                        MessageUtil.displayDetailsMessage((String)bundle.getString("CubeViewer.DataSourceTree.ReadError.txt"), (int)0, (String)olapException.getLocalizedMessage());
                                        this.abort_mdxConstruction = true;
                                        break;
                                    }
                                    catch (IllegalStateException e3) {
                                        this.abort_mdxConstruction = true;
                                        MessageUtil.displayMessage((String)bundle.formatString("ViewCube.NoResultsDisplayed.informational.txt", (Object)CubeViewerPanel.this.cubeName), (int)1);
                                        break;
                                    }
                                }
                            }
                        }
                        if (MDXQueryGeneration.containsDimension((List)(existingDimensions = CubeViewerPanel.this.mdxGeneration.getAxisDimensions(axisToApply)), (DimensionInterface)this.dimension)) {
                            CubeViewerPanel.this.mdxGeneration.addToExistingDimensionMembers(this.dimension, selectedUniqueName);
                            continue;
                        }
                        this.dimension_list = new ArrayList();
                        this.dimension_list.add(selectedUniqueName);
                        CubeViewerPanel.this.mdxGeneration.addDimensionMembersForAxis(this.dimension, this.dimension_list, axisToApply);
                    }
                    if (!this.abort_mdxConstruction) {
                        CubeViewerPanel.this.mdxQuery = CubeViewerPanel.this.mdxGeneration.constructMdxQuery(CubeViewerPanel.this.cubeName);
                        CubeViewerPanel.this.applyMDXtoTable(CubeViewerPanel.this.mdxQuery);
                        CubeViewerPanel.this.mdxInput.setText(CubeViewerPanel.this.mdxQuery);
                    } else if (selectedAxis.equals(ROW)) {
                        CubeViewerPanel.this.mdxGeneration.restoreRowAxis();
                    } else if (selectedAxis.equals(COLUMN)) {
                        CubeViewerPanel.this.mdxGeneration.restoreColumnAxis();
                    }
                }
                catch (MDXQueryGenerationException e1) {
                    MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)1);
                    return;
                }
                finally {
                    CubeViewerPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
    }
}

