/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.calcmembers.formulas;

import com.sas.olapadmin.calcmembers.BoldLabel;
import com.sas.olapadmin.calcmembers.formulas.AbstractFormula;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PercentChange
extends AbstractFormula
implements ActionListener {
    private static WAdminResource bundle = new WAdminResource(PercentChange.class);
    private JLabel divisorLabel;
    private boolean decrease;
    private WAComboBox first;
    private WAComboBox second;
    private List measures;
    private JPanel panel;

    public PercentChange(List inMeasures, boolean decr) {
        this.measures = inMeasures;
        this.decrease = decr;
        if (this.decrease) {
            this.label = bundle.getString("PctDecrease.Label.txt");
            this.defaultName = bundle.getString("PctDecrease.DefaultName.txt");
        } else {
            this.label = bundle.getString("PctIncrease.Label.txt");
            this.defaultName = bundle.getString("PctIncrease.DefaultName.txt");
        }
    }

    @Override
    public String getFormulaText() {
        StringBuffer formulaText = new StringBuffer(150);
        try {
            formulaText.append("(");
            AbstractOLAPModel selectedItem = (AbstractOLAPModel)this.first.getSelectedItem();
            String firstName = this.getItemUniqueName(selectedItem);
            formulaText.append(firstName);
            formulaText.append("-");
            selectedItem = (AbstractOLAPModel)this.second.getSelectedItem();
            String secondName = this.getItemUniqueName(selectedItem);
            formulaText.append(secondName);
            formulaText.append(") / ");
            if (this.decrease) {
                formulaText.append(secondName);
            } else {
                formulaText.append(firstName);
            }
        }
        catch (OLAPException e) {
            e.printStackTrace();
        }
        return formulaText.toString();
    }

    @Override
    public JPanel getFormulaPanel() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        JPanel top = new JPanel();
        top.setLayout(new GridBagLayout());
        BoldLabel leftParen = new BoldLabel("(", 4);
        top.add((Component)leftParen, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.first = new WAComboBox();
        this.first.getAccessibleContext().setAccessibleName(bundle.getString("Formula.FirstMeasure.control.label"));
        int size = this.measures.size();
        for (int i = 0; i < size; ++i) {
            this.first.addItem(this.measures.get(i));
        }
        this.first.setActionCommand("FIRST");
        this.first.setSelectedIndex(0);
        this.first.addActionListener((ActionListener)this);
        top.add((Component)this.first, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.panel.add((Component)top, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
        BoldLabel sign = new BoldLabel("-", 0);
        this.panel.add((Component)sign, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel bottom = new JPanel();
        bottom.setLayout(new GridBagLayout());
        this.second = new WAComboBox();
        this.second.getAccessibleContext().setAccessibleName(bundle.getString("Formula.SecondMeasure.control.label"));
        int size2 = this.measures.size();
        for (int i = 0; i < size2; ++i) {
            this.second.addItem(this.measures.get(i));
        }
        this.second.setActionCommand("SECOND");
        this.second.setSelectedIndex(0);
        this.second.addActionListener((ActionListener)this);
        bottom.add((Component)this.second, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        BoldLabel rightParen = new BoldLabel(")", 2);
        bottom.add((Component)rightParen, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.panel.add((Component)bottom, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
        BoldLabel divideSign = new BoldLabel("/", 0);
        this.panel.add((Component)divideSign, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        AbstractOLAPModel selectedItem = this.decrease ? (AbstractOLAPModel)this.second.getSelectedItem() : (AbstractOLAPModel)this.first.getSelectedItem();
        String divisor = selectedItem.toString();
        this.divisorLabel = new JLabel(divisor, 0);
        this.panel.add((Component)this.divisorLabel, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        return this.panel;
    }

    @Override
    public boolean validateFormula() {
        boolean dataOK = true;
        if (this.first.getSelectedItem() == null | this.second.getSelectedItem() == null) {
            MessageUtil.displayMessage((String)bundle.getString("Formula.MissingSelection.txt"), (int)0);
            dataOK = false;
        }
        return dataOK;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        WAComboBox obj = (WAComboBox)e.getSource();
        AbstractOLAPModel item = (AbstractOLAPModel)obj.getSelectedItem();
        if (this.decrease && obj == this.second || !this.decrease && obj == this.first) {
            this.divisorLabel.setText(item.toString());
        }
        WAWizardDialog parent = (WAWizardDialog)this.panel.getTopLevelAncestor();
        parent.addWizardData(obj.getActionCommand(), (Object)item);
    }

    @Override
    public void refreshDisplay() {
        WAWizardDialog parent = (WAWizardDialog)this.panel.getTopLevelAncestor();
        Object item = parent.getWizardData("FIRST");
        if (item != null) {
            this.first.setSelectedItem(item);
        }
        if ((item = parent.getWizardData("SECOND")) != null) {
            this.second.setSelectedItem(item);
        }
    }
}

