/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.calcmembers.formulas;

import com.sas.olapadmin.calcmembers.BoldLabel;
import com.sas.olapadmin.calcmembers.formulas.AbstractFormula;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JPanel;

public abstract class AbstractSimpleMathFormula
extends AbstractFormula
implements ActionListener {
    private static WAdminResource bundle = new WAdminResource(AbstractSimpleMathFormula.class);
    protected String operator = " ";
    private WAComboBox first;
    private WAComboBox second;
    private List measures;
    protected JPanel panel;

    public AbstractSimpleMathFormula(List inMeasures) {
        this.measures = inMeasures;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        WAComboBox obj = (WAComboBox)e.getSource();
        AbstractOLAPModel item = (AbstractOLAPModel)obj.getSelectedItem();
        WAWizardDialog parent = (WAWizardDialog)this.panel.getTopLevelAncestor();
        parent.addWizardData(obj.getActionCommand(), (Object)item);
    }

    @Override
    public String getFormulaText() {
        StringBuffer formulaText = new StringBuffer(150);
        try {
            AbstractOLAPModel selectedItem = (AbstractOLAPModel)this.first.getSelectedItem();
            String uniqueName = this.getItemUniqueName(selectedItem);
            formulaText.append(uniqueName);
            formulaText.append(this.operator);
            selectedItem = (AbstractOLAPModel)this.second.getSelectedItem();
            uniqueName = this.getItemUniqueName(selectedItem);
            formulaText.append(uniqueName);
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        return formulaText.toString();
    }

    @Override
    public JPanel getFormulaPanel() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.first = new WAComboBox();
        this.first.getAccessibleContext().setAccessibleName(bundle.getString("Formula.FirstMeasure.control.label"));
        int size = this.measures.size();
        for (int i = 0; i < size; ++i) {
            this.first.addItem(this.measures.get(i));
        }
        this.first.setActionCommand("FIRST");
        this.first.setSelectedIndex(0);
        this.first.addActionListener((ActionListener)this);
        this.panel.add((Component)this.first, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        BoldLabel sign = new BoldLabel(this.operator, 0);
        this.panel.add((Component)sign, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.second = new WAComboBox();
        this.second.getAccessibleContext().setAccessibleName(bundle.getString("Formula.SecondMeasure.control.label"));
        int size2 = this.measures.size();
        for (int i = 0; i < size2; ++i) {
            this.second.addItem(this.measures.get(i));
        }
        this.second.setActionCommand("SECOND");
        this.second.setSelectedIndex(0);
        this.second.addActionListener((ActionListener)this);
        this.panel.add((Component)this.second, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
        return this.panel;
    }

    @Override
    public void refreshDisplay() {
        WAWizardDialog parent = (WAWizardDialog)this.panel.getTopLevelAncestor();
        Object item = parent.getWizardData("FIRST");
        if (item != null) {
            this.first.setSelectedItem(item);
        }
        if ((item = parent.getWizardData("SECOND")) != null) {
            this.second.setSelectedItem(item);
        }
    }

    @Override
    public boolean validateFormula() {
        boolean dataOK = true;
        if (this.first.getSelectedItem() == null | this.second.getSelectedItem() == null) {
            MessageUtil.displayMessage((String)bundle.getString("Formula.MissingSelection.txt"), (int)0);
            dataOK = false;
        }
        return dataOK;
    }
}

