/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.calcmembers;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPDefinedMember;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class NewMemberGeneralTab
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(NewMemberGeneralTab.class);
    private WATextField name;
    private WAComboBox format;
    private JSpinner solveOrder;
    private WATextField dimension;
    private WATextField parentMember;
    private OLAPDefinedMember calculation;
    private WATextField type;
    private WAIntTextField mlsid;
    private boolean isMLS;

    public NewMemberGeneralTab(OLAPDefinedMember calcObject, boolean isMLS) {
        super(bundle.getString("NewMemberWizard.General.Instructions.txt"));
        this.calculation = calcObject;
        this.isMLS = isMLS;
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("calculate_member_general");
        this.layoutWidgets();
    }

    public String createFinishString() {
        String lineSeparator = System.getProperty("line.separator");
        String finishString0 = bundle.formatString("NewMemberWizard.General.FinishInfo.Dimension.fmt.txt", (Object)this.dimension.getText());
        String finishString1 = bundle.formatString("NewMemberWizard.General.FinishInfo.ParentMember.fmt.txt", (Object)this.parentMember.getText());
        String finishString2 = bundle.formatString("NewMemberWizard.General.FinishInfo.Name.fmt.txt", (Object)this.name.getText());
        String finishString3 = bundle.formatString("NewMemberWizard.General.FinishInfo.Format.fmt.txt", this.format.getSelectedItem());
        String finishString4 = bundle.formatString("NewMemberWizard.General.FinishInfo.SolveOrder.fmt.txt", (Object)this.solveOrder.getValue().toString());
        String finishString5 = null;
        if (this.isMLS && this.mlsid != null && this.mlsid.getValue() > 0) {
            finishString5 = bundle.formatString("NewMemberWizard.General.FinishInfo.MLSID.fmt.txt", (Object)String.valueOf(this.mlsid.getValue()));
        }
        StringBuffer finishString = new StringBuffer();
        finishString.append(finishString0).append(lineSeparator).append(lineSeparator);
        finishString.append(finishString1).append(lineSeparator).append(lineSeparator);
        finishString.append(finishString2).append(lineSeparator).append(lineSeparator);
        finishString.append(finishString3).append(lineSeparator).append(lineSeparator);
        finishString.append(finishString4);
        if (finishString5 != null) {
            finishString.append(lineSeparator).append(lineSeparator).append(finishString5);
        }
        return finishString.toString();
    }

    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        if (saveToModel) {
            try {
                this.calculation.setName(this.name.getText());
                this.calculation.setFormat(this.format.getSelectedItem().toString());
                Integer value = (Integer)this.solveOrder.getValue();
                if (value != 0) {
                    this.calculation.setSolveOrder(Integer.valueOf(value));
                } else {
                    this.calculation.setSolveOrder(null);
                }
                if (this.isMLS && this.mlsid != null) {
                    int mlsidValue = this.mlsid.getValue();
                    if (mlsidValue > 0) {
                        this.calculation.setMLSID(Integer.valueOf(mlsidValue));
                    } else {
                        this.calculation.setMLSID(null);
                    }
                }
                this.calculation.setExpression(this.calculation.buildExpression());
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
        } else {
            this.dimension.setText(this.calculation.getDimensionName());
            this.parentMember.setText(this.calculation.getParentMember());
            this.name.setText(this.calculation.getName());
            WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
            String typeString = (String)parent.getWizardData("CALCULATIONTYPE");
            this.type.setText(typeString);
        }
        return true;
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.type = new WATextField();
        this.type.setBehavior(1);
        JLabel typeLabel = new JLabel(bundle.getString("NewMemberWizard.General.Type.txt"));
        typeLabel.setName("NewMemberType");
        typeLabel.setLabelFor((Component)this.type);
        this.add(typeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.type, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.dimension = new WATextField();
        this.dimension.setBehavior(1);
        this.dimension.setName("NewMemberDimension");
        JLabel dimensionLabel = new JLabel(bundle.getString("NewMemberWizard.General.Dimension.txt"));
        dimensionLabel.setLabelFor((Component)this.dimension);
        dimensionLabel.setName("NewMemberDimensionLabel");
        this.add(dimensionLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.dimension, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.parentMember = new WATextField();
        this.parentMember.setBehavior(1);
        this.parentMember.setName("NewMemberParentMember");
        JLabel parentMemberLabel = new JLabel(bundle.getString("NewMemberWizard.General.ParentMember.txt"));
        parentMemberLabel.setLabelFor((Component)this.parentMember);
        parentMemberLabel.setName("NewMemberParentMemberLabel");
        this.add(parentMemberLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.parentMember, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.name = new WATextField();
        this.name.setMaxCharacters(256);
        this.name.setToolTipText(bundle.getString("NewMemberWizard.General.Name.Tooltip.txt"));
        this.name.setName("NewMemberNameField");
        JLabel nameLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(nameLabel, bundle.getString("NewMemberWizard.General.Name.txt"));
        nameLabel.setLabelFor((Component)this.name);
        nameLabel.setName("NewMemberNameLabelField");
        this.add(nameLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.name, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.format = new WAComboBox();
        this.format.setEditable(true);
        this.format.addItems((Object[])ModelUtilities.formats);
        this.format.setSelectedIndex(1);
        this.format.setToolTipText(bundle.getString("NewMemberWizard.General.Format.Tooltip.txt"));
        this.format.setName("NewMemberFormatField");
        JLabel formatLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(formatLabel, bundle.getString("NewMemberWizard.General.Format.txt"));
        formatLabel.setLabelFor((Component)this.format);
        formatLabel.setName("NewMemberFormatLabelField");
        this.add(formatLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.format, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.solveOrder = new JSpinner(new SpinnerNumberModel(0, -8191, 65535, 1));
        this.solveOrder.setToolTipText(bundle.getString("NewMemberWizard.General.SolveOrder.Tooltip.txt"));
        this.solveOrder.setName("NewMemberSolveOrderField");
        JLabel solveOrderLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(solveOrderLabel, bundle.getString("NewMemberWizard.General.SolveOrder.txt"));
        solveOrderLabel.setLabelFor(this.solveOrder);
        solveOrderLabel.setName("NewMemberSolveOrderLabel");
        this.add(solveOrderLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.solveOrder, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        if (this.isMLS) {
            this.mlsid = new WAIntTextField(false);
            this.mlsid.setColumns(6);
            this.mlsid.setMaxCharacters(10);
            this.mlsid.setToolTipText(bundle.getString("NewMemberWizard.General.MLSID.Tooltip.txt"));
            JLabel mlsidLabel = new JLabel();
            VisualUtilities.setLabelTextAndMnemonic(mlsidLabel, bundle.getString("NewMemberWizard.General.MLSID.txt"));
            mlsidLabel.setLabelFor((Component)this.mlsid);
            this.add(mlsidLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.mlsid, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        }
    }

    public void onBack() {
        this.calculation.setName(this.name.getText());
    }

    public boolean validateData() {
        boolean dataOK = false;
        String oldName = this.calculation.getName();
        try {
            int mlsidValue;
            this.calculation.setName(this.name.getText());
            this.calculation.verifyName();
            if (this.isMLS && this.mlsid != null && (mlsidValue = this.mlsid.getValue()) > 0) {
                this.calculation.verifyMLSId(new Integer(mlsidValue));
            }
            dataOK = true;
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
            this.calculation.setName(oldName);
        }
        return dataOK;
    }
}

