/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.calcmembers;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.calcmembers.TimePeriodItem;
import com.sas.olapadmin.calcmembers.formulas.Balances;
import com.sas.olapadmin.calcmembers.formulas.ComparePeriods;
import com.sas.olapadmin.calcmembers.formulas.Difference;
import com.sas.olapadmin.calcmembers.formulas.DistinctCount;
import com.sas.olapadmin.calcmembers.formulas.FormulaInterface;
import com.sas.olapadmin.calcmembers.formulas.PercentChange;
import com.sas.olapadmin.calcmembers.formulas.PeriodToDate;
import com.sas.olapadmin.calcmembers.formulas.Ratio;
import com.sas.olapadmin.calcmembers.formulas.Sum;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDefinedMember;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

public class NewMemberFormulasTab
extends WsDescriptionWizardTab
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(NewMemberFormulasTab.class);
    private OLAPDefinedMember calculation;
    private ButtonGroup formulas;
    private JPanel formulaPanel;
    private FormulaInterface currentFormula;
    private ArrayList formulaObjects = new ArrayList();
    private CardLayout cards;
    private OLAPDimension timeDimension;
    private OLAPCube cube;

    public NewMemberFormulasTab(OLAPDefinedMember calcObject, String type) {
        this.calculation = calcObject;
        this.cube = this.calculation.getOwningCube();
        this.findTimeDimension();
        ArrayList measures = this.getAllMeasures();
        this.setHelpProduct("olapadmin");
        if (type.equals("TIME") && this.timeDimension != null) {
            this.setHelpTopic("calculate_member_time_calc");
            this.setDescription(bundle.getString("NewMemberWizard.Time.Instructions.txt"));
            ArrayList timePeriods = this.getTimePeriods();
            SpinnerNumberModel spinner = new SpinnerNumberModel(1, 1, 100, 1);
            spinner.setMaximum(null);
            try {
                OLAPList timeHierarchies = this.timeDimension.getHierarchies();
                this.formulaObjects.add(new Balances(measures, true));
                this.formulaObjects.add(new Balances(measures, false));
                this.formulaObjects.add(new PeriodToDate(measures, timePeriods, spinner, true));
                this.formulaObjects.add(new PeriodToDate(measures, timePeriods, spinner, false));
                this.formulaObjects.add(new ComparePeriods(measures, this.timeDimension, (List)timeHierarchies, true));
                this.formulaObjects.add(new ComparePeriods(measures, this.timeDimension, (List)timeHierarchies, false));
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
        } else {
            this.setHelpTopic("calculate_member_simp_calc");
            this.setDescription(bundle.getString("NewMemberWizard.Simple.Instructions.txt"));
            this.formulaObjects = new ArrayList();
            this.formulaObjects.add(new Sum(measures));
            this.formulaObjects.add(new Difference(measures));
            this.formulaObjects.add(new Ratio(measures));
            this.formulaObjects.add(new PercentChange(measures, false));
            this.formulaObjects.add(new PercentChange(measures, true));
            this.formulaObjects.add(new DistinctCount(this.cube));
        }
        this.layoutWidgets();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JRadioButton button = (JRadioButton)e.getSource();
        int index = Integer.parseInt(button.getActionCommand());
        this.currentFormula = (FormulaInterface)this.formulaObjects.get(index);
        this.currentFormula.refreshDisplay();
        this.cards.show(this.formulaPanel, button.getText());
    }

    public String createFinishString() {
        String formulaText = this.currentFormula.getFormulaText();
        String finishString1 = bundle.formatString("NewMemberWizard.Formulas.FinishInfo.Formula.fmt.txt", (Object)formulaText);
        String lineSeparator = System.getProperty("line.separator");
        int bufferLength = finishString1.length() + lineSeparator.length() * 2;
        StringBuffer buffer = new StringBuffer(bufferLength);
        buffer.append(finishString1).append(lineSeparator).append(lineSeparator);
        return buffer.toString();
    }

    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        if (saveToModel) {
            String formulaText = this.currentFormula.getFormulaText();
            this.calculation.setFormula(formulaText);
        } else {
            try {
                this.calculation.setDimension(null);
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            ButtonModel button = this.formulas.getSelection();
            int index = Integer.parseInt(button.getActionCommand());
            this.currentFormula = (FormulaInterface)this.formulaObjects.get(index);
            this.currentFormula.refreshDisplay();
        }
        return true;
    }

    private void findTimeDimension() {
        try {
            List dimensions = this.cube.getDimensionSet().getAllCubeDimensions();
            int i = 0;
            while (i < dimensions.size() & this.timeDimension == null) {
                OLAPDimension dimension = (OLAPDimension)dimensions.get(i);
                if (dimension.isTime()) {
                    this.timeDimension = dimension;
                }
                ++i;
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    private ArrayList getAllMeasures() {
        ArrayList<OLAPMeasure> measures = new ArrayList<OLAPMeasure>();
        try {
            OLAPList cubeMeasures = this.cube.getMeasureSet().getMeasures();
            measures.addAll((Collection<OLAPMeasure>)cubeMeasures);
            OLAPList definedMembers = this.cube.getDefinedMemberSet().getCalculatedMeasures();
            measures.addAll((Collection<OLAPMeasure>)definedMembers);
            Collections.sort(measures);
            OLAPMeasure defaultMeasure = this.cube.getMeasureSet().getDefaultMeasure();
            measures.remove(defaultMeasure);
            measures.add(0, defaultMeasure);
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        return measures;
    }

    private ArrayList getTimePeriods() {
        ArrayList<TimePeriodItem> periods = new ArrayList<TimePeriodItem>();
        try {
            if (this.timeDimension != null) {
                OLAPList levels = this.timeDimension.getLevels();
                block8: for (int i = 0; i < levels.size(); ++i) {
                    OLAPLevel level = (OLAPLevel)levels.get(i);
                    int levelType = level.getType();
                    switch (levelType) {
                        case 16: {
                            periods.add(new TimePeriodItem("YTD"));
                            continue block8;
                        }
                        case 64: {
                            periods.add(new TimePeriodItem("QTD"));
                            continue block8;
                        }
                        case 128: {
                            periods.add(new TimePeriodItem("MTD"));
                            continue block8;
                        }
                        case 256: {
                            periods.add(new TimePeriodItem("WTD"));
                        }
                    }
                }
                periods.add(new TimePeriodItem("LastPeriods"));
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        return periods;
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.formulas = new ButtonGroup();
        this.formulaPanel = new JPanel();
        this.cards = new CardLayout();
        this.formulaPanel.setLayout(this.cards);
        this.formulaPanel.setBorder(new TitledBorder(bundle.getString("NewMemberWizard.Formulas.FormulaArea.txt")));
        int numFormulas = this.formulaObjects.size();
        for (int i = 0; i < numFormulas; ++i) {
            FormulaInterface formula = (FormulaInterface)this.formulaObjects.get(i);
            String formulaName = formula.getLabel();
            this.formulaPanel.add((Component)formula.getFormulaPanel(), formulaName);
            JRadioButton radio = new JRadioButton(formulaName);
            radio.setActionCommand(Integer.toString(i));
            radio.setMnemonic(formula.getMnemonic());
            radio.setDisplayedMnemonicIndex(formula.getMnemonicIndex());
            this.formulas.add(radio);
            int topInset = 5;
            if (i == 0) {
                topInset = 0;
                radio.setSelected(true);
            }
            this.add(radio, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 18, 2, new Insets(topInset, 0, 0, 0), 0, 0));
            radio.addActionListener(this);
        }
        this.cards.first(this.formulaPanel);
        this.add(this.formulaPanel, new GridBagConstraints(1, 0, 1, numFormulas, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        return this.currentFormula.validateFormula();
    }
}

