/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.calcmembers;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDefinedMember;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OlapServer;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.MDXExpressionBuilder;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.studio.BrowseMemberTreeDialog;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.sasmdx.Metadata;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NewMemberCustomTab
extends WsDescriptionWizardTab
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(NewMemberCustomTab.class);
    private WATextArea formula;
    private JButton buildButton;
    private JButton verifyButton;
    private JButton clearButton;
    private OLAPDefinedMember calculation;
    private WAComboBox dimension;
    private WATextField parentMember;
    private JButton browseButton;
    private boolean initialized;
    private WATextField name;
    private OLAPDimension lastSelectedDimension;
    private boolean verifiedOK;
    private WAComboBox format;
    private JSpinner solveOrder;
    private OlapServer olapServer;
    private OLAPCube olapCube;
    private String measureDimensionName;
    private WAIntTextField mlsid;
    private boolean isMLS;

    public NewMemberCustomTab(OLAPDefinedMember calcObject, OlapServer server, boolean isMLS) {
        super(bundle.getString("NewMemberWizard.Custom.Instructions.txt"));
        this.calculation = calcObject;
        this.olapServer = server;
        this.olapCube = this.calculation.getOwningCube();
        this.isMLS = isMLS;
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("calculate_member_cust_calc");
        this.layoutWidgets();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.verifyButton)) {
            this.verify(false);
        } else if (e.getSource().equals(this.clearButton)) {
            this.formula.setText("");
        } else if (e.getSource().equals(this.dimension)) {
            this.setParentDefaults();
        } else if (e.getSource().equals(this.browseButton)) {
            this.browseForParentMember();
        } else if (e.getSource().equals(this.buildButton)) {
            this.displayExpressionBuilder();
        }
    }

    private void browseForParentMember() {
        try {
            if (this.calculation.getOwningCube().physicallyExists() && this.olapServer != null) {
                this.olapServer.connect();
            }
            WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
            parent.setCursor(Cursor.getPredefinedCursor(3));
            BrowseMemberTreeDialog dialog = new BrowseMemberTreeDialog((Dialog)parent, bundle.getString("BrowseMember.Title.txt"), this.calculation.getOwningCube(), this.olapServer, this.lastSelectedDimension, false);
            parent.setCursor(Cursor.getPredefinedCursor(0));
            dialog.setResizable(true);
            String currentMember = this.parentMember.getText();
            if (!ModelUtilities.isBlank((String)currentMember)) {
                dialog.setSelectedMember(currentMember);
            }
            dialog.show();
            if (dialog.getReturnValue() == 1) {
                this.verifiedOK = false;
                this.parentMember.setText(dialog.getSelectedMember());
            }
        }
        catch (com.sas.olapadmin.designer.model.OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    public String createFinishString() {
        String lineSeparator = System.getProperty("line.separator");
        String dimName = "";
        dimName = this.lastSelectedDimension != null ? this.lastSelectedDimension.getName() : this.measureDimensionName;
        String finishString0 = bundle.formatString("NewMemberWizard.General.FinishInfo.Dimension.fmt.txt", (Object)dimName);
        String finishString1 = bundle.formatString("NewMemberWizard.General.FinishInfo.ParentMember.fmt.txt", (Object)this.parentMember.getText());
        String finishString2 = bundle.formatString("NewMemberWizard.General.FinishInfo.Name.fmt.txt", (Object)this.name.getText());
        String finishString3 = bundle.formatString("NewMemberWizard.General.FinishInfo.Format.fmt.txt", this.format.getSelectedItem());
        String finishString4 = bundle.formatString("NewMemberWizard.General.FinishInfo.SolveOrder.fmt.txt", (Object)this.solveOrder.getValue().toString());
        String formulaText = this.formula.getText();
        String finishString5 = bundle.formatString("NewMemberWizard.Custom.FinishInfo.Formula.fmt.txt", (Object)formulaText);
        String finishString6 = null;
        if (this.isMLS && this.mlsid.getValue() > 0) {
            finishString6 = bundle.formatString("NewMemberWizard.General.FinishInfo.MLSID.fmt.txt", (Object)String.valueOf(this.mlsid.getValue()));
        }
        StringBuffer finishString = new StringBuffer();
        finishString.append(finishString0).append(lineSeparator).append(lineSeparator);
        finishString.append(finishString1).append(lineSeparator).append(lineSeparator);
        finishString.append(finishString2).append(lineSeparator).append(lineSeparator);
        finishString.append(finishString3).append(lineSeparator).append(lineSeparator);
        finishString.append(finishString4).append(lineSeparator).append(lineSeparator);
        if (finishString6 != null) {
            finishString.append(finishString6).append(lineSeparator).append(lineSeparator);
        }
        finishString.append(finishString5);
        return finishString.toString();
    }

    private void displayExpressionBuilder() {
        if (this.lastSelectedDimension != null && ModelUtilities.isBlank((String)this.parentMember.getText()) || ModelUtilities.isBlank((String)this.name.getText())) {
            MessageUtil.displayMessage((String)bundle.getString("NewMemberWizard.Custom.NoBuild.Error.txt"), (int)0);
        } else {
            try {
                if (!this.olapServer.isConnected()) {
                    this.olapServer.connect();
                }
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                parent.setCursor(Cursor.getPredefinedCursor(3));
                this.calculation.setParentMember(this.parentMember.getText());
                this.calculation.setName(this.name.getText());
                this.calculation.setFormat(this.format.getText());
                Integer value = (int)((Integer)this.solveOrder.getValue());
                if (value != 0) {
                    this.calculation.setSolveOrder(value);
                } else {
                    this.calculation.setSolveOrder(null);
                }
                if (this.isMLS) {
                    if (this.mlsid.getValue() > 0) {
                        this.calculation.setMLSID(Integer.valueOf(this.mlsid.getValue()));
                    } else {
                        this.calculation.setMLSID(null);
                    }
                }
                MDXExpressionBuilder panel = new MDXExpressionBuilder(this.calculation.getOwningCube(), this.olapServer, null, this.calculation.generateCreateClause(), this.formula.getText(), this.calculation.generatePropertiesClause(), false);
                WAStandardDialog dialog = new WAStandardDialog((Dialog)parent, bundle.getString("NewMemberWizard.Custom.BuildFormula.Title.txt"), true, (WAPanel)panel);
                dialog.setResizable(true);
                parent.setCursor(Cursor.getPredefinedCursor(0));
                dialog.show();
                if (dialog.getReturnValue() == 1) {
                    this.formula.setText(panel.getExpressionText());
                }
            }
            catch (com.sas.olapadmin.designer.model.OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        if (!saveToModel) {
            try {
                if (!this.olapCube.physicallyExists()) {
                    this.verifyButton.setEnabled(false);
                    this.buildButton.setEnabled(false);
                    this.verifiedOK = true;
                }
                if (this.initialized) return true;
                this.initialized = true;
                List dimensions = this.olapCube.getDimensionSet().getAllCubeDimensions();
                this.measureDimensionName = this.olapCube.getMeasureSet().getMeasuresDimensionName();
                this.dimension.addItem((Object)this.measureDimensionName);
                this.dimension.setSelectedIndex(0);
                for (int i = 0; i < dimensions.size(); ++i) {
                    OLAPDimension dim = (OLAPDimension)dimensions.get(i);
                    this.dimension.addItem((Object)dim);
                }
                return true;
            }
            catch (com.sas.olapadmin.designer.model.OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
                return true;
            }
        }
        try {
            String parent = this.parentMember.getText();
            this.calculation.setParentMemberInfo(this.getParentMemberInfo(parent));
            this.calculation.setParentMember(parent);
            this.calculation.setFormula(this.formula.getText());
            this.calculation.setName(this.name.getText());
            this.calculation.setFormat(this.format.getSelectedItem().toString());
            Integer value = (Integer)this.solveOrder.getValue();
            if (value != 0) {
                this.calculation.setSolveOrder(value);
            } else {
                this.calculation.setSolveOrder(null);
            }
            if (this.isMLS) {
                int mlsidvalue = this.mlsid.getValue();
                if (mlsidvalue > 0) {
                    this.calculation.setMLSID(Integer.valueOf(mlsidvalue));
                } else {
                    this.calculation.setMLSID(null);
                }
            }
            this.calculation.setExpression(this.calculation.buildExpression());
            return true;
        }
        catch (com.sas.olapadmin.designer.model.OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        return true;
    }

    private Map getParentMemberInfo(String parent) {
        HashMap<String, String> parentMemberInfo = new HashMap<String, String>();
        try {
            if (this.olapCube.physicallyExists() && !Utilities.isBlank((String)parent)) {
                if (!this.olapServer.isConnected()) {
                    this.olapServer.connect();
                }
                Metadata cubeMetadata = this.olapServer.getCubeMetadataSet();
                Filter filter = new Filter();
                filter.setCubeName(this.olapCube.getName());
                OLAPSchema schema = this.olapCube.getAssociatedOLAPSchema();
                if (schema != null) {
                    filter.setSchemaName(schema.getName());
                }
                filter.setUniqueMemberName(parent);
                MemberInterface[] members = cubeMetadata.getMembers(filter, 0, 1);
                MemberInterface mbr = members[0];
                LevelInterface level = mbr.getLevel();
                HierarchyInterface hier = level.getHierarchy();
                String levelname = level.getName();
                String hiername = hier.getName();
                parentMemberInfo.put("levelName", levelname);
                parentMemberInfo.put("hierarchyName", hiername);
            }
        }
        catch (com.sas.olapadmin.designer.model.OLAPException oLAPException) {
        }
        catch (RemoteException remoteException) {
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return parentMemberInfo;
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.dimension = new WAComboBox(true, true);
        this.dimension.addActionListener((ActionListener)this);
        this.dimension.setToolTipText(bundle.getString("NewMemberWizard.Custom.Dimension.Tooltip.txt"));
        this.dimension.setName("NewMemberCustomDimensionComboBox");
        JLabel dimensionLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(dimensionLabel, bundle.getString("NewMemberWizard.Custom.Dimension.txt"));
        dimensionLabel.setLabelFor((Component)this.dimension);
        dimensionLabel.setName("NewMemberCustomDimensionComboBoxLabel");
        this.add(dimensionLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.dimension, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.parentMember = new WATextField();
        this.parentMember.setToolTipText(bundle.getString("NewMemberWizard.Custom.ParentMember.Tooltip.txt"));
        this.parentMember.setName("NewMemberCustomParentMemberField");
        JLabel parentMemberLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(parentMemberLabel, bundle.getString("NewMemberWizard.Custom.ParentMember.txt"));
        parentMemberLabel.setLabelFor((Component)this.parentMember);
        parentMemberLabel.setName("NewMemberCustomParentMemberLabel");
        this.browseButton = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.browseButton, bundle.getString("NewMemberWizard.Custom.BrowseButton.txt"));
        this.browseButton.addActionListener(this);
        this.browseButton.setToolTipText(bundle.getString("NewMemberWizard.Custom.BrowseButton.Tooltip.txt"));
        this.add(parentMemberLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.parentMember, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.browseButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.name = new WATextField();
        this.name.setMaxCharacters(256);
        this.name.setToolTipText(bundle.getString("NewMemberWizard.Custom.Name.Tooltip.txt"));
        this.name.setName("NewMemberNameField");
        this.name.getDocument().addDocumentListener(this);
        JLabel nameLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(nameLabel, bundle.getString("NewMemberWizard.Custom.Name.txt"));
        nameLabel.setLabelFor((Component)this.name);
        nameLabel.setName("NewMemberNameLabelField");
        this.add(nameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.name, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.format = new WAComboBox();
        this.format.setEditable(true);
        this.format.addItems((Object[])ModelUtilities.formats);
        this.format.setSelectedIndex(1);
        this.format.setToolTipText(bundle.getString("NewMemberWizard.General.Format.Tooltip.txt"));
        this.format.setName("NewMemberFormatField");
        JLabel formatLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(formatLabel, bundle.getString("NewMemberWizard.General.Format.txt"));
        formatLabel.setLabelFor((Component)this.format);
        formatLabel.setName("NewMemberFormatLabelField");
        this.add(formatLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.format, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.solveOrder = new JSpinner(new SpinnerNumberModel(0, -8191, 65535, 1));
        this.solveOrder.setToolTipText(bundle.getString("NewMemberWizard.General.SolveOrder.Tooltip.txt"));
        this.solveOrder.setName("NewMemberSolveOrderField");
        JLabel solveOrderLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(solveOrderLabel, bundle.getString("NewMemberWizard.General.SolveOrder.txt"));
        solveOrderLabel.setLabelFor(this.solveOrder);
        solveOrderLabel.setName("NewMemberSolveOrderLabel");
        this.add(solveOrderLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.solveOrder, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        if (this.isMLS) {
            this.mlsid = new WAIntTextField(false);
            this.mlsid.setColumns(6);
            this.mlsid.setMaxCharacters(10);
            this.mlsid.setToolTipText(bundle.getString("NewMemberWizard.General.MLSID.Tooltip.txt"));
            JLabel mlsidLabel = new JLabel();
            VisualUtilities.setLabelTextAndMnemonic(mlsidLabel, bundle.getString("NewMemberWizard.General.MLSID.txt"));
            mlsidLabel.setLabelFor((Component)this.mlsid);
            this.add(mlsidLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.mlsid, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        }
        JLabel editBoxLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(editBoxLabel, bundle.getString("NewMemberWizard.Custom.EditBoxLabel.txt"));
        this.add(editBoxLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.formula = new WATextArea();
        editBoxLabel.setLabelFor((Component)this.formula);
        this.formula.setWrapStyleWord(true);
        this.formula.setLineWrap(true);
        this.formula.setToolTipText(bundle.getString("NewMemberWizard.Custom.EditBox.Tooltip.txt"));
        this.formula.setName("NewMemberWizardCustomFormula");
        this.formula.getDocument().addDocumentListener(this);
        JScrollPane scrollPane = new JScrollPane((Component)this.formula);
        scrollPane.setPreferredSize(new Dimension(350, 75));
        this.add(scrollPane, new GridBagConstraints(0, 7, 3, 1, 1.0, 0.75, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        this.buildButton = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.buildButton, bundle.getString("NewMemberWizard.Custom.BuildButton.txt"));
        this.buildButton.setToolTipText(bundle.getString("NewMemberWizard.Custom.BuildButton.Tooltip.txt"));
        this.buildButton.addActionListener(this);
        buttonPanel.add((Component)this.buildButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.verifyButton = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.verifyButton, bundle.getString("NewMemberWizard.Custom.VerifyButton.txt"));
        this.verifyButton.setToolTipText(bundle.getString("NewMemberWizard.Custom.VerifyButton.Tooltip.txt"));
        this.verifyButton.addActionListener(this);
        buttonPanel.add((Component)this.verifyButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.clearButton = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.clearButton, bundle.getString("NewMemberWizard.Custom.ClearButton.txt"));
        this.clearButton.setToolTipText(bundle.getString("NewMemberWizard.Custom.ClearButton.Tooltip.txt"));
        this.clearButton.addActionListener(this);
        buttonPanel.add((Component)this.clearButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 13, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(buttonPanel, new GridBagConstraints(1, 8, 2, 1, 0.0, 0.0, 12, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    private void setParentDefaults() {
        Object obj = this.dimension.getSelectedItem();
        if (obj instanceof OLAPDimension && !((OLAPDimension)obj).equals(this.lastSelectedDimension)) {
            this.verifiedOK = false;
            this.lastSelectedDimension = (OLAPDimension)obj;
            try {
                this.calculation.setDimension(this.lastSelectedDimension);
                this.calculation.setType("Calculated Member");
            }
            catch (com.sas.olapadmin.designer.model.OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            this.parentMember.setEnabled(true);
            this.parentMember.setEditable(true);
            this.browseButton.setEnabled(true);
            this.parentMember.setText(this.calculation.getParentMember());
        } else if (obj instanceof String) {
            this.verifiedOK = false;
            this.lastSelectedDimension = null;
            try {
                this.calculation.setDimension(null);
                this.calculation.setType("Calculated Measure");
            }
            catch (com.sas.olapadmin.designer.model.OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            this.parentMember.setEnabled(false);
            this.parentMember.setEditable(false);
            this.browseButton.setEnabled(false);
            this.parentMember.setText(this.calculation.getParentMember());
        }
    }

    public boolean validateData() {
        boolean dataOK = true;
        if (!this.verifiedOK) {
            dataOK = this.verify(true);
            if (dataOK && !this.olapCube.physicallyExists()) {
                int choice = MessageUtil.displayMessage((String)bundle.getString("NewMemberWizard.Custom.NoVerification.txt"), (int)2, (int)0);
                dataOK = choice == 0;
            }
            this.verifiedOK = dataOK;
        }
        return dataOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verify(boolean askToSave) {
        this.verifiedOK = false;
        String oldName = this.calculation.getName();
        String oldParent = this.calculation.getParentMember();
        String oldValue = this.calculation.getFormula();
        String oldFmt = this.calculation.getFormat();
        String oldExpression = this.calculation.getExpression();
        int oldOrder = 0;
        Integer oldmlsid = null;
        boolean dataok = false;
        try {
            oldOrder = this.calculation.getSolveOrder();
            if (this.isMLS) {
                oldmlsid = this.calculation.getMLSID();
            }
            this.calculation.setName(this.name.getText());
            this.calculation.setParentMember(this.parentMember.getText());
            this.calculation.verifyName();
            if (ModelUtilities.isBlank((String)this.formula.getText())) {
                MessageUtil.displayMessage((String)bundle.getString("CalculatedMember.NoFormula.txt"), (int)0);
                this.calculation.setName(oldName);
            } else {
                int mlsidvalue;
                if (this.isMLS && (mlsidvalue = this.mlsid.getValue()) > 0) {
                    Integer newmlsid = mlsidvalue;
                    this.calculation.verifyMLSId(newmlsid);
                }
                dataok = true;
            }
        }
        catch (com.sas.olapadmin.designer.model.OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
            this.calculation.setName(oldName);
            this.calculation.setParentMember(oldParent);
        }
        if (dataok) {
            try {
                if (this.olapCube.physicallyExists()) {
                    this.calculation.setFormula(this.formula.getText());
                    this.calculation.setFormat(this.format.getText());
                    Integer value = (int)((Integer)this.solveOrder.getValue());
                    if (value != 0) {
                        this.calculation.setSolveOrder(value);
                    } else {
                        this.calculation.setSolveOrder(null);
                    }
                    if (this.isMLS) {
                        int mlsidvalue = this.mlsid.getValue();
                        if (mlsidvalue > 0) {
                            this.calculation.setMLSID(Integer.valueOf(mlsidvalue));
                        } else {
                            this.calculation.setMLSID(null);
                        }
                    }
                    this.calculation.setExpression(this.calculation.buildExpression());
                    WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                    parent.setCursor(Cursor.getPredefinedCursor(3));
                    if (!this.olapServer.isConnected()) {
                        this.olapServer.connect();
                    }
                    this.calculation.verifySyntax(this.olapServer);
                    String mdxString = this.calculation.generateCreateStatement();
                    MessageUtil.displayDetailsMessage((String)bundle.getString("CalculatedMember.FormulaVerified.txt"), (int)1, (String)mdxString);
                    this.verifiedOK = true;
                } else {
                    this.verifiedOK = true;
                }
            }
            catch (com.sas.olapadmin.designer.model.OLAPException e) {
                int response;
                ExceptionHandler.handleException((Exception)((Object)e));
                if (!this.olapServer.isConnected() && askToSave && (response = MessageUtil.displayMessage((String)bundle.getString("Verification.SaveAnyway.txt"), (int)2, (int)0)) == 0) {
                    this.verifiedOK = true;
                }
                if (!this.verifiedOK) {
                    try {
                        this.calculation.setName(oldName);
                        this.calculation.setParentMember(oldParent);
                        this.calculation.setFormat(oldFmt);
                        this.calculation.setFormula(oldValue);
                        if (oldOrder != 0) {
                            this.calculation.setSolveOrder(Integer.valueOf(oldOrder));
                        } else {
                            this.calculation.setSolveOrder(null);
                        }
                        this.calculation.setMLSID(oldmlsid);
                        this.calculation.setExpression(oldExpression);
                    }
                    catch (com.sas.olapadmin.designer.model.OLAPException e1) {
                        ExceptionHandler.handleException((Exception)((Object)e1));
                    }
                }
            }
            finally {
                WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                parent.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return this.verifiedOK;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.verifiedOK = false;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.verifiedOK = false;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.verifiedOK = false;
    }
}

