/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.calcmembers;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPDefinedMember;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OlapServer;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.MDXExpressionBuilder;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class EditPanel
extends WAPanel
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(EditPanel.class);
    private OLAPDefinedMember calculation;
    private WATextField dimension;
    private WATextField name;
    private WATextField parentMember;
    private WATextArea formula;
    private JButton verify;
    private boolean verifiedOK;
    private JButton build;
    private OlapServer olapServer;

    public EditPanel(OLAPDefinedMember selectedItem, OlapServer server) {
        this.calculation = selectedItem;
        this.olapServer = server;
        this.layoutWidgets();
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridBagLayout());
        JLabel dimensionLabel = new JLabel(bundle.getString("EditPanel.Dimension.txt"));
        dimensionLabel.setName("EditPanelDimensionLabel");
        topPanel.add((Component)dimensionLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.dimension = new WATextField();
        this.dimension.setBehavior(1);
        dimensionLabel.setLabelFor((Component)this.dimension);
        topPanel.add((Component)this.dimension, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        JLabel parentMemberLabel = new JLabel(bundle.getString("EditPanel.ParentMember.txt"));
        parentMemberLabel.setName("EditPanelParentMemberLabel");
        topPanel.add((Component)parentMemberLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.parentMember = new WATextField();
        this.parentMember.setBehavior(1);
        parentMemberLabel.setLabelFor((Component)this.parentMember);
        topPanel.add((Component)this.parentMember, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        JLabel nameLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(nameLabel, bundle.getString("EditPanel.Name.txt"));
        nameLabel.setName("editPanelNameLabel");
        topPanel.add((Component)nameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.name = new WATextField();
        this.name.setMaxCharacters(256);
        this.name.setToolTipText(bundle.getString("EditPanel.Name.Tooltip.txt"));
        this.name.setName("EditPanelNameField");
        nameLabel.setLabelFor((Component)this.name);
        topPanel.add((Component)this.name, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 5, 0), 0, 0));
        JLabel editBoxLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(editBoxLabel, bundle.getString("EditPanel.EditBoxLabel.txt"));
        this.add(editBoxLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.formula = new WATextArea();
        editBoxLabel.setLabelFor((Component)this.formula);
        this.formula.setWrapStyleWord(true);
        this.formula.setLineWrap(true);
        this.formula.setToolTipText(bundle.getString("EditPanel.EditBox.Tooltip.txt"));
        this.formula.setName("EditPanelFormula");
        JScrollPane scrollPane = new JScrollPane((Component)this.formula);
        scrollPane.setPreferredSize(new Dimension(350, 200));
        this.add(scrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 5, 0), 0, 0));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        this.build = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.build, bundle.getString("EditPanel.BuildButton.txt"));
        this.build.setToolTipText(bundle.getString("EditPanel.BuildButton.Tooltip.txt"));
        this.build.setName("EditPanelBuildButton");
        buttonPanel.add((Component)this.build, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.build.addActionListener(this);
        this.verify = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.verify, bundle.getString("EditPanel.VerifyButton.txt"));
        this.verify.setToolTipText(bundle.getString("EditPanel.VerifyButton.Tooltip.txt"));
        this.verify.setName("EditPanelVerifyButton");
        buttonPanel.add((Component)this.verify, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.5, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.verify.addActionListener(this);
        this.add(buttonPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void moveDataToStore() throws MdException, RemoteException {
        try {
            this.calculation.setExpression(this.formula.getText());
            this.calculation.setName(this.name.getText());
            int solveOrder = this.calculation.getSolveOrderFromExpression();
            if (solveOrder != 0) {
                this.calculation.setSolveOrder(Integer.valueOf(solveOrder));
            } else {
                this.calculation.setSolveOrder(null);
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.name.setText(this.calculation.getName());
        this.formula.setText(this.calculation.getExpression());
        this.dimension.setText(this.calculation.getDimensionName());
        this.parentMember.setText(this.calculation.getParentMember());
        this.listenForDataChangesTo((JTextComponent)this.formula);
        this.formula.getDocument().addDocumentListener(this);
        this.listenForDataChangesTo((JTextComponent)this.name);
        this.name.getDocument().addDocumentListener(this);
        if (!this.calculation.getOwningCube().physicallyExists()) {
            this.verify.setEnabled(false);
            this.build.setEnabled(false);
        }
    }

    public void populateStore() throws MdException, RemoteException {
        this.setStorePopulated(true);
    }

    public boolean validateData() {
        boolean dataOK;
        String oldExpression;
        String oldName;
        block9: {
            oldName = this.calculation.getName();
            oldExpression = this.calculation.getExpression();
            dataOK = true;
            boolean cubeExists = this.calculation.getOwningCube().physicallyExists();
            try {
                if (this.hasDataChanged() && (dataOK = this.verifyName())) {
                    int choice;
                    if (ModelUtilities.isBlank((String)this.formula.getText())) {
                        MessageUtil.displayMessage((String)bundle.getString("CalculatedMember.NoFormula.txt"), (int)0);
                        dataOK = false;
                    } else if (cubeExists && !this.verifiedOK) {
                        if (this.olapServer != null && !this.olapServer.isConnected()) {
                            this.olapServer.connect();
                        }
                        this.calculation.setExpression(this.formula.getText());
                        this.calculation.verifySyntax(this.olapServer);
                        MessageUtil.displayMessage((String)bundle.getString("CalculatedMember.FormulaVerified.txt"), (int)1);
                        dataOK = true;
                        this.verifiedOK = true;
                    } else if (!cubeExists && (choice = MessageUtil.displayMessage((String)bundle.getString("EditPanel.NoVerification.txt"), (int)2, (int)0)) == 0) {
                        dataOK = true;
                    }
                }
            }
            catch (OLAPException e) {
                int response;
                ExceptionHandler.handleException((Exception)((Object)e));
                dataOK = false;
                if (this.olapServer == null || this.olapServer.isConnected() || (response = MessageUtil.displayMessage((String)bundle.getString("Verification.SaveAnyway.txt"), (int)2, (int)0)) != 0) break block9;
                dataOK = true;
            }
        }
        this.calculation.setName(oldName);
        this.calculation.setExpression(oldExpression);
        return dataOK;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.verify) {
            String oldName = this.calculation.getName();
            String oldExpression = this.calculation.getExpression();
            this.verifiedOK = this.verifyName();
            if (this.verifiedOK) {
                if (ModelUtilities.isBlank((String)this.formula.getText())) {
                    MessageUtil.displayMessage((String)bundle.getString("CalculatedMember.NoFormula.txt"), (int)0);
                    this.verifiedOK = false;
                } else {
                    try {
                        this.calculation.setExpression(this.formula.getText());
                        if (this.olapServer != null && !this.olapServer.isConnected()) {
                            this.olapServer.connect();
                        }
                        this.calculation.verifySyntax(this.olapServer);
                        MessageUtil.displayMessage((String)bundle.getString("CalculatedMember.FormulaVerified.txt"), (int)1);
                        this.verifiedOK = true;
                    }
                    catch (OLAPException e1) {
                        ExceptionHandler.handleException((Exception)((Object)e1));
                        this.verifiedOK = false;
                    }
                }
            }
            this.calculation.setName(oldName);
            this.calculation.setExpression(oldExpression);
        } else if (e.getSource() == this.build) {
            this.displayExpressionBuilder();
        }
    }

    private void displayExpressionBuilder() {
        if (ModelUtilities.isBlank((String)this.name.getText())) {
            MessageUtil.displayMessage((String)bundle.getString("NewMemberWizard.Custom.NoBuild.Error.txt"), (int)0);
        } else {
            try {
                if (this.olapServer != null && !this.olapServer.isConnected()) {
                    this.olapServer.connect();
                }
                WAStandardDialog parent = (WAStandardDialog)this.getTopLevelAncestor();
                parent.setCursor(Cursor.getPredefinedCursor(3));
                String beginning = this.calculation.generateCreateClause();
                MDXExpressionBuilder panel = new MDXExpressionBuilder(this.calculation.getOwningCube(), this.olapServer, null, beginning, this.formula.getText(), "", false);
                WAStandardDialog dialog = new WAStandardDialog((Dialog)parent, bundle.getString("NewMemberWizard.Custom.BuildFormula.Title.txt"), true, (WAPanel)panel);
                parent.setCursor(Cursor.getPredefinedCursor(0));
                dialog.setResizable(true);
                dialog.show();
                if (dialog.getReturnValue() == 1) {
                    this.formula.setText(panel.getExpressionText());
                }
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
        }
    }

    private boolean verifyName() {
        boolean nameOK = true;
        try {
            this.calculation.setName(this.name.getText());
            this.calculation.verifyName();
        }
        catch (OLAPException e1) {
            ExceptionHandler.handleException((Exception)((Object)e1));
            nameOK = false;
        }
        return nameOK;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.verifiedOK = false;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.verifiedOK = false;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.verifiedOK = false;
    }
}

