/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.calcmembers;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.calcmembers.EditPanel;
import com.sas.olapadmin.calcmembers.NewMemberWizard;
import com.sas.olapadmin.designer.model.DefinedMemberSet;
import com.sas.olapadmin.designer.model.MLSCaptionTable;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDefinedMember;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OlapServer;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CalculatedMembersPanel
extends WAPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(CalculatedMembersPanel.class);
    private OLAPCube cube;
    private JButton addButton;
    private JButton editButton;
    private JButton deleteButton;
    private JList currentCalculations;
    private DefaultListModel model;
    private OlapServer olapServer;
    private DefinedMemberSet memberSet;
    private OLAPList membersList;
    private boolean updateMetadata;
    private List deletedMembers;
    private List editedMembers;
    private List oldNames;
    private boolean isMLS;

    public CalculatedMembersPanel(OLAPCube olapCube, OlapServer server) {
        this(olapCube, server, true);
    }

    public CalculatedMembersPanel(OLAPCube olapCube, OlapServer server, boolean update) {
        this.updateMetadata = update;
        this.deletedMembers = new ArrayList();
        this.editedMembers = new ArrayList();
        this.oldNames = new ArrayList();
        this.cube = olapCube;
        this.olapServer = server;
        this.layoutWidgets();
    }

    private void displayEditWindow() {
        Object[] selected = this.currentCalculations.getSelectedValues();
        if (selected.length == 1) {
            OLAPDefinedMember selectedItem = (OLAPDefinedMember)selected[0];
            String originalName = selectedItem.getFullName();
            EditPanel mainPanel = new EditPanel(selectedItem, this.olapServer);
            WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("EditDialog.Title.txt"), true);
            dialog.setHelpProduct("olapadmin");
            dialog.setHelpTopic("calculate_member_edit");
            dialog.setMainPanel((WAPanel)mainPanel);
            dialog.show();
            if (dialog.getReturnValue() == 1 && dialog.hasDataChanged()) {
                this.setDataChanged(true);
                if (!this.editedMembers.contains(selectedItem)) {
                    this.editedMembers.add(selectedItem);
                    this.oldNames.add(originalName);
                }
            }
        }
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        WATextArea m_instructions = new WATextArea();
        m_instructions.setColumns(30);
        m_instructions.setText(bundle.getString("CalculatedMembersPanel.Instructions.txt"));
        m_instructions.setBehavior(1);
        m_instructions.setBackground((Color)SystemColor.control);
        m_instructions.setAutosize(true);
        this.add((Component)m_instructions, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        JSeparator sep = new JSeparator(0);
        this.add(sep, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        JLabel listboxLabel = new JLabel();
        m_instructions.setFont(listboxLabel.getFont());
        VisualUtilities.setLabelTextAndMnemonic(listboxLabel, bundle.getString("CurrentCalculationsList.Label.txt"));
        this.add(listboxLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.model = new DefaultListModel();
        this.currentCalculations = new JList(this.model);
        listboxLabel.setLabelFor(this.currentCalculations);
        this.currentCalculations.setToolTipText(bundle.getString("CurrentCalculationsList.Tooltip.txt"));
        this.currentCalculations.addFocusListener(new MemberListFocusAdapter());
        JScrollPane scrollPane = new JScrollPane(this.currentCalculations);
        scrollPane.setPreferredSize(new Dimension(300, 300));
        this.add(scrollPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        this.addButton = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.addButton, bundle.getString("AddButton.Label.txt"));
        this.addButton.setToolTipText(bundle.getString("AddButton.Tooltip.txt"));
        buttonPanel.add((Component)this.addButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.editButton = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.editButton, bundle.getString("EditButton.Label.txt"));
        this.editButton.setToolTipText(bundle.getString("EditButton.Tooltip.txt"));
        buttonPanel.add((Component)this.editButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.deleteButton = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.deleteButton, bundle.getString("DeleteButton.Label.txt"));
        this.deleteButton.setToolTipText(bundle.getString("DeleteButton.Tooltip.txt"));
        buttonPanel.add((Component)this.deleteButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(buttonPanel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void moveDataToStore() throws MdException, RemoteException {
        block8: {
            boolean doRefresh = false;
            if (this.updateMetadata) {
                try {
                    this.cube.updateMetadataDefinedMembersOnly();
                    if (this.hasDataChanged()) {
                        if (this.cube.physicallyExists() && this.olapServer != null) {
                            doRefresh = true;
                            AssociationList servers = this.olapServer.getServerContexts();
                            if (servers != null && servers.size() > 0) {
                                this.olapServer.refreshCube(this.cube.getName());
                            } else {
                                MessageUtil.displayMessage((String)bundle.getString("CalculatedMembersPanel.NoRefresh.txt"));
                            }
                        } else {
                            MessageUtil.displayMessage((String)bundle.getString("CalculatedMembersPanel.Saved.txt"));
                        }
                    }
                }
                catch (OLAPException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                    if (!doRefresh) break block8;
                    MessageUtil.displayMessage((String)bundle.getString("CalculatedMembersPanel.RefreshError.txt"));
                }
            }
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        int size = this.membersList.size();
        for (int i = 0; i < size; ++i) {
            this.model.addElement(this.membersList.get(i));
        }
        this.currentCalculations.setCellRenderer(new MemberCellRenderer());
        this.currentCalculations.addListSelectionListener(this);
        this.currentCalculations.setSelectionMode(2);
        this.editButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(new DeleteButtonListener());
        this.addButton.addActionListener(new AddButtonListener());
        this.editButton.addActionListener(new EditButtonListener());
        MemberListMouseAdapter mouseListener = new MemberListMouseAdapter();
        this.currentCalculations.addMouseListener(mouseListener);
    }

    public void populateStore() throws MdException, RemoteException {
        if (!this.isStorePopulated()) {
            try {
                this.memberSet = this.cube.getDefinedMemberSet();
                this.membersList = this.memberSet.getCalculatedMembers();
                this.membersList.sort();
                MLSCaptionTable mlsTable = this.cube.getMLSCaptionTable();
                this.isMLS = mlsTable != null;
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
        }
        this.setStorePopulated(true);
    }

    public boolean validateData() {
        return Utilities.isConnectedToMetadataServer((boolean)true);
    }

    public void saveSettingsAndCleanUp() {
        if (this.olapServer != null) {
            try {
                this.olapServer.disconnect();
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            finally {
                this.olapServer = null;
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (this.currentCalculations.isSelectionEmpty()) {
                this.editButton.setEnabled(false);
                this.deleteButton.setEnabled(false);
            } else {
                Object[] selected = this.currentCalculations.getSelectedValues();
                if (selected.length == 1) {
                    OLAPDefinedMember selectedMember = (OLAPDefinedMember)selected[0];
                    try {
                        this.editButton.setEnabled(selectedMember.isWriteAllowed());
                        this.deleteButton.setEnabled(selectedMember.isWriteAllowed());
                    }
                    catch (OLAPException e1) {
                        ExceptionHandler.handleException((Exception)((Object)e1));
                        this.editButton.setEnabled(false);
                        this.deleteButton.setEnabled(false);
                    }
                } else {
                    this.editButton.setEnabled(false);
                    this.deleteButton.setEnabled(true);
                }
            }
        }
    }

    public class MemberListFocusAdapter
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
            if (CalculatedMembersPanel.this.model.getSize() > 0 && CalculatedMembersPanel.this.currentCalculations.getMaxSelectionIndex() < 0) {
                CalculatedMembersPanel.this.currentCalculations.setSelectedIndex(0);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    public class MemberCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            OLAPDefinedMember item = (OLAPDefinedMember)value;
            String toolTip = item.getExpression();
            if (ModelUtilities.isBlank((String)toolTip)) {
                toolTip = item.getName();
            }
            this.setToolTipText(toolTip);
            return this;
        }
    }

    public class DeleteButtonListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selected = CalculatedMembersPanel.this.currentCalculations.getSelectedValues();
            int numDelete = selected.length;
            if (numDelete > 0) {
                Object[] warningOptions = new Object[]{bundle.getString("Common.OK.txt"), bundle.getString("Common.Cancel.txt")};
                int warningChoice = JOptionPane.showOptionDialog((Component)Workspace.getWorkspace(), bundle.getString("DeleteConfirm.Message.txt"), bundle.getString("DeleteConfirm.Title.txt"), 2, 2, null, warningOptions, warningOptions[0]);
                if (warningChoice == 0) {
                    for (int i = 0; i < numDelete; ++i) {
                        OLAPDefinedMember selectedItem = (OLAPDefinedMember)selected[i];
                        try {
                            if (selectedItem.isWriteAllowed()) {
                                CalculatedMembersPanel.this.memberSet.delete(selectedItem);
                                CalculatedMembersPanel.this.model.removeElement(selectedItem);
                                if (CalculatedMembersPanel.this.deletedMembers.contains(selectedItem)) continue;
                                CalculatedMembersPanel.this.deletedMembers.add(selectedItem);
                                if (!CalculatedMembersPanel.this.editedMembers.contains(selectedItem)) continue;
                                int pos = CalculatedMembersPanel.this.editedMembers.indexOf(selectedItem);
                                CalculatedMembersPanel.this.editedMembers.remove(pos);
                                String fullName = (String)CalculatedMembersPanel.this.oldNames.get(pos);
                                CalculatedMembersPanel.this.oldNames.remove(pos);
                                int lastBracket = fullName.lastIndexOf("[");
                                String originalName = fullName.substring(lastBracket + 1, fullName.length() - 1);
                                selectedItem.setName(originalName);
                                continue;
                            }
                            MessageUtil.displayMessage((String)bundle.formatString("CalculatedMemberPanel.NoPermissions.fmt.txt", (Object)selectedItem.getName()), (int)0);
                            continue;
                        }
                        catch (OLAPException e1) {
                            ExceptionHandler.handleException((Exception)((Object)e1));
                        }
                    }
                    CalculatedMembersPanel.this.currentCalculations.clearSelection();
                    CalculatedMembersPanel.this.setDataChanged(true);
                }
            }
        }
    }

    public class AddButtonListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Workspace workspace = Workspace.getWorkspace();
                NewMemberWizard wizard = new NewMemberWizard(workspace, bundle.getString("NewMemberWizard.Title.txt"), CalculatedMembersPanel.this.cube, CalculatedMembersPanel.this.olapServer, CalculatedMembersPanel.this.isMLS);
                wizard.show();
                if (wizard.getReturnValue() == 1 | wizard.getReturnValue() == 3) {
                    CalculatedMembersPanel.this.membersList.sort();
                    CalculatedMembersPanel.this.model.clear();
                    int size = CalculatedMembersPanel.this.membersList.size();
                    for (int i = 0; i < size; ++i) {
                        CalculatedMembersPanel.this.model.addElement(CalculatedMembersPanel.this.membersList.get(i));
                    }
                    CalculatedMembersPanel.this.setDataChanged(true);
                }
            }
            catch (OLAPException e1) {
                ExceptionHandler.handleException((Exception)((Object)e1));
            }
        }
    }

    public class EditButtonListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            CalculatedMembersPanel.this.displayEditWindow();
            CalculatedMembersPanel.this.currentCalculations.repaint();
        }
    }

    private final class MemberListMouseAdapter
    extends MouseAdapter {
        private MemberListMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                CalculatedMembersPanel.this.displayEditWindow();
            }
        }
    }
}

