/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.aggregation;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.StructureTreeCellRenderer;
import com.sas.swing.visuals.dualselector.DualTreeSelector;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SelectHierarchiesPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(SelectHierarchiesPanel.class);
    private Vector hierarchies;
    private OLAPCube olapCube;
    private DualTreeSelector treeSelector;
    private DefaultTreeModel availableTreeModel;
    private DefaultTreeModel selectedTreeModel;
    private JTree availableTree;
    private int maxHier;

    public SelectHierarchiesPanel(OLAPCube cube) {
        this.olapCube = cube;
        this.hierarchies = new Vector();
        this.layoutWidgets();
    }

    public Vector getHierarchies() {
        return this.hierarchies;
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        WATextArea instructions = new WATextArea(bundle.getString("SelectHierarchies.instructions.txt"));
        JLabel l = new JLabel();
        instructions.setFont(l.getFont());
        instructions.setBehavior(1);
        instructions.setBackground((Color)SystemColor.control);
        instructions.setAutosize(true);
        this.add((Component)instructions, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.treeSelector = new LimitedDualTreeSelector();
        this.treeSelector.setSourceCellRenderer((TreeCellRenderer)new StructureTreeCellRenderer());
        this.treeSelector.setTargetCellRenderer((TreeCellRenderer)new StructureTreeCellRenderer());
        this.treeSelector.setTargetControlsVisible(false);
        this.treeSelector.setPreferredSize(new Dimension(400, 250));
        this.treeSelector.setDragAndDropEnabled(false);
        this.treeSelector.setSourceRootVisible(false);
        this.treeSelector.setTargetRootVisible(false);
        this.treeSelector.setRemoveEmptyParentNodes(true);
        this.availableTree = (JTree)this.treeSelector.getSourceComponent();
        DefaultMutableTreeNode availableRootNode = new DefaultMutableTreeNode();
        DefaultMutableTreeNode selectedRootNode = new DefaultMutableTreeNode();
        this.availableTreeModel = new DefaultTreeModel(availableRootNode);
        this.treeSelector.setModel((TreeModel)this.availableTreeModel);
        this.selectedTreeModel = new DefaultTreeModel(selectedRootNode);
        this.treeSelector.setTargetModel((TreeModel)this.selectedTreeModel);
        this.add((Component)this.treeSelector, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.hierarchies.clear();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.selectedTreeModel.getRoot();
        for (DefaultMutableTreeNode leaf = root.getFirstLeaf(); leaf != null; leaf = leaf.getNextLeaf()) {
            Object userObject = leaf.getUserObject();
            if (!(userObject instanceof OLAPHierarchy)) continue;
            this.hierarchies.addElement(userObject);
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.availableTreeModel.getRoot();
        try {
            List cubeDimensions = this.olapCube.getDimensionSet().getAllCubeDimensions();
            for (int j = 0; j < cubeDimensions.size(); ++j) {
                OLAPDimension dimension = (OLAPDimension)cubeDimensions.get(j);
                if (dimension.isMeasure() || dimension.isTime()) continue;
                DefaultMutableTreeNode dimensionNode = new DefaultMutableTreeNode(dimension, true);
                this.availableTreeModel.insertNodeInto(dimensionNode, root, root.getChildCount());
                OLAPList dimensionHierarchies = dimension.getHierarchies();
                for (int hiernum = 0; hiernum < dimensionHierarchies.size(); ++hiernum) {
                    OLAPHierarchy hier = (OLAPHierarchy)dimensionHierarchies.get(hiernum);
                    DefaultMutableTreeNode levelNode = new DefaultMutableTreeNode(hier, true);
                    this.availableTreeModel.insertNodeInto(levelNode, dimensionNode, dimensionNode.getChildCount());
                }
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        this.availableTreeModel.reload();
        this.expandAll((JTree)this.treeSelector.getSourceComponent(), new TreePath(root));
    }

    public void populateStore() throws MdException, RemoteException {
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        this.maxHier = appDefaults.getPropertyInt("CubeStudio.Tuning.SelectHierarchies.Maximum", 8);
        super.populateStore();
    }

    public boolean validateData() {
        boolean dataOK = true;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.selectedTreeModel.getRoot();
        if (root.getChildCount() <= 0) {
            dataOK = false;
            MessageUtil.displayMessage((String)bundle.getString("SelectHierarchiesPanel.MustSelectHierarchies.txt"));
        }
        return dataOK;
    }

    private void expandAll(JTree tree, TreePath parent) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path);
            }
        }
        tree.expandPath(parent);
    }

    public class LimitedDualTreeSelector
    extends DualTreeSelector {
        private static final long serialVersionUID = 1L;

        private boolean checkTransferOfSelectedItems() {
            int targetCount;
            int sourceCount;
            boolean canTransfer = true;
            if (SelectHierarchiesPanel.this.availableTree != null && SelectHierarchiesPanel.this.selectedTreeModel != null && (sourceCount = SelectHierarchiesPanel.this.availableTree.getSelectionCount()) + (targetCount = this.getCurrentCount(SelectHierarchiesPanel.this.selectedTreeModel)) > SelectHierarchiesPanel.this.maxHier) {
                canTransfer = false;
            }
            return canTransfer;
        }

        private boolean checkTransferOfAllItems() {
            int targetCount;
            int sourceCount;
            boolean canTransfer = true;
            if (SelectHierarchiesPanel.this.availableTreeModel != null && SelectHierarchiesPanel.this.selectedTreeModel != null && (sourceCount = this.getCurrentCount(SelectHierarchiesPanel.this.availableTreeModel)) + (targetCount = this.getCurrentCount(SelectHierarchiesPanel.this.selectedTreeModel)) > SelectHierarchiesPanel.this.maxHier) {
                canTransfer = false;
            }
            return canTransfer;
        }

        private int getCurrentCount(DefaultTreeModel modelToCheck) {
            int count = 0;
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)modelToCheck.getRoot();
            int rootCount = root.getChildCount();
            for (int i = 0; i < rootCount; ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)root.getChildAt(i);
                if (child.getChildCount() <= 0) continue;
                count += child.getChildCount();
            }
            return count;
        }

        public synchronized void transferAllSourceItems() {
            if (!this.checkTransferOfAllItems()) {
                String maxStr = String.valueOf(SelectHierarchiesPanel.this.maxHier);
                MessageUtil.displayMessage((String)bundle.formatString("SelectHierarchiesPanel.GreaterThanMax.fmt.txt", (Object)maxStr));
            } else {
                super.transferAllSourceItems();
            }
        }

        public synchronized void transferSourceItems() {
            if (!this.checkTransferOfSelectedItems()) {
                String maxStr = String.valueOf(SelectHierarchiesPanel.this.maxHier);
                MessageUtil.displayMessage((String)bundle.formatString("SelectHierarchiesPanel.GreaterThanMax.fmt.txt", (Object)maxStr));
            } else {
                super.transferSourceItems();
            }
        }
    }
}

