/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.aggregation;

import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;

public class SaveProcOlapPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(SaveProcOlapPanel.class);
    private JLabel label_directions;
    private File storeFileTo;
    private FileWriter fileWriter;
    private BufferedWriter writer;
    private JButton browseButton;
    private StringBuffer tuningProcCode;
    Vector paths;
    JLabel label_path;
    WAComboBox inputPath;
    JFileChooser fileChooser;
    boolean isAppend;

    public SaveProcOlapPanel(StringBuffer procCode) {
        this.tuningProcCode = procCode;
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public boolean validateData() {
        String savePath = this.inputPath.getText();
        String absolutePath = null;
        if (savePath.length() > 0) {
            this.storeFileTo = new File(savePath);
            if (this.storeFileTo == null) {
                MessageUtil.displayMessage((String)bundle.getString("SaveProcCode.Error.filename.txt"));
                return false;
            }
            if (this.storeFileTo.exists()) {
                int option = Utilities.displayFileExistsMessage((String)savePath);
                if (option == 2) {
                    return false;
                }
                this.isAppend = option == 0;
            }
            try {
                this.fileWriter = null;
                this.fileWriter = new FileWriter(this.storeFileTo, this.isAppend);
            }
            catch (IOException oError) {
                MessageUtil.displayDetailsMessage((String)bundle.getString("SaveProcCode.Error.nowrite.txt"), (int)0, (int)0, (String)oError.getLocalizedMessage());
                return false;
            }
            if (!this.storeFileTo.canWrite()) {
                MessageUtil.displayMessage((String)bundle.getString("SaveProcCode.Error.nowrite.txt"));
                return false;
            }
        } else {
            MessageUtil.displayMessage((String)bundle.getString("SaveProcCode.Instruct.txt"));
            return false;
        }
        try {
            this.writer = new BufferedWriter(this.fileWriter);
            this.writer.write(this.tuningProcCode.toString());
            this.writer.close();
        }
        catch (IOException oError) {
            MessageUtil.displayDetailsMessage((String)bundle.getString("SaveProcCode.Error.nowrite.txt"), (int)0, (int)0, (String)oError.getLocalizedMessage());
        }
        File exportPath = new File(savePath);
        absolutePath = exportPath.getAbsolutePath();
        if (this.paths.indexOf(savePath) < 0) {
            this.paths.insertElementAt(savePath, 0);
        }
        VisualUtilities.setSaveProcCodePaths(this.paths);
        MessageUtil.displayMessage((String)bundle.formatString("Aggregations.ExportCode.confirmation.txt", (Object)absolutePath), (int)1);
        return true;
    }

    private void _layoutWidgets() {
        this.paths = VisualUtilities.getSaveProcCodePaths();
        this.label_directions = new JLabel(bundle.getString("SaveProcCode.TuneCube.txt"));
        this.label_path = new JLabel();
        this.inputPath = new WAComboBox(this.paths.toArray());
        this.inputPath.setEditable(true);
        if (!this.paths.isEmpty()) {
            this.inputPath.setSelectedIndex(0);
        }
        VisualUtilities.setLabelTextAndMnemonic(this.label_path, bundle.getString("SaveProcCode.TuneCube.Path.control.label"));
        this.label_path.setLabelFor((Component)this.inputPath);
        this.inputPath.setName("SaveProcPath");
        this.label_path.setName("SaveProcPathLabel");
        this.inputPath.setToolTipText(bundle.getString("SaveProcCode.TuneCube.tip"));
        this.browseButton = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.browseButton, bundle.getString("SaveProcCode.Browse.action.label"));
        this.add(this.label_directions, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 5, 10), 0, 0));
        this.add(this.label_path, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 10, 5, 10), 0, 0));
        this.add((Component)this.inputPath, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
        this.add(this.browseButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.fileChooser = new JFileChooser();
        BrowseListener browseListener2 = new BrowseListener();
        this.browseButton.addActionListener(browseListener2);
    }

    class BrowseListener
    implements ActionListener {
        BrowseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SaveProcOlapPanel.this.fileChooser.setDialogTitle(bundle.getString("SaveProcCode.FileChooser.window.title"));
            SaveProcOlapPanel.this.fileChooser.setApproveButtonText(bundle.getString("SaveProcCode.FileChooser.OK.action.label"));
            SaveProcOlapPanel.this.fileChooser.showDialog((Component)Workspace.getWorkspace(), null);
            File selectedFile = SaveProcOlapPanel.this.fileChooser.getSelectedFile();
            if (selectedFile != null) {
                String filename = selectedFile.toString();
                if (SaveProcOlapPanel.this.paths.indexOf(filename) < 0) {
                    SaveProcOlapPanel.this.inputPath.insertItemAt((Object)filename, 0);
                }
                SaveProcOlapPanel.this.inputPath.setSelectedIndex(0);
            }
        }
    }
}

