/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.aggregation;

import com.sas.olapadmin.aggregation.AggregationsTablePanel;
import com.sas.olapadmin.aggregation.SaveProcOlapDialog;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ExportAggregationCode
implements ActionListener {
    private static WAdminResource bundle = new WAdminResource(ExportAggregationCode.class);
    private OLAPCube olapCube;
    private StringBuffer tuningProcCode = null;
    private AggregationsTablePanel table;

    public ExportAggregationCode(OLAPCube cube, AggregationsTablePanel tablePanel) {
        this.olapCube = cube;
        this.table = tablePanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.table != null) {
            this.table.stopCellEditing();
            if (!this.table.validateNames()) {
                return;
            }
        }
        OLAPList aggregationsToAdd = this.olapCube.getAggregationSet().getAddedAggregations();
        OLAPList aggregationsToDrop = this.olapCube.getAggregationSet().getDroppedAggregations();
        if (aggregationsToAdd.isEmpty() && aggregationsToDrop.isEmpty()) {
            String msg = bundle.getString("NoAggrs.NoSaveProcCode.txt");
            String title = bundle.getString("NoSaveProcCode.window.title");
            MessageUtil.displayMessage((String)msg, (String)title);
        } else {
            try {
                this.tuningProcCode = this.olapCube.generateCodeManualTuning(true);
            }
            catch (OLAPException OLAPError) {
                ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
            SaveProcOlapDialog savedlg = new SaveProcOlapDialog(bundle.getString("SaveProcCode.window.title"), this.tuningProcCode);
            savedlg.show();
        }
    }
}

