/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.aggregation;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsBooleanTableColumn;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnalysisRecommendTableModel
extends WsAbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(AnalysisRecommendTableModel.class);
    protected static final int SELECTED = 0;
    protected static final int COUNT = 1;
    protected static final int TIME = 2;
    protected static final int AVGTIME = 3;
    protected static final int NAME_IN_FIFTH_COLUMN = 4;
    protected static final int NAME_IN_SECOND_COLUMN = 1;
    private static final int COLUMN_SELECTED_WIDTH = 40;
    private static final int COLUMN_WIDTH = 85;
    private static final int COLUMN_NUMERIC_WIDTH = 45;
    private static final int COLUMN_TIME_WIDTH = 90;
    public static final int ARM_RESULTS = 0;
    public static final int CARDINALITY_RESULTS = 1;
    private List aggregationList;
    private List aggregationsInTable;
    private List hierarchies;
    private List hierarchyRemember;
    private OLAPHierarchy hierarchy;
    private Map hierarchyPositionMap;
    private boolean showLevelNumber;
    int totalNumberOfColumns;
    int totalStaticColumns;
    int nameColumn;
    private int resultType;
    private List existingAggregations;

    public AnalysisRecommendTableModel(List hierarchyList, int rType, List allAggregations) {
        this.resultType = rType;
        this.totalStaticColumns = this.resultType == 0 ? 5 : 2;
        this.hierarchies = hierarchyList;
        this.existingAggregations = allAggregations;
        this.initialize();
    }

    private void initialize() {
        this.hierarchyRemember = new ArrayList();
        this.hierarchyRemember.addAll(this.hierarchies);
        this.aggregationList = new ArrayList();
        this.aggregationsInTable = new ArrayList();
        this.showLevelNumber = true;
        this.setupFirstColumns();
        this.setupHierarchyColumns();
    }

    private void setupFirstColumns() {
        this.totalNumberOfColumns = this.getColumnCount();
        this.m_aColumns = new WsAbstractTableColumn[this.totalNumberOfColumns];
        WsBooleanTableColumn booleanColumn = new WsBooleanTableColumn(0, " ", 40);
        booleanColumn.setUseCheckboxSemantics(true);
        booleanColumn.setEditable(true);
        this.m_aColumns[0] = booleanColumn;
        WsIntegerTableColumn integerColumn = new WsIntegerTableColumn(1, bundle.getString("AggregationsTableModel.Count.header.title"), 45);
        integerColumn.setMissingValue(new Integer(-1));
        if (this.resultType == 0) {
            this.m_aColumns[1] = integerColumn;
            this.m_aColumns[1].setEditable(false);
            this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("AggregationsTableModel.Time.header.title"), 90);
            this.m_aColumns[2].setEditable(false);
            this.m_aColumns[3] = new WsStringTableColumn(3, bundle.getString("AggregationsTableModel.AvgTime.header.title"), 90);
            this.m_aColumns[3].setEditable(false);
            this.m_aColumns[4] = new WsStringTableColumn(4, bundle.getString("AggregationsTableModel.Name.header.title"), 85, 60);
            this.m_aColumns[4].setEditable(true);
            this.nameColumn = 4;
        } else {
            this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("AggregationsTableModel.Name.header.title"), 85, 60);
            this.m_aColumns[1].setEditable(true);
            this.nameColumn = 1;
        }
    }

    private void setupHierarchyColumns() {
        this.hierarchyPositionMap = new HashMap();
        int hierarchyCount = this.getHierarchyCount();
        for (int p = 0; p < hierarchyCount; ++p) {
            this.hierarchy = (OLAPHierarchy)this.hierarchies.get(p);
            String hierName = this.hierarchy.getName();
            int position = p + this.totalStaticColumns;
            this.m_aColumns[position] = new WsStringTableColumn(position, hierName, 85);
            this.m_aColumns[position].setEditable(false);
            Integer pos = new Integer(position);
            this.hierarchyPositionMap.put(hierName, pos);
        }
    }

    public int getColumnCount() {
        return this.totalStaticColumns + this.getHierarchyCount();
    }

    public int getRowCount() {
        return this.aggregationsInTable.size();
    }

    public int getHierarchyCount() {
        return this.hierarchies.size();
    }

    public void setHierarchies(List cubeHierarchies) {
        this.hierarchies = cubeHierarchies;
        this.setupHierarchyColumns();
    }

    public void setValueAt(Object value, int iRow, int iCol) {
        boolean isUnique = true;
        Object newValue = value;
        OLAPAggregation aggregation = (OLAPAggregation)this.aggregationsInTable.get(iRow);
        if (iCol == this.nameColumn) {
            String nameValue = (String)value;
            String oldValue = (String)this.getValueAt(iRow, iCol);
            if (Utilities.isBlank((String)nameValue)) {
                MessageUtil.displayMessage((String)bundle.getString("AggregationName.Required.txt"), (int)1);
                newValue = oldValue;
            } else {
                isUnique = this.isAggregationNameUnique(nameValue, iRow);
                if (isUnique) {
                    aggregation.setName(nameValue);
                } else {
                    MessageUtil.displayMessage((String)bundle.formatString("AggregationName.Duplicate.OfNewOrExisting.txt", (Object)nameValue), (int)1);
                    newValue = oldValue;
                }
            }
        }
        super.setValueAt(newValue, iRow, iCol);
    }

    public boolean isAggregationNameUnique(String name, int row) {
        OLAPAggregation aggregation;
        int i;
        boolean unique = true;
        for (i = 0; i < this.aggregationsInTable.size(); ++i) {
            aggregation = (OLAPAggregation)this.aggregationsInTable.get(i);
            if (row == i || !aggregation.getName().equalsIgnoreCase(name)) continue;
            unique = false;
            break;
        }
        if (unique) {
            for (i = 0; i < this.existingAggregations.size(); ++i) {
                aggregation = (OLAPAggregation)this.existingAggregations.get(i);
                if (row == i || !aggregation.getName().equalsIgnoreCase(name)) continue;
                unique = false;
                break;
            }
        }
        return unique;
    }

    public void hideDrillpathNumber() {
        this.showLevelNumber = false;
    }

    public void showDrillpathNumber() {
        this.showLevelNumber = true;
    }

    public void moveDataToModel() {
        OLAPList levels = null;
        String tooltipToDisplay = "";
        int nRows = this.m_lData.size();
        this.clear();
        nRows = this.aggregationList.size();
        int columnCount = this.getColumnCount();
        this.m_aColumns[0].setName(" ");
        for (int i = 0; i < nRows; ++i) {
            ArrayList<Object> alRow = new ArrayList<Object>(columnCount);
            OLAPAggregation aggregation = (OLAPAggregation)this.aggregationList.get(i);
            try {
                levels = aggregation.getLevels();
                tooltipToDisplay = "";
                for (int m = 0; m < levels.size(); ++m) {
                    OLAPLevel levelToProcess = (OLAPLevel)levels.get(m);
                    String levelName = levelToProcess.getName().concat(" ");
                    tooltipToDisplay = tooltipToDisplay.concat(levelName);
                }
            }
            catch (OLAPException e1) {
                ExceptionHandler.handleException((Exception)((Object)e1));
            }
            alRow.add(0, Boolean.FALSE);
            if (this.resultType == 0) {
                String avgtime;
                String time;
                Integer count = aggregation.getCount();
                if (count == null) {
                    count = new Integer(-1);
                }
                alRow.add(1, count);
                Double timeValue = aggregation.getTime();
                if (timeValue != null) {
                    time = Utilities.formatTime((double)timeValue, (boolean)true);
                    double avgTimeValue = timeValue / count.doubleValue();
                    avgtime = Utilities.formatTime((double)avgTimeValue, (boolean)true);
                } else {
                    time = "";
                    avgtime = "";
                }
                alRow.add(2, time);
                alRow.add(3, avgtime);
                alRow.add(4, aggregation.getName());
            } else {
                alRow.add(1, aggregation.getName());
            }
            try {
                int p;
                OLAPList hierarchiesInAggregation = aggregation.getHierarchies();
                for (p = 0; p < columnCount; ++p) {
                    alRow.add(this.totalStaticColumns + p, "");
                }
                for (p = 0; p < hierarchiesInAggregation.size(); ++p) {
                    this.hierarchy = (OLAPHierarchy)hierarchiesInAggregation.get(p);
                    OLAPList levelsInAggregation = aggregation.getLevelsByHierarchy(this.hierarchy);
                    Integer columnPosition = (Integer)this.hierarchyPositionMap.get(this.hierarchy.getName());
                    OLAPLevel lastLevel = (OLAPLevel)levelsInAggregation.get(levelsInAggregation.size() - 1);
                    String stringToDisplay = this.showLevelNumber ? levelsInAggregation.size() + ". " + lastLevel.toString() : lastLevel.toString();
                    alRow.set(columnPosition, stringToDisplay);
                }
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            this.m_lData.add(alRow);
        }
        this.fireTableModelPopulated();
        this.m_nRowInstances = nRows;
    }

    public void addAggregationsToTable(List aggregations) {
        this.aggregationsInTable.clear();
        this.aggregationList.clear();
        for (int p = 0; p < aggregations.size(); ++p) {
            OLAPAggregation aggregationToCheck = (OLAPAggregation)aggregations.get(p);
            this.aggregationsInTable.add(aggregationToCheck);
            this.aggregationList.add(aggregationToCheck);
        }
        this.moveDataToModel();
    }

    public List getAggregationsInTable() {
        return this.aggregationsInTable;
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.setStorePopulated(true);
    }

    public void clearSelections() {
        int rowCount = this.getRowCount();
        for (int p = 0; p < rowCount; ++p) {
            this.setValueAt(Boolean.FALSE, p, 0);
        }
    }

    public void selectAll() {
        int rowCount = this.getRowCount();
        for (int p = 0; p < rowCount; ++p) {
            this.setValueAt(Boolean.TRUE, p, 0);
        }
    }

    public List getSelectedCheckboxValues() {
        ArrayList selectedItems = new ArrayList();
        int numberRows = this.getRowCount();
        for (int i = 0; i < numberRows; ++i) {
            List rowValues = this.getRowValues(i);
            Boolean checkbox = (Boolean)rowValues.get(0);
            if (!checkbox.booleanValue()) continue;
            selectedItems.add(this.aggregationsInTable.get(i));
        }
        return selectedItems;
    }
}

