/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.aggregation;

import com.sas.olapadmin.aggregation.AggregationItem;
import com.sas.olapadmin.aggregation.AggregationTuningModel;
import com.sas.olapadmin.aggregation.AggregationsARMLogTab;
import com.sas.olapadmin.aggregation.AggregationsCardinalityTab;
import com.sas.olapadmin.aggregation.AggregationsDialog;
import com.sas.olapadmin.aggregation.AggregationsDisplayInterface;
import com.sas.olapadmin.aggregation.AggregationsManualTab;
import com.sas.olapadmin.aggregation.AggregationsTabberPanel;
import com.sas.olapadmin.aggregation.AggregationsTableModel;
import com.sas.olapadmin.aggregation.ExportAggregationCode;
import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.studio.AggregationPreviewLevelsPanel;
import com.sas.olapadmin.utilities.studio.PerformancePropertyDialog;
import com.sas.swing.visuals.tableview.HoldInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsTable;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class AggregationsTablePanel
extends WAPanel
implements AggregationsDisplayInterface {
    private static final long serialVersionUID = 1L;
    static WAdminResource bundle = new WAdminResource(AggregationsTablePanel.class);
    protected AggregationsTableModel aggregationsModel;
    protected AggregationTuningModel tuningModel;
    protected OLAPCube olapCube;
    protected OLAPList olapAggregations;
    private OLAPList hierarchies;
    private JButton options;
    protected AggregationSet aggregationSet;
    protected WsAbstractAction actDrop;
    protected WsAbstractAction actPreviewLevel;
    protected WsAbstractAction actDelete;
    protected Vector aggregationDataPaths;
    protected Vector aggregationIndexPaths;
    protected JButton export;
    protected JButton drop;
    protected JButton delete;
    protected JButton clearDrop;
    protected WsTable tuningTable;
    protected JCheckBox previewCheckbox;
    protected JScrollPane tableScrollPane;
    protected JSplitPane splitPane;
    protected JPopupMenu popupMenu;
    protected JCheckBoxMenuItem previewMenuItem;
    protected JMenuItem deleteMenuItem;
    protected JMenuItem dropMenuItem;
    protected JMenuItem clearDropMenuItem;
    protected AggregationPreviewLevelsPanel previewLevelsPanel;
    protected AggregationsTablePanel aggregationsTablePanel;
    protected AggregationsTabberPanel tabber;
    protected AggregationsDialog parentAggregationsDialog;
    private int numberOfNewAggregations;
    private TableCellEditor cellEditor;
    protected int saveDividerLocation;

    public AggregationsTablePanel(OLAPCube oCube, AggregationsTabberPanel tabbedPane, AggregationsDialog parent) {
        this.olapCube = oCube;
        this.initialize();
        this.aggregationsTablePanel = this;
        this.parentAggregationsDialog = parent;
        this.tabber = tabbedPane;
        this.aggregationSet = oCube.getAggregationSet();
        this.aggregationSet.setIsAggregationTuning(true);
    }

    public List getAggregationsInTable() {
        return this.aggregationsModel.getAggregationsInTable();
    }

    public WAPropertyTab getSelectedTab() {
        return this.tabber.getSelectedTab();
    }

    protected void initialize() {
        this.setLayout(new GridBagLayout());
        try {
            this.hierarchies = this.olapCube.getDimensionSet().getHierarchies();
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        this.aggregationsModel = new AggregationsTableModel((List)this.hierarchies);
        this.tuningTable = new WsTable((WsAbstractTableModel)this.aggregationsModel);
        this.tuningModel = new AggregationTuningModel(this.olapCube);
        this.tuningTable.getRowHeader().setReorderingAllowed(false);
        this.tuningTable.getColumnHeader().setReorderingAllowed(false);
        this.tuningTable.setSelectionMode(2);
        this.tuningTable.setCellSelectionEnabled(false);
        this.tuningTable.setRowSelectionAllowed(true);
        this.tuningTable.setColumnSelectionAllowed(false);
        this.tuningTable.setColumnAutoResizeMode(4);
        this.tuningTable.sizeColumnsToFit();
        this.tuningTable.setColumnHeaderPopupMenuEnabled(false);
        this.tuningTable.setRowHeaderPopupMenuEnabled(false);
        this.previewMenuItem = new JCheckBoxMenuItem();
        VisualUtilities.setButtonTextAndMnemonic(this.previewMenuItem, bundle.getString("Aggregations.PreviewLevels.action.label"));
        this.deleteMenuItem = new JMenuItem();
        VisualUtilities.setButtonTextAndMnemonic(this.deleteMenuItem, bundle.getString("Aggregations.Delete.action.label"));
        this.dropMenuItem = new JMenuItem();
        VisualUtilities.setButtonTextAndMnemonic(this.dropMenuItem, bundle.getString("Aggregations.Drop.action.label"));
        this.clearDropMenuItem = new JMenuItem();
        VisualUtilities.setButtonTextAndMnemonic(this.clearDropMenuItem, bundle.getString("Aggregations.ClearDrop.action.label"));
        this.previewMenuItem.addActionListener(new previewListener());
        this.deleteMenuItem.addActionListener(new DeleteListener());
        this.dropMenuItem.addActionListener(new dropListener());
        this.clearDropMenuItem.addActionListener(new clearDropListener());
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.previewMenuItem);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.dropMenuItem);
        this.popupMenu.add(this.clearDropMenuItem);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.deleteMenuItem);
        PopupListener popupListener = new PopupListener();
        this.tuningTable.addMouseListener((MouseListener)popupListener);
        HoldInterface mgrHold = (HoldInterface)this.tuningTable.getTableHeader();
        mgrHold.hold(0, 2);
        RowSelectionListener rowSelectionListener = new RowSelectionListener(this.tuningTable);
        this.tuningTable.getRowModel().getSelectionModel().addListSelectionListener(rowSelectionListener);
        TableColumn newColumn = this.tuningTable.getColumnModel().getColumn(this.tuningTable.convertColumnIndexToView(0));
        newColumn.setResizable(false);
        TableColumn optionsColumn = this.tuningTable.getColumnModel().getColumn(this.tuningTable.convertColumnIndexToView(1));
        optionsColumn.setResizable(false);
        this.tableScrollPane = new JScrollPane((Component)this.tuningTable);
        Dimension tableSize = new Dimension(650, 300);
        Dimension minimumTableSize = new Dimension(150, 100);
        this.tableScrollPane.setMinimumSize(minimumTableSize);
        this.tableScrollPane.setPreferredSize(tableSize);
        WAPanel aboveTablePanel = new WAPanel();
        aboveTablePanel.setLayout((LayoutManager)new GridBagLayout());
        WAPanel rightTableButtons = new WAPanel();
        rightTableButtons.setLayout((LayoutManager)new GridBagLayout());
        WAPanel leftTableButtons = new WAPanel();
        leftTableButtons.setLayout((LayoutManager)new GridBagLayout());
        this.delete = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.delete, bundle.getString("Aggregations.Delete.action.label"));
        this.delete.setToolTipText(bundle.getString("Aggregations.Delete.action.tip"));
        this.delete.addActionListener(new DeleteListener());
        this.delete.setEnabled(false);
        this.drop = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.drop, bundle.getString("Aggregations.Drop.action.label"));
        this.drop.setToolTipText(bundle.getString("Aggregations.Drop.action.tip"));
        this.drop.addActionListener(new dropListener());
        this.drop.setEnabled(false);
        this.clearDrop = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.clearDrop, bundle.getString("Aggregations.ClearDrop.action.label"));
        this.clearDrop.setToolTipText(bundle.getString("Aggregations.ClearDrop.action.tip"));
        this.clearDrop.addActionListener(new clearDropListener());
        this.clearDrop.setEnabled(false);
        this.options = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.options, bundle.getString("Aggregations.Options.action.label"));
        this.options.setToolTipText(bundle.getString("Aggregations.Options.action.tip"));
        this.options.addActionListener(new OptionsListener());
        this.options.setEnabled(false);
        this.export = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.export, bundle.getString("Aggregations.Export.action.label"));
        this.export.setToolTipText(bundle.getString("Aggregations.Export.action.tip"));
        this.export.addActionListener(new ExportAggregationCode(this.olapCube, this));
        this.export.setEnabled(false);
        JLabel tableLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(tableLabel, bundle.getString("Aggregations.Table.control.label"));
        tableLabel.setLabelFor(this.tableScrollPane);
        this.previewCheckbox = new JCheckBox();
        VisualUtilities.setButtonTextAndMnemonic(this.previewCheckbox, bundle.getString("Aggregations.PreviewLevels.action.label"));
        aboveTablePanel.add((Component)tableLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 16, 2, new Insets(0, 0, 0, 0), 0, 0));
        aboveTablePanel.add((Component)this.previewCheckbox, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)aboveTablePanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.1, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.previewLevelsPanel = new AggregationPreviewLevelsPanel(null);
        this.previewLevelsPanel.enableNoItemsMessage(true);
        this.previewCheckbox.addActionListener(new previewListener());
        this.splitPane = new JSplitPane(1);
        this.splitPane.setLeftComponent(this.tableScrollPane);
        this.splitPane.setRightComponent((Component)((Object)this.previewLevelsPanel));
        this.splitPane.setResizeWeight(0.7);
        this.previewLevelsPanel.setVisible(false);
        this.splitPane.setDividerLocation(0.7);
        this.saveDividerLocation = this.splitPane.getDividerLocation();
        this.add(this.splitPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        leftTableButtons.add((Component)this.export, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)leftTableButtons, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.1, 17, 2, new Insets(5, 0, 5, 150), 0, 0));
        rightTableButtons.add((Component)this.delete, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        rightTableButtons.add((Component)this.drop, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        rightTableButtons.add((Component)this.clearDrop, (Object)new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        rightTableButtons.add((Component)this.options, (Object)new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)rightTableButtons, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.1, 13, 0, new Insets(5, 0, 5, 0), 0, 0));
        try {
            this.aggregationSet = this.olapCube.getAggregationSet();
            this.olapAggregations = this.aggregationSet.getAggregations();
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        if (!this.olapAggregations.isEmpty()) {
            this.addAggregations((List)this.olapAggregations, 0);
        }
        DataChangedListener tableModelListener = new DataChangedListener();
        this.tuningTable.getModel().addTableModelListener(tableModelListener);
        this.cellEditor = this.tuningTable.getCellEditor();
    }

    @Override
    public void addAggregations(List analysisResults, int tuningMethodUsed) {
        this.aggregationsModel.addAggregationsToTable(analysisResults, tuningMethodUsed);
        this.numberOfNewAggregations = analysisResults.size();
    }

    @Override
    public void scrollDown() {
        int numberRows = this.aggregationsModel.getRowCount() - 1;
        Rectangle rRow = this.tuningTable.getCellRect(numberRows, -1, true);
        this.tuningTable.scrollRectToVisible(rRow);
        int startHighlight = this.aggregationsModel.getRowCount() - this.numberOfNewAggregations;
        this.tuningTable.setRowSelectionInterval(startHighlight, numberRows);
    }

    @Override
    public void updateStatistics(List analysisResults) {
        try {
            this.clearStatistics();
            this.aggregationsModel.updateStatisticsColumnsInTable(analysisResults);
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    public void clearStatistics() {
        this.aggregationsModel.clearStatisticsColumnsInTable();
    }

    @Override
    public boolean isDuplicateAggregation(AggregationItem aggregationToCheck) {
        boolean isInTable = false;
        try {
            isInTable = this.aggregationsModel.isAggregationItemInTable(aggregationToCheck);
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        return isInTable;
    }

    @Override
    public boolean isDuplicateOLAPAggregation(OLAPAggregation aggregationToCheck) {
        boolean isInTable = false;
        try {
            isInTable = this.aggregationsModel.isAggregationItemInTable(aggregationToCheck);
            if (aggregationToCheck.isNewObject() & isInTable) {
                aggregationToCheck.delete();
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        return isInTable;
    }

    @Override
    public void enableDisableExportAndBuild() {
        boolean isEnableOk = this.tuningModel.isAggregationToBeAddedOrDropped();
        this.options.setEnabled(isEnableOk);
        this.export.setEnabled(isEnableOk);
        this.parentAggregationsDialog.enableBuild(isEnableOk);
    }

    void refreshPreviewPanelWithSelections() {
        this.aggregationsTablePanel.previewLevelsPanel.clear();
        this.cellEditor = this.tuningTable.getCellEditor();
        if (this.cellEditor != null) {
            this.cellEditor.stopCellEditing();
        }
        int[] selectedRows = this.tuningTable.getSelectedRowsFromSelectedCells();
        this.tuningTable.convertRowIndexesToModel(selectedRows);
        ArrayList<OLAPAggregation> selectedAggregations = new ArrayList<OLAPAggregation>(selectedRows.length);
        for (int i = 0; i < selectedRows.length; ++i) {
            int selectedRow = selectedRows[i];
            List aggregationsInTable = this.aggregationsModel.getAggregationsInTable();
            OLAPAggregation aggregation = (OLAPAggregation)aggregationsInTable.get(selectedRow);
            selectedAggregations.add(aggregation);
        }
        this.previewLevelsPanel.setSelectedAggregations(selectedAggregations);
    }

    public void saveAggregationPaths() {
        if (this.aggregationDataPaths != null) {
            VisualUtilities.setAggregationDataPaths(this.aggregationDataPaths);
        }
        if (this.aggregationIndexPaths != null) {
            VisualUtilities.setAggregationIndexPaths(this.aggregationIndexPaths);
        }
    }

    @Override
    public void stopCellEditing() {
        this.cellEditor = this.tuningTable.getCellEditor();
        if (this.cellEditor != null) {
            this.cellEditor.stopCellEditing();
        }
    }

    public boolean validateNames() {
        int rowCount = this.aggregationsModel.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            String rowName = (String)this.aggregationsModel.getValueAt(row, 6);
            if (Utilities.isBlank((String)rowName) & this.aggregationsModel.isCellEditable(row, 6)) {
                MessageUtil.displayMessage((String)bundle.getString("AggregationName.Required.txt"), (int)1);
                this.tuningTable.editCellAt(row, 6);
                return false;
            }
            if (this.aggregationsModel.isAggregationNameUnique(rowName, row)) continue;
            MessageUtil.displayMessage((String)bundle.formatString("AggregationName.Duplicate.OfNewOrExisting.txt", (Object)rowName), (int)1);
            this.tuningTable.editCellAt(row, 6);
            return false;
        }
        return true;
    }

    class previewListener
    implements ActionListener {
        previewListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AggregationsTablePanel.this.cellEditor = AggregationsTablePanel.this.tuningTable.getCellEditor();
            if (AggregationsTablePanel.this.cellEditor != null) {
                AggregationsTablePanel.this.cellEditor.stopCellEditing();
            }
            if (e.getSource() == AggregationsTablePanel.this.previewMenuItem & AggregationsTablePanel.this.previewMenuItem.isSelected() || e.getSource() == AggregationsTablePanel.this.previewCheckbox & AggregationsTablePanel.this.previewCheckbox.isSelected()) {
                AggregationsTablePanel.this.previewLevelsPanel.setVisible(true);
                AggregationsTablePanel.this.splitPane.setDividerLocation(AggregationsTablePanel.this.saveDividerLocation);
                AggregationsTablePanel.this.aggregationsTablePanel.refreshPreviewPanelWithSelections();
                if (e.getSource() == AggregationsTablePanel.this.previewMenuItem & AggregationsTablePanel.this.previewMenuItem.isSelected()) {
                    AggregationsTablePanel.this.previewCheckbox.setSelected(true);
                } else if (e.getSource() == AggregationsTablePanel.this.previewCheckbox & AggregationsTablePanel.this.previewCheckbox.isSelected()) {
                    AggregationsTablePanel.this.previewMenuItem.setSelected(true);
                }
                AggregationsTablePanel.this.aggregationsTablePanel.validate();
                AggregationsTablePanel.this.aggregationsTablePanel.repaint();
            } else {
                AggregationsTablePanel.this.saveDividerLocation = AggregationsTablePanel.this.splitPane.getDividerLocation();
                AggregationsTablePanel.this.previewLevelsPanel.setVisible(false);
                if (e.getSource() == AggregationsTablePanel.this.previewMenuItem & !AggregationsTablePanel.this.previewMenuItem.isSelected()) {
                    AggregationsTablePanel.this.previewCheckbox.setSelected(false);
                } else if (e.getSource() == AggregationsTablePanel.this.previewCheckbox & !AggregationsTablePanel.this.previewCheckbox.isSelected()) {
                    AggregationsTablePanel.this.previewMenuItem.setSelected(false);
                }
                AggregationsTablePanel.this.aggregationsTablePanel.validate();
                AggregationsTablePanel.this.aggregationsTablePanel.repaint();
            }
        }
    }

    class DeleteListener
    implements ActionListener {
        DeleteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int choice;
            OLAPAggregation aggregationToRemove;
            List aggregationsInTable;
            int selectedRow;
            AggregationsTablePanel.this.cellEditor = AggregationsTablePanel.this.tuningTable.getCellEditor();
            if (AggregationsTablePanel.this.cellEditor != null) {
                AggregationsTablePanel.this.cellEditor.cancelCellEditing();
            }
            int[] selectedRows = AggregationsTablePanel.this.tuningTable.getSelectedRows();
            AggregationsTablePanel.this.tuningTable.convertRowIndexesToModel(selectedRows);
            if (selectedRows.length == 1) {
                selectedRow = selectedRows[0];
                aggregationsInTable = AggregationsTablePanel.this.aggregationsModel.getAggregationsInTable();
                aggregationToRemove = (OLAPAggregation)aggregationsInTable.get(selectedRow);
                String aggregationName = aggregationToRemove.getName();
                choice = MessageUtil.displayMessage((String)bundle.formatString("ConfirmDelete.SingleAggregation.fmt.txt", (Object)aggregationName), (String)bundle.getString("ConfirmDelete.window.title"), (int)2, (int)0);
            } else {
                choice = MessageUtil.displayMessage((String)bundle.getString("ConfirmDelete.MultipleAggregations.txt"), (String)bundle.getString("ConfirmDelete.window.title"), (int)2, (int)0);
            }
            if (choice == 0) {
                AggregationsTablePanel.this.setCursor(Cursor.getPredefinedCursor(3));
                for (int i = selectedRows.length - 1; i >= 0; --i) {
                    selectedRow = selectedRows[i];
                    aggregationsInTable = AggregationsTablePanel.this.aggregationsModel.getAggregationsInTable();
                    aggregationToRemove = (OLAPAggregation)aggregationsInTable.get(selectedRow);
                    if (!aggregationToRemove.isNewObject()) continue;
                    AggregationsTablePanel.this.tuningTable.removeRowFromSelection(selectedRow);
                    AggregationsTablePanel.this.aggregationsModel.removeAggregation(aggregationToRemove, selectedRow);
                }
                AggregationsTablePanel.this.aggregationsTablePanel.enableDisableExportAndBuild();
                AggregationsTablePanel.this.setCursor(Cursor.getPredefinedCursor(0));
            }
            WAPropertyTab selectedTab = AggregationsTablePanel.this.tabber.getSelectedTab();
            if (AggregationsTablePanel.this.olapCube.getAggregationSet().getAddedAggregations().size() > 98) {
                if (selectedTab instanceof AggregationsCardinalityTab) {
                    AggregationsCardinalityTab cardinalityTab = (AggregationsCardinalityTab)AggregationsTablePanel.this.tabber.getSelectedTab();
                    cardinalityTab.disableAddButton();
                } else if (selectedTab instanceof AggregationsARMLogTab) {
                    selectedTab.setEnabled(false);
                } else if (selectedTab instanceof AggregationsManualTab) {
                    selectedTab.setEnabled(false);
                }
            } else if (selectedTab instanceof AggregationsCardinalityTab) {
                AggregationsCardinalityTab cardinalityTab = (AggregationsCardinalityTab)selectedTab;
                cardinalityTab.enableAddButton();
            }
        }
    }

    class dropListener
    implements ActionListener {
        dropListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AggregationsTablePanel.this.cellEditor = AggregationsTablePanel.this.tuningTable.getCellEditor();
            if (AggregationsTablePanel.this.cellEditor != null) {
                AggregationsTablePanel.this.cellEditor.stopCellEditing();
            }
            int[] selectedRows = AggregationsTablePanel.this.tuningTable.getSelectedRows();
            AggregationsTablePanel.this.tuningTable.convertRowIndexesToModel(selectedRows);
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                int selectedRow = selectedRows[i];
                List aggregationsInTable = AggregationsTablePanel.this.aggregationsModel.getAggregationsInTable();
                OLAPAggregation aggregationToRemove = (OLAPAggregation)aggregationsInTable.get(selectedRow);
                if (!(!aggregationToRemove.isNewObject() & !aggregationToRemove.isNway())) continue;
                AggregationsTablePanel.this.aggregationsModel.dropExistingAggregation(aggregationToRemove);
                AggregationsTablePanel.this.clearDrop.setEnabled(true);
            }
            AggregationsTablePanel.this.drop.setEnabled(false);
            AggregationsTablePanel.this.aggregationsTablePanel.enableDisableExportAndBuild();
        }
    }

    class clearDropListener
    implements ActionListener {
        clearDropListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AggregationsTablePanel.this.cellEditor = AggregationsTablePanel.this.tuningTable.getCellEditor();
            if (AggregationsTablePanel.this.cellEditor != null) {
                AggregationsTablePanel.this.cellEditor.stopCellEditing();
            }
            int[] selectedRows = AggregationsTablePanel.this.tuningTable.getSelectedRows();
            AggregationsTablePanel.this.tuningTable.convertRowIndexesToModel(selectedRows);
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                int selectedRow = selectedRows[i];
                List aggregationsInTable = AggregationsTablePanel.this.aggregationsModel.getAggregationsInTable();
                OLAPAggregation aggregationToRemoveDrop = (OLAPAggregation)aggregationsInTable.get(selectedRow);
                if (!(!aggregationToRemoveDrop.isNewObject() & aggregationToRemoveDrop.isDropped())) continue;
                AggregationsTablePanel.this.aggregationsModel.removeDropOnExistingAggregation(aggregationToRemoveDrop);
            }
            AggregationsTablePanel.this.clearDrop.setEnabled(false);
            AggregationsTablePanel.this.drop.setEnabled(true);
            AggregationsTablePanel.this.aggregationsTablePanel.enableDisableExportAndBuild();
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
        }

        private void showPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                AggregationsTablePanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class RowSelectionListener
    implements ListSelectionListener {
        WsTable table;

        RowSelectionListener(WsTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.enableDisableOptions(false);
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                AggregationsTablePanel.this.aggregationsTablePanel.refreshPreviewPanelWithSelections();
                int[] selectedRows = AggregationsTablePanel.this.tuningTable.getSelectedRows();
                AggregationsTablePanel.this.tuningTable.convertRowIndexesToModel(selectedRows);
                List aggregationsInTable = AggregationsTablePanel.this.aggregationsModel.getAggregationsInTable();
                OLAPAggregation aggregation = (OLAPAggregation)aggregationsInTable.get(selectedRows[0]);
                if (selectedRows.length == 1 && aggregation.isNway()) {
                    this.enableDisableOptions(false);
                } else {
                    if (this.hasNewAggrs(selectedRows, aggregationsInTable)) {
                        AggregationsTablePanel.this.delete.setEnabled(true);
                        AggregationsTablePanel.this.deleteMenuItem.setEnabled(true);
                    }
                    if (this.hasExistingNotDroppedAggrs(selectedRows, aggregationsInTable)) {
                        AggregationsTablePanel.this.drop.setEnabled(true);
                        AggregationsTablePanel.this.dropMenuItem.setEnabled(true);
                    }
                }
                if (this.hasDroppedAggrs(selectedRows, aggregationsInTable)) {
                    AggregationsTablePanel.this.clearDrop.setEnabled(true);
                    AggregationsTablePanel.this.clearDropMenuItem.setEnabled(true);
                }
                AggregationsTablePanel.this.aggregationsTablePanel.enableDisableExportAndBuild();
            }
        }

        private void enableDisableOptions(boolean isEnabled) {
            AggregationsTablePanel.this.delete.setEnabled(isEnabled);
            AggregationsTablePanel.this.drop.setEnabled(isEnabled);
            AggregationsTablePanel.this.clearDrop.setEnabled(isEnabled);
            AggregationsTablePanel.this.deleteMenuItem.setEnabled(isEnabled);
            AggregationsTablePanel.this.dropMenuItem.setEnabled(isEnabled);
            AggregationsTablePanel.this.clearDropMenuItem.setEnabled(isEnabled);
        }

        private boolean hasNewAggrs(int[] selectedRows, List aggrsInTable) {
            boolean isNewAggrs = false;
            int size = selectedRows.length;
            for (int i = 0; i < size; ++i) {
                OLAPAggregation selectedAggr = (OLAPAggregation)aggrsInTable.get(selectedRows[i]);
                if (!selectedAggr.isNewObject()) continue;
                isNewAggrs = true;
            }
            return isNewAggrs;
        }

        private boolean hasExistingNotDroppedAggrs(int[] selectedRows, List aggrsInTable) {
            boolean isExistingNotDropped = false;
            int size = selectedRows.length;
            for (int i = 0; i < size; ++i) {
                OLAPAggregation selectedAggr = (OLAPAggregation)aggrsInTable.get(selectedRows[i]);
                OLAPList addedAggregations = AggregationsTablePanel.this.olapCube.getAggregationSet().getAddedAggregations();
                if (!selectedAggr.isNewObject() & (selectedAggr.isDropped() & addedAggregations.contains((Object)selectedAggr))) {
                    isExistingNotDropped = true;
                    continue;
                }
                if (!(!selectedAggr.isNewObject() & !selectedAggr.isDropped())) continue;
                isExistingNotDropped = true;
            }
            return isExistingNotDropped;
        }

        private boolean hasDroppedAggrs(int[] selectedRows, List aggrsInTable) {
            boolean hasDroppedAggrs = false;
            int size = selectedRows.length;
            for (int i = 0; i < size; ++i) {
                OLAPAggregation selectedAggr = (OLAPAggregation)aggrsInTable.get(selectedRows[i]);
                if (!AggregationsTablePanel.this.aggregationsModel.hasAggrsMarkedDropped(AggregationsTablePanel.this.aggregationSet, selectedAggr)) continue;
                hasDroppedAggrs = true;
            }
            return hasDroppedAggrs;
        }
    }

    class OptionsListener
    implements ActionListener {
        private Integer originalIndexSortSize;
        private Integer originalConcurrent;
        private Integer originalMaxThreads;

        OptionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AggregationsTablePanel.this.cellEditor = AggregationsTablePanel.this.tuningTable.getCellEditor();
            if (AggregationsTablePanel.this.cellEditor != null) {
                AggregationsTablePanel.this.cellEditor.stopCellEditing();
            }
            try {
                if (this.originalIndexSortSize == null) {
                    this.originalIndexSortSize = AggregationsTablePanel.this.olapCube.getPerformanceOptionIndexSortSize();
                }
                if (this.originalConcurrent == null) {
                    this.originalConcurrent = AggregationsTablePanel.this.olapCube.getPerformanceOptionConcurrent();
                }
                if (this.originalMaxThreads == null) {
                    this.originalMaxThreads = AggregationsTablePanel.this.olapCube.getPerformanceOptionMaxThreads();
                }
            }
            catch (OLAPException e2) {
                ExceptionHandler.handleException((Exception)((Object)e2));
            }
            if (AggregationsTablePanel.this.aggregationDataPaths == null) {
                AggregationsTablePanel.this.aggregationDataPaths = VisualUtilities.getAggregationDataPaths();
            }
            if (AggregationsTablePanel.this.aggregationIndexPaths == null) {
                AggregationsTablePanel.this.aggregationIndexPaths = VisualUtilities.getAggregationIndexPaths();
            }
            PerformancePropertyDialog optionsDialog = new PerformancePropertyDialog(AggregationsTablePanel.this.olapCube, null, null, AggregationsTablePanel.this.aggregationDataPaths, AggregationsTablePanel.this.aggregationIndexPaths, true, this.originalIndexSortSize, this.originalConcurrent, this.originalMaxThreads, true);
            optionsDialog.show();
            try {
                AggregationsTablePanel.this.aggregationsModel.updateOptionsColumnInTable();
            }
            catch (OLAPException e1) {
                ExceptionHandler.handleException((Exception)((Object)e1));
            }
            AggregationsTablePanel.this.aggregationsTablePanel.enableDisableExportAndBuild();
        }
    }

    class DataChangedListener
    implements TableModelListener {
        DataChangedListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            AggregationsTablePanel.this.aggregationsTablePanel.enableDisableExportAndBuild();
            AggregationsTablePanel.this.aggregationsTablePanel.refreshPreviewPanelWithSelections();
        }
    }
}

