/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.aggregation;

import com.sas.olapadmin.aggregation.AggregationsDisplayInterface;
import com.sas.olapadmin.aggregation.AggregationsSelectorTableModel;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class AggregationsManualPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    static WAdminResource bundle = new WAdminResource(AggregationsManualPanel.class);
    private OLAPCube cube;
    JButton addButton;
    JButton clearButton;
    AggregationsDisplayInterface resultsDisplayObject;

    public AggregationsManualPanel(OLAPCube olapCube) {
        this.cube = olapCube;
        this.initialize();
    }

    protected void initialize() {
        final AggregationsSelectorTableModel aggregationSelectorModel = new AggregationsSelectorTableModel(this.cube);
        WsTable table = new WsTable((WsAbstractTableModel)aggregationSelectorModel);
        aggregationSelectorModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                if (aggregationSelectorModel.levelSelected()) {
                    AggregationsManualPanel.this.addButton.setEnabled(true);
                    AggregationsManualPanel.this.clearButton.setEnabled(true);
                } else {
                    AggregationsManualPanel.this.addButton.setEnabled(false);
                    AggregationsManualPanel.this.clearButton.setEnabled(false);
                }
            }
        });
        table.setRowSelectionAllowed(false);
        table.setColumnSelectionAllowed(false);
        table.setRowHeaderVisible(false);
        table.sizeColumnsToFit();
        table.setSortingEnabled(false);
        table.setColumnHidingEnabled(false);
        table.setColumnsReorderable(false);
        table.setRowHoldingEnabled(false);
        table.setColumnHeaderPopupMenuEnabled(false);
        table.setOriginPopupMenuEnabled(false);
        table.setPopupMenuEnabled(false);
        table.setRowHeaderPopupMenuEnabled(false);
        table.setTablePopupMenuEnabled(false);
        table.setViewportPopupMenuEnabled(false);
        table.setToolTipText(bundle.getString("Aggregations.ManualTable.control.tip"));
        table.setName("AggregationSelectorTable");
        table.setAutoResizeMode(0);
        Dimension tableSize = new Dimension(350, 60);
        Dimension minTableSize = new Dimension(200, 60);
        JScrollPane tableScrollPane = new JScrollPane((Component)table);
        tableScrollPane.setMinimumSize(minTableSize);
        tableScrollPane.setPreferredSize(tableSize);
        this.setLayout(new GridBagLayout());
        this.addButton = new JButton();
        this.addButton.setEnabled(false);
        VisualUtilities.setButtonTextAndMnemonic(this.addButton, bundle.getString("Aggregations.Manual.Add.action.label"));
        this.addButton.setToolTipText(bundle.getString("Aggregations.Manual.Add.action.tip"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AggregationsManualPanel.this.resultsDisplayObject.stopCellEditing();
                OLAPAggregation aggregation = aggregationSelectorModel.createOLAPAggregationInSelector();
                if (aggregation == null) {
                    MessageUtil.displayMessage((String)bundle.getString("Aggregations.Manual.NoLevelsSelected.txt"));
                } else {
                    boolean aggregationInTable = AggregationsManualPanel.this.resultsDisplayObject.isDuplicateOLAPAggregation(aggregation);
                    if (!aggregationInTable) {
                        ArrayList<OLAPAggregation> newList = new ArrayList<OLAPAggregation>();
                        newList.add(aggregation);
                        if (newList.size() > 0) {
                            AggregationsManualPanel.this.resultsDisplayObject.addAggregations(newList, 3);
                            AggregationsManualPanel.this.resultsDisplayObject.scrollDown();
                            AggregationsManualPanel.this.resultsDisplayObject.enableDisableExportAndBuild();
                        }
                    } else {
                        MessageUtil.displayMessage((String)bundle.getString("Aggregations.Manual.Duplicate.txt"), (int)1);
                    }
                }
            }
        });
        this.clearButton = new JButton();
        this.clearButton.setEnabled(false);
        VisualUtilities.setButtonTextAndMnemonic(this.clearButton, bundle.getString("Aggregations.Clear.action.label"));
        this.clearButton.setToolTipText(bundle.getString("Aggregations.Clear.action.tip"));
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                aggregationSelectorModel.resetAllSelections();
                AggregationsManualPanel.this.addButton.setEnabled(false);
                AggregationsManualPanel.this.clearButton.setEnabled(false);
            }
        });
        WAPanel manualPanel = new WAPanel();
        manualPanel.setLayout((LayoutManager)new GridBagLayout());
        JLabel selectorLabel = new JLabel(bundle.getString("Aggregations.ManualTable.control.label"));
        manualPanel.add((Component)selectorLabel, (Object)new GridBagConstraints(0, 0, 2, 1, 1.0, 0.1, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        manualPanel.add((Component)tableScrollPane, (Object)new GridBagConstraints(0, 1, 2, 1, 1.0, 0.7, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        WAPanel rightTableButtons = new WAPanel();
        rightTableButtons.setLayout((LayoutManager)new GridBagLayout());
        rightTableButtons.add((Component)this.addButton, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        rightTableButtons.add((Component)this.clearButton, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        manualPanel.add((Component)rightTableButtons, (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 0.1, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)manualPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setAnalysisDisplay(AggregationsDisplayInterface displayObject) {
        this.resultsDisplayObject = displayObject;
    }
}

