/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.aggregation;

import com.sas.olapadmin.aggregation.AggregationsPanel;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.WsRunCode;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import java.awt.Cursor;
import java.awt.Frame;
import javax.swing.JButton;

public class AggregationsDialog
extends WAStandardDialog {
    private static final long serialVersionUID = 1L;
    static WAdminResource bundle = new WAdminResource(AggregationsDialog.class);
    OLAPCube olapCube;
    AggregationsPanel centerPanel;
    private JButton buildButton;

    public AggregationsDialog(Workspace owner, String title, OLAPCube oCube) {
        super((Frame)owner, title, true);
        this.olapCube = oCube;
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("aggregation_dialog");
    }

    public void initialize() {
        this.centerPanel = new AggregationsPanel(this.olapCube, this);
        this.setMainPanel(this.centerPanel);
        this.setResizable(true);
        super.initialize();
        VisualUtilities.setButtonTextAndMnemonic(this.m_btnOk, bundle.getString("Aggregations.SaveBuild.action.label"));
        this.m_btnOk.setName("SaveBuildButton");
        this.m_btnOk.setToolTipText(bundle.getString("Aggregations.SaveBuild.action.tip"));
        this.m_btnOk.setEnabled(false);
        this.buildButton = this.m_btnOk;
    }

    public void enableBuild(boolean isOkToBuild) {
        this.buildButton.setEnabled(isOkToBuild);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean saveMetadataUpdateCube() {
        WsRunCode wsRunCode = null;
        boolean errorOccurred = false;
        WsAppServer applicationServer = WsRunCode.getServer();
        if (applicationServer != null) {
            String message = bundle.getString("UpdateCubeProgressIndicator.message.txt");
            String title = bundle.getString("UpdateCubeProgressIndicator.window.title");
            wsRunCode = new WsRunCode(applicationServer);
            wsRunCode.showLogMessagesInDetails(true);
            errorOccurred = wsRunCode.hasSubmitError;
            if (errorOccurred) return errorOccurred;
            try {
                errorOccurred = wsRunCode.executeCode(this.olapCube.generateCodeManualTuning(false), message, title);
                if (errorOccurred) return errorOccurred;
                this.centerPanel.saveAggregationPaths();
                return errorOccurred;
            }
            catch (OLAPException e) {
                errorOccurred = true;
                ExceptionHandler.handleException((Exception)((Object)e));
                return errorOccurred;
            }
            finally {
                wsRunCode.term();
            }
        } else {
            MessageUtil.displayMessage((String)bundle.getString("Error.ServerNeeded.txt"), (int)0);
            return true;
        }
    }

    public boolean onOK() {
        if (!Utilities.isConnectedToMetadataServer((boolean)true)) {
            return false;
        }
        this.centerPanel.stopCellEditing();
        if (!this.centerPanel.validateNames()) {
            return false;
        }
        if (this.olapCube.physicallyExists()) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            OLAPList aggregationsToAdd = this.olapCube.getAggregationSet().getAddedAggregations();
            OLAPList aggregationsToDrop = this.olapCube.getAggregationSet().getDroppedAggregations();
            if (aggregationsToAdd.isEmpty() && aggregationsToDrop.isEmpty()) {
                String msg = bundle.getString("SaveAndBuild.NoSaveBuild.txt");
                String title = bundle.getString("SaveAndBuild.window.title");
                MessageUtil.displayMessage((String)msg, (String)title);
                this.setCursor(Cursor.getPredefinedCursor(0));
                return false;
            }
            boolean errorOccurred = this.saveMetadataUpdateCube();
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (!errorOccurred & (aggregationsToAdd.size() > 0 | aggregationsToDrop.size() > 0)) {
                MessageUtil.displayMessage((String)bundle.getString("Aggregations.UpdatesCompleted.txt"), (int)1);
            } else if (errorOccurred) {
                return false;
            }
        } else {
            MessageUtil.displayMessage((String)bundle.getString("Aggregations.NoPhysicalCube.txt"), (int)1);
        }
        return true;
    }
}

