/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.aggregation;

import com.sas.olapadmin.aggregation.AggregationItem;
import com.sas.olapadmin.aggregation.AggregationTuningModel;
import com.sas.olapadmin.aggregation.AggregationTuningModelException;
import com.sas.olapadmin.aggregation.AggregationsDisplayInterface;
import com.sas.olapadmin.aggregation.AnalysisRecommendDialog;
import com.sas.olapadmin.aggregation.SelectHierarchiesPanel;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;

public class AggregationsCardinalityPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    static WAdminResource bundle = new WAdminResource(AggregationsCardinalityPanel.class);
    OLAPCube cube;
    JButton addButton;
    private JLabel instruction;
    AggregationTuningModel aggregationTuningModel;
    Vector generatedAggregations;
    OLAPAggregation aggregation;
    private static final int MAX_AGGREGATIONS = 100;
    AggregationsDisplayInterface resultsDisplayObject;
    int degreeOfCardinality;
    AggregationsCardinalityPanel parent;

    public AggregationsCardinalityPanel(OLAPCube olapCube) {
        this.cube = olapCube;
        this.parent = this;
        this.initialize();
    }

    protected void initialize() {
        this.generatedAggregations = new Vector();
        this.aggregationTuningModel = new AggregationTuningModel(this.cube);
        this.setLayout(new GridBagLayout());
        this.addButton = new JButton();
        this.addButton.setEnabled(true);
        VisualUtilities.setButtonTextAndMnemonic(this.addButton, bundle.getString("Aggregations.Cardinality.Add.action.label"));
        this.addButton.setToolTipText(bundle.getString("Aggregations.Cardinality.Add.action.tip"));
        this.addButton.addActionListener(new AddActionListener());
        WAPanel manualPanel = new WAPanel();
        manualPanel.setLayout((LayoutManager)new GridBagLayout());
        this.instruction = new JLabel(bundle.getString("Aggregations.Cardinality.txt"));
        manualPanel.add((Component)this.instruction, (Object)new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 16, 2, new Insets(0, 0, 0, 0), 0, 0));
        manualPanel.add((Component)this.addButton, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)manualPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public List processAggregationItem(AggregationItem aggregationItem, List newAggregationsList) {
        boolean isAggregationInNewAggrsList = false;
        try {
            boolean aggregationInTable = this.resultsDisplayObject.isDuplicateAggregation(aggregationItem);
            isAggregationInNewAggrsList = this.aggregationTuningModel.isOLAPAggregationInList(newAggregationsList, aggregationItem);
            if (!aggregationInTable & !isAggregationInNewAggrsList) {
                this.aggregation = this.aggregationTuningModel.createAggregation(aggregationItem);
                newAggregationsList.add(this.aggregation);
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        return newAggregationsList;
    }

    public void setAnalysisDisplay(AggregationsDisplayInterface displayObject) {
        this.resultsDisplayObject = displayObject;
    }

    class AddActionListener
    implements ActionListener {
        List newListWithTimeProcessed;

        AddActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            AggregationsCardinalityPanel.this.resultsDisplayObject.stopCellEditing();
            try {
                Vector hierarchies = new Vector();
                List dimensionList = AggregationsCardinalityPanel.this.cube.getDimensionSet().getAllCubeDimensions();
                for (OLAPDimension dimension : dimensionList) {
                    OLAPList dimHiers;
                    if (dimension.isTime() || (dimHiers = dimension.getHierarchies()).size() <= 0) continue;
                    Iterator dimHiersIterator = dimHiers.iterator();
                    while (dimHiersIterator.hasNext()) {
                        hierarchies.addElement(dimHiersIterator.next());
                    }
                }
                if (hierarchies.size() > 8) {
                    SelectHierarchiesPanel panel = new SelectHierarchiesPanel(AggregationsCardinalityPanel.this.cube);
                    WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("SelectHierarchies.window.title"), true, (WAPanel)panel);
                    dialog.setResizable(true);
                    dialog.show();
                    if (dialog.getReturnValue() == 1) {
                        hierarchies = panel.getHierarchies();
                    } else {
                        return;
                    }
                }
                AggregationsCardinalityPanel.this.parent.setCursor(Cursor.getPredefinedCursor(3));
                AggregationsCardinalityPanel.this.degreeOfCardinality = 2;
                AggregationsCardinalityPanel.this.generatedAggregations = AggregationsCardinalityPanel.this.aggregationTuningModel.generateCardinalityBasedAggregations(AggregationsCardinalityPanel.this.generatedAggregations, AggregationsCardinalityPanel.this.degreeOfCardinality, hierarchies);
                this.newListWithTimeProcessed = new ArrayList(AggregationsCardinalityPanel.this.generatedAggregations);
                this.newListWithTimeProcessed = AggregationsCardinalityPanel.this.aggregationTuningModel.appendTimeDimensions(this.newListWithTimeProcessed);
            }
            catch (AggregationTuningModelException e2) {
                AggregationsCardinalityPanel.this.parent.setCursor(Cursor.getPredefinedCursor(0));
                ExceptionHandler.handleException((Exception)((Object)new OLAPException(bundle.getString("Aggregations.Cardinality.Error.txt"), (Throwable)e2, 12)));
            }
            catch (OLAPException e) {
                e.printStackTrace();
            }
            if (this.newListWithTimeProcessed.isEmpty()) {
                MessageUtil.displayMessage((String)bundle.getString("Aggregations.Cardinality.NoAggregationsToAdd.txt"), (int)1);
            } else {
                AggregationItem aggregationItem;
                int i;
                ArrayList newList = new ArrayList();
                if (this.newListWithTimeProcessed.size() > 100) {
                    int numberToProcess = 100;
                    while (newList.size() < numberToProcess & i < this.newListWithTimeProcessed.size()) {
                        aggregationItem = (AggregationItem)this.newListWithTimeProcessed.get(i);
                        AggregationsCardinalityPanel.this.parent.processAggregationItem(aggregationItem, newList);
                        ++i;
                    }
                } else {
                    int numberToProcess = AggregationsCardinalityPanel.this.generatedAggregations.size();
                    for (i = 0; i < numberToProcess - 1; ++i) {
                        aggregationItem = (AggregationItem)this.newListWithTimeProcessed.get(i);
                        AggregationsCardinalityPanel.this.parent.processAggregationItem(aggregationItem, newList);
                    }
                }
                if (newList.size() > 0) {
                    List selectedAggregations;
                    AnalysisRecommendDialog recommendDialog = new AnalysisRecommendDialog(Workspace.getWorkspace(), bundle.getString("AnalysisRecommend.window.title"), AggregationsCardinalityPanel.this.cube, newList, 1);
                    recommendDialog.show();
                    if (!recommendDialog.isCancelled() && (selectedAggregations = recommendDialog.getSelectedAggregations()) != null && selectedAggregations.size() > 0) {
                        AggregationsCardinalityPanel.this.resultsDisplayObject.addAggregations(selectedAggregations, 2);
                        AggregationsCardinalityPanel.this.resultsDisplayObject.scrollDown();
                        AggregationsCardinalityPanel.this.resultsDisplayObject.enableDisableExportAndBuild();
                    }
                } else {
                    MessageUtil.displayMessage((String)bundle.getString("Aggregations.Cardinality.NoAdditional.txt"), (int)1);
                }
                if (AggregationsCardinalityPanel.this.cube.getAggregationSet().getAddedAggregations().size() > 98) {
                    AggregationsCardinalityPanel.this.addButton.setEnabled(false);
                } else {
                    AggregationsCardinalityPanel.this.addButton.setEnabled(true);
                }
            }
            AggregationsCardinalityPanel.this.parent.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

