/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.aggregation;

import com.sas.olapadmin.aggregation.AggregationItem;
import com.sas.olapadmin.aggregation.AggregationTuningModelException;
import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.utilities.ExceptionHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class AggregationTuningModel {
    private Vector hList;
    private OLAPCube olapCube;
    private OLAPList existingAggregations;

    public AggregationTuningModel(OLAPCube cube) {
        this.olapCube = cube;
    }

    public int getLargestHierarchyDepth() throws OLAPException {
        int largestDepth = 0;
        int depth = 0;
        OLAPList hierarchies = this.olapCube.getDimensionSet().getHierarchies();
        for (int n = 0; n < hierarchies.size(); ++n) {
            OLAPHierarchy hierarchy = (OLAPHierarchy)hierarchies.get(n);
            depth = hierarchy.getLevels().size();
            if (depth <= largestDepth) continue;
            largestDepth = depth;
        }
        return largestDepth;
    }

    private Map CardinalityOptimizer(int stairDepth, List hierarchiesToProcess) throws AggregationTuningModelException {
        HashMap cardinalityMap = new HashMap();
        HashMap<String, Vector> stairsByHierarchyMap = new HashMap<String, Vector>();
        HashMap avgChildrenPerStairByHierMap = new HashMap();
        HashMap avgChildrenIndexStairByHierMap = new HashMap();
        Vector<Vector> revisedStairStepList = new Vector<Vector>();
        HashMap<String, Vector> revisedStairMap = new HashMap<String, Vector>();
        try {
            int i;
            String hierName;
            OLAPHierarchy hierarchyForCard;
            List hierarchiesForCard = hierarchiesToProcess;
            for (int i2 = 0; i2 < hierarchiesForCard.size(); ++i2) {
                hierarchyForCard = (OLAPHierarchy)hierarchiesForCard.get(i2);
                OLAPList levelsForCard = hierarchyForCard.getLevels();
                ArrayList<Integer> cardinalityList = new ArrayList<Integer>();
                for (int m = 0; m < levelsForCard.size(); ++m) {
                    OLAPLevel levelForCard = (OLAPLevel)levelsForCard.get(m);
                    Integer levelCardinality = new Integer(levelForCard.getCardinality());
                    cardinalityList.add(levelCardinality);
                }
                cardinalityMap.put(hierarchyForCard.getName(), cardinalityList);
            }
            for (int n = 0; n < hierarchiesForCard.size(); ++n) {
                hierarchyForCard = (OLAPHierarchy)hierarchiesForCard.get(n);
                hierName = hierarchyForCard.getName();
                try {
                    Vector hierarchyStairs = this.Stairstep(hierarchyForCard, 0);
                    stairsByHierarchyMap.put(hierName, hierarchyStairs);
                    ArrayList cardinalityListForHierarchy = (ArrayList)cardinalityMap.get(hierName);
                    int maxLevelsInStair = hierarchyForCard.getLevels().size();
                    ArrayList<Double> avgChildrenPerStairList = new ArrayList<Double>();
                    HashMap avgChildrenIndexStairMap = new HashMap();
                    double increment = 0.01;
                    for (int p = 0; p < hierarchyStairs.size() - 1; ++p) {
                        double avgNumChildren;
                        int index = maxLevelsInStair - 1;
                        if (p == 0) {
                            avgNumChildren = 0.0;
                        } else {
                            Integer childCardinality = (Integer)cardinalityListForHierarchy.get(index + 1);
                            Integer currentCardinality = (Integer)cardinalityListForHierarchy.get(index);
                            avgNumChildren = childCardinality / currentCardinality;
                        }
                        if (avgChildrenIndexStairMap.containsKey(new Double(avgNumChildren))) {
                            double newavgChildren = avgNumChildren + increment;
                            increment += 0.01;
                            avgChildrenPerStairList.add(p, new Double(newavgChildren));
                            avgChildrenIndexStairMap.put(new Double(newavgChildren), hierarchyStairs.get(p));
                        } else {
                            avgChildrenPerStairList.add(p, new Double(avgNumChildren));
                            avgChildrenIndexStairMap.put(new Double(avgNumChildren), hierarchyStairs.get(p));
                        }
                        --maxLevelsInStair;
                    }
                    Collections.sort(avgChildrenPerStairList);
                    avgChildrenPerStairByHierMap.put(hierName, avgChildrenPerStairList);
                    avgChildrenIndexStairByHierMap.put(hierName, avgChildrenIndexStairMap);
                    continue;
                }
                catch (AggregationTuningModelException e1) {
                    throw new AggregationTuningModelException(e1.getLocalizedMessage());
                }
            }
            for (int currentRank = 0; currentRank < stairDepth; ++currentRank) {
                for (i = 0; i < hierarchiesForCard.size(); ++i) {
                    Vector stairList;
                    hierarchyForCard = (OLAPHierarchy)hierarchiesForCard.get(i);
                    hierName = hierarchyForCard.getName();
                    Map hierStairsByavgChildren = (Map)avgChildrenIndexStairByHierMap.get(hierName);
                    Vector sortedAvgChildren = new Vector(hierStairsByavgChildren.keySet());
                    Collections.sort(sortedAvgChildren);
                    Collections.reverse(sortedAvgChildren);
                    if (currentRank >= hierStairsByavgChildren.size()) continue;
                    Vector stair = (Vector)hierStairsByavgChildren.get(sortedAvgChildren.get(currentRank));
                    revisedStairStepList.add(stair);
                    if (revisedStairMap.containsKey(hierName)) {
                        stairList = (Vector)revisedStairMap.get(hierName);
                        stairList.add(stair);
                        revisedStairMap.put(hierName, stairList);
                        continue;
                    }
                    stairList = new Vector();
                    stairList.add(stair);
                    revisedStairMap.put(hierName, stairList);
                }
            }
            for (i = 0; i < hierarchiesForCard.size(); ++i) {
                hierarchyForCard = (OLAPHierarchy)hierarchiesForCard.get(i);
                hierName = hierarchyForCard.getName();
                List stairList = (List)revisedStairMap.get(hierName);
                Vector<Object> nullPlaceholder = new Vector<Object>();
                nullPlaceholder.add(null);
                stairList.add(nullPlaceholder);
            }
        }
        catch (OLAPException e1) {
            throw new AggregationTuningModelException(e1.getLocalizedMessage());
        }
        return revisedStairMap;
    }

    private Vector Stairstep(OLAPHierarchy hierarchy, int spinNum) throws AggregationTuningModelException {
        try {
            int maxLevels;
            int levelsDepth;
            Vector<String> hierarchyStairs = new Vector<String>();
            this.hList = new Vector();
            OLAPList levels = hierarchy.getLevels();
            String hierItem = "";
            int actualDepth = levels.size();
            if (spinNum == 0) {
                levelsDepth = actualDepth;
                maxLevels = actualDepth;
            } else if (actualDepth < spinNum) {
                levelsDepth = actualDepth;
                maxLevels = actualDepth;
            } else {
                levelsDepth = spinNum;
                maxLevels = spinNum;
            }
            for (int k = 0; k < maxLevels; ++k) {
                Vector<OLAPLevel> levelList = new Vector<OLAPLevel>();
                for (int j = 0; j < levelsDepth; ++j) {
                    OLAPLevel level = (OLAPLevel)levels.get(j);
                    hierItem = hierItem.concat(level.toString()).concat(" ");
                    levelList.add(level);
                }
                hierarchyStairs.addElement(hierItem);
                this.hList.addElement(levelList);
                hierItem = "";
                --levelsDepth;
            }
            hierarchyStairs.addElement(null);
            Vector<Object> levelList = new Vector<Object>();
            levelList.add(null);
            this.hList.addElement(levelList);
        }
        catch (OLAPException e2) {
            throw new AggregationTuningModelException(e2.getLocalizedMessage());
        }
        return this.hList;
    }

    public Vector generateCardinalityBasedAggregations(Vector aggregationList, int degreeCardinality, Vector hierarchies) throws AggregationTuningModelException {
        return this.generateCrossDimensional(aggregationList, true, degreeCardinality, hierarchies);
    }

    public Vector generateCrossDimensionalAggregations(Vector aggregationList, int depthSelected) throws AggregationTuningModelException {
        return this.generateCrossDimensional(aggregationList, false, depthSelected, null);
    }

    private Vector generateCrossDimensional(Vector vectGenAggr, boolean cardinalityBased, int depthSelected, Vector hierarchies) throws AggregationTuningModelException {
        boolean doneFlag = false;
        HashMap<String, Integer> hierarchyResetNum = new HashMap<String, Integer>();
        HashMap<String, Integer> hierarchyPointer = new HashMap<String, Integer>();
        String hierName = "";
        vectGenAggr.clear();
        try {
            int reset;
            int counter;
            Vector hierarchyList;
            OLAPHierarchy hierarchy;
            int i;
            Map<String, Vector> hierarchyStairstep;
            if (hierarchies == null) {
                hierarchies = new Vector();
                List dimensionList = this.olapCube.getDimensionSet().getAllCubeDimensions();
                for (OLAPDimension dimension : dimensionList) {
                    OLAPList dimHiers;
                    if (dimension.isTime() || (dimHiers = dimension.getHierarchies()).size() <= 0) continue;
                    Iterator dimHiersIterator = dimHiers.iterator();
                    while (dimHiersIterator.hasNext()) {
                        hierarchies.addElement(dimHiersIterator.next());
                    }
                }
            }
            int hierSize = hierarchies.size();
            if (cardinalityBased) {
                hierarchyStairstep = this.CardinalityOptimizer(depthSelected, hierarchies);
                for (i = 0; i < hierarchyStairstep.size(); ++i) {
                    hierarchy = (OLAPHierarchy)hierarchies.elementAt(i);
                    hierName = hierarchy.getName();
                    hierarchyList = (Vector)hierarchyStairstep.get(hierName);
                    counter = 0;
                    hierarchyPointer.put(hierName, new Integer(counter));
                    reset = hierarchyList.size();
                    hierarchyResetNum.put(hierName, new Integer(reset));
                }
            } else {
                hierarchyStairstep = new HashMap();
                for (i = 0; i < hierSize; ++i) {
                    hierarchy = (OLAPHierarchy)hierarchies.elementAt(i);
                    hierName = hierarchy.getName();
                    hierarchyList = this.Stairstep(hierarchy, depthSelected);
                    hierarchyStairstep.put(hierName, hierarchyList);
                    counter = 0;
                    hierarchyPointer.put(hierName, new Integer(counter));
                    reset = hierarchyList.size();
                    hierarchyResetNum.put(hierName, new Integer(reset));
                }
            }
            String lastHierName = hierName;
            Vector<OLAPLevel> genAggrList = new Vector<OLAPLevel>();
            block7: while (!doneFlag) {
                int lastIndex;
                for (int i2 = 0; i2 < hierSize; ++i2) {
                    Integer p;
                    hierarchy = (OLAPHierarchy)hierarchies.elementAt(i2);
                    hierName = hierarchy.getName();
                    hierarchyList = (Vector)hierarchyStairstep.get(hierName);
                    Vector Item_list = (Vector)hierarchyList.get(p = (Integer)hierarchyPointer.get(hierName));
                    if (Item_list.elementAt(0) == null) continue;
                    for (int n = 0; n < Item_list.size(); ++n) {
                        OLAPLevel itemLevel = (OLAPLevel)Item_list.elementAt(n);
                        if (genAggrList.indexOf(itemLevel) != -1) continue;
                        genAggrList.add(itemLevel);
                    }
                }
                if (genAggrList.size() == 0 || vectGenAggr.size() >= 100000) {
                    doneFlag = true;
                    break;
                }
                AggregationItem aggrItem = new AggregationItem(genAggrList);
                vectGenAggr.addElement(aggrItem);
                genAggrList.clear();
                int lastPtr = Integer.parseInt(hierarchyPointer.get(lastHierName).toString());
                hierarchyPointer.put(lastHierName, new Integer(++lastPtr));
                for (int j = lastIndex = hierSize - 1; j >= 0; --j) {
                    int firstResetPtr;
                    int firstPtr;
                    hierarchy = (OLAPHierarchy)hierarchies.elementAt(j);
                    hierName = hierarchy.getName();
                    int resetPtr = Integer.parseInt(hierarchyResetNum.get(hierName).toString());
                    int ptr = Integer.parseInt(hierarchyPointer.get(hierName).toString());
                    if (ptr == resetPtr) {
                        hierarchyPointer.put(hierName, new Integer(0));
                        hierarchy = (OLAPHierarchy)hierarchies.elementAt(j - 1);
                        hierName = hierarchy.getName();
                        ptr = Integer.parseInt(hierarchyPointer.get(hierName).toString());
                        hierarchyPointer.put(hierName, new Integer(++ptr));
                    }
                    if (j != 0 || (firstPtr = Integer.parseInt(hierarchyPointer.get(hierName = (hierarchy = (OLAPHierarchy)hierarchies.elementAt(0)).getName()).toString())) != (firstResetPtr = Integer.parseInt(hierarchyResetNum.get(hierName).toString()))) continue;
                    doneFlag = true;
                    continue block7;
                }
            }
        }
        catch (OLAPException e) {
            throw new AggregationTuningModelException(e.getLocalizedMessage());
        }
        catch (AggregationTuningModelException e) {
            throw new AggregationTuningModelException(e.getLocalizedMessage());
        }
        return vectGenAggr;
    }

    public List appendTimeDimensions(List newListWithTimeProcessed) throws AggregationTuningModelException {
        try {
            List dimensionList = this.olapCube.getDimensionSet().getAllCubeDimensions();
            for (OLAPDimension dimension : dimensionList) {
                if (!dimension.isTime()) continue;
                OLAPList timeHierarchies = dimension.getHierarchies();
                OLAPHierarchy timeHierarchy = timeHierarchies.size() > 0 ? dimension.getDefault() : (OLAPHierarchy)timeHierarchies.get(0);
                OLAPList levels = timeHierarchy.getLevels();
                OLAPLevel firstLevel = (OLAPLevel)levels.get(0);
                OLAPLevel secondLevel = null;
                if (levels.size() > 1) {
                    secondLevel = (OLAPLevel)levels.get(1);
                }
                for (AggregationItem aggregationItem : newListWithTimeProcessed) {
                    Vector aggregationLevels = aggregationItem.getAggrLevels();
                    aggregationLevels.add(firstLevel);
                    if (secondLevel == null) continue;
                    aggregationLevels.add(secondLevel);
                }
            }
        }
        catch (Exception e) {
            throw new AggregationTuningModelException(e.getLocalizedMessage());
        }
        return newListWithTimeProcessed;
    }

    public OLAPAggregation createAggregation(AggregationItem aggrItem) throws OLAPException {
        AggregationSet aggregationSet = this.olapCube.getAggregationSet();
        OLAPAggregation aggregation = null;
        try {
            aggregation = aggregationSet.createOLAPAggregation();
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        String aggrname = this.createUniqueAggregationName();
        aggregation.setName(aggrname);
        aggregation.setDesc(aggrItem.toString());
        Vector aggrItemLevels = aggrItem.getAggrLevels();
        OLAPList aggrLevels = null;
        try {
            aggrLevels = aggregation.getLevels();
        }
        catch (OLAPException e1) {
            ExceptionHandler.handleException((Exception)((Object)e1));
        }
        for (int p = 0; p < aggrItemLevels.size(); ++p) {
            Vector levelList = aggrItemLevels;
            if (levelList.elementAt(0) == null) continue;
            OLAPLevel level = (OLAPLevel)levelList.elementAt(p);
            aggrLevels.add((Object)level);
        }
        try {
            aggregation.setType("MOLAP");
            Double time = new Double(aggrItem.getTime());
            aggregation.setTime(time);
            int countValue = aggrItem.getCount();
            if (countValue != 0) {
                aggregation.setCount(new Integer(countValue));
            }
        }
        catch (OLAPException e2) {
            ExceptionHandler.handleException((Exception)((Object)e2));
        }
        return aggregation;
    }

    public String createUniqueAggregationName() throws OLAPException {
        String uniqueName = "";
        this.existingAggregations = this.olapCube.getAggregationSet().getAggregations();
        int aggrCounter = this.existingAggregations.size();
        String counterNumber = new Integer(++aggrCounter).toString();
        uniqueName = uniqueName.concat("AGGR").concat(counterNumber);
        while (!this.uniqueAggregationNameVerified(uniqueName)) {
            uniqueName = "";
            uniqueName = uniqueName.concat("AGGR").concat(new Integer(++aggrCounter).toString());
        }
        return uniqueName;
    }

    public boolean uniqueAggregationNameVerified(String name) {
        OLAPAggregation aggregation;
        boolean unique = true;
        for (int i = 0; i < this.existingAggregations.size(); ++i) {
            aggregation = (OLAPAggregation)this.existingAggregations.get(i);
            if (!aggregation.getName().equalsIgnoreCase(name)) continue;
            unique = false;
            break;
        }
        if (unique) {
            OLAPList aggregationsToDrop = this.olapCube.getAggregationSet().getDroppedAggregations();
            for (int i = 0; i < aggregationsToDrop.size(); ++i) {
                aggregation = (OLAPAggregation)aggregationsToDrop.get(i);
                if (!aggregation.getName().equalsIgnoreCase(name)) continue;
                unique = false;
                break;
            }
        }
        return unique;
    }

    public boolean isAggregationToBeAddedOrDropped() {
        OLAPAggregation olapAggregation;
        boolean isNewOrDrop = false;
        OLAPList aggregationsToAdd = this.olapCube.getAggregationSet().getAddedAggregations();
        for (int i = 0; i < aggregationsToAdd.size() && !(isNewOrDrop = (olapAggregation = (OLAPAggregation)aggregationsToAdd.get(i)).isNewObject()); ++i) {
        }
        OLAPList aggregationsToDrop = this.olapCube.getAggregationSet().getDroppedAggregations();
        for (int i = 0; i < aggregationsToDrop.size() && !(isNewOrDrop = (olapAggregation = (OLAPAggregation)aggregationsToDrop.get(i)).isDropped()); ++i) {
        }
        return isNewOrDrop;
    }

    public boolean isOLAPAggregationInList(List listToCheck, AggregationItem aggrToVerify) throws OLAPException {
        boolean dupFlag = false;
        if (listToCheck.isEmpty()) {
            return false;
        }
        Vector aggrToVerify_levels = aggrToVerify.getAggrLevels();
        for (int k = 0; k < listToCheck.size(); ++k) {
            OLAPAggregation listToCheck_aggr = (OLAPAggregation)listToCheck.get(k);
            OLAPList listToCheckAggr_levels = listToCheck_aggr.getLevels();
            boolean match_level = true;
            if (aggrToVerify_levels.size() != listToCheckAggr_levels.size()) {
                match_level = false;
            } else {
                for (int m = 0; m < listToCheckAggr_levels.size(); ++m) {
                    OLAPLevel level = (OLAPLevel)listToCheckAggr_levels.get(m);
                    if (aggrToVerify_levels.contains(level)) continue;
                    match_level = false;
                }
            }
            if (!match_level) continue;
            dupFlag = true;
            break;
        }
        return dupFlag;
    }
}

