/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.aggregation;

import com.sas.olapadmin.aggregation.AggregationItem;
import com.sas.olapadmin.aggregation.AggregationsARMLogPanel;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.tools.armreader.Analyzer;
import com.sas.tools.armreader.ArmReaderException;
import com.sas.tools.armreader.Transaction;
import com.sas.tools.armreader.TransactionComparator;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class ARM_Analyzer
implements Runnable {
    private static WAdminResource bundle = new WAdminResource(AggregationsARMLogPanel.class);
    public boolean returnValue = true;
    private Transaction[] completedTransactions = null;
    private final Analyzer analyzer;
    private String cName;
    private File iFile;
    private int maxHierarchyLevels;
    private HashMap hierarchyLevels;
    private String hierName;
    private OLAPLevel level;
    private OLAPHierarchy hier;
    private OLAPList levels;
    private Vector generatedAggregations;

    public ARM_Analyzer(OLAPCube olapCube, File inputFile) throws OLAPException {
        this.cName = olapCube.getName();
        this.iFile = inputFile;
        this.analyzer = new Analyzer();
        this.analyzer.setCharsetName("UTF-8");
        this.generatedAggregations = new Vector();
        this.maxHierarchyLevels = 0;
        this.hierarchyLevels = new HashMap();
        OLAPList hierarchies = olapCube.getDimensionSet().getHierarchies();
        for (int i = 0; i < hierarchies.size(); ++i) {
            this.hier = (OLAPHierarchy)hierarchies.get(i);
            this.hierName = this.hier.getName();
            this.levels = this.hier.getLevels();
            Vector<OLAPLevel> hierLevels = new Vector<OLAPLevel>();
            int hierLevelSize = this.levels.size();
            if (hierLevelSize > this.maxHierarchyLevels) {
                this.maxHierarchyLevels = hierLevelSize;
            }
            for (int p = 0; p < hierLevelSize; ++p) {
                this.level = (OLAPLevel)this.levels.get(p);
                hierLevels.add(p, this.level);
            }
            this.hierarchyLevels.put(this.hierName, hierLevels);
        }
    }

    @Override
    public void run() {
        this.analyzer.setCubeName(this.cName);
        this.analyzer.setInputFile(this.iFile);
        try {
            this.analyzer.doit(null);
        }
        catch (IOException e1) {
            MessageUtil.displayMessage((String)bundle.getString("Error.IO.txt"), (int)0);
            this.returnValue = false;
            return;
        }
        catch (ArmReaderException e2) {
            MessageUtil.displayDetailsMessage((String)bundle.getString("Error.AnalyzingLog.txt"), (int)0, (String)e2.getLocalizedMessage());
            this.returnValue = false;
            return;
        }
        this.completedTransactions = this.analyzer.getCompletedTransactions();
    }

    public Transaction[] getCompletedTransactions() {
        return this.completedTransactions;
    }

    public boolean getReturnValue() {
        return this.returnValue;
    }

    public Vector processAnalyzerResults(Transaction[] completedTransactions) {
        ArrayList<Transaction> aList = new ArrayList<Transaction>(Arrays.asList(completedTransactions));
        Collections.sort(aList, TransactionComparator.byOccurrences);
        int transactionLength = completedTransactions.length;
        this.generatedAggregations.clear();
        block0: for (int i = 0; i < transactionLength; ++i) {
            Transaction transaction = aList.get(i);
            Map levelsMap = transaction.getRegionLevelsMap();
            if (levelsMap.isEmpty()) continue;
            double walltime = transaction.getWallTime();
            int occurrence = transaction.getOccurrences();
            Vector<OLAPLevel> aggrList = new Vector<OLAPLevel>();
            ArrayList region = new ArrayList(levelsMap.entrySet());
            aggrList.clear();
            for (int r = 0; r < region.size(); ++r) {
                Vector armHierLevels;
                int metadataHierSize;
                Map.Entry reg = region.get(r);
                String hierName = (String)reg.getKey();
                if (!this.hierarchyLevels.containsKey(hierName)) continue block0;
                Integer hierDepth = (Integer)reg.getValue();
                int hierDepthNum = hierDepth;
                if (hierDepthNum > (metadataHierSize = (armHierLevels = (Vector)this.hierarchyLevels.get(hierName)).size())) {
                    hierDepthNum = metadataHierSize;
                }
                for (int j = 0; j < hierDepthNum; ++j) {
                    this.level = (OLAPLevel)armHierLevels.get(j);
                    if (aggrList.indexOf(this.level) != -1) continue;
                    aggrList.addElement(this.level);
                }
            }
            Collections.sort(aggrList);
            boolean genAggrFound = false;
            for (int genNum = 0; genNum < this.generatedAggregations.size() && !genAggrFound; ++genNum) {
                AggregationItem item = (AggregationItem)this.generatedAggregations.elementAt(genNum);
                Vector genLevels = item.getAggrLevels();
                Collections.sort(genLevels);
                genAggrFound = aggrList.equals(genLevels);
            }
            int aggrList_size = aggrList.size();
            if (aggrList_size == 0 || genAggrFound) continue;
            AggregationItem aggrItem = new AggregationItem(aggrList);
            aggrItem.setCount(occurrence);
            aggrItem.setTime(walltime);
            this.generatedAggregations.add(aggrItem);
        }
        return this.generatedAggregations;
    }

    public Vector processAnalyzerResultsForStatistics(Transaction[] completedTransactions) {
        ArrayList<Transaction> aList = new ArrayList<Transaction>(Arrays.asList(completedTransactions));
        Collections.sort(aList, TransactionComparator.byOccurrences);
        int transactionLength = completedTransactions.length;
        this.generatedAggregations.clear();
        block0: for (int i = 0; i < transactionLength; ++i) {
            Transaction transaction = aList.get(i);
            Map levelsMap = transaction.getRegionLevelsMap();
            if (levelsMap.isEmpty()) continue;
            double walltime = transaction.getWallTime();
            int occurrence = transaction.getOccurrences();
            Vector<OLAPLevel> aggrList = new Vector<OLAPLevel>();
            ArrayList region = new ArrayList(levelsMap.entrySet());
            aggrList.clear();
            for (int r = 0; r < region.size(); ++r) {
                Vector armHierLevels;
                int metadataHierSize;
                Map.Entry reg = region.get(r);
                this.hierName = (String)reg.getKey();
                if (!this.hierarchyLevels.containsKey(this.hierName)) continue block0;
                Integer hierDepth = (Integer)reg.getValue();
                int hierDepthNum = hierDepth;
                if (hierDepthNum > (metadataHierSize = (armHierLevels = (Vector)this.hierarchyLevels.get(this.hierName)).size())) {
                    hierDepthNum = metadataHierSize;
                }
                for (int j = 0; j < hierDepthNum; ++j) {
                    this.level = (OLAPLevel)armHierLevels.get(j);
                    if (aggrList.indexOf(this.level) != -1) continue;
                    aggrList.addElement(this.level);
                }
            }
            int aggrList_size = aggrList.size();
            if (aggrList_size == 0) continue;
            AggregationItem aggrItem = new AggregationItem(aggrList);
            aggrItem.setCount(occurrence);
            aggrItem.setTime(walltime);
            this.generatedAggregations.add(aggrItem);
        }
        return this.generatedAggregations;
    }
}

