/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.visuals.UpgradeLogicalObjectVersionUI;
import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.actions.AbstractSelectionAction;
import com.sas.visuals.Resources;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractApplicationActionsManager;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.models.SimpleObject;
import java.rmi.RemoteException;

public class UpgradeMetadataObjectAction
extends AbstractSelectionAction {
    private static final long serialVersionUID = 4972104012965636926L;
    private static final WAdminResource bundle = WAdminResource.getBundle(UpgradeMetadataObjectAction.class);

    public UpgradeMetadataObjectAction() {
        super(bundle, "OLAPActionsManager.ContextAction.UpgradeMetadataObject", 257);
        this.putValue("SmallIcon", Resources.getImageIcon((String)"UpgradeMetadata.gif", (int)16));
        this.setHidable(true);
    }

    @Override
    protected void actionPerformed(Object[] selectedObjects) {
        WsSelectionProvider selectionProvider;
        LogicalObjectInterface[] los = null;
        try {
            los = ObjectConverter.getInstance().convertToLogicalObjects(selectedObjects);
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (LogicalTypeException e) {
            Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        UpgradeLogicalObjectVersionUI ui = new UpgradeLogicalObjectVersionUI();
        ui.executeLogicalVersionUpgrade(los);
        WsAbstractApplicationActionsManager actionsMgr = WsAbstractApplicationActionsManager.getInstance();
        if (actionsMgr != null && (selectionProvider = actionsMgr.getSelectionProvider()) != null) {
            Object[] aSelectedObjects = selectionProvider.getSelectedObjects();
            if (this.isSelectionCompatible(aSelectedObjects) || this.isEnabledForIncompatibleObjects()) {
                this.setEnabled(this.isSelectionValid(aSelectedObjects));
            } else {
                this.setEnabled(false);
            }
            return;
        }
        this.setEnabled(false);
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        if (selectedObjects.length == 0) {
            return false;
        }
        for (int iObject = 0; iObject < selectedObjects.length; ++iObject) {
            if (!(selectedObjects[iObject] instanceof SimpleObject)) {
                return false;
            }
            SimpleObject sObject = (SimpleObject)selectedObjects[iObject];
            if (this.m_validator.isUpgradeable(sObject)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidForContext(WsActionContextInterface context) {
        boolean ret_val = true;
        Object[] aObjects = context.getSelectedObjects();
        if (aObjects.length == 0) {
            ret_val = false;
        } else {
            for (int iObject = 0; iObject < aObjects.length; ++iObject) {
                if (!(aObjects[iObject] instanceof SimpleObject)) {
                    ret_val = false;
                    break;
                }
                SimpleObject sObject = (SimpleObject)aObjects[iObject];
                if (!this.m_validator.isSupportedForVersioning(sObject)) {
                    ret_val = false;
                    break;
                }
                if (this.m_validator.isVersionSupported(sObject)) {
                    ret_val = false;
                    break;
                }
                if (this.m_validator.isUpgradeable(sObject)) continue;
                ret_val = false;
                break;
            }
        }
        this.setEnabled(ret_val);
        return ret_val;
    }

    @Override
    protected boolean isEnabledForIncompatibleObjects() {
        return true;
    }
}

