/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.SharedDimension;
import com.sas.olapadmin.actions.AbstractSharedDimensionSelectionAction;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.update.SharedDimUpdateDesigner;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.swing.visuals.util.Util;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleObject;
import java.awt.Cursor;
import java.awt.Frame;
import java.rmi.RemoteException;

public class UpdateSharedDimensionAction
extends AbstractSharedDimensionSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(UpdateSharedDimensionAction.class);
    public static final int INPLACE = 0;
    public static final int COPY = 1;
    private int type;

    public UpdateSharedDimensionAction(int inType) {
        super(bundle, "SharedDimension.Update.InPlace", 257);
        this.type = inType;
        if (this.type == 1) {
            String text = bundle.getString("SharedDimension.Update.NewGen.txt");
            int cMnem = Util.getDisplayedMnemonic((String)text);
            int iMnem = Util.getDisplayedMnemonicIndex((String)text);
            text = Util.getLabelWithoutMnemonic((String)text);
            this.setText(text);
            this.putValue("MnemonicKey", new Integer(cMnem));
            this.putValue("MnemonicIndex", new Integer(iMnem));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            UpdateSharedDimensionAction.clearCurrentObject();
            if (this.isSelectionValid(aSelectedObjects)) {
                Workspace workspace = Workspace.getWorkspace();
                MdObjectStore store = null;
                try {
                    store = Workspace.getMdFactory().createObjectStore(null, "UpdateSharedDimensionAction");
                    SimpleObject obj = (SimpleObject)aSelectedObjects[0];
                    SharedDimension dim = (SharedDimension)ObjectConverter.getInstance().convertToJOMAObject(store, obj);
                    workspace.setCursor(Cursor.getPredefinedCursor(3));
                    OLAPSharedDimension olapDim = new OLAPSharedDimension(dim);
                    workspace.setCursor(Cursor.getPredefinedCursor(0));
                    if (olapDim.getErrorLevel() != -1) {
                        MessageUtil.displayDetailsMessage((String)bundle.getString("SharedDimension.MetadataChanges.txt"), (int)2, (String)olapDim.getVerifyMessage().toString());
                    }
                    SharedDimUpdateDesigner wasdimdlg = new SharedDimUpdateDesigner((Frame)workspace, bundle.formatString("SharedDimensionUpdate.NewGen.window.title.fmt.txt", (Object)olapDim.getName()), olapDim);
                    wasdimdlg.show();
                }
                catch (OLAPException error) {
                    ExceptionHandler.handleException((Exception)((Object)error));
                }
                catch (RemoteException error) {
                    ExceptionHandler.handleException((Exception)error);
                }
                catch (MdException error) {
                    ExceptionHandler.handleException((Exception)((Object)error));
                }
                finally {
                    workspace.setCursor(Cursor.getPredefinedCursor(0));
                    try {
                        if (store != null) {
                            store.dispose();
                        }
                    }
                    catch (RemoteException error) {}
                }
            }
        } else {
            MessageUtil.displayMessage((String)bundle.getString("Action.NoPermissions.txt"));
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        boolean selectionOk = super.isSelectionValid(selectedObjects);
        if (selectionOk) {
            AbstractSharedDimensionSelectionAction.getSharedDimensionPermissions((SimpleObject)selectedObjects[0]);
            selectionOk = canWriteAllDim & canReadAllDim & exists;
        }
        return selectionOk;
    }
}

