/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.SharedDimension;
import com.sas.olapadmin.actions.AbstractSharedDimensionSelectionAction;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.update.QuickEditSharedDimensionDialog;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleObject;
import java.awt.Cursor;
import java.awt.Frame;
import java.rmi.RemoteException;

public class SharedDimensionQuickEditAction
extends AbstractSharedDimensionSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(SharedDimensionQuickEditAction.class);

    public SharedDimensionQuickEditAction() {
        super(bundle, "SharedDimension.QEdit", 1);
        this.mustExist = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            SharedDimensionQuickEditAction.clearCurrentObject();
            if (this.isSelectionValid(aSelectedObjects)) {
                Workspace workspace = Workspace.getWorkspace();
                MdObjectStore store = null;
                try {
                    store = Workspace.getMdFactory().createObjectStore(null, "SharedDimensionQuickEdit");
                    SimpleObject obj = (SimpleObject)aSelectedObjects[0];
                    SharedDimension dimension = (SharedDimension)ObjectConverter.getInstance().convertToJOMAObject(store, obj);
                    workspace.setCursor(Cursor.getPredefinedCursor(3));
                    OLAPSharedDimension olapDim = new OLAPSharedDimension(dimension);
                    workspace.setCursor(Cursor.getPredefinedCursor(0));
                    if (olapDim.getErrorLevel() != -1) {
                        MessageUtil.displayDetailsMessage((String)bundle.getString("Cube.MetadataChanges.txt"), (int)2, (String)olapDim.getVerifyMessage().toString());
                    }
                    QuickEditSharedDimensionDialog dialog = new QuickEditSharedDimensionDialog((Frame)workspace, bundle.getString("CubeUpdateCaptions.window.title"), true, olapDim);
                    dialog.setResizable(true);
                    dialog.show();
                }
                catch (OLAPException error) {
                    ExceptionHandler.handleException((Exception)((Object)error));
                }
                catch (RemoteException error) {
                    ExceptionHandler.handleException((Exception)error);
                }
                catch (MdException error) {
                    ExceptionHandler.handleException((Exception)((Object)error));
                }
                finally {
                    workspace.setCursor(Cursor.getPredefinedCursor(0));
                    try {
                        if (store != null) {
                            store.dispose();
                        }
                    }
                    catch (RemoteException error) {}
                }
            } else {
                MessageUtil.displayMessage((String)bundle.getString("Action.NoPermissions.txt"));
            }
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        boolean selectionOk = super.isSelectionValid(selectedObjects);
        if (selectionOk) {
            AbstractSharedDimensionSelectionAction.getSharedDimensionPermissions((SimpleObject)selectedObjects[0]);
            selectionOk = canWriteAllDim & canReadAllDim & exists;
        }
        return selectionOk;
    }
}

