/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.olapadmin.actions.AbstractCubeSelectionAction;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OlapServer;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleObject;
import java.awt.Cursor;
import java.rmi.RemoteException;
import java.util.List;

public class RefreshCubeAction
extends AbstractCubeSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(RefreshCubeAction.class);

    public RefreshCubeAction() {
        super(bundle, "Cube.RefreshCube", 258);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(Object[] selectedObjects) {
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            MdObjectStore store = null;
            SimpleObject currentObject = (SimpleObject)selectedObjects[0];
            List servers = null;
            String name = "";
            try {
                store = Workspace.getMdFactory().createObjectStore(null, "RefreshCubeAction");
                Cube cube = (Cube)ObjectConverter.getInstance().convertToJOMAObject(store, currentObject);
                servers = ModelUtilities.getServersForCube((Cube)cube);
                name = cube.getName();
                this.doRefresh(servers, name);
            }
            catch (RemoteException e) {
                ExceptionHandler.handleException((Exception)e);
            }
            catch (MdException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            finally {
                try {
                    Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                    if (store != null) {
                        store.dispose();
                    }
                }
                catch (RemoteException e) {
                    ExceptionHandler.handleException((Exception)e);
                }
            }
        }
    }

    private void doRefresh(List servers, String name) {
        if (servers != null && servers.size() > 0 && !ModelUtilities.isBlank((String)name)) {
            OlapServer olapServer = null;
            int numServers = servers.size();
            for (int i = 0; i < numServers; ++i) {
                try {
                    LogicalServer server = (LogicalServer)servers.get(i);
                    olapServer = new OlapServer(server);
                    olapServer.refreshCube(name);
                    Workspace.getWorkspace().getStatusBar().setText(bundle.formatString("RefreshCube.Success.fmt.txt", (Object)name));
                    continue;
                }
                catch (OLAPException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
            }
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        boolean selectionOk = super.isSelectionValid(selectedObjects);
        if (selectionOk) {
            AbstractCubeSelectionAction.getCubePermissions((SimpleObject)selectedObjects[0]);
            selectionOk = exists;
        }
        return selectionOk;
    }
}

