/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.olapadmin.actions.AbstractSelectionAction;
import com.sas.olapadmin.actions.SchedulingMenuAction;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPJobCube;
import com.sas.olapadmin.scheduling.RedeployJobSchedulingDialog;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.visuals.Resources;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractApplicationActionsManager;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.SimpleObject;
import java.awt.Cursor;
import java.util.List;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class RedeployJobCubeAction
extends AbstractSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(RedeployJobCubeAction.class);
    protected SimpleObject mySimpleObject;

    public RedeployJobCubeAction() {
        super(bundle, "JobCube.Redeploy", 1);
        this.mySimpleObject = null;
    }

    public RedeployJobCubeAction(SimpleObject override) {
        super(bundle, "JobCube.Redeploy", 257);
        this.mySimpleObject = override;
    }

    public static boolean addDeployedJobsToMenu(JPopupMenu mnuPopup, WsActionContextInterface context) {
        boolean ret_val = false;
        Object[] aObjects = context.getSelectedObjects();
        SimpleObject[] aSimpleObjects = new SimpleObject[aObjects.length];
        if (aSimpleObjects.length == 1) {
            System.arraycopy(aObjects, 0, aSimpleObjects, 0, aObjects.length);
            ret_val = RedeployJobCubeAction.attachRelatedJobsTo(mnuPopup, aSimpleObjects[0]);
        }
        return ret_val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean attachRelatedJobsTo(JPopupMenu mnuPopup, SimpleObject aObject) {
        boolean ret_val = false;
        OLAPJobCube temp = RedeployJobCubeAction.createJobCubeFor(aObject);
        try {
            List jobs;
            if (temp != null && (jobs = temp.getDeployedJobs()) != null) {
                for (SimpleObject curJob : jobs) {
                    SchedulingMenuAction action = new SchedulingMenuAction();
                    JMenu jobMenu = new JMenu((Action)((Object)action));
                    jobMenu.setText(curJob.getName());
                    jobMenu.setIcon(Resources.getImageIcon((String)"Job_deployed.gif", (int)16));
                    action.setEnabled(true);
                    JPopupMenu redeployJob = jobMenu.getPopupMenu();
                    RedeployJobCubeAction redeployAction = new RedeployJobCubeAction(curJob);
                    redeployAction.setEnabled(true);
                    redeployAction.setSelectionProvider(WsAbstractApplicationActionsManager.getInstance().getSelectionProvider());
                    JMenuItem menuItem = WsUIUtilities.createMenuItem((WsAbstractAction)redeployAction);
                    redeployJob.add(menuItem);
                    mnuPopup.add(jobMenu);
                    ret_val = true;
                }
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        finally {
            try {
                if (temp != null) {
                    temp.cleanup();
                }
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
        }
        return ret_val;
    }

    private static OLAPJobCube createJobCubeFor(SimpleObject aObject) {
        OLAPJobCube jc = null;
        if (aObject != null && "Job.CubeBuild".equals(aObject.getPublicType())) {
            try {
                jc = new OLAPJobCube(aObject.getPublicType(), aObject.getMetadataType(), aObject.getID(), aObject.getName());
            }
            catch (IllegalStateException e) {
                ExceptionHandler.handleException((Exception)e);
            }
        }
        return jc;
    }

    private OLAPJobCube createJobCube(SimpleObject[] aObjects) {
        OLAPJobCube jc = null;
        if (aObjects == null || aObjects.length != 1) {
            throw new IllegalArgumentException("Invalid object");
        }
        jc = new OLAPJobCube(aObjects[0].getPublicType(), aObjects[0].getMetadataType(), aObjects[0].getID(), aObjects[0].getName());
        return jc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            SimpleObject[] aObjects = null;
            OLAPJobCube jobcube = null;
            if (this.mySimpleObject == null) {
                aObjects = new SimpleObject[aSelectedObjects.length];
                System.arraycopy(aSelectedObjects, 0, aObjects, 0, aSelectedObjects.length);
            } else {
                aObjects = new SimpleObject[]{this.mySimpleObject};
            }
            jobcube = this.createJobCube(aObjects);
            this.showDialog(aObjects, jobcube);
            try {
                jobcube.cleanup();
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            finally {
                jobcube = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        boolean selectionOk = false;
        if (selectedObjects.length == 1 && selectedObjects[0] instanceof SimpleObject) {
            SimpleObject[] aObjects = new SimpleObject[1];
            System.arraycopy(selectedObjects, 0, aObjects, 0, selectedObjects.length);
            SimpleObject obj = aObjects[0];
            String type = obj.getPublicType();
            if ("DeployedJob".equals(type)) {
                selectionOk = true;
            } else if ("Job.CubeBuild".equals(type)) {
                OLAPJobCube temp = this.createJobCube(aObjects);
                try {
                    if (temp.isDeployedForScheduling()) {
                        selectionOk = true;
                    }
                }
                catch (OLAPException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
                finally {
                    try {
                        if (temp != null) {
                            temp.cleanup();
                        }
                    }
                    catch (OLAPException ex) {
                        ExceptionHandler.handleException((Exception)((Object)ex));
                    }
                }
            }
        }
        return selectionOk;
    }

    @Override
    public boolean isValidForContext(WsActionContextInterface context) {
        return this.isSelectionValid(context.getSelectedObjects());
    }

    private void showDialog(SimpleObject[] aObjects, OLAPJobCube jobcube) {
        Workspace workspace = Workspace.getWorkspace();
        RedeployJobSchedulingDialog dialog = new RedeployJobSchedulingDialog((JFrame)workspace, aObjects, jobcube);
        workspace.setCursor(Cursor.getPredefinedCursor(3));
        dialog.show();
        workspace.setCursor(Cursor.getPredefinedCursor(0));
    }
}

