/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.etl.models.IComplexPersistableObject;
import com.sas.etl.models.IExtendedAttributesContainer;
import com.sas.etl.models.IModel;
import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.IObject;
import com.sas.etl.models.IPersistableObject;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.BaseModel;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.SmartObjectFactoryInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.unknown.UnknownType;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.olapadmin.actions.AbstractSelectionAction;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.visuals.DocumentView;
import com.sas.wadmin.visuals.FolderPropertiesView;
import com.sas.wadmin.visuals.LogicalObjectPropertiesView;
import com.sas.wadmin.visuals.SASLibraryView;
import com.sas.wadmin.visuals.TextStoreView;
import com.sas.wadmin.visuals.WAExtAttrPropertyTab;
import com.sas.wadmin.visuals.common.ColumnsTab;
import com.sas.wadmin.visuals.common.ExtendedAttributesTab;
import com.sas.wadmin.visuals.common.GeneralTab;
import com.sas.wadmin.visuals.common.IndexesTab;
import com.sas.wadmin.visuals.common.KeysTab;
import com.sas.wadmin.visuals.common.ModelUndoManager;
import com.sas.wadmin.visuals.common.NotesTab;
import com.sas.wadmin.visuals.common.ParameterTab;
import com.sas.wadmin.visuals.common.PhysicalStorageTab;
import com.sas.wadmin.visuals.common.TableOptionsTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAPropertyTabGroup;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATabbedPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.plugins.PluginViewInterface;
import com.sas.workspace.visuals.WsGenericGeneralPropertyTab;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.undo.UndoManager;

public class PropertiesAction
extends AbstractSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = WAdminResource.getBundle(PropertiesAction.class);
    private static final String MAXIMUM_UNDOS_KEY = "AppPropertiesDialogFactory.MaximumUndos";
    private static final String SHOW_ADVANCED_TABS_KEY = "Workspace.ShowAdvancedPropertyTabs";

    public PropertiesAction() {
        super(bundle, "Edit.Properties", 258);
        this.setMenuSupportId("Edit:Properties");
    }

    @Override
    protected boolean isEnabledForIncompatibleObjects() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            SimpleObject object = (SimpleObject)aSelectedObjects[0];
            String sTitle = bundle.formatString("PropertiesDialog.window.title.fmt.txt", (Object)object.getName());
            WAPropertyDialog dlg = new WAPropertyDialog((Frame)Workspace.getWorkspace(), sTitle, true);
            dlg.setResizable(true);
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            try {
                LogicalObjectInterface lob = ObjectConverter.getInstance().convertToLogicalObject(object);
                if (lob != null && Factory.getInstance().isSmartObjectBasedDialog(lob)) {
                    SmartObjectFactoryInterface factory = (SmartObjectFactoryInterface)lob.getTypeInterface().getObjectFactory();
                    ChildServerInterface transaction = Workspace.getWorkspace().getConnectionManager().getMetadataServer().newChild(true);
                    try {
                        String sKey = lob.getID() + "/" + lob.getTypeInterface().getMetadataType();
                        MetadataInterface mdiObject = transaction.fetch(sKey, true);
                        dlg.setMetadataServiceObject(mdiObject);
                        dlg.setMainPanel(this.createSmartObjectMainPanel(lob, factory, transaction, mdiObject));
                        dlg.show();
                        transaction = null;
                        return;
                    }
                    finally {
                        if (transaction != null) {
                            transaction.destroy();
                        }
                        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, sTitle);
                try {
                    LogicalObjectPropertiesView logicalObjectView;
                    Root mdo = ObjectConverter.getInstance().convertToJOMAObject(store, object);
                    String sType = object.getPublicType();
                    SASLibraryView view = null;
                    boolean panelCreated = false;
                    if (!this.isSelectionCompatible() && !"Folder".equals(sType)) {
                        LogicalObjectInterface obj = null;
                        TypeInterface unknwn = UnknownType.getInstance((Factory)Factory.getInstance());
                        obj = unknwn.getObjectFactory().createItemFromMetadataObject(mdo);
                        logicalObjectView = new LogicalObjectPropertiesView();
                        logicalObjectView.setMetadata(mdo);
                        logicalObjectView.setLogicalObject(obj);
                        dlg.setMainPanel(logicalObjectView.createMainPanel());
                        panelCreated = true;
                    } else {
                        if ("Table".equals(sType)) {
                            PropertiesAction.showTablePropertySheet((Window)Workspace.getWorkspace(), object, true);
                            return;
                        }
                        if ("Library".equals(sType)) {
                            view = new SASLibraryView();
                        } else if ("Note".equals(sType)) {
                            view = new TextStoreView();
                        } else if ("Document".equals(sType)) {
                            view = new DocumentView();
                        }
                    }
                    boolean showDialog = true;
                    if (view != null) {
                        dlg.setHelpProduct("wdb");
                        view.setMetadata(mdo);
                        WAPropertyTabGroup tabs = view.createView();
                        if (tabs != null) {
                            for (int iTab = 0; iTab < tabs.getTabCount(); ++iTab) {
                                dlg.addTab(tabs.getTitleAt(iTab), tabs.getTabAt(iTab));
                            }
                        } else {
                            showDialog = false;
                        }
                    } else if ("Folder".equals(sType)) {
                        FolderPropertiesView logicalObjectView2 = new FolderPropertiesView();
                        logicalObjectView2.setMetadata(mdo);
                        logicalObjectView2.setLogicalObject(ObjectConverter.getInstance().convertToLogicalObject(mdo));
                        dlg.setMainPanel(logicalObjectView2.createMainPanel());
                        dlg.setHelpProduct("wdb");
                    } else if (!panelCreated) {
                        LogicalObjectInterface obj = ObjectConverter.getInstance().convertToLogicalObject(mdo);
                        if (obj == null) {
                            TypeInterface unknwn = UnknownType.getInstance((Factory)Factory.getInstance());
                            obj = unknwn.getObjectFactory().createItemFromMetadataObject(mdo);
                        }
                        logicalObjectView = new LogicalObjectPropertiesView();
                        logicalObjectView.setMetadata(mdo);
                        logicalObjectView.setLogicalObject(obj);
                        dlg.setMainPanel(logicalObjectView.createMainPanel());
                    }
                    Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                    if (showDialog) {
                        if (!Workspace.getWorkspace().isObjectEditable((CMetadata)mdo)) {
                            dlg.setEditable(false);
                        }
                        dlg.show();
                        if (dlg.getReturnValue() == 1) {
                            store.updatedMetadataAll();
                        }
                    }
                }
                finally {
                    store.dispose();
                    Workspace.getWorkspace().getMdObjectFactory().dumpDetailHashMap();
                    Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            catch (MdException ex) {
                ExceptionHandler.handleException((Exception)((Object)ex));
            }
            catch (LogicalTypeException ex) {
                ExceptionHandler.handleException((Exception)((Object)ex));
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (ServiceException ex) {
                Workspace.handleServiceException((ServiceException)ex);
            }
        }
    }

    private WAPanel createSmartObjectMainPanel(LogicalObjectInterface lob, SmartObjectFactoryInterface factory, ChildServerInterface transaction, MetadataInterface mdiObject) throws ServiceException, RemoteException, MdException {
        PropertyTabsPanel pnlTabs = new PropertyTabsPanel();
        Root mdoOjbect = (Root)mdiObject.getRepositoryEntity();
        List tabs = factory.getPropertyTabs(lob, transaction, mdiObject, mdoOjbect, null);
        for (WAPropertyTab tab : tabs) {
            if (!PropertiesAction.isUserPreferenceToShowAdvancedTabs() && (tab instanceof WsGenericGeneralPropertyTab || tab instanceof WAExtAttrPropertyTab)) continue;
            pnlTabs.addTab(tab.getName(), tab);
        }
        if (PropertiesAction.isUserPreferenceToShowAdvancedTabs()) {
            PropertiesAction.addAuthorizationTab(pnlTabs, mdoOjbect);
        }
        return pnlTabs;
    }

    @Override
    protected boolean isSelectionValid(Object[] aSelectedObjects) {
        return aSelectedObjects.length == 1 && aSelectedObjects[0] instanceof SimpleObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showTablePropertySheet(Window wdwParent, SimpleObject object, boolean editable) {
        MdObjectStore store = null;
        wdwParent.setCursor(Cursor.getPredefinedCursor(3));
        try {
            IComplexPersistableObject obj = PropertiesAction.createModelObject(object);
            store = Workspace.getMdFactory().createObjectStore(null, object.getName() + " advanced_tab store: " + object.hashCode());
            try {
                if (PropertiesAction.loadModelObject((IObject)obj)) {
                    PropertiesAction.showModelPropertiesDialog(wdwParent, obj, store, editable);
                }
            }
            finally {
                obj.getModel().dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        finally {
            if (store != null) {
                try {
                    store.dispose();
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException((RemoteException)ex);
                }
            }
            wdwParent.setCursor(Cursor.getDefaultCursor());
        }
    }

    private static IComplexPersistableObject createModelObject(SimpleObject obj) {
        boolean bEditable = Workspace.isObjectEditable((SimpleObject)obj);
        BaseModel mdl = new BaseModel();
        mdl.setDebugName(obj.getName() + " Properties");
        mdl.setEditable(bEditable);
        mdl.setUndoSupported(bEditable);
        String sType = obj.getPublicType();
        if (!"Table".equals(sType)) {
            throw new UnsupportedOperationException("Unsupported type for createModel: " + sType);
        }
        IPhysicalTable object = mdl.getObjectFactory().createPhysicalTable(obj.getID());
        object.setName(obj.getName());
        object.setChanged(false);
        mdl.setMainObject((IPersistableObject)object);
        mdl.setUndoManager((UndoManager)new ModelUndoManager());
        mdl.getUndoManager().setLimit(PropertiesAction.getUserPreferenceForUndoLimit());
        return object;
    }

    private static int getUserPreferenceForUndoLimit() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyInt(MAXIMUM_UNDOS_KEY, 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadModelObject(IObject obj) {
        IModel mdl = obj.getModel();
        mdl.setModelEventsEnabled(false);
        try {
            LoadRunnable run = new LoadRunnable(mdl);
            OpRequestUI op = new OpRequestUI();
            op.setTitle(obj.getName());
            op.setMessage(bundle.getString("TablePropertiesDialog.Loading.Title.txt"));
            op.execute((Runnable)run);
            boolean bl = run.wasSuccessful();
            return bl;
        }
        finally {
            mdl.setModelEventsEnabled(true);
        }
    }

    private static int showModelPropertiesDialog(Window wdwParent, IComplexPersistableObject object, MdObjectStore store, boolean bPrimary) {
        WAPanel pnlMain = PropertiesAction.createPhysicalTableMainPanel((IPhysicalTable)object, store);
        if (pnlMain != null) {
            PropertiesDialog dlg = wdwParent instanceof JFrame ? new PropertiesDialog((JFrame)wdwParent, (IObject)object, pnlMain, bPrimary) : new PropertiesDialog((JDialog)wdwParent, (IObject)object, pnlMain, bPrimary);
            dlg.setResizable(true);
            dlg.setMainPanel(pnlMain);
            dlg.setUndoManager(object.getModel().getUndoManager());
            dlg.setHelpProduct("wdb");
            boolean bEditable = bPrimary && object.getModel().isEditable() && Workspace.isObjectEditable((SimpleObject)object);
            dlg.setEditable(bEditable);
            dlg.show();
            return dlg.getReturnValue();
        }
        return -1;
    }

    private static WAPanel createPhysicalTableMainPanel(IPhysicalTable table, MdObjectStore store) {
        PropertyTabsPanel pnlTabs = new PropertyTabsPanel();
        pnlTabs.setUndoManager(table.getModel().getUndoManager());
        pnlTabs.addTab((WAPropertyTab)new GeneralTab((IObject)table, true, true));
        pnlTabs.addTab((WAPropertyTab)new ColumnsTab((ITable)table));
        pnlTabs.addTab((WAPropertyTab)new IndexesTab(table));
        pnlTabs.addTab((WAPropertyTab)new KeysTab(table));
        pnlTabs.addTab((WAPropertyTab)new ParameterTab((IParametersContainer)table));
        pnlTabs.addTab((WAPropertyTab)new PhysicalStorageTab(table));
        pnlTabs.addTab((WAPropertyTab)new TableOptionsTab(table));
        pnlTabs.addTab((WAPropertyTab)new NotesTab((INotesAndDocumentsContainer)table));
        PropertiesAction.addAdvancedTabs(pnlTabs, (IComplexPersistableObject)table, store);
        return pnlTabs;
    }

    private static boolean isUserPreferenceToShowAdvancedTabs() {
        return Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean(SHOW_ADVANCED_TABS_KEY, true);
    }

    private static void addAdvancedTabs(WATabbedPanel pnlTabs, IComplexPersistableObject obj, MdObjectStore store) {
        if (PropertiesAction.isUserPreferenceToShowAdvancedTabs()) {
            pnlTabs.addTab((WAPropertyTab)new ExtendedAttributesTab((IExtendedAttributesContainer)obj));
            try {
                if (store == null) {
                    throw new IllegalStateException("Object store cannot be null");
                }
                Root mdo = ObjectConverter.getInstance().convertToJOMAObject(store, (SimpleObject)obj);
                if (mdo == null) {
                    throw new IllegalStateException("Unable to obtain metadata object for table " + obj.getName());
                }
                pnlTabs.addTab((WAPropertyTab)new WsGenericGeneralPropertyTab((CMetadata)mdo));
                PropertiesAction.addAuthorizationTab(pnlTabs, mdo);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (MdException ex) {
                ExceptionHandler.handleException((Exception)((Object)ex));
            }
        }
    }

    private static void addAuthorizationTab(WATabbedPanel pnlTabs, Root mdo) {
        ArrayList lPlugins = Workspace.getWorkspace().getPluginLoader().getPlugins("com.sas.wadmin.plugins.authtab.AuthorizationTabPluginInterface", true);
        for (int iPlugin = 0; iPlugin < lPlugins.size(); ++iPlugin) {
            PluginViewInterface plugin = (PluginViewInterface)lPlugins.get(iPlugin);
            ArrayList lTabs = plugin.getPropertyTabs((CMetadata)mdo);
            if (lTabs == null) continue;
            for (int iTab = 0; iTab < lTabs.size(); ++iTab) {
                pnlTabs.addTab((WAPropertyTab)lTabs.get(iTab));
            }
        }
    }

    private static class PropertyTabsPanel
    extends WATabbedPanel {
        private static final long serialVersionUID = 1L;

        private PropertyTabsPanel() {
        }

        protected void populateStoreWrapper(WAPropertyTab tab) {
            try {
                tab.populateStore();
                this.moveTabDataToView(tab);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
        }
    }

    private static class LoadRunnable
    extends AbstractWasSuccessfulRunnable {
        private IModel m_mdl;

        public LoadRunnable(IModel mdl) {
            this.m_mdl = mdl;
        }

        @Override
        public void run() {
            this.setSuccessful(false);
            try {
                this.m_mdl.loadFromOMR(Workspace.getMdFactory());
                this.setSuccessful(true);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)new MdException((Throwable)ex), (String)"Reading");
            }
        }
    }

    private static class PropertiesDialog
    extends WAStandardDialog {
        private static final long serialVersionUID = 1L;
        private IObject m_object;
        private boolean m_bSaveModel;

        public PropertiesDialog(Dialog dlgOwner, IObject object, WAPanel pnlMain, boolean bPrimary) {
            super(dlgOwner, bundle.formatString("PropertiesDialog.window.title.fmt.txt", (Object)object.getName()), true, pnlMain);
            this.m_object = object;
            this.m_bSaveModel = bPrimary;
        }

        public PropertiesDialog(Frame frmOwner, IObject object, WAPanel pnlMain, boolean bPrimary) {
            super(frmOwner, bundle.formatString("PropertiesDialog.window.title.fmt.txt", (Object)object.getName()), true, pnlMain);
            this.m_object = object;
            this.m_bSaveModel = bPrimary;
        }

        protected boolean doDataExchange(boolean bSaveToModel) {
            try {
                if (bSaveToModel) {
                    this.getMainPanel().moveDataToStore();
                    if (this.m_bSaveModel) {
                        this.saveModelObject();
                    }
                } else {
                    this.getMainPanel().populateStore();
                    this.getMainPanel().moveDataToView();
                }
                return true;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (MdException ex) {
                String sAccess = bSaveToModel ? "Writing" : "Reading";
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)sAccess);
            }
            return false;
        }

        private boolean saveModelObject() {
            SaveRunnable run = new SaveRunnable(this.m_object.getModel());
            OpRequestUI op = new OpRequestUI();
            op.setTitle(this.m_object.getName());
            op.setMessage(bundle.getString("TablePropertiesDialog.Saving.Title.txt"));
            op.execute((Runnable)run);
            return run.wasSuccessful();
        }
    }

    private static class SaveRunnable
    extends AbstractWasSuccessfulRunnable {
        private IModel m_mdl;

        public SaveRunnable(IModel mdl) {
            this.m_mdl = mdl;
        }

        @Override
        public void run() {
            this.setSuccessful(false);
            try {
                this.m_mdl.saveToOMR(Workspace.getMdFactory());
                this.setSuccessful(true);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)new MdException((Throwable)ex), (String)"Writing");
            }
        }
    }

    private static abstract class AbstractWasSuccessfulRunnable
    implements Runnable {
        private boolean m_bSuccessful;

        private AbstractWasSuccessfulRunnable() {
        }

        public boolean wasSuccessful() {
            return this.m_bSuccessful;
        }

        protected void setSuccessful(boolean bSuccessful) {
            this.m_bSuccessful = bSuccessful;
        }
    }
}

