/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.actions.AbstractSelectionAction;
import com.sas.olapadmin.actions.DisplayLibnameAction;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;

public class OpenDocumentAction
extends AbstractSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(DisplayLibnameAction.class);
    private static final String WINDOWS_COMMAND = "rundll32 url.dll,FileProtocolHandler ";
    private static final String UNIX_COMMAND = "netscape -remote openURL(";
    private static final String UNIX_COMMAND_END = ")";

    public OpenDocumentAction() {
        super(bundle, "Document.OpenDocument", 257);
    }

    @Override
    protected void actionPerformed(Object[] selectedObjects) {
        if (this.isSelectionValid(selectedObjects)) {
            this.showDocumentURL((SimpleObject)selectedObjects[0]);
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        return selectedObjects != null && selectedObjects.length == 1 && selectedObjects[0] instanceof SimpleObject && "Document".equals(((SimpleObject)selectedObjects[0]).getPublicType());
    }

    @Override
    public boolean isValidForContext(WsActionContextInterface context) {
        return this.isSelectionValid(context.getSelectedObjects());
    }

    private void showDocumentURL(SimpleObject document) {
        try {
            String sURL = WsMetadataUtil.getSimpleAttribute((String)document.getMetadataType(), (String)document.getID(), (String)"URI");
            if (!this.isURLValid(sURL)) {
                String sMessage = bundle.formatString("OpenDocument.DocumentDoesNotExist.fmt", (Object)document.getName(), (Object)sURL);
                MessageUtil.displayMessage((String)sMessage, (int)0);
            } else {
                this.showURLImpl(sURL);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
    }

    private void showURLImpl(String sURL) {
        String sCommand = System.getProperty("os.name").startsWith("Windows") ? WINDOWS_COMMAND + sURL : UNIX_COMMAND + sURL + UNIX_COMMAND_END;
        try {
            Runtime.getRuntime().exec(sCommand);
        }
        catch (IOException ex) {
            MessageUtil.displayMessage((String)ex.getMessage(), (int)0);
        }
    }

    private boolean isURLValid(String sURL) {
        try {
            new URL(sURL);
            return true;
        }
        catch (MalformedURLException ex) {
            return new File(sURL).exists();
        }
    }
}

