/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Tree;
import com.sas.olapadmin.actions.AbstractSelectionAction;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.shareddims.visuals.SharedDimDesigner;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.visuals.Resources;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.models.SimpleObject;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;

public class NewSharedDimensionAction
extends AbstractSelectionAction
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(NewSharedDimensionAction.class);

    public NewSharedDimensionAction() {
        super(bundle, "File.New.SharedDim", 256);
        this.setIcon(Resources.getImageIcon((String)"OLAPDimension_shared.gif", (int)16));
        Workspace.getWorkspace().addPropertyChangeListener("MetadataProfile", (PropertyChangeListener)this);
        this.setEnabled(Workspace.getWorkspace().getProjectRepository() == null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object[] objects = null;
        if (this.m_provider != null) {
            objects = this.m_provider.getSelectedObjects();
        }
        this.actionPerformed(objects);
    }

    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            SharedDimDesigner dialog = new SharedDimDesigner((Frame)Workspace.getWorkspace(), bundle.getString("SharedDimension.window.title"));
            Tree folder = null;
            if (aSelectedObjects != null && aSelectedObjects.length == 1 && aSelectedObjects[0] instanceof SimpleObject && "Folder".equals(((SimpleObject)aSelectedObjects[0]).getPublicType())) {
                try {
                    MdObjectStore store = (MdObjectStore)dialog.getWizardData("OBJECTSTORE");
                    folder = (Tree)ObjectConverter.getInstance().convertToJOMAObject(store, (SimpleObject)aSelectedObjects[0]);
                    if (folder != null) {
                        dialog.addWizardData("GROUP", folder);
                    }
                }
                catch (RemoteException e) {
                    ExceptionHandler.handleException((Exception)e);
                }
                catch (MdException error) {
                    ExceptionHandler.handleException((Exception)((Object)error));
                }
            }
            dialog.show();
        }
    }

    @Override
    protected boolean isEnabledForIncompatibleObjects() {
        return true;
    }

    @Override
    protected boolean isEnabledWhenNoSelectionProvider() {
        return true;
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        if (Workspace.getWorkspace().getProjectRepository() != null) {
            return false;
        }
        if (selectedObjects != null && selectedObjects.length == 1 && selectedObjects[0] instanceof SimpleObject && "Folder".equals(((SimpleObject)selectedObjects[0]).getPublicType())) {
            SimpleObject folder = (SimpleObject)selectedObjects[0];
            return ModelUtilities.getPermissionFromId((String)"WriteMemberMetadata", (String)folder.getMetadataType(), (String)folder.getID());
        }
        return true;
    }

    @Override
    public boolean isValidForContext(WsActionContextInterface context) {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setEnabled(Workspace.getWorkspace().getProjectRepository() == null);
    }
}

