/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.olapadmin.actions.AbstractSelectionAction;
import com.sas.olapadmin.actions.CopyToFolderAction;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractApplicationFrameworkManager;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import java.rmi.RemoteException;
import javax.swing.JFrame;

public class MoveToFolderAction
extends AbstractSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = WAdminResource.getBundle(CopyToFolderAction.class);

    public MoveToFolderAction() {
        super(bundle, "Edit.MoveToFolder", 258);
    }

    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            SimpleObject[] aObjects = new SimpleObject[aSelectedObjects.length];
            System.arraycopy(aSelectedObjects, 0, aObjects, 0, aSelectedObjects.length);
            this.showMoveToFolderDialog((JFrame)Workspace.getWorkspace(), aObjects);
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        if (selectedObjects.length == 0) {
            return false;
        }
        String sRepository = null;
        for (int i = 0; i < selectedObjects.length; ++i) {
            if (!(selectedObjects[i] instanceof SimpleObject)) {
                return false;
            }
            try {
                SimpleObject obj = (SimpleObject)selectedObjects[0];
                String publicType = obj.getPublicType();
                TypeDescriptorInterface typeDescriptor = Factory.getInstance().getMetadataServerInterface().getTypeDescriptor(publicType);
                if (typeDescriptor == null) {
                    return false;
                }
                if (!"Folder".equals(typeDescriptor.getContainerType())) {
                    return false;
                }
            }
            catch (RemoteException e) {
                ExceptionHandler.handleException((Exception)e);
            }
            catch (ServiceException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            if (sRepository == null) {
                sRepository = ((SimpleObject)selectedObjects[0]).getID().substring(0, 8);
            }
            if (((SimpleObject)selectedObjects[i]).getID().substring(0, 8).equals(sRepository)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidForContext(WsActionContextInterface context) {
        return this.isSelectionValid(context.getSelectedObjects());
    }

    private void showMoveToFolderDialog(JFrame frmParent, SimpleObject[] aObjects) {
        try {
            String repository = aObjects[0].getID().substring(0, 8);
            Tree mdoTree = (Tree)WsMetadataUtil.promptForFolder(null, (boolean)false, (SimpleObject[])aObjects);
            if (mdoTree != null) {
                if (!mdoTree.getRepositoryID().equals(repository)) {
                    MessageUtil.displayMessage((String)bundle.getString("MoveToFolder.NotSameRepository.txt"));
                    return;
                }
                LogicalObjectInterface targetFolder = ObjectConverter.getInstance().convertToLogicalObject((Root)mdoTree);
                for (int iObject = 0; iObject < aObjects.length; ++iObject) {
                    LogicalObjectInterface logicalObject = ObjectConverter.getInstance().convertToLogicalObject(aObjects[iObject]);
                    if (logicalObject == null) continue;
                    logicalObject.move((FolderInterface)targetFolder);
                }
                WsAbstractApplicationFrameworkManager.getInstance().findInFolders(aObjects);
            }
        }
        catch (RemoteException e) {
            ExceptionHandler.handleException((Exception)e);
        }
        catch (MdException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        catch (LogicalTypeException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }
}

