/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.visuals.ExportWizard;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.olapadmin.actions.AbstractSelectionAction;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.app.TransportUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.models.SimpleObject;
import java.awt.Cursor;
import java.rmi.RemoteException;

public class ExportAction
extends AbstractSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(ExportAction.class);

    public ExportAction() {
        super(bundle, "File.Export", 2);
    }

    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            if (aSelectedObjects.length == 0) {
                this.showExportSASPackageDialog();
            } else {
                SimpleObject[] aObjects = new SimpleObject[aSelectedObjects.length];
                System.arraycopy(aSelectedObjects, 0, aObjects, 0, aSelectedObjects.length);
                this.showExportSASPackageDialog(aObjects);
            }
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        if (selectedObjects.length == 0) {
            return false;
        }
        for (int i = 0; i < selectedObjects.length; ++i) {
            if (selectedObjects[i] instanceof SimpleObject) continue;
            return false;
        }
        SimpleObject[] aObjects = new SimpleObject[selectedObjects.length];
        System.arraycopy(selectedObjects, 0, aObjects, 0, selectedObjects.length);
        return TransportUtil.areObjectsTransportable((SimpleObject[])aObjects);
    }

    @Override
    public boolean isValidForContext(WsActionContextInterface context) {
        return this.isSelectionValid(context.getSelectedObjects());
    }

    private void showExportSASPackageDialog() {
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            SoftwareComponent target = (SoftwareComponent)server.getRootFolder().getRepositoryEntity();
            this.showExportSASPackageDialog(new Object[]{target});
        }
        catch (RemoteException ex) {
            ExceptionHandler.handleException((Exception)ex);
        }
        catch (ServiceException ex) {
            ExceptionHandler.handleException((Exception)((Object)ex));
        }
    }

    private void showExportSASPackageDialog(SimpleObject[] aObjects) {
        try {
            this.showExportSASPackageDialog(ObjectConverter.getInstance().convertToLogicalObjects(aObjects));
        }
        catch (LogicalTypeException ex) {
            ExceptionHandler.handleException((Exception)((Object)ex));
        }
        catch (MdException ex) {
            ExceptionHandler.handleException((Exception)((Object)ex));
        }
        catch (RemoteException ex) {
            ExceptionHandler.handleException((Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showExportSASPackageDialog(Object[] aObjects) {
        String sWizardTitle = bundle.getString("ExportWizard.window.title");
        try {
            ExportWizard wizard;
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            TypeInterface[] aSupportedTypes = Factory.getInstance().getTypesSupported();
            if (aObjects instanceof LogicalObjectInterface[]) {
                wizard = new ExportWizard((SimpleLogicalObjectInterface[])((LogicalObjectInterface[])aObjects), aSupportedTypes, sWizardTitle);
            } else if (aObjects.length == 1 && aObjects[0] instanceof SoftwareComponent) {
                wizard = new ExportWizard((SoftwareComponent)aObjects[0], aSupportedTypes, sWizardTitle);
            } else {
                throw new IllegalArgumentException("The supplied target must be of type LogicalObjectInterface[] or Object[] containg a single SoftwareComponent");
            }
            Workspace.getWorkspace().setCursor(Cursor.getDefaultCursor());
            wizard.show();
        }
        catch (LogicalTypeException ex) {
            ExceptionHandler.handleException((Exception)((Object)ex));
        }
        catch (RemoteException ex) {
            ExceptionHandler.handleException((Exception)ex);
        }
        finally {
            Workspace.getWorkspace().setCursor(Cursor.getDefaultCursor());
        }
    }
}

