/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.olapadmin.actions.AbstractCubeSelectionAction;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OlapServer;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.swing.visuals.util.Util;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleObject;
import java.awt.Cursor;
import java.rmi.RemoteException;
import java.util.List;

public class EnableDisableCubeAction
extends AbstractCubeSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(EnableDisableCubeAction.class);
    public static final int ENABLE = 0;
    public static final int DISABLE = 1;
    private int m_type;

    public EnableDisableCubeAction(int type) {
        super(bundle, "Cube.Enable", 2);
        this.m_type = type;
        if (this.m_type == 1) {
            String text = bundle.getString("Cube.Disable.txt");
            this.setIcon(bundle.getImageIcon("Cube.Disable.image"));
            this.setToolTipText(bundle.getString("Cube.Disable.tip"));
            int cMnem = Util.getDisplayedMnemonic((String)text);
            int iMnem = Util.getDisplayedMnemonicIndex((String)text);
            text = Util.getLabelWithoutMnemonic((String)text);
            this.setText(text);
            this.putValue("MnemonicKey", new Integer(cMnem));
            this.putValue("MnemonicIndex", new Integer(iMnem));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            List servers = null;
            String name = "";
            Workspace workspace = Workspace.getWorkspace();
            MdObjectStore store = null;
            try {
                store = Workspace.getMdFactory().createObjectStore(null, "EnableDisableAction");
                SimpleObject obj = (SimpleObject)aSelectedObjects[0];
                Cube cube = (Cube)ObjectConverter.getInstance().convertToJOMAObject(store, obj);
                workspace.setCursor(Cursor.getPredefinedCursor(3));
                servers = ModelUtilities.getServersForCube((Cube)cube);
                name = cube.getName();
                this.doEnableDisable(servers, name, workspace);
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            catch (RemoteException e) {
                ExceptionHandler.handleException((Exception)e);
            }
            catch (MdException error) {
                ExceptionHandler.handleException((Exception)((Object)error));
            }
            catch (UnsupportedOperationException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage());
            }
            finally {
                workspace.setCursor(Cursor.getPredefinedCursor(0));
                try {
                    if (store != null) {
                        store.dispose();
                    }
                }
                catch (RemoteException e) {
                    ExceptionHandler.handleException((Exception)e);
                }
            }
        }
    }

    private void doEnableDisable(List servers, String name, Workspace workspace) {
        if (servers != null && servers.size() > 0 && !ModelUtilities.isBlank((String)name)) {
            int count = 0;
            int numServers = servers.size();
            for (int i = 0; i < numServers; ++i) {
                OlapServer olapServer = null;
                try {
                    LogicalServer server = (LogicalServer)servers.get(i);
                    olapServer = new OlapServer(server);
                    if (this.m_type == 0) {
                        olapServer.enableCube(name);
                        ++count;
                        if (i == numServers - 1) {
                            MessageUtil.displayMessage((String)bundle.formatString("CubeEnableAction.Success.fmt.txt", (Object)name, (Object)String.valueOf(count), (Object)String.valueOf(numServers)), (int)1);
                        }
                    } else if (this.m_type == 1) {
                        olapServer.disableCube(name);
                        ++count;
                        if (i == numServers - 1) {
                            MessageUtil.displayMessage((String)bundle.formatString("CubeDisableAction.Success.fmt.txt", (Object)name, (Object)String.valueOf(count), (Object)String.valueOf(numServers)), (int)1);
                        }
                    }
                    workspace.setCursor(Cursor.getPredefinedCursor(0));
                    continue;
                }
                catch (OLAPException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
            }
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        boolean selectionOk = super.isSelectionValid(selectedObjects);
        if (selectionOk) {
            AbstractCubeSelectionAction.getCubePermissions((SimpleObject)selectedObjects[0]);
            selectionOk = exists;
        }
        return selectionOk;
    }
}

