/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.SharedDimension;
import com.sas.olapadmin.actions.AbstractSharedDimensionSelectionAction;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.shareddims.visuals.SharedDimDesigner;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleObject;
import java.awt.Cursor;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;

public class EditSharedDimensionAction
extends AbstractSharedDimensionSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(EditSharedDimensionAction.class);

    public EditSharedDimensionAction() {
        super(bundle, "SharedDimension.Edit", 1);
        this.mustExist = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (!Utilities.isConnectedToMetadataServer((boolean)true)) return;
        EditSharedDimensionAction.clearCurrentObject();
        if (this.isSelectionValid(aSelectedObjects)) {
            Workspace workspace = Workspace.getWorkspace();
            MdObjectStore store = null;
            try {
                store = Workspace.getMdFactory().createObjectStore(null, "EditSharedAction");
                SimpleObject obj = (SimpleObject)aSelectedObjects[0];
                SharedDimension dimension = (SharedDimension)ObjectConverter.getInstance().convertToJOMAObject(store, obj);
                workspace.setCursor(Cursor.getPredefinedCursor(3));
                OLAPSharedDimension olapDimension = new OLAPSharedDimension(dimension);
                workspace.setCursor(Cursor.getPredefinedCursor(0));
                boolean canSeeAllCubes = olapDimension.canActionBePerformed();
                if (canSeeAllCubes) {
                    String verifyMessage = olapDimension.getVerifyMessage().toString();
                    int errorLevel = olapDimension.getErrorLevel();
                    List checkPhysicalCubes = olapDimension.physicallyExistingCubes();
                    if (!checkPhysicalCubes.isEmpty()) {
                        String indentBuffer = "   ";
                        String delimeter = ", ";
                        MessageUtil.displayMessage((String)bundle.formatString("BuildSharedDimension.Cubes.PhysicallyExists.fmt.txt", (Object)ModelUtilities.stringListFormatter((List)checkPhysicalCubes, (String)indentBuffer, (String)delimeter)));
                        errorLevel = 0;
                    } else if (!ModelUtilities.isBlank((String)verifyMessage)) {
                        String message = "";
                        if (errorLevel == 2) {
                            MessageUtil.displayMessage((String)verifyMessage);
                            errorLevel = 0;
                        } else if (errorLevel == 1) {
                            MessageUtil.displayMessage((String)bundle.getString("SharedDimension.EditStructure.NoTable.txt"), (int)2);
                        } else {
                            errorLevel = 2;
                            message = bundle.getString("SharedDimesnion.EditStructure.MetadataChanges.txt");
                            MessageUtil.displayDetailsMessage((String)message, (int)errorLevel, (String)verifyMessage);
                        }
                    }
                    if (errorLevel != 2 && errorLevel != -1 && errorLevel != 1) return;
                    SharedDimDesigner wacubedlg = new SharedDimDesigner((Frame)workspace, bundle.getString("SharedDimension.window.title"), olapDimension);
                    wacubedlg.show();
                    MdFactory factory = workspace.getMdObjectFactory();
                    HashMap<String, String> map = new HashMap<String, String>(1);
                    map.put(dimension.getFQID(), dimension.getCMetadataType());
                    Workspace.getMdFactory().fireMdObjectsModified(new MdFactoryEvent(factory, map));
                    return;
                }
                MessageUtil.displayMessage((String)bundle.getString("Action.SharedDimension.NoPermissionsRemovePhysicalFiles.txt"));
                return;
            }
            catch (OLAPException error) {
                ExceptionHandler.handleException((Exception)((Object)error));
                return;
            }
            catch (RemoteException error) {
                ExceptionHandler.handleException((Exception)error);
                return;
            }
            catch (MdException error) {
                ExceptionHandler.handleException((Exception)((Object)error));
                return;
            }
            finally {
                workspace.setCursor(Cursor.getPredefinedCursor(0));
                try {
                    if (store != null) {
                        store.dispose();
                    }
                }
                catch (RemoteException error) {}
            }
        }
        MessageUtil.displayMessage((String)bundle.getString("Action.NoPermissions.txt"));
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        boolean selectionOk = super.isSelectionValid(selectedObjects);
        if (selectionOk) {
            AbstractSharedDimensionSelectionAction.getSharedDimensionPermissions((SimpleObject)selectedObjects[0]);
            selectionOk = canWriteAllDim & canReadAllDim;
        }
        return selectionOk;
    }
}

