/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.olapadmin.actions.AbstractSelectionAction;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPJobCube;
import com.sas.olapadmin.scheduling.DeployJobSchedulingDialog;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractApplicationActionsManager;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.models.SimpleObject;
import java.awt.Cursor;
import javax.swing.JFrame;

public class DeployJobCubeAction
extends AbstractSelectionAction {
    private static final WAdminResource bundle = new WAdminResource(DeployJobCubeAction.class);
    private static final long serialVersionUID = 42L;

    public DeployJobCubeAction() {
        super(bundle, "JobCube.Deploy", 1);
    }

    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            SimpleObject[] aObjects = new SimpleObject[aSelectedObjects.length];
            System.arraycopy(aSelectedObjects, 0, aObjects, 0, aSelectedObjects.length);
            this.showDeploySchedulingDialog(aObjects);
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        String type;
        boolean selectionOk = false;
        if (selectedObjects.length == 1 && selectedObjects[0] instanceof SimpleObject && "Job.CubeBuild".equals(type = ((SimpleObject)selectedObjects[0]).getPublicType())) {
            selectionOk = true;
        }
        return selectionOk;
    }

    @Override
    public boolean isValidForContext(WsActionContextInterface context) {
        return this.isSelectionValid(context.getSelectedObjects());
    }

    private void showDeploySchedulingDialog(SimpleObject[] aObjects) {
        OLAPJobCube jobCube = new OLAPJobCube(aObjects[0].getPublicType(), aObjects[0].getMetadataType(), aObjects[0].getID(), aObjects[0].getName());
        Workspace workspace = Workspace.getWorkspace();
        DeployJobSchedulingDialog deployJobSchedulingDialog = new DeployJobSchedulingDialog((JFrame)workspace, aObjects, jobCube);
        workspace.setCursor(Cursor.getPredefinedCursor(3));
        deployJobSchedulingDialog.show();
        WsAbstractApplicationActionsManager actionsMgr = WsAbstractApplicationActionsManager.getInstance();
        WsAbstractAction action = actionsMgr.getAction("JobCube:Redeploy");
        if (actionsMgr != null && action instanceof AbstractSelectionAction) {
            AbstractSelectionAction redeploy = (AbstractSelectionAction)action;
            WsSelectionProvider selectionProvider = actionsMgr.getSelectionProvider();
            if (selectionProvider != null) {
                redeploy.setSelectionProvider(null);
                redeploy.setSelectionProvider(selectionProvider);
            }
        }
        workspace.setCursor(Cursor.getPredefinedCursor(0));
        try {
            jobCube.cleanup();
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }
}

