/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.SharedDimension;
import com.sas.olapadmin.actions.AbstractSharedDimensionSelectionAction;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.WsRunCode;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.models.SimpleObject;
import java.awt.Cursor;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class DeletePhysicalSharedDimensionAction
extends AbstractSharedDimensionSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(DeletePhysicalSharedDimensionAction.class);

    public DeletePhysicalSharedDimensionAction() {
        super(bundle, "SharedDimension.DeletePhysicalCube", 257);
    }

    private boolean repairOLAPSchema(SharedDimension jomaDim, MdObjectStore objectStore) throws MdException, RemoteException {
        boolean removeSchema = false;
        OLAPSchema schema = this.createValidSchema(objectStore);
        removeSchema = true;
        if (schema != null) {
            AssociationList schemas = jomaDim.getAssociatedOLAPSchemas(true);
            schemas.clear();
            schemas.add((Object)schema);
            jomaDim.touch();
            jomaDim.updateMetadataAll();
        }
        return removeSchema;
    }

    private OLAPSchema createValidSchema(MdObjectStore objectStore) throws MdException, RemoteException {
        OLAPSchema schema = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        StringBuffer tempName = new StringBuffer(format.format(new Date()));
        tempName.append("TEMPORARY_OLAPSCHEMA_DONOTUSE");
        String shortFQID = Workspace.getMdFactory().getOMIUtil().getFoundationReposID().substring(9, 17);
        schema = (OLAPSchema)Workspace.getMdFactory().createComplexMetadataObject(objectStore, "", "OLAPSchema", shortFQID);
        schema.setName(tempName.toString());
        schema.touch();
        schema.updateMetadataAll();
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (!Utilities.isConnectedToMetadataServer((boolean)true)) return;
        DeletePhysicalSharedDimensionAction.clearCurrentObject();
        if (this.isSelectionValid(aSelectedObjects)) {
            WsRunCode wsRunCode = null;
            String message = "";
            String title = "";
            Workspace workspace = Workspace.getWorkspace();
            MdObjectStore store = null;
            try {
                SimpleObject obj = (SimpleObject)aSelectedObjects[0];
                SharedDimension dim = (SharedDimension)ObjectConverter.getInstance().convertToJOMAObject(store, obj);
                OLAPSharedDimension olapDim = new OLAPSharedDimension(dim);
                boolean canSeeAllCubes = olapDim.canActionBePerformed();
                if (canSeeAllCubes) {
                    List checkPhysicalCubes = olapDim.physicallyExistingCubes();
                    String indentBuffer = "   ";
                    String delimeter = ", ";
                    if (!checkPhysicalCubes.isEmpty()) {
                        MessageUtil.displayMessage((String)bundle.formatString("BuildSharedDimension.Cubes.PhysicallyExists.fmt.txt", (Object)ModelUtilities.stringListFormatter((List)checkPhysicalCubes, (String)indentBuffer, (String)delimeter)));
                        return;
                    }
                    int choice = MessageUtil.displayMessage((String)bundle.getString("SharedDimension.DeletePhysical.YES_NO.prompt.txt"), (String)bundle.getString("SharedDimension.DeletePhysical.window.title"), (int)3, (int)0);
                    if (choice != 0) return;
                    workspace.setCursor(Cursor.getPredefinedCursor(3));
                    store = Workspace.getMdFactory().createObjectStore(null, "DeletePhysicalAction");
                    HashMap<String, String> map = new HashMap<String, String>(1);
                    WsAppServer applicationServer = WsRunCode.getServer();
                    if (applicationServer == null) return;
                    wsRunCode = new WsRunCode(applicationServer);
                    if (wsRunCode.hasSubmitError) return;
                    map.put(dim.getFQID(), dim.getCMetadataType());
                    message = bundle.getString("DeleteSharedDimProgressIndicator.Msg.Message.txt");
                    title = bundle.getString("DeleteSharedDimProgressIndicator.Msg.window.title");
                    AssociationList schemas = dim.getAssociatedOLAPSchemas(true);
                    OLAPSchema schema = null;
                    boolean removeSchema = false;
                    if (!schemas.isEmpty()) {
                        schema = (OLAPSchema)schemas.get(0);
                    }
                    if (schema == null) {
                        removeSchema = true;
                        this.repairOLAPSchema(dim, store);
                        schemas = dim.getAssociatedOLAPSchemas(true);
                        if (!schemas.isEmpty()) {
                            schema = (OLAPSchema)schemas.get(0);
                        }
                        olapDim.setAssociatedOLAPSchema(schema);
                        olapDim.updateMetadata();
                    }
                    wsRunCode.executeCode(olapDim.generateCodeDeletePhysical(true), message, title);
                    if (removeSchema) {
                        Workspace.getMdFactory().deleteMetadataObject((CMetadata)schema);
                    }
                    MdFactory factory = workspace.getMdObjectFactory();
                    Workspace.getMdFactory().fireMdObjectsModified(new MdFactoryEvent(factory, map));
                    return;
                }
                MessageUtil.displayMessage((String)bundle.getString("Action.SharedDimension.NoPermissionsRemovePhysicalFiles.txt"));
                return;
            }
            catch (OLAPException error) {
                ExceptionHandler.handleException((Exception)((Object)error));
                return;
            }
            catch (RemoteException error) {
                ExceptionHandler.handleException((Exception)error);
                return;
            }
            catch (MdException error) {
                ExceptionHandler.handleException((Exception)((Object)error));
                return;
            }
            finally {
                workspace.setCursor(Cursor.getPredefinedCursor(0));
                try {
                    if (wsRunCode != null) {
                        wsRunCode.term();
                    }
                    if (store != null) {
                        store.dispose();
                    }
                }
                catch (RemoteException error) {}
            }
        }
        MessageUtil.displayMessage((String)bundle.getString("Action.NoPermissions.txt"));
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        boolean selectionOk = super.isSelectionValid(selectedObjects);
        if (selectionOk) {
            AbstractSharedDimensionSelectionAction.getSharedDimensionPermissions((SimpleObject)selectedObjects[0]);
            selectionOk = canWriteAllDim & canReadAllDim & exists;
        }
        return selectionOk;
    }
}

