/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.olapadmin.actions.AbstractCubeSelectionAction;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.WsRunCode;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.models.SimpleObject;
import java.awt.Cursor;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class DeletePhysicalCubeAction
extends AbstractCubeSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(DeletePhysicalCubeAction.class);

    public DeletePhysicalCubeAction() {
        super(bundle, "Cube.DeletePhysicalCube", 257);
    }

    private boolean repairOLAPSchema(Cube jomaCube, MdObjectStore objectStore) throws MdException, RemoteException {
        boolean removeSchema = false;
        OLAPSchema schema = this.createValidSchema(objectStore);
        removeSchema = true;
        if (schema != null) {
            AssociationList schemas = jomaCube.getAssociatedOLAPSchemas(true);
            schemas.clear();
            schemas.add((Object)schema);
            jomaCube.touch();
            Job jobCube = ModelUtilities.getJobCube((Cube)jomaCube);
            if (jobCube != null) {
                jobCube.touch();
            }
            jomaCube.updateMetadataAll();
        }
        return removeSchema;
    }

    private OLAPSchema createValidSchema(MdObjectStore objectStore) throws MdException, RemoteException {
        OLAPSchema schema = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        StringBuffer tempName = new StringBuffer(format.format(new Date()));
        tempName.append("TEMPORARY_OLAPSCHEMA_DONOTUSE");
        String shortFQID = Workspace.getMdFactory().getOMIUtil().getFoundationReposID().substring(9, 17);
        schema = (OLAPSchema)Workspace.getMdFactory().createComplexMetadataObject(objectStore, "", "OLAPSchema", shortFQID);
        schema.setName(tempName.toString());
        schema.touch();
        schema.updateMetadataAll();
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (!Utilities.isConnectedToMetadataServer((boolean)true)) return;
        DeletePhysicalCubeAction.clearCurrentObject();
        if (this.isSelectionValid(aSelectedObjects)) {
            if (!this.isCurrentGeneration(aSelectedObjects[0])) return;
            WsRunCode wsRunCode = null;
            String message = "";
            String title = "";
            Workspace workspace = Workspace.getWorkspace();
            MdObjectStore store = null;
            try {
                int choice = MessageUtil.displayMessage((String)bundle.getString("Cube.DeletePhysical.YES_NO.prompt.txt"), (String)bundle.getString("Cube.DeletePhysical.window.title"), (int)3, (int)0);
                if (choice != 0) return;
                workspace.setCursor(Cursor.getPredefinedCursor(3));
                store = Workspace.getMdFactory().createObjectStore(null, "DeletePhysicalAction");
                workspace.setCursor(Cursor.getPredefinedCursor(0));
                HashMap<String, String> map = new HashMap<String, String>(1);
                WsAppServer applicationServer = WsRunCode.getServer();
                if (applicationServer == null) return;
                wsRunCode = new WsRunCode(applicationServer);
                if (wsRunCode.hasSubmitError) return;
                SimpleObject obj = (SimpleObject)aSelectedObjects[0];
                Cube cube = (Cube)ObjectConverter.getInstance().convertToJOMAObject(store, obj);
                OLAPCube olapCube = new OLAPCube(cube);
                map.put(cube.getFQID(), cube.getCMetadataType());
                message = bundle.getString("DeleteCubeProgressIndicator.Msg.Message.txt");
                title = bundle.getString("DeleteCubeProgressIndicator.Msg.window.title");
                AssociationList schemas = cube.getAssociatedOLAPSchemas(true);
                OLAPSchema schema = null;
                boolean removeSchema = false;
                if (!schemas.isEmpty()) {
                    schema = (OLAPSchema)schemas.get(0);
                }
                if (schema == null) {
                    removeSchema = true;
                    this.repairOLAPSchema(cube, store);
                    schemas = cube.getAssociatedOLAPSchemas(true);
                    if (!schemas.isEmpty()) {
                        schema = (OLAPSchema)schemas.get(0);
                    }
                    olapCube.setAssociatedOLAPSchema(schema);
                    olapCube.updateMetadataOlapSchemaOnly();
                }
                wsRunCode.executeCode(olapCube.generateCodeDeletePhysical(), message, title);
                if (removeSchema) {
                    Workspace.getMdFactory().deleteMetadataObject((CMetadata)schema);
                }
                MdFactory factory = workspace.getMdObjectFactory();
                Workspace.getMdFactory().fireMdObjectsModified(new MdFactoryEvent(factory, map));
                return;
            }
            catch (OLAPException error) {
                ExceptionHandler.handleException((Exception)((Object)error));
                return;
            }
            catch (RemoteException error) {
                ExceptionHandler.handleException((Exception)error);
                return;
            }
            catch (MdException error) {
                ExceptionHandler.handleException((Exception)((Object)error));
                return;
            }
            finally {
                workspace.setCursor(Cursor.getPredefinedCursor(0));
                try {
                    if (wsRunCode != null) {
                        wsRunCode.term();
                    }
                    if (store != null) {
                        store.dispose();
                    }
                }
                catch (RemoteException error) {}
            }
        }
        MessageUtil.displayMessage((String)bundle.getString("Action.NoPermissions.txt"));
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        boolean selectionOk = super.isSelectionValid(selectedObjects);
        if (selectionOk) {
            AbstractCubeSelectionAction.getCubePermissions((SimpleObject)selectedObjects[0]);
            selectionOk = canWriteAllCube & canReadAllCube & exists;
        }
        return selectionOk;
    }
}

