/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.visuals.CopyPasteUtil;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.olapadmin.actions.AbstractSelectionAction;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.app.TransportUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import java.rmi.RemoteException;
import java.util.Map;
import javax.swing.JFrame;

public class CopyToFolderAction
extends AbstractSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = WAdminResource.getBundle(CopyToFolderAction.class);

    public CopyToFolderAction() {
        super(bundle, "Edit.CopyToFolder", 258);
    }

    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            SimpleObject[] aObjects = new SimpleObject[aSelectedObjects.length];
            System.arraycopy(aSelectedObjects, 0, aObjects, 0, aSelectedObjects.length);
            this.showCopyToFolderDialog((JFrame)Workspace.getWorkspace(), aObjects);
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        if (selectedObjects.length == 0) {
            return false;
        }
        for (int iSelectedObject = 0; iSelectedObject < selectedObjects.length; ++iSelectedObject) {
            if (!(selectedObjects[iSelectedObject] instanceof SimpleObject)) {
                return false;
            }
            try {
                SimpleObject obj = (SimpleObject)selectedObjects[0];
                String publicType = obj.getPublicType();
                TypeDescriptorInterface typeDescriptor = Factory.getInstance().getMetadataServerInterface().getTypeDescriptor(publicType);
                if (typeDescriptor == null) {
                    return false;
                }
                if ("Folder".equals(typeDescriptor.getContainerType())) continue;
                return false;
            }
            catch (RemoteException e) {
                ExceptionHandler.handleException((Exception)e);
                continue;
            }
            catch (ServiceException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
        }
        SimpleObject[] aObjects = new SimpleObject[selectedObjects.length];
        System.arraycopy(selectedObjects, 0, aObjects, 0, selectedObjects.length);
        return TransportUtil.areObjectsTransportable((SimpleObject[])aObjects);
    }

    @Override
    public boolean isValidForContext(WsActionContextInterface context) {
        return this.isSelectionValid(context.getSelectedObjects());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showCopyToFolderDialog(JFrame frmParent, SimpleObject[] aObjects) {
        MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
        try {
            MdObjectStore store = factory.createObjectStore(null, "ShowCopyToFolderDialog");
            try {
                Tree mdoTree = (Tree)WsMetadataUtil.promptForFolder(null, (boolean)false);
                if (mdoTree != null) {
                    FolderInterface folder = (FolderInterface)Factory.getInstance().getObject((Root)mdoTree);
                    CopyPasteUtil.copy((SimpleLogicalObjectInterface[])ObjectConverter.getInstance().convertToLogicalObjects(aObjects));
                    TypeInterface[] aSupportedTypes = Factory.getInstance().getTypesSupported();
                    CopyPasteUtil.paste((FolderInterface)folder, (TypeInterface[])aSupportedTypes);
                    if (CopyPasteUtil.objectsWerePasted()) {
                        TransportUtil.generateObjectsModifiedEvent((Map)CopyPasteUtil.getObjectsPasted());
                    }
                }
            }
            catch (LogicalTypeException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }
}

