/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.logical.Factory;
import com.sas.olapadmin.actions.AbstractSelectionAction;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.wadmin.app.TransportUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.models.SimpleObject;
import java.rmi.RemoteException;

public class CopyAction
extends AbstractSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(CopyAction.class);

    public CopyAction() {
        super(bundle, "Edit.Copy", 2);
    }

    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            SimpleObject[] aObjects = new SimpleObject[aSelectedObjects.length];
            System.arraycopy(aSelectedObjects, 0, aObjects, 0, aSelectedObjects.length);
            TransportUtil.doCopy((SimpleObject[])aObjects);
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        if (selectedObjects.length == 0) {
            return false;
        }
        for (int i = 0; i < selectedObjects.length; ++i) {
            if (!(selectedObjects[i] instanceof SimpleObject)) {
                return false;
            }
            try {
                SimpleObject obj = (SimpleObject)selectedObjects[0];
                String publicType = obj.getPublicType();
                TypeDescriptorInterface typeDescriptor = Factory.getInstance().getMetadataServerInterface().getTypeDescriptor(publicType);
                if (typeDescriptor == null) {
                    return false;
                }
                if ("Folder".equals(typeDescriptor.getContainerType())) continue;
                return false;
            }
            catch (RemoteException e) {
                ExceptionHandler.handleException((Exception)e);
                continue;
            }
            catch (ServiceException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
        }
        SimpleObject[] aObjects = new SimpleObject[selectedObjects.length];
        System.arraycopy(selectedObjects, 0, aObjects, 0, selectedObjects.length);
        return TransportUtil.areObjectsTransportable((SimpleObject[])aObjects);
    }
}

