/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.SharedDimension;
import com.sas.olapadmin.actions.AbstractSharedDimensionSelectionAction;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.studio.OLAPSharedDimensionSchemaPanel;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleObject;
import java.awt.Cursor;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class ChangeSharedDimensionSchemaAction
extends AbstractSharedDimensionSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(ChangeSharedDimensionSchemaAction.class);

    public ChangeSharedDimensionSchemaAction() {
        super(bundle, "SharedDimension.ChangeSchema", 257);
        this.mustExist = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            ChangeSharedDimensionSchemaAction.clearCurrentObject();
            if (this.isSelectionValid(aSelectedObjects)) {
                Workspace workspace = Workspace.getWorkspace();
                MdObjectStore store = null;
                try {
                    store = Workspace.getMdFactory().createObjectStore(null, "ChangeSchemaActionPerformed");
                    SimpleObject obj = (SimpleObject)aSelectedObjects[0];
                    SharedDimension dim = (SharedDimension)ObjectConverter.getInstance().convertToJOMAObject(store, obj);
                    workspace.setCursor(Cursor.getPredefinedCursor(3));
                    OLAPSharedDimension olapDim = new OLAPSharedDimension(dim);
                    workspace.setCursor(Cursor.getPredefinedCursor(0));
                    if (olapDim.getErrorLevel() != -1) {
                        MessageUtil.displayDetailsMessage((String)bundle.getString("SharedDimension.MetadataChanges.txt"), (int)2, (String)olapDim.getVerifyMessage().toString());
                    }
                    OLAPSchema schema = olapDim.getAssociatedOLAPSchema();
                    if (ModelUtilities.canWrite((String)"OLAPSchema", (CMetadata)schema)) {
                        ArrayList<OLAPSharedDimension> dims = new ArrayList<OLAPSharedDimension>();
                        dims.add(olapDim);
                        WAStandardDialog dialog = new WAStandardDialog((Frame)workspace, bundle.formatString("ChangeOlapSchema.window.title.fmt.txt", (Object)olapDim.getName()), true);
                        OLAPSharedDimensionSchemaPanel mainPanel = new OLAPSharedDimensionSchemaPanel(dims.toArray(), bundle.getString("ChangeOlapSchemaSD.ChangeOlapSchema.txt"));
                        dialog.setMainPanel((WAPanel)mainPanel);
                        dialog.show();
                    }
                    MessageUtil.displayMessage((String)bundle.getString("ChangeOlapSchema.NoPermissions.txt"));
                }
                catch (OLAPException error) {
                    ExceptionHandler.handleException((Exception)((Object)error));
                }
                catch (RemoteException error) {
                    ExceptionHandler.handleException((Exception)error);
                }
                catch (MdException error) {
                    ExceptionHandler.handleException((Exception)((Object)error));
                }
                finally {
                    workspace.setCursor(Cursor.getPredefinedCursor(0));
                    try {
                        if (store != null) {
                            store.dispose();
                        }
                    }
                    catch (RemoteException error) {}
                }
            } else {
                MessageUtil.displayMessage((String)bundle.getString("Action.NoPermissions.txt"));
            }
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        boolean selectionOk = super.isSelectionValid(selectedObjects);
        if (selectionOk) {
            AbstractSharedDimensionSelectionAction.getSharedDimensionPermissions((SimpleObject)selectedObjects[0]);
            selectionOk = canWriteAllDim & canReadAllDim;
        }
        return selectionOk;
    }
}

