/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.olapadmin.actions.AbstractCubeSelectionAction;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.studio.OLAPSchemaPanel;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleObject;
import java.awt.Cursor;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class ChangeSchemaAction
extends AbstractCubeSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(ChangeSchemaAction.class);

    public ChangeSchemaAction() {
        super(bundle, "Cube.ChangeSchema", 257);
        this.mustExist = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            ChangeSchemaAction.clearCurrentObject();
            if (this.isSelectionValid(aSelectedObjects)) {
                Workspace workspace = Workspace.getWorkspace();
                MdObjectStore store = null;
                try {
                    store = Workspace.getMdFactory().createObjectStore(null, "ChangeSchemaActionPerformed");
                    SimpleObject obj = (SimpleObject)aSelectedObjects[0];
                    Cube cube = (Cube)ObjectConverter.getInstance().convertToJOMAObject(store, obj);
                    workspace.setCursor(Cursor.getPredefinedCursor(3));
                    OLAPCube olapCube = new OLAPCube(cube);
                    workspace.setCursor(Cursor.getPredefinedCursor(0));
                    if (olapCube.getErrorLevel() != -1) {
                        MessageUtil.displayDetailsMessage((String)bundle.getString("Cube.MetadataChanges.txt"), (int)2, (String)olapCube.getCubeVerifyMessage().toString());
                    }
                    OLAPSchema schema = olapCube.getAssociatedOLAPSchema();
                    if (ModelUtilities.canWrite((String)"OLAPSchema", (CMetadata)schema)) {
                        ArrayList<OLAPCube> cubes = new ArrayList<OLAPCube>();
                        cubes.add(olapCube);
                        WAStandardDialog dialog = new WAStandardDialog((Frame)workspace, bundle.formatString("ChangeOlapSchema.window.title.fmt.txt", (Object)olapCube.getName()), true);
                        OLAPSchemaPanel mainPanel = new OLAPSchemaPanel(cubes.toArray(), bundle.getString("ChangeOlapSchema.ChangeOlapSchema.txt"));
                        dialog.setMainPanel((WAPanel)mainPanel);
                        dialog.show();
                    }
                    MessageUtil.displayMessage((String)bundle.getString("ChangeOlapSchema.NoPermissions.txt"));
                }
                catch (OLAPException error) {
                    ExceptionHandler.handleException((Exception)((Object)error));
                }
                catch (RemoteException error) {
                    ExceptionHandler.handleException((Exception)error);
                }
                catch (MdException error) {
                    ExceptionHandler.handleException((Exception)((Object)error));
                }
                finally {
                    workspace.setCursor(Cursor.getPredefinedCursor(0));
                    try {
                        if (store != null) {
                            store.dispose();
                        }
                    }
                    catch (RemoteException error) {}
                }
            } else {
                MessageUtil.displayMessage((String)bundle.getString("Action.NoPermissions.txt"));
            }
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        boolean selectionOk = super.isSelectionValid(selectedObjects);
        if (selectionOk) {
            AbstractCubeSelectionAction.getCubePermissions((SimpleObject)selectedObjects[0]);
            selectionOk = canWriteAllCube & canReadAllCube;
        }
        return selectionOk;
    }
}

