/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.SharedDimension;
import com.sas.olapadmin.actions.AbstractSharedDimensionSelectionAction;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.WsRunCode;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.models.SimpleObject;
import java.awt.Cursor;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;

public class BuildSharedDimensionAction
extends AbstractSharedDimensionSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(BuildSharedDimensionAction.class);
    public List cubeList;

    public BuildSharedDimensionAction() {
        super(bundle, "SharedDimension.Build", 1);
        this.mustExist = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (!Utilities.isConnectedToMetadataServer((boolean)true)) return;
        BuildSharedDimensionAction.clearCurrentObject();
        if (this.isSelectionValid(aSelectedObjects)) {
            Workspace workspace = Workspace.getWorkspace();
            MdObjectStore store = null;
            String message = "";
            String title = "";
            WsRunCode wsRunCode = null;
            try {
                store = Workspace.getMdFactory().createObjectStore(null, "BuildActionPerformed");
                SimpleObject obj = (SimpleObject)aSelectedObjects[0];
                SharedDimension dim = (SharedDimension)ObjectConverter.getInstance().convertToJOMAObject(store, obj);
                workspace.setCursor(Cursor.getPredefinedCursor(3));
                OLAPSharedDimension olapDim = new OLAPSharedDimension(dim);
                boolean canSeeAllCubes = olapDim.canActionBePerformed();
                if (canSeeAllCubes) {
                    List checkPhysicalCubes = olapDim.physicallyExistingCubes();
                    if (olapDim.getErrorLevel() != -1) {
                        MessageUtil.displayDetailsMessage((String)bundle.getString("SharedDimension.MetadataChanges.txt"), (int)0, (String)olapDim.getVerifyMessage().toString());
                        return;
                    }
                    if (!checkPhysicalCubes.isEmpty()) {
                        String indentBuffer = "   ";
                        String delimeter = ", ";
                        workspace.setCursor(Cursor.getPredefinedCursor(0));
                        MessageUtil.displayMessage((String)bundle.formatString("BuildSharedDimension.Cubes.PhysicallyExists.fmt.txt", (Object)ModelUtilities.stringListFormatter((List)checkPhysicalCubes, (String)indentBuffer, (String)delimeter)));
                        return;
                    }
                    int choice = MessageUtil.displayMessage((String)bundle.getString("CreateSD.prompt.txt"), (String)bundle.getString("CreateSD.Overwrite.window.title"), (int)2, (int)2);
                    if (choice != 0) return;
                    WsAppServer applicationServer = WsRunCode.getServer();
                    if (applicationServer != null) {
                        wsRunCode = new WsRunCode(applicationServer);
                        if (wsRunCode.hasSubmitError) return;
                        if (olapDim.physicallyExists()) {
                            message = bundle.getString("DeleteSharedDimProgressIndicator.Msg.Message.txt");
                            title = bundle.getString("DeleteSharedDimProgressIndicator.Msg.window.title");
                            wsRunCode.executeCode(olapDim.generateCodeDeletePhysical(false), message, title);
                        }
                        message = bundle.getString("CreateSharedDimProgressIndicator.Msg.Message.txt");
                        title = bundle.getString("CreateSharedDimProgressIndicator.Msg.window.title");
                        wsRunCode.executeCode(olapDim.generateCodeCreate(), message, title);
                        wsRunCode.term();
                        MdFactory factory = workspace.getMdObjectFactory();
                        HashMap<String, String> map = new HashMap<String, String>(1);
                        map.put(dim.getFQID(), dim.getCMetadataType());
                        Workspace.getMdFactory().fireMdObjectsModified(new MdFactoryEvent(factory, map));
                        return;
                    }
                    MessageUtil.displayMessage((String)bundle.getString("SharedDimension.NoCreate.txt"));
                    return;
                }
                MessageUtil.displayMessage((String)bundle.getString("Action.SharedDimension.NoPermissionsRemovePhysicalFiles.txt"));
                return;
            }
            catch (OLAPException error) {
                ExceptionHandler.handleException((Exception)((Object)error));
                return;
            }
            catch (RemoteException error) {
                ExceptionHandler.handleException((Exception)error);
                return;
            }
            catch (MdException error) {
                ExceptionHandler.handleException((Exception)((Object)error));
                return;
            }
            finally {
                try {
                    if (wsRunCode != null) {
                        wsRunCode.term();
                    }
                    if (store != null) {
                        store.dispose();
                    }
                }
                catch (RemoteException error) {
                    ExceptionHandler.handleException((Exception)error);
                }
                workspace.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        MessageUtil.displayMessage((String)bundle.getString("Action.NoPermissions.txt"));
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        boolean selectionOk = super.isSelectionValid(selectedObjects);
        if (selectionOk) {
            AbstractSharedDimensionSelectionAction.getSharedDimensionPermissions((SimpleObject)selectedObjects[0]);
            selectionOk = canWriteAllDim & canReadAllDim;
        }
        return selectionOk;
    }
}

