/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.olapadmin.actions.AbstractSelectionAction;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleObject;
import java.rmi.RemoteException;
import java.util.ArrayList;

public abstract class AbstractCubeSelectionAction
extends AbstractSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(AbstractCubeSelectionAction.class);
    public static boolean canWriteAllCube;
    public static boolean canReadAllCube;
    public static boolean canReadAllCubeData;
    public static boolean canReadCube;
    public static boolean canWriteCube;
    public static boolean exists;
    public static boolean canWriteJob;
    private static SimpleObject currentObject;
    protected boolean mustExist;

    public AbstractCubeSelectionAction() {
        this.setEnabled(this.isEnabledWhenNoSelectionProvider());
        this.mustExist = true;
    }

    public AbstractCubeSelectionAction(WAdminResource bundle, String sResourceKey, int fFlags) {
        super(bundle, sResourceKey, fFlags);
        this.setEnabled(this.isEnabledWhenNoSelectionProvider());
        this.mustExist = true;
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        SimpleObject obj;
        boolean selectionOK = false;
        if (selectedObjects.length == 1 && selectedObjects[0] instanceof SimpleObject && "Cube".equals((obj = (SimpleObject)selectedObjects[0]).getPublicType())) {
            selectionOK = true;
        }
        return selectionOK;
    }

    @Override
    public boolean isValidForObjects(Object[] selectedObjects) {
        SimpleObject obj;
        boolean selectionOK = false;
        if (selectedObjects.length == 1 && selectedObjects[0] instanceof SimpleObject && "Cube".equals((obj = (SimpleObject)selectedObjects[0]).getPublicType())) {
            if (this.mustExist) {
                AbstractCubeSelectionAction.getCubePermissions(obj);
                selectionOK = exists;
            } else {
                selectionOK = true;
            }
        }
        return selectionOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getCubePermissions(SimpleObject obj) {
        if (obj == null) {
            return;
        }
        if (!obj.equals((Object)currentObject) || currentObject != null && !obj.getID().equals(currentObject.getID())) {
            MdObjectStore store = null;
            try {
                currentObject = obj;
                store = Workspace.getMdFactory().createObjectStore(null, "getCubePermissionsStore");
                Cube cube = (Cube)ObjectConverter.getInstance().convertToJOMAObject(store, currentObject);
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)cube, null, null, "", 8);
                String cubeName = cube.getCubeName();
                canWriteAllCube = ModelUtilities.canWriteAllCubeMetadata((CMetadata)cube);
                canReadAllCube = ModelUtilities.canReadAllCubeMetadata((CMetadata)cube);
                canReadAllCubeData = ModelUtilities.canReadAllCubeData((CMetadata)cube);
                canReadCube = ModelUtilities.canRead((String)"Cube", (CMetadata)cube);
                canWriteCube = ModelUtilities.canWrite((String)"Cube", (CMetadata)cube);
                exists = !ModelUtilities.isBlank((String)cubeName);
                Job cubeJob = ModelUtilities.getJobCube((Cube)cube);
                canWriteJob = cubeJob != null ? ModelUtilities.canWrite((String)"Job", (CMetadata)cubeJob) : true;
            }
            catch (MdException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            catch (RemoteException e) {
                ExceptionHandler.handleException((Exception)e);
            }
            finally {
                try {
                    if (store != null) {
                        store.dispose();
                    }
                }
                catch (RemoteException e) {
                    ExceptionHandler.handleException((Exception)e);
                }
            }
        }
    }

    public static void clearCurrentObject() {
        currentObject = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isCurrentGeneration(Object obj) {
        boolean currentGeneration = false;
        MdObjectStore store = null;
        try {
            store = Workspace.getMdFactory().createObjectStore(null, "CurrentGenerationCheck");
            Cube cube = (Cube)ObjectConverter.getInstance().convertToJOMAObject(store, (SimpleObject)obj);
            ArrayList<String> associations = new ArrayList<String>();
            associations.add("NextGenerations");
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)cube, null, associations, "", 8);
            currentGeneration = ModelUtilities.isCurrentGeneration((Cube)cube);
            if (!currentGeneration) {
                MessageUtil.displayMessage((String)bundle.formatString("Cube.NotCurrentGeneration.fmt.txt", (Object)cube.getName()));
            }
        }
        catch (MdException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        catch (RemoteException e) {
            ExceptionHandler.handleException((Exception)e);
        }
        finally {
            try {
                if (store != null) {
                    store.dispose();
                }
            }
            catch (RemoteException e) {
                ExceptionHandler.handleException((Exception)e);
            }
        }
        return currentGeneration;
    }
}

