/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server.util;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.util.BackupServerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PurgeHelper {
    private Map<String, List<String>> purgeMe = new HashMap<String, List<String>>(3);
    private static String ABS_PATH_BASE = "ABS_PATH";
    private Logger logger = LogManager.getLogger(PurgeHelper.class);

    public void purge(Command command) throws BackupException {
        String antProjectFile = null;
        antProjectFile = command.hasParameter("beforedate") ? this.createANTProjectDeleteBeforeDate(command.getParameter("beforedate"), command.getParameter("sessionid")) : this.createANTProject();
        this.logger.debug(antProjectFile);
        if (StringUtils.isNotBlank((String)antProjectFile)) {
            try {
                BackupServerUtil.runANTProject(antProjectFile, command);
            }
            catch (Exception exception) {
                throw new BackupException(exception, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_RUNNING_ANT.getErrorCode());
            }
        }
    }

    public void addToPurge(String baseDir, List<String> sessionIds) {
        if (this.purgeMe.containsKey(baseDir)) {
            this.purgeMe.get(baseDir).addAll(sessionIds);
        } else {
            this.purgeMe.put(baseDir, sessionIds);
        }
    }

    public void addToPurge(List<String> dirs) {
        this.addToPurge(ABS_PATH_BASE, dirs);
    }

    private String createANTProject() {
        StringBuilder projectFile = new StringBuilder();
        if (!this.purgeMe.isEmpty()) {
            String projectFilePrePart = "<project name=\"purgedirectories\" default=\"purge\"><target name=\"purge\">";
            String projectFilePostPart = "</target></project>";
            String deleteCommandPrePart = "<delete dir=\"";
            String deleteCommandPostPart = "\" verbose=\"true\" failonerror=\"false\"/>";
            String startEncode = "<?xml version=\"1.0\"?>";
            projectFile.append(startEncode);
            projectFile.append(projectFilePrePart);
            List<String> sessionIds = null;
            for (String baseDir : this.purgeMe.keySet()) {
                sessionIds = this.purgeMe.get(baseDir);
                for (String sessionId : sessionIds) {
                    projectFile.append(deleteCommandPrePart);
                    if (!baseDir.equals(ABS_PATH_BASE)) {
                        projectFile.append(baseDir);
                        projectFile.append("/");
                    }
                    projectFile.append(sessionId);
                    projectFile.append(deleteCommandPostPart);
                }
            }
            projectFile.append(projectFilePostPart);
        }
        return projectFile.toString();
    }

    public String createANTProjectDeleteBeforeDate(String beforeDate, String sessionId) {
        this.logger.debug("beforeDate:" + beforeDate);
        this.logger.debug("purgeMe:" + this.purgeMe);
        StringBuilder projectFile = new StringBuilder();
        if (!this.purgeMe.isEmpty() && StringUtils.isNotBlank((String)beforeDate)) {
            String projectFilePrePart = "<project name=\"purgedirectories\" default=\"purge\"><target name=\"purge\">";
            String projectFilePostPart = "</target></project>";
            String deleteCommandPrePart = "<delete includeemptydirs=\"true\" verbose=\"true\" failonerror=\"false\">";
            String deleteCommandEndPart = "</delete>";
            String startEncode = "<?xml version=\"1.0\"?>";
            String filesetPreStartCondition = "<fileset dir=\"";
            String filesetEndPart = "</fileset>";
            String includeSubDirs = "includes=\"**/*\"";
            String excludeSubDirs = "excludes=\"**/" + sessionId + "/**\"";
            String datePrestart = "<date pattern=\"dd/MM/yyyy\" when=\"before\" datetime=";
            String datePostStart = "/>";
            projectFile.append(startEncode);
            projectFile.append(projectFilePrePart);
            for (String baseDir : this.purgeMe.get(ABS_PATH_BASE)) {
                projectFile.append(deleteCommandPrePart);
                projectFile.append(filesetPreStartCondition);
                projectFile.append(baseDir);
                projectFile.append("\" " + includeSubDirs + " " + excludeSubDirs + " >");
                projectFile.append(datePrestart);
                projectFile.append("\"" + beforeDate + "\"");
                projectFile.append(datePostStart);
                projectFile.append(filesetEndPart);
                projectFile.append(deleteCommandEndPart);
            }
            projectFile.append(projectFilePostPart);
        } else {
            this.logger.warn(" Cannot create project during purge , directories to purge are empty or before date is empty");
        }
        this.logger.trace((CharSequence)projectFile);
        return projectFile.toString();
    }
}

