/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server.util;

import com.sas.svcs.backup.client.Command;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupServer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class BackupServerUtil {
    public static final String SAS_MAJOR_VERSION = "9.4";
    private static final Logger logger = LogManager.getLogger(BackupServerUtil.class);

    public static long getDirectorySize(File dir) {
        long dirSize = 0L;
        if (dir.exists()) {
            if (dir.isDirectory()) {
                File[] fileList = dir.listFiles();
                for (int i = 0; i < fileList.length; ++i) {
                    if (fileList[i].isDirectory()) {
                        dirSize += BackupServerUtil.getDirectorySize(fileList[i]);
                        continue;
                    }
                    dirSize += fileList[i].length();
                }
            } else {
                dirSize = dir.length();
            }
        }
        return dirSize;
    }

    public static void writeFile(File file, String content) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file, true));
            writer.append(content);
            writer.newLine();
        }
        catch (FileNotFoundException exception) {
            throw new IOException();
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static <T, E> List<E> getCollection(Collection<T> ts, String attrib, Class<E> attribClass) {
        List returnValues = Collections.emptyList();
        if (ts != null) {
            returnValues = new ArrayList();
            for (T t : ts) {
                try {
                    Method getter = t.getClass().getDeclaredMethod("get" + attrib, new Class[0]);
                    Object e = getter.invoke(t, new Object[0]);
                    returnValues.add(e);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
        return returnValues;
    }

    public static <T> String toString(List<T> list) {
        StringBuilder retValue = new StringBuilder();
        if (list != null && list.size() > 0) {
            for (T t : list) {
                retValue.append(t.toString());
                retValue.append(",");
            }
            return retValue.toString().substring(0, retValue.length() - 1);
        }
        return "";
    }

    public static String makeSHA1Hash(String input) throws NoSuchAlgorithmException {
        if (input != null) {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.reset();
            byte[] buffer = input.getBytes();
            md.update(buffer);
            byte[] digest = md.digest();
            String hexStr = "";
            for (int i = 0; i < digest.length; ++i) {
                hexStr = hexStr + Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1);
            }
            return hexStr;
        }
        return null;
    }

    public static Project runANTProject(String antProject, Command command) throws Exception {
        File f = null;
        try {
            File tempFolder = new File(".", "Backuptemp");
            try {
                f = File.createTempFile("Build", "xml");
            }
            catch (Exception e1) {
                block7: {
                    try {
                        tempFolder.mkdirs();
                        f = File.createTempFile("Build", "xml", tempFolder);
                    }
                    catch (Exception e2) {
                        if (command == null) break block7;
                        String dropZone = BackupServerUtil.getDropZonePath(command);
                        tempFolder = new File(dropZone, "Backuptemp");
                        tempFolder.mkdirs();
                        f = File.createTempFile("Build", "xml", tempFolder);
                    }
                }
                tempFolder.deleteOnExit();
            }
            if (f == null) {
                throw new BackupException(BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_RUNNING_ANT.getErrorCode());
            }
            f.deleteOnExit();
            BackupServerUtil.writeFile(f, antProject);
        }
        catch (IOException exception) {
            throw new BackupException(exception, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_RUNNING_ANT.getErrorCode());
        }
        Project p = new Project();
        p.setUserProperty("ant.file", f.getAbsolutePath());
        p.init();
        ProjectHelper helper = ProjectHelper.getProjectHelper();
        p.addReference("ant.projectHelper", (Object)helper);
        helper.parse(p, (Object)f);
        p.executeTarget(p.getDefaultTarget());
        return p;
    }

    private static String getDropZonePath(Command command) {
        if (command.hasParameter("configdir") && command.hasParameter("backupworkspace")) {
            return command.getParameter("configdir") + File.separator + command.getParameter("backupworkspace") + File.separator + "dropzone";
        }
        if (command.hasParameter("configbase")) {
            return command.getParameter("configbase") + File.separator + "dropzone";
        }
        return "." + File.separator + "dropzone";
    }

    public static File presentAndAccessible(String filePath) throws BackupException {
        return BackupServerUtil.presentAndAccessible(filePath, BackupServer.ReturnCode.FILE_NOT_PRESENT);
    }

    public static File presentAndAccessible(String filePath, BackupServer.ReturnCode code) throws BackupException {
        if (filePath == null) {
            throw new BackupException("Null value for file path received. Hence can't check if it is present and accessible.", BackupServer.ReturnCode.INVALID_FILE_PATH.getErrorCode());
        }
        File file = new File(filePath);
        if (!file.exists() || !file.canRead()) {
            throw new BackupException(file.getAbsolutePath() + " is either not present or not accessible.", code.getErrorCode());
        }
        return file;
    }

    public static File ifNotExistsCreate(String fileName) {
        File file = null;
        if (fileName != null && !(file = new File(fileName)).exists()) {
            file.mkdir();
        }
        return file;
    }

    public static Properties loadProperties(File file) {
        Properties properties = new Properties();
        if (file != null) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return properties;
    }

    public static boolean isEmpty(Object object) {
        boolean isEmpty = false;
        if (object == null) {
            isEmpty = true;
        } else if (object instanceof String && ((String)object).length() <= 0) {
            isEmpty = true;
        } else if (object instanceof Collection && ((Collection)object).size() <= 0) {
            isEmpty = true;
        } else if (object instanceof Map && ((Map)object).size() <= 0) {
            isEmpty = true;
        } else if (object.getClass().isArray() && ((Object[])object).length <= 0) {
            isEmpty = true;
        }
        return isEmpty;
    }

    public static String getCurrentDateTime() {
        Date currentDate = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH_mm_ss");
        return formatter.format(currentDate);
    }

    public static String getCfgwizardPath(String sasHome) {
        String cfgwizardinstalldir = null;
        String deploymentManagerPath = sasHome + File.separator + "SASDeploymentManager" + File.separator + SAS_MAJOR_VERSION + File.separator + "products";
        String productName = "cfgwizard";
        cfgwizardinstalldir = BackupServerUtil.getLatestProductPath(deploymentManagerPath, "cfgwizard");
        logger.info("Cfgwizard Install Dir:" + deploymentManagerPath + File.separator + cfgwizardinstalldir);
        return deploymentManagerPath + File.separator + cfgwizardinstalldir;
    }

    public static String getDeployWizardPath(String sasHome) {
        String deploywizardinstalldir = null;
        String deploymentManagerPath = sasHome + File.separator + "SASDeploymentManager" + File.separator + SAS_MAJOR_VERSION + File.separator + "products";
        String productName = "deploywiz";
        deploywizardinstalldir = BackupServerUtil.getLatestProductPath(deploymentManagerPath, "deploywiz");
        logger.info("Deploywizard Install Dir:" + deploymentManagerPath + File.separator + deploywizardinstalldir);
        return deploymentManagerPath + File.separator + deploywizardinstalldir;
    }

    public static String getLatestProductPath(String parentInstallDir, final String productName) {
        String latestProductDir = null;
        String[] productDirs = new File(parentInstallDir).list(new FilenameFilter(){

            @Override
            public boolean accept(File parent, String name) {
                return name != null && name.startsWith(productName) && new File(parent, name).isDirectory();
            }
        });
        if (productDirs != null) {
            if (productDirs.length == 1) {
                latestProductDir = productDirs[0];
            } else {
                List<String> cfgwizList = Arrays.asList(productDirs);
                Collections.sort(cfgwizList, Collections.reverseOrder());
                System.out.println(cfgwizList);
                if (cfgwizList != null && !cfgwizList.isEmpty()) {
                    latestProductDir = cfgwizList.get(0);
                }
            }
        }
        return latestProductDir;
    }

    public static boolean isHostsEqual(String host1, String host2) {
        InetAddress hostAddress1 = BackupServerUtil.convertToInetAddress(host1);
        InetAddress hostAddress2 = BackupServerUtil.convertToInetAddress(host2);
        return hostAddress1 != null && hostAddress1.getHostAddress() != null && hostAddress2 != null && hostAddress2.getHostAddress() != null && hostAddress1.getHostAddress().equals(hostAddress2.getHostAddress());
    }

    public static boolean isLocalHost(String hostName) {
        boolean result = false;
        try {
            InetAddress hostAddress1 = BackupServerUtil.convertToInetAddress(hostName);
            InetAddress hostAddress2 = InetAddress.getLocalHost();
            result = hostAddress1 != null && hostAddress1.getHostAddress() != null && hostAddress2 != null && hostAddress2.getHostAddress() != null && hostAddress1.getHostAddress().equals(hostAddress2.getHostAddress());
        }
        catch (UnknownHostException e) {
            logger.error("Unknown host : " + hostName);
        }
        return result;
    }

    public static InetAddress convertToInetAddress(String host) {
        InetAddress address = null;
        try {
            if (!BackupServerUtil.isEmpty(host)) {
                address = InetAddress.getByName(host);
                logger.debug("Inet address for " + host + " is " + address);
            }
        }
        catch (UnknownHostException unknownHost) {
            logger.error("Unknown host : " + host);
        }
        return address;
    }

    public static boolean isPathAccessible(String dropzone, File path) {
        logger.info("Checking if the " + path + "is accessible...");
        boolean isAccesible = true;
        try {
            if (path != null) {
                BackupServerUtil.presentAndAccessible(path.getCanonicalPath());
                isAccesible = path.canWrite();
                File dirdropzone = new File(dropzone);
                if (!dirdropzone.exists()) {
                    dirdropzone.mkdirs();
                }
                File testfile = new File(dropzone + File.separator + "TestPermission.txt");
                FileUtils.writeStringToFile((File)testfile, (String)"Testing File write permisssion");
                FileUtils.copyFileToDirectory((File)testfile, (File)path);
                if (!new File(path, "TestPermission.txt").exists()) {
                    return false;
                }
            } else {
                return false;
            }
            isAccesible = new File(path, "TestPermission.txt").delete();
            logger.info("Temp file from vault can be deleted : " + isAccesible);
        }
        catch (FileNotFoundException e) {
            isAccesible = false;
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            isAccesible = false;
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (BackupException e) {
            isAccesible = false;
            logger.error(e.getMessage(), (Throwable)e);
        }
        return isAccesible;
    }

    public static String extractFilter(String filter, String configDir) {
        StringBuffer sb = new StringBuffer();
        try {
            String[] filterStrs;
            if (filter != null && !filter.isEmpty() && (filterStrs = filter.split(",")) != null) {
                for (String filterString : filterStrs) {
                    String extractedFilter = null;
                    String[] filterTokens = filterString.split("\\?");
                    if (filterTokens.length == 2) {
                        String filterValue = filterTokens[1];
                        logger.debug("Filter value: " + filterValue);
                        if (filterValue != null) {
                            String dirpath = filterTokens[0];
                            logger.debug("Filter dirPath: " + dirpath);
                            File dir = new File(dirpath);
                            if (!dir.isAbsolute()) {
                                dir = new File(configDir, dirpath);
                            }
                            String canonicalPath = dir.getCanonicalPath();
                            extractedFilter = canonicalPath + "|" + filterValue;
                        }
                    }
                    if (extractedFilter == null) continue;
                    if (sb.length() != 0) {
                        sb.append(",");
                    }
                    sb.append(extractedFilter);
                }
            }
        }
        catch (IOException e) {
            logger.warn("Error occured while trying to extract filters.");
        }
        return sb.toString();
    }

    public static boolean prepareSharedVault(String dropzone, String sharedVaultBase) {
        boolean created = true;
        if (sharedVaultBase != null) {
            File sharedBase = new File(sharedVaultBase);
            created = !sharedBase.exists() ? sharedBase.mkdirs() : BackupServerUtil.isPathAccessible(dropzone, sharedBase);
        }
        return created;
    }
}

