/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server.util;

import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupServer;
import com.sas.svcs.backup.server.util.BackupServerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class AntProjectRunner {
    private String antFile;
    private Properties properties;

    public AntProjectRunner(String antProjectFile) {
        this.antFile = antProjectFile;
    }

    public AntProjectRunner properties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public Project run() throws Exception {
        File f = null;
        try {
            File tempFolder = new File(".", "Backuptemp");
            try {
                f = File.createTempFile("Build", "xml");
            }
            catch (Exception e) {
                tempFolder.mkdirs();
                f = File.createTempFile("Build", "xml", tempFolder);
            }
            if (f == null) {
                throw new BackupException(BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_RUNNING_ANT.getErrorCode());
            }
            f.deleteOnExit();
            BackupServerUtil.writeFile(f, this.antFile);
        }
        catch (IOException exception) {
            throw new BackupException(exception, BackupServer.ReturnCode.COMMAND_INTERNAL_ERROR_RUNNING_ANT.getErrorCode());
        }
        Project p = new Project();
        p.setUserProperty("ant.file", f.getAbsolutePath());
        if (this.properties != null) {
            this.setProperties(p);
        }
        p.init();
        ProjectHelper helper = ProjectHelper.getProjectHelper();
        p.addReference("ant.projectHelper", (Object)helper);
        helper.parse(p, (Object)f);
        p.executeTarget(p.getDefaultTarget());
        return p;
    }

    private void setProperties(Project p) {
        Enumeration<Object> propNames = this.properties.keys();
        String key = null;
        while (propNames.hasMoreElements()) {
            key = (String)propNames.nextElement();
            p.setProperty(key, this.properties.getProperty(key));
        }
    }
}

