/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.server.handler;

import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.server.BackupRunEnvironment;
import com.sas.svcs.backup.server.BackupSession;
import com.sas.svcs.backup.server.CommandPostProcessor;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhysicalDataBackupPostProcessor
implements CommandPostProcessor<BackupRunEnvironment> {
    Logger logger = LogManager.getLogger(PhysicalDataBackupPostProcessor.class);

    @Override
    public void doPostProcess(BackupRunEnvironment environment, BackupSession session) throws BackupException {
        File localVaultcontentDetails;
        String targetPath = environment.getTargetPath();
        String statusArea = environment.getStatusAreaPath();
        this.logger.info("Copying results from : " + targetPath);
        if (targetPath != null && (localVaultcontentDetails = new File(targetPath, "packagedFiles")).exists() && localVaultcontentDetails.isDirectory()) {
            File resultArea = new File(statusArea);
            try {
                this.logger.info("Copying results from : " + targetPath + " to " + statusArea);
                FileUtils.copyDirectoryToDirectory((File)localVaultcontentDetails, (File)resultArea);
            }
            catch (IOException e) {
                this.logger.error("Error while copying the results : " + e.getMessage());
            }
        }
    }
}

